<?php
// app/Http/Middleware/CheckVehicleRole.php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckVehicleRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();
        
        // ตรวจสอบว่าเป็น 2wheel หรือ 4wheel
        if (!in_array($user->role, ['2wheel', '4wheel'])) {
            abort(403, 'คุณไม่มีสิทธิ์เข้าถึงหน้านี้');
        }
        
        // ตรวจสอบสถานะผู้ใช้
        if (!$user->is_active) {
            Auth::logout();
            return redirect()->route('login')->with('error', 'บัญชีของคุณถูกปิดใช้งาน');
        }
        
        return $next($request);
    }
}