<?php
// database/migrations/xxxx_create_warehouses_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('warehouses', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique(); // รหัสคลัง เช่น WH001, WH002
            $table->string('name'); // ชื่อคลัง เช่น คลังกรุงเทพ, คลังเชียงใหม่
            $table->string('location')->nullable(); // ที่ตั้งคลัง
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('warehouses');
    }
};