@extends('layouts.app')

@section('content')
<div class="goals-container"><br><br>
    <!-- Header -->
    <div class="goals-header">
        <div class="header-left">
            <h1 class="goals-title">
                <i class="fas fa-piggy-bank"></i>
                เป้าหมายการออม
            </h1>
            <p class="goals-subtitle">จัดการเป้าหมายการออมเงินของคุณ</p>
        </div>
        <div class="header-right">
            <a href="{{ route('finance.goals.create') }}" class="btn btn-create">
                <i class="fas fa-plus-circle"></i> สร้างเป้าหมายใหม่
            </a>
        </div>
    </div>

    <!-- Summary Stats -->
    <div class="goals-summary">
        <div class="summary-item">
            <div class="summary-icon">
                <i class="fas fa-bullseye"></i>
            </div>
            <div class="summary-info">
                <h3>เป้าหมายทั้งหมด</h3>
                <p class="summary-value">{{ $stats['total_goals'] }}</p>
            </div>
        </div>
        <div class="summary-item">
            <div class="summary-icon active">
                <i class="fas fa-running"></i>
            </div>
            <div class="summary-info">
                <h3>กำลังดำเนินการ</h3>
                <p class="summary-value">{{ $stats['active_goals'] }}</p>
            </div>
        </div>
        <div class="summary-item">
            <div class="summary-icon completed">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="summary-info">
                <h3>สำเร็จแล้ว</h3>
                <p class="summary-value">{{ $stats['completed_goals'] }}</p>
            </div>
        </div>
        <div class="summary-item">
            <div class="summary-icon progress">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="summary-info">
                <h3>ความคืบหน้าเฉลี่ย</h3>
                <p class="summary-value">{{ $stats['overall_progress'] }}%</p>
            </div>
        </div>
    </div>

    <!-- Goals List -->
    <div class="goals-grid">
        @forelse($goals as $goal)
            <div class="goal-card {{ $goal->status }}">
                <div class="goal-header">
                    <h3 class="goal-name">{{ $goal->goal_name }}</h3>
                    <div class="goal-menu">
                        <button class="menu-btn" onclick="toggleMenu({{ $goal->id }})">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                        <div class="menu-dropdown" id="menu-{{ $goal->id }}">
                            <a href="{{ route('finance.goals.edit', $goal) }}" class="menu-item">
                                <i class="fas fa-edit"></i> แก้ไข
                            </a>
                            @if($goal->status === 'active')
                                <button onclick="showDepositModal({{ $goal->id }}, '{{ $goal->goal_name }}')" class="menu-item">
                                    <i class="fas fa-plus"></i> เพิ่มเงิน
                                </button>
                                @if($goal->current_amount >= $goal->target_amount)
                                    <form action="{{ route('finance.goals.complete', $goal) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="menu-item">
                                            <i class="fas fa-check"></i> ทำเครื่องหมายสำเร็จ
                                        </button>
                                    </form>
                                @endif
                                <form action="{{ route('finance.goals.cancel', $goal) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="menu-item danger">
                                        <i class="fas fa-ban"></i> ยกเลิก
                                    </button>
                                </form>
                            @elseif($goal->status === 'cancelled')
                                <form action="{{ route('finance.goals.reactivate', $goal) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="menu-item">
                                        <i class="fas fa-redo"></i> เปิดใช้งานอีกครั้ง
                                    </button>
                                </form>
                            @endif
                            <form action="{{ route('finance.goals.destroy', $goal) }}" method="POST" 
                                  onsubmit="return confirm('คุณต้องการลบเป้าหมายนี้ใช่หรือไม่?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="menu-item danger">
                                    <i class="fas fa-trash"></i> ลบ
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="goal-amount">
                    <div class="current-amount">
                        <span class="label">ออมได้แล้ว</span>
                        <span class="value">฿{{ number_format($goal->current_amount, 0) }}</span>
                    </div>
                    <div class="target-amount">
                        <span class="label">เป้าหมาย</span>
                        <span class="value">฿{{ number_format($goal->target_amount, 0) }}</span>
                    </div>
                </div>

                <div class="progress-container">
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: {{ $goal->progress_percentage }}%">
                            <span class="progress-text">{{ $goal->progress_percentage }}%</span>
                        </div>
                    </div>
                </div>

                <div class="goal-info">
                    @if($goal->target_date)
                        <div class="info-item">
                            <i class="fas fa-calendar"></i>
                            <span>{{ $goal->target_date->format('d/m/Y') }}</span>
                        </div>
                        @if($goal->days_remaining !== null)
                            <div class="info-item {{ $goal->is_overdue ? 'overdue' : '' }}">
                                <i class="fas fa-clock"></i>
                                <span>
                                    @if($goal->is_overdue)
                                        เกินกำหนด {{ abs($goal->days_remaining) }} วัน
                                    @else
                                        เหลือ {{ $goal->days_remaining }} วัน
                                    @endif
                                </span>
                            </div>
                        @endif
                    @endif
                </div>

                @if($goal->status === 'active' && $goal->suggested_monthly_saving > 0)
                    <div class="suggestion">
                        <i class="fas fa-info-circle"></i>
                        ควรออมเดือนละ ฿{{ number_format($goal->suggested_monthly_saving, 0) }}
                    </div>
                @endif

                <div class="goal-status">
                    <span class="status-badge {{ $goal->status }}" style="background-color: {{ $goal->status_color }}20; color: {{ $goal->status_color }}">
                        {{ $goal->status_text }}
                    </span>
                </div>
            </div>
        @empty
            <div class="empty-state">
                <i class="fas fa-piggy-bank"></i>
                <h3>ยังไม่มีเป้าหมายการออม</h3>
                <p>เริ่มต้นสร้างเป้าหมายการออมเงินของคุณวันนี้</p>
                <a href="{{ route('finance.goals.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus-circle"></i> สร้างเป้าหมายแรก
                </a>
            </div>
        @endforelse
    </div>
</div>

<!-- Deposit Modal -->
<div class="modal" id="depositModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>เพิ่มเงินออม</h3>
            <button class="modal-close" onclick="closeDepositModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form id="depositForm" method="POST">
            @csrf
            <div class="modal-body">
                <p class="goal-name-display" id="goalNameDisplay"></p>
                <div class="form-group">
                    <label>จำนวนเงิน</label>
                    <div class="input-with-prefix">
                        <span class="prefix">฿</span>
                        <input type="number" name="amount" class="form-control" 
                               placeholder="0.00" step="0.01" min="1" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>หมายเหตุ (ถ้ามี)</label>
                    <input type="text" name="note" class="form-control" 
                           placeholder="เช่น โบนัสเดือนนี้">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeDepositModal()">
                    ยกเลิก
                </button>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> บันทึก
                </button>
            </div>
        </form>
    </div>
</div>

@push('styles')
<style>
.goals-container {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 0 1rem;
}

/* Header */
.goals-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 2rem;
    flex-wrap: wrap;
    gap: 1rem;
}

.goals-title {
    font-size: 2rem;
    font-weight: 700;
    color: #1f2937;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 0.5rem;
}

.goals-subtitle {
    color: #6b7280;
    font-size: 1.1rem;
}

.btn-create {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
    transition: all 0.3s;
}

.btn-create:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
}

/* Summary */
.goals-summary {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.summary-item {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
    display: flex;
    align-items: center;
    gap: 1rem;
}

.summary-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    background: #f3f4f6;
    color: #6b7280;
}

.summary-icon.active {
    background: #dbeafe;
    color: #3b82f6;
}

.summary-icon.completed {
    background: #d1fae5;
    color: #10b981;
}

.summary-icon.progress {
    background: #fef3c7;
    color: #f59e0b;
}

.summary-info h3 {
    font-size: 0.875rem;
    color: #6b7280;
    margin-bottom: 0.25rem;
}

.summary-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

/* Goals Grid */
.goals-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
    gap: 1.5rem;
}

.goal-card {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    position: relative;
    transition: all 0.3s;
    border: 2px solid transparent;
}

.goal-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12);
}

.goal-card.active {
    border-color: #3b82f6;
}

.goal-card.completed {
    border-color: #10b981;
    background: #f0fdf4;
}

.goal-card.cancelled {
    opacity: 0.7;
    border-color: #e5e7eb;
}

/* Goal Header */
.goal-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 1rem;
}

.goal-name {
    font-size: 1.2rem;
    font-weight: 600;
    color: #1f2937;
    flex: 1;
    margin-right: 1rem;
}

.menu-btn {
    background: none;
    border: none;
    color: #6b7280;
    padding: 0.5rem;
    cursor: pointer;
    border-radius: 8px;
    transition: all 0.3s;
}

.menu-btn:hover {
    background: #f3f4f6;
}

.menu-dropdown {
    position: absolute;
    top: 3rem;
    right: 1rem;
    background: white;
    border-radius: 12px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.15);
    min-width: 180px;
    display: none;
    z-index: 10;
    overflow: hidden;
}

.menu-dropdown.active {
    display: block;
}

.menu-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem 1rem;
    border: none;
    background: none;
    color: #374151;
    font-size: 0.9rem;
    cursor: pointer;
    transition: all 0.2s;
    width: 100%;
    text-align: left;
    text-decoration: none;
}

.menu-item:hover {
    background: #f3f4f6;
}

.menu-item.danger {
    color: #ef4444;
}

/* Goal Amount */
.goal-amount {
    display: flex;
    justify-content: space-between;
    margin-bottom: 1rem;
    padding: 1rem;
    background: #f9fafb;
    border-radius: 12px;
}

.current-amount,
.target-amount {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.current-amount .label,
.target-amount .label {
    font-size: 0.875rem;
    color: #6b7280;
}

.current-amount .value {
    font-size: 1.25rem;
    font-weight: 700;
    color: #3b82f6;
}

.target-amount .value {
    font-size: 1.25rem;
    font-weight: 700;
    color: #6b7280;
}

/* Progress Bar */
.progress-container {
    margin-bottom: 1rem;
}

.progress-bar {
    height: 20px;
    background: #e5e7eb;
    border-radius: 10px;
    overflow: hidden;
    position: relative;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #3b82f6 0%, #60a5fa 100%);
    border-radius: 10px;
    transition: width 0.5s ease;
    position: relative;
    min-width: 40px;
}

.progress-text {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    color: white;
    font-size: 0.875rem;
    font-weight: 600;
}

/* Goal Info */
.goal-info {
    display: flex;
    gap: 1rem;
    margin-bottom: 1rem;
    flex-wrap: wrap;
}

.info-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.875rem;
    color: #6b7280;
}

.info-item.overdue {
    color: #ef4444;
}

.info-item i {
    font-size: 1rem;
}

/* Suggestion */
.suggestion {
    background: #eff6ff;
    border: 1px solid #dbeafe;
    border-radius: 8px;
    padding: 0.75rem;
    font-size: 0.875rem;
    color: #1e40af;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 1rem;
}

/* Status Badge */
.goal-status {
    display: flex;
    justify-content: center;
}

.status-badge {
    padding: 0.375rem 1rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 600;
}

/* Empty State */
.empty-state {
    grid-column: 1 / -1;
    text-align: center;
    padding: 4rem 2rem;
    background: white;
    border-radius: 20px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
}

.empty-state i {
    font-size: 4rem;
    color: #e5e7eb;
    margin-bottom: 1rem;
}

.empty-state h3 {
    font-size: 1.5rem;
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
}

.empty-state p {
    color: #6b7280;
    margin-bottom: 2rem;
}

/* Modal */
.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    align-items: center;
    justify-content: center;
}

.modal.active {
    display: flex;
}

.modal-content {
    background: white;
    border-radius: 20px;
    width: 90%;
    max-width: 500px;
    box-shadow: 0 20px 50px rgba(0, 0, 0, 0.2);
}

.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem;
    border-bottom: 1px solid #e5e7eb;
}

.modal-header h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1f2937;
}

.modal-close {
    background: none;
    border: none;
    color: #6b7280;
    font-size: 1.5rem;
    cursor: pointer;
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
}

.modal-close:hover {
    background: #f3f4f6;
}

.modal-body {
    padding: 1.5rem;
}

.goal-name-display {
    font-weight: 600;
    color: #374151;
    margin-bottom: 1.5rem;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
}

.form-control {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 1rem;
    transition: all 0.3s;
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.input-with-prefix {
    position: relative;
}

.input-with-prefix .prefix {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #6b7280;
    font-weight: 600;
}

.input-with-prefix .form-control {
    padding-left: 2.5rem;
}

.modal-footer {
    display: flex;
    justify-content: flex-end;
    gap: 0.75rem;
    padding: 1.5rem;
    border-top: 1px solid #e5e7eb;
}

.btn {
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-primary {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
}

.btn-secondary {
    background: #f3f4f6;
    color: #6b7280;
}

.btn-secondary:hover {
    background: #e5e7eb;
}

/* Responsive */
@media (max-width: 768px) {
    .goals-header {
        flex-direction: column;
    }
    
    .goals-summary {
        grid-template-columns: 1fr 1fr;
    }
    
    .goals-grid {
        grid-template-columns: 1fr;
    }
    
    .goal-amount {
        flex-direction: column;
        gap: 0.75rem;
    }
}

@media (max-width: 480px) {
    .goals-summary {
        grid-template-columns: 1fr;
    }
}
</style>
@endpush

@push('scripts')
<script>
// Toggle menu dropdown
function toggleMenu(goalId) {
    const menu = document.getElementById(`menu-${goalId}`);
    
    // Close all other menus
    document.querySelectorAll('.menu-dropdown').forEach(m => {
        if (m.id !== `menu-${goalId}`) {
            m.classList.remove('active');
        }
    });
    
    menu.classList.toggle('active');
}

// Close menus when clicking outside
document.addEventListener('click', function(e) {
    if (!e.target.closest('.goal-menu')) {
        document.querySelectorAll('.menu-dropdown').forEach(m => {
            m.classList.remove('active');
        });
    }
});

// Deposit Modal
function showDepositModal(goalId, goalName) {
    const modal = document.getElementById('depositModal');
    const form = document.getElementById('depositForm');
    const nameDisplay = document.getElementById('goalNameDisplay');
    
    form.action = `/finance/goals/${goalId}/deposit`;
    nameDisplay.textContent = goalName;
    modal.classList.add('active');
    
    // Close menu
    document.querySelectorAll('.menu-dropdown').forEach(m => {
        m.classList.remove('active');
    });
}

function closeDepositModal() {
    const modal = document.getElementById('depositModal');
    const form = document.getElementById('depositForm');
    
    modal.classList.remove('active');
    form.reset();
}

// Handle deposit form submission
document.getElementById('depositForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = this.querySelector('button[type="submit"]');
    
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> กำลังบันทึก...';
    
    fetch(this.action, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json',
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message || 'เกิดข้อผิดพลาด');
            submitBtn.disabled = false;
            submitBtn.innerHTML = '<i class="fas fa-save"></i> บันทึก';
        }
    })
    .catch(error => {
        alert('เกิดข้อผิดพลาดในการบันทึก');
        submitBtn.disabled = false;
        submitBtn.innerHTML = '<i class="fas fa-save"></i> บันทึก';
    });
});

// Close modal on outside click
document.getElementById('depositModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeDepositModal();
    }
});
</script>
@endpush
@endsection