
<?php $__env->startSection('title', 'แดชบอร์ด'); ?>

<?php $__env->startSection('content'); ?>
<main class="main-content" style="width:100%;max-width:100vw;min-width:0;margin:0;padding:0;overflow-x:hidden;">
    <div class="content-container" style="width:100%;max-width:100vw;min-width:0;padding:2rem;overflow-x:hidden;">
        
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-tachometer-alt"></i>
                สรุปผลงานประจำเดือน <?php echo e(\Carbon\Carbon::now()->isoFormat('MMMM YYYY')); ?>

            </h1>
            <p class="page-subtitle">ติดตามและจัดการประวัติการจัดส่งพัสดุของคุณ</p>
            <div class="user-info">
                <span style="color: var(--gray);">ตำแหน่ง:</span> 
                <span class="badge" style="background: var(--primary-orange); color: white;"><?php echo e(auth()->user()->role); ?></span>
                <span style="color: var(--gray); margin-left: 1rem;">คลัง:</span>
                <span style="font-weight: 500;"><?php echo e(auth()->user()->warehouse->name ?? '-'); ?></span>
            </div>
        </div>

        <!-- Filter Section -->
        <div class="filter-section mb-4">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-calendar-alt"></i> วันที่เริ่มต้น
                    </label>
                    <input type="date" name="date_from" class="form-control" 
                           value="<?php echo e($dateFrom); ?>"
                           max="<?php echo e(now()->format('Y-m-d')); ?>">
                </div>
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-calendar-check"></i> วันที่สิ้นสุด
                    </label>
                    <input type="date" name="date_to" class="form-control" 
                           value="<?php echo e($dateTo); ?>"
                           max="<?php echo e(now()->format('Y-m-d')); ?>">
                </div>
                <div class="form-group" style="display: flex; gap: 0.75rem; align-items: end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> ค้นหา
                    </button>
                    <a href="<?php echo e(route('vehicle.dashboard')); ?>" class="btn" style="background: var(--gray); color: var(--white);">
                        <i class="fas fa-undo"></i> รีเซ็ต
                    </a>
                </div>
            </form>
        </div>

        <!-- Stats Grid -->
        <div class="stats-grid mb-4">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #FF6B35, #F7931E);">
                    <i class="fas fa-calendar-day"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e(number_format($monthlyStats['total_days'])); ?></div>
                    <div class="stat-label">วันที่ทำงาน</div>
                    <div class="stat-extra">เดือนนี้</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #4ECDC4, #44A08D);">
                    <i class="fas fa-box"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e(number_format($monthlyStats['total_parcels'])); ?></div>
                    <div class="stat-label">พัสดุที่จัดส่ง</div>
                    <div class="stat-extra"><?php echo e($monthlyStats['total_days'] > 0 ? number_format($monthlyStats['total_parcels'] / $monthlyStats['total_days'], 1) : 0); ?> ชิ้น/วัน</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #A8E6CF, #56C596);">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e(number_format($monthlyStats['total_commission'], 2)); ?></div>
                    <div class="stat-label">ค่าคอมมิชชั่นรวม</div>
                    <div class="stat-extra">บาท</div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="mb-4" style="display: flex; gap: 1rem; flex-wrap: wrap; justify-content: center;">
            <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> บันทึกการจัดส่งใหม่
            </a>
            <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="btn" style="background: var(--info); color: white;">
                <i class="fas fa-history"></i> ประวัติการจัดส่ง
            </a>
            <a href="<?php echo e(route('vehicle.calculator')); ?>" class="btn" style="background: var(--success); color: white;">
                <i class="fas fa-calculator"></i> คำนวณค่าคอมมิชชั่น
            </a>
        </div><br>

        <!-- Main Data Table -->
        <div class="table-container">
            <div class="table-header">
                <h2 class="table-title">
                    <i class="fas fa-history"></i> 
                    บันทึกการจัดส่งล่าสุด 
                    <small style="font-weight: 400; color: var(--gray); font-size: 0.9rem;">
                        (รวม <?php echo e(number_format($totalRecords)); ?> รายการ)
                    </small>
                </h2>
            </div>

            <?php if($records->isEmpty()): ?>
                <!-- Empty State -->
                <div style="padding: 4rem 2rem; text-align: center;">
                    <div style="color: var(--gray); margin-bottom: 2rem;">
                        <i class="fas fa-inbox" style="font-size: 4rem; margin-bottom: 1rem; display: block;"></i>
                    </div>
                    <h3 style="color: var(--dark-gray); margin-bottom: 1rem; font-weight: 500;">ไม่พบข้อมูลการจัดส่ง</h3>
                    <p style="color: var(--gray); margin-bottom: 2rem;">ยังไม่มีบันทึกการจัดส่ง เริ่มบันทึกการจัดส่งแรกของคุณ</p>
                    <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus"></i> บันทึกการจัดส่งใหม่
                    </a>
                </div>
            <?php else: ?>
                <!-- Data Table -->
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>วันที่จัดส่ง</th>
                                <th>วัน</th>
                                <th>จำนวนพัสดุ</th>
                                <th>ค่าคอมมิชชั่น</th>
                                <th>อัตราเฉลี่ย</th>
                                <th>บันทึกเมื่อ</th>
                                <th>จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong style="color: var(--dark-gray);">
                                            <?php echo e(\Carbon\Carbon::parse($record->delivery_date)->format('d/m/Y')); ?>

                                        </strong>
                                    </td>
                                    <td>
                                        <?php
                                            $days = ['อาทิตย์','จันทร์','อังคาร','พุธ','พฤหัสบดี','ศุกร์','เสาร์'];
                                            echo $days[\Carbon\Carbon::parse($record->delivery_date)->dayOfWeek];
                                        ?>
                                    </td>
                                    <td>
                                        <span style="background: var(--info); color: white; padding: 0.25rem 0.75rem; border-radius: var(--radius-full); font-size: 0.85rem; font-weight: 500;">
                                            <?php echo e(number_format($record->parcel_count)); ?> ชิ้น
                                        </span>
                                    </td>
                                    <td>
                                        <strong style="color: var(--success); font-size: 1.05rem;">
                                            <?php echo e(number_format($record->commission_amount, 2)); ?> บาท
                                        </strong>
                                    </td>
                                    <td>
                                        <?php
                                            $rate = $record->parcel_count > 0 ? $record->commission_amount / $record->parcel_count : 0;
                                        ?>
                                        <span style="color: var(--gray); font-size: 0.9rem;">
                                            <?php echo e(number_format($rate, 2)); ?> บาท/ชิ้น
                                        </span>
                                    </td>
                                    <td>
                                        <span style="color: var(--gray); font-size: 0.9rem;">
                                            <?php echo e(\Carbon\Carbon::parse($record->created_at)->format('d/m/Y H:i')); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div style="display: flex; gap: 0.5rem;">
                                            <a href="<?php echo e(route('vehicle.deliveries.edit', $record)); ?>" 
                                               class="btn btn-sm" style="background: var(--warning); color: white;" 
                                               title="แก้ไข">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger" 
                                                    onclick="deleteRecord(<?php echo e($record->id); ?>)" title="ลบ">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if($records->hasPages()): ?>
                <div class="custom-pagination-wrapper">
                    <div class="custom-pagination-info">
                        แสดง <?php echo e($records->firstItem()); ?> - <?php echo e($records->lastItem()); ?> จาก <?php echo e(number_format($records->total())); ?> รายการ
                    </div>
                    <div class="custom-pagination">
                        <?php echo e($records->links('vendor.pagination.custom')); ?>

                    </div>
                </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>

        <!-- Performance Insights -->
        <div class="row mt-4">
            <div class="col-md-6">
                <div class="table-container">
                    <div class="table-header">
                        <h4 class="table-title">
                            <i class="fas fa-chart-line"></i> สถิติประสิทธิภาพ
                        </h4>
                    </div>
                    <div style="padding: 1.5rem;">
                        <div id="weekly-comparison" style="text-align: center;">
                            <div style="font-size: 0.9rem; color: var(--gray); margin-bottom: 0.5rem;">เปรียบเทียบสัปดาห์นี้ vs สัปดาห์ที่แล้ว</div>
                            <div id="comparison-content">
                                <i class="fas fa-spinner fa-spin"></i> กำลังโหลด...
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                                <div style="text-align: center; padding: 1rem; background: #f8f9fa; border-radius: 8px;">
                                    <div style="font-size: 1.2rem; font-weight: 600; color: var(--primary-orange);">
                                        <?php echo e($monthlyStats['total_days'] > 0 ? number_format($monthlyStats['total_parcels'] / $monthlyStats['total_days'], 1) : 0); ?>

                                    </div>
                                    <div style="font-size: 0.85rem; color: var(--gray);">เฉลี่ย/วัน</div>
                                </div>
                                <div style="text-align: center; padding: 1rem; background: #f8f9fa; border-radius: 8px;">
                                    <div style="font-size: 1.2rem; font-weight: 600; color: var(--success);">
                                        <?php echo e($monthlyStats['total_parcels'] > 0 ? number_format($monthlyStats['total_commission'] / $monthlyStats['total_parcels'], 2) : 0); ?>

                                    </div>
                                    <div style="font-size: 0.85rem; color: var(--gray);">บาท/ชิ้น</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="table-container">
                    <div class="table-header">
                        <h4 class="table-title">
                            <i class="fas fa-target"></i> เป้าหมายและคำแนะนำ
                        </h4>
                    </div>
                    <div style="padding: 1.5rem;">
                        <?php
                            $avgPerDay = $monthlyStats['total_days'] > 0 ? $monthlyStats['total_parcels'] / $monthlyStats['total_days'] : 0;
                            $daysLeft = now()->endOfMonth()->diffInDays(now());
                            $projectedMonthly = $avgPerDay * now()->endOfMonth()->day;
                        ?>
                        
                        <div class="mb-3">
                            <div style="display: flex; justify-content: space-between; margin-bottom: 0.5rem;">
                                <span style="font-size: 0.9rem; color: var(--gray);">ความคืบหน้าเดือนนี้</span>
                                <span style="font-size: 0.9rem; font-weight: 500;"><?php echo e(number_format($monthlyStats['total_parcels'])); ?> ชิ้น</span>
                            </div>
                            <div style="background: #e0e0e0; height: 8px; border-radius: 4px; overflow: hidden;">
                                <?php
                                    $progress = $projectedMonthly > 0 ? min(($monthlyStats['total_parcels'] / $projectedMonthly) * 100, 100) : 0;
                                ?>
                                <div style="background: var(--primary-gradient); height: 100%; width: <?php echo e($progress); ?>%; transition: width 0.3s ease;"></div>
                            </div>
                        </div>

                        <div class="tips">
                            <h6 style="color: var(--primary-orange); margin-bottom: 0.75rem;">💡 คำแนะนำ</h6>
                            <ul style="font-size: 0.9rem; color: var(--gray); line-height: 1.6; padding-left: 1.2rem;">
                                <?php if($avgPerDay < 50): ?>
                                    <li>ลองเพิ่มประสิทธิภาพการจัดส่งให้ได้มากกว่า 50 ชิ้น/วัน</li>
                                <?php elseif($avgPerDay < 100): ?>
                                    <li>ผลงานดี! เป้าหมายต่อไปคือ 100 ชิ้น/วัน</li>
                                <?php else: ?>
                                    <li>ยอดเยี่ยม! คุณอยู่ในระดับ Top Performer</li>
                                <?php endif; ?>
                                <li>ใช้เครื่องมือคำนวณค่าคอมมิชชั่นเพื่อวางแผนรายได้</li>
                                <li>บันทึกข้อมูลอย่างสม่ำเสมอเพื่อความแม่นยำ</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Load weekly comparison
    loadWeeklyComparison();
});

function loadWeeklyComparison() {
    fetch('/api/vehicle/weekly-comparison')
        .then(response => response.json())
        .then(data => {
            const content = document.getElementById('comparison-content');
            const trendIcon = data.trend === 'up' ? '📈' : (data.trend === 'down' ? '📉' : '➡️');
            const trendColor = data.trend === 'up' ? 'var(--success)' : (data.trend === 'down' ? '#e74c3c' : 'var(--gray)');
            
            content.innerHTML = `
                <div style="display: flex; justify-content: space-around; align-items: center;">
                    <div style="text-align: center;">
                        <div style="font-size: 1.5rem; font-weight: 600; color: var(--primary-orange);">${data.current_week}</div>
                        <div style="font-size: 0.8rem; color: var(--gray);">สัปดาห์นี้</div>
                    </div>
                    <div style="font-size: 1.5rem;">${trendIcon}</div>
                    <div style="text-align: center;">
                        <div style="font-size: 1.5rem; font-weight: 600; color: var(--gray);">${data.last_week}</div>
                        <div style="font-size: 0.8rem; color: var(--gray);">สัปดาห์ที่แล้ว</div>
                    </div>
                </div>
                <div style="margin-top: 0.75rem; font-size: 0.9rem; color: ${trendColor};">
                    ${data.percentage_change > 0 ? '+' : ''}${data.percentage_change}% 
                    ${data.trend === 'up' ? 'เพิ่มขึ้น' : (data.trend === 'down' ? 'ลดลง' : 'เท่าเดิม')}
                </div>
            `;
        })
        .catch(error => {
            document.getElementById('comparison-content').innerHTML = 
                '<span style="color: var(--gray);">ไม่สามารถโหลดข้อมูลได้</span>';
        });
}

function deleteRecord(id) {
    Swal.fire({
        title: 'ยืนยันการลบ',
        text: 'คุณต้องการลบบันทึกการจัดส่งนี้หรือไม่?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก',
        confirmButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/vehicle/deliveries/${id}`;
            
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'DELETE';
            
            form.appendChild(csrfToken);
            form.appendChild(methodField);
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Show session messages
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ',
        text: '<?php echo e(session('success')); ?>',
        timer: 3000,
        showConfirmButton: false
    });
<?php endif; ?>

<?php if(session('error')): ?>
    Swal.fire({
        icon: 'error',
        title: 'เกิดข้อผิดพลาด',
        text: '<?php echo e(session('error')); ?>'
    });
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.user-info {
    margin-top: 0.5rem;
    padding: 0.75rem 1rem;
    background: rgba(255, 107, 53, 0.05);
    border-radius: 8px;
    border-left: 4px solid var(--primary-orange);
}

.row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -0.75rem;
}

.col-md-6 {
    flex: 0 0 50%;
    max-width: 50%;
    padding: 0 0.75rem;
    margin-bottom: 1.5rem;
}

.stat-card {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
}

.stat-content {
    flex: 1;
}

.stat-extra {
    font-size: 0.85rem;
    color: var(--gray);
    margin-top: 0.25rem;
}

.tips ul {
    margin: 0;
}

@media (max-width: 768px) {
    .col-md-6 {
        flex: 0 0 100%;
        max-width: 100%;
    }
    
    .filter-form {
        grid-template-columns: 1fr !important;
    }
    
    .data-table th:nth-child(5),
    .data-table td:nth-child(5),
    .data-table th:nth-child(6),
    .data-table td:nth-child(6) {
        display: none;
    }
    
    .stat-card {
        flex-direction: column;
        text-align: center;
        gap: 0.5rem;
    }
    
    .stat-icon {
        width: 50px;
        height: 50px;
        font-size: 1.2rem;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/vehicle/dashboard.blade.php ENDPATH**/ ?>