<!-- resources/views/auth/forgot-password.blade.php -->
<?php if (isset($component)) { $__componentOriginal69dc84650370d1d4dc1b42d016d7226b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal69dc84650370d1d4dc1b42d016d7226b = $attributes; } ?>
<?php $component = App\View\Components\GuestLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('guest-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\GuestLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <!-- Include CSS -->
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap');
        @import url('<?php echo e(asset('css/app.css')); ?>');
        
        .auth-container {
            min-height: 100vh;
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            position: relative;
            overflow: hidden;
        }
        
        .auth-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><polygon fill="%23ffffff10" points="0,1000 1000,0 1000,1000"/></svg>');
            background-size: cover;
        }
        
        .auth-card {
            background: var(--white);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-xl);
            padding: 3rem 2.5rem;
            width: 100%;
            max-width: 420px;
            position: relative;
            z-index: 1;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .auth-header {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        
        .auth-logo {
            width: 60px;
            height: 60px;
            background: var(--primary-gradient);
            border-radius: var(--radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem auto;
            box-shadow: var(--shadow-md);
        }
        
        .auth-title {
            font-size: 1.75rem;
            font-weight: 600;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }
        
        .auth-subtitle {
            color: var(--gray);
            font-size: 1rem;
            line-height: 1.5;
        }
        
        .alert {
            padding: 1rem 1.25rem;
            border-radius: var(--radius-md);
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
            border: 1px solid;
        }
        
        .alert-success {
            background: rgba(34, 197, 94, 0.1);
            border-color: rgba(34, 197, 94, 0.3);
            color: #16a34a;
        }
        
        .auth-submit {
            width: 100%;
            background: var(--primary-gradient);
            color: var(--white);
            border: none;
            padding: 0.875rem 1.5rem;
            border-radius: var(--radius-md);
            font-family: inherit;
            font-weight: 500;
            font-size: 1rem;
            cursor: pointer;
            transition: var(--transition-fast);
            box-shadow: var(--shadow-sm);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }
        
        .auth-submit:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }
        
        .auth-submit:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .auth-footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--medium-gray);
        }
        
        .auth-link {
            color: var(--primary-orange);
            text-decoration: none;
            font-weight: 500;
            transition: var(--transition-fast);
            font-size: 0.9rem;
        }
        
        .auth-link:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }
        
        .info-card {
            background: rgba(59, 130, 246, 0.05);
            border: 1px solid rgba(59, 130, 246, 0.2);
            border-radius: var(--radius-md);
            padding: 1.5rem;
            margin-top: 2rem;
        }
        
        .info-title {
            color: #2563eb;
            font-weight: 600;
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.95rem;
        }
        
        .info-content {
            color: var(--gray);
            font-size: 0.85rem;
            line-height: 1.5;
        }
        
        @media (max-width: 640px) {
            .auth-card {
                padding: 2rem 1.5rem;
                margin: 1rem;
            }
        }
    </style>

    <div class="auth-container">
        <div class="auth-card">
            <!-- Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    <svg width="32" height="32" fill="white" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                    </svg>
                </div>
                <h1 class="auth-title">ลืมรหัสผ่าน?</h1>
                <p class="auth-subtitle">
                    ไม่ต้องกังวล เพียงแจ้งที่อยู่อีเมลของคุณ และเราจะส่งลิงก์รีเซ็ตรหัสผ่านให้คุณ
                </p>
            </div>

            <!-- Session Status -->
            <?php if(session('status')): ?>
                <div class="alert alert-success">
                    <div style="display: flex; align-items: center; gap: 0.5rem;">
                        <svg width="20" height="20" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                        </svg>
                        <?php echo e(session('status')); ?>

                    </div>
                </div>
            <?php endif; ?>

            <!-- Form -->
            <form method="POST" action="<?php echo e(route('password.email')); ?>" id="forgotForm">
                <?php echo csrf_field(); ?>

                <!-- Email Address -->
                <div class="form-group" style="margin-bottom: 2rem;">
                    <label for="email" class="form-label">อีเมล</label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           value="<?php echo e(old('email')); ?>" 
                           required 
                           autofocus 
                           autocomplete="username"
                           placeholder="example@email.com">
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="auth-submit" id="submitBtn">
                    <span id="submitText">ส่งลิงก์รีเซ็ตรหัสผ่าน</span>
                    <svg class="animate-spin hidden" id="loadingIcon" width="20" height="20" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </button>

                <!-- Footer Links -->
                <div class="auth-footer">
                    <div style="display: flex; flex-direction: column; gap: 1rem; align-items: center;">
                        <a href="<?php echo e(route('login')); ?>" class="auth-link">
                            <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="margin-right: 0.5rem;">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                            </svg>
                            กลับสู่หน้าเข้าสู่ระบบ
                        </a>
                        
                        <div style="color: var(--gray); font-size: 0.9rem;">
                            ยังไม่มีบัญชี? 
                            <a href="<?php echo e(route('register')); ?>" class="auth-link">สมัครสมาชิก</a>
                        </div>
                    </div>
                </div>
            </form>

            <!-- Information Card -->
            <div class="info-card">
                <div class="info-title">
                    <svg width="16" height="16" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                    </svg>
                    ข้อมูลการรีเซ็ตรหัสผ่าน
                </div>
                <div class="info-content">
                    <ul style="margin: 0; padding-left: 1rem; line-height: 1.6;">
                        <li>ลิงก์รีเซ็ตรหัสผ่านจะถูกส่งไปยังอีเมลที่คุณระบุ</li>
                        <li>ลิงก์จะมีอายุการใช้งาน 60 นาที</li>
                        <li>หากไม่พบอีเมลในกล่องจดหมาย ให้ตรวจสอบในโฟลเดอร์ Spam</li>
                        <li>หากยังไม่ได้รับอีเมล สามารถขอส่งใหม่ได้อีกครั้ง</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Form submission handling
        document.getElementById('forgotForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            const submitText = document.getElementById('submitText');
            const loadingIcon = document.getElementById('loadingIcon');
            
            submitBtn.disabled = true;
            submitText.textContent = 'กำลังส่งอีเมล...';
            loadingIcon.classList.remove('hidden');
        });

        // Email validation
        document.getElementById('email').addEventListener('blur', function() {
            const email = this.value;
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            
            if (email && !emailRegex.test(email)) {
                this.style.borderColor = 'var(--danger)';
                this.style.boxShadow = '0 0 0 3px rgba(239, 68, 68, 0.1)';
            } else {
                this.style.borderColor = 'var(--medium-gray)';
                this.style.boxShadow = 'none';
            }
        });

        // Focus management
        document.getElementById('email').focus();
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal69dc84650370d1d4dc1b42d016d7226b)): ?>
<?php $attributes = $__attributesOriginal69dc84650370d1d4dc1b42d016d7226b; ?>
<?php unset($__attributesOriginal69dc84650370d1d4dc1b42d016d7226b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal69dc84650370d1d4dc1b42d016d7226b)): ?>
<?php $component = $__componentOriginal69dc84650370d1d4dc1b42d016d7226b; ?>
<?php unset($__componentOriginal69dc84650370d1d4dc1b42d016d7226b); ?>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/auth/forgot-password.blade.php ENDPATH**/ ?>