

<?php $__env->startSection('title', 'จัดการอัตราค่าคอมมิชชั่น - ระบบจัดการค่าคอมมิชชั่น'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-container">
    <!-- Enhanced Page Header -->
    <div class="page-header">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="page-title">
                    <i class="fas fa-percentage text-orange-500 mr-3"></i>
                    จัดการอัตราค่าคอมมิชชั่น
                </h1>
                <p class="page-subtitle">กำหนดและจัดการอัตราค่าคอมมิชชั่นสำหรับแต่ละคลังและประเภทรถ</p>
            </div>
            <div class="flex space-x-3">
                <button onclick="showCalculator()" class="btn btn-info">
                    <i class="fas fa-calculator"></i>คำนวณค่าคอมมิชชั่น
                </button>
                <button onclick="exportRates()" class="btn btn-success">
                    <i class="fas fa-download"></i>Export CSV
                </button>
                <a href="<?php echo e(route('admin.commission-rates.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i>เพิ่มอัตราใหม่
                </a>
            </div>
        </div>
    </div>

    <!-- Enhanced Stats Cards -->
    <div class="dashboard-grid">
        <div class="dashboard-card dashboard-card-orange">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-orange">
                        <i class="fas fa-percentage"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num"><?php echo e(number_format($stats['total'] ?? 0)); ?></div>
                        <div class="dashboard-card-label">อัตราทั้งหมด</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status">
                        <i class="fas fa-chart-line"></i>
                        <span>ทั้งระบบ</span>
                    </div>
                    <a href="#" class="dashboard-card-link">ดูรายละเอียด</a>
                </div>
            </div>
        </div>

        <div class="dashboard-card dashboard-card-green">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-green">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num"><?php echo e(number_format($stats['active'] ?? 0)); ?></div>
                        <div class="dashboard-card-label">อัตราที่ใช้งาน</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-green">
                        <i class="fas fa-check"></i>
                        <span>ใช้งานอยู่</span>
                    </div>
                    <a href="#" onclick="filterByStatus('active')" class="dashboard-card-link">กรองดู</a>
                </div>
            </div>
        </div>

        <div class="dashboard-card dashboard-card-blue">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-blue">
                        <i class="fas fa-warehouse"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num"><?php echo e(number_format($stats['warehouses'] ?? 0)); ?></div>
                        <div class="dashboard-card-label">คลังที่มีอัตรา</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-blue">
                        <i class="fas fa-building"></i>
                        <span>คลังสินค้า</span>
                    </div>
                    <a href="#" class="dashboard-card-link">จัดการคลัง</a>
                </div>
            </div>
        </div>

        <div class="dashboard-card dashboard-card-purple">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-purple">
                        <i class="fas fa-layer-group"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num"><?php echo e(number_format($stats['avg_tiers'] ?? 0, 1)); ?></div>
                        <div class="dashboard-card-label">ขั้นเฉลี่ย/คลัง</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-purple">
                        <i class="fas fa-stairs"></i>
                        <span>ระดับขั้น</span>
                    </div>
                    <a href="#" class="dashboard-card-link">วิเคราะห์</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Filters -->
    <div class="modern-card">
        <div class="modern-card-header">
            <h3 class="modern-card-title">
                <i class="fas fa-filter text-blue-500"></i>
                ตัวกรองและค้นหา
            </h3>
        </div>
        <div class="modern-card-body">
            <form method="GET" action="<?php echo e(route('admin.commission-rates.index')); ?>" class="filter-form">
                <div class="filter-grid">
                    <div class="form-group">
                        <label class="form-label">คลังสินค้า</label>
                        <div class="input-with-icon">
                            <i class="fas fa-warehouse input-icon"></i>
                            <select name="warehouse" class="form-control" onchange="this.form.submit()">
                                <option value="">ทั้งหมด</option>
                                <?php $__currentLoopData = $warehouses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($warehouse->code); ?>" 
                                            <?php echo e(request('warehouse') === $warehouse->code ? 'selected' : ''); ?>>
                                        <?php echo e($warehouse->code); ?> - <?php echo e($warehouse->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">ประเภทรถ</label>
                        <div class="input-with-icon">
                            <i class="fas fa-truck input-icon"></i>
                            <select name="vehicle_type" class="form-control" onchange="this.form.submit()">
                                <option value="">ทั้งหมด</option>
                                <option value="2wheel" <?php echo e(request('vehicle_type') === '2wheel' ? 'selected' : ''); ?>>
                                    🏍️ รถ 2 ล้อ
                                </option>
                                <option value="4wheel" <?php echo e(request('vehicle_type') === '4wheel' ? 'selected' : ''); ?>>
                                    🚚 รถ 4 ล้อ
                                </option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">สถานะ</label>
                        <div class="input-with-icon">
                            <i class="fas fa-toggle-on input-icon"></i>
                            <select name="status" class="form-control" onchange="this.form.submit()">
                                <option value="">ทั้งหมด</option>
                                <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>
                                    ✅ ใช้งานอยู่
                                </option>
                                <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>
                                    ❌ ปิดใช้งาน
                                </option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">การดำเนินการ</label>
                        <div class="filter-actions">
                            <a href="<?php echo e(route('admin.commission-rates.index')); ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i>ล้าง
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Commission Rates Display -->
    <?php if(isset($commissionRates) && $commissionRates->isNotEmpty()): ?>
        <?php
            $groupedRates = $commissionRates->groupBy(['warehouse_code', 'vehicle_type']);
        ?>

        <?php $__currentLoopData = $groupedRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouseCode => $warehouseRates): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $warehouse = $warehouses->firstWhere('code', $warehouseCode);
            ?>
            
            <div class="modern-card mb-6">
                <div class="modern-card-header">
                    <div class="flex items-center justify-between">
                        <h3 class="modern-card-title">
                            <i class="fas fa-warehouse text-blue-500"></i>
                            คลัง: <?php echo e($warehouseCode); ?> - <?php echo e($warehouse->name ?? 'ไม่พบชื่อคลัง'); ?>

                        </h3>
                        <div class="flex space-x-2">
                            <button onclick="addRateForWarehouse('<?php echo e($warehouseCode); ?>')" class="btn btn-sm btn-primary">
                                <i class="fas fa-plus"></i>เพิ่มอัตรา
                            </button>
                            <button onclick="bulkAction('<?php echo e($warehouseCode); ?>')" class="btn btn-sm btn-warning">
                                <i class="fas fa-cogs"></i>จัดการทั้งหมด
                            </button>
                        </div>
                    </div>
                    <?php if($warehouse && $warehouse->location): ?>
                        <p class="text-sm text-gray-600 mt-1">
                            <i class="fas fa-map-marker-alt"></i> <?php echo e($warehouse->location); ?>

                        </p>
                    <?php endif; ?>
                </div>
                
                <div class="modern-card-body">
                    <?php $__currentLoopData = $warehouseRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicleType => $rates): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="vehicle-section mb-6">
                            <div class="flex items-center justify-between mb-4">
                                <h4 class="text-lg font-semibold flex items-center">
                                    <i class="fas fa-<?php echo e($vehicleType === '2wheel' ? 'motorcycle' : 'truck'); ?> text-orange-500 mr-2"></i>
                                    <?php echo e($vehicleType === '2wheel' ? 'รถ 2 ล้อ' : 'รถ 4 ล้อ'); ?>

                                    <span class="ml-2 px-2 py-1 bg-gray-100 text-gray-600 text-sm rounded-full">
                                        <?php echo e($rates->count()); ?> ขั้น
                                    </span>
                                </h4>
                                <button onclick="previewCommission('<?php echo e($warehouseCode); ?>', '<?php echo e($vehicleType); ?>')" 
                                        class="btn btn-sm btn-info">
                                    <i class="fas fa-calculator"></i>ทดสอบคำนวณ
                                </button>
                            </div>
                            
                            <div class="commission-tier-box">
                                <div class="commission-title">
                                    <i class="fas fa-layer-group"></i>
                                    โครงสร้างอัตราค่าคอมมิชชั่น
                                </div>
                                
                                <ul class="commission-tier-list">
                                    <?php $__currentLoopData = $rates->sortBy('tier'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="commission-tier-item" data-rate-id="<?php echo e($rate->id); ?>">
                                            <span class="tier-count">ขั้นที่ <?php echo e($rate->tier); ?></span>
                                            <span class="tier-label">:</span>
                                            <span class="tier-range">
                                                <?php echo e(number_format($rate->min_packages)); ?>

                                                <?php if($rate->max_packages): ?>
                                                    - <?php echo e(number_format($rate->max_packages)); ?>

                                                <?php else: ?>
                                                    +
                                                <?php endif; ?>
                                                ชิ้น
                                            </span>
                                            <span class="tier-mult">×</span>
                                            <span class="tier-rate"><?php echo e(number_format($rate->rate_per_package, 2)); ?></span>
                                            <span class="tier-currency">บาท/ชิ้น</span>
                                            
                                            <div class="ml-auto flex items-center space-x-2">
                                                <?php if($rate->is_active): ?>
                                                    <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded-full">
                                                        ใช้งาน
                                                    </span>
                                                <?php else: ?>
                                                    <span class="px-2 py-1 bg-red-100 text-red-800 text-xs rounded-full">
                                                        ปิดใช้งาน
                                                    </span>
                                                <?php endif; ?>
                                                
                                                <div class="action-buttons">
                                                    <button onclick="editRate(<?php echo e($rate->id); ?>)" 
                                                            class="action-btn action-edit" title="แก้ไข">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <button onclick="toggleRateStatus(<?php echo e($rate->id); ?>)" 
                                                            class="action-btn action-toggle" title="เปลี่ยนสถานะ">
                                                        <i class="fas fa-<?php echo e($rate->is_active ? 'pause' : 'play'); ?>"></i>
                                                    </button>
                                                    <button onclick="deleteRate(<?php echo e($rate->id); ?>)" 
                                                            class="action-btn action-delete" title="ลบ">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                
                                <!-- Commission Preview Example -->
                                <div class="mt-4 p-3 bg-gray-50 rounded-lg">
                                    <div class="commission-total">
                                        <i class="fas fa-info-circle"></i>
                                        <span class="label">ตัวอย่าง: จัดส่ง 150 ชิ้น</span>
                                        <div id="preview-<?php echo e($warehouseCode); ?>-<?php echo e($vehicleType); ?>" class="commission-preview">
                                            <span class="loading-text">กำลังคำนวณ...</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <!-- Empty State -->
        <div class="modern-card">
            <div class="modern-card-body">
                <div class="empty-state">
                    <div class="empty-content">
                        <i class="fas fa-percentage text-6xl text-gray-300 mb-4"></i>
                        <h3 class="text-xl font-semibold text-gray-500 mb-2">ยังไม่มีอัตราค่าคอมมิชชั่น</h3>
                        <p class="text-gray-400 mb-4">เริ่มต้นการตั้งค่าอัตราค่าคอมมิชชั่นสำหรับคลังและประเภทรถต่างๆ</p>
                        <a href="<?php echo e(route('admin.commission-rates.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i>เพิ่มอัตราแรก
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Commission Calculator Modal -->
<div id="calculatorModal" class="modal" style="display: none;">
    <div class="modal-content">
        <div class="modal-header">
            <h3 class="modal-title">
                <i class="fas fa-calculator text-blue-500"></i>
                คำนวณค่าคอมมิชชั่น
            </h3>
            <button onclick="closeCalculator()" class="modal-close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="modal-body">
            <form id="calculatorForm" class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="form-group">
                        <label class="form-label">คลังสินค้า</label>
                        <select id="calc_warehouse" name="warehouse_code" class="form-control" required>
                            <option value="">เลือกคลัง</option>
                            <?php $__currentLoopData = $warehouses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($warehouse->code); ?>">
                                    <?php echo e($warehouse->code); ?> - <?php echo e($warehouse->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">ประเภทรถ</label>
                        <select id="calc_vehicle" name="vehicle_type" class="form-control" required>
                            <option value="">เลือกประเภท</option>
                            <option value="2wheel">🏍️ รถ 2 ล้อ</option>
                            <option value="4wheel">🚚 รถ 4 ล้อ</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">จำนวนพัสดุ</label>
                        <input type="number" id="calc_packages" name="package_count" 
                               class="form-control" min="1" placeholder="กรอกจำนวน" required>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary w-full">
                    <i class="fas fa-calculator"></i>คำนวณ
                </button>
            </form>
            
            <div id="calculatorResult" class="mt-6" style="display: none;">
                <!-- Results will be displayed here -->
            </div>
        </div>
    </div>
</div>

<!-- Enhanced Styles -->
<style>
/* Fix Horizontal Scrollbar */
* {
    box-sizing: border-box;
}

body {
    overflow-x: hidden;
}

.content-container {
    max-width: 100vw;
    overflow-x: hidden;
    padding-left: 1rem;
    padding-right: 1rem;
    box-sizing: border-box;
}

.page-header,
.modern-card,
.dashboard-grid {
    max-width: 100%;
    overflow-x: auto;
    box-sizing: border-box;
}

.page-header .flex {
    flex-wrap: wrap;
    gap: 1rem;
}

.dashboard-grid {
    width: 100%;
    min-width: 0;
}

/* Enhanced Filter Form Styles */
.filter-form {
    width: 100%;
    overflow-x: auto;
}

.filter-grid {
    display: grid;
    grid-template-columns: minmax(200px, 2fr) minmax(150px, 1.5fr) minmax(150px, 1.5fr) minmax(120px, 1fr);
    gap: 1rem;
    align-items: end;
    width: 100%;
    min-width: 0;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-label {
    font-weight: 500;
    color: var(--dark-gray);
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}

.input-with-icon {
    position: relative;
    display: flex;
    align-items: center;
}

.input-icon {
    position: absolute;
    left: 0.75rem;
    color: var(--gray);
    font-size: 0.9rem;
    z-index: 1;
}

.form-control {
    width: 100%;
    padding: 0.75rem 1rem 0.75rem 2.5rem;
    border: 2px solid var(--medium-gray);
    border-radius: var(--radius-md);
    font-family: inherit;
    font-size: 0.95rem;
    transition: var(--transition-fast);
    background: var(--white);
}

.form-control:focus {
    outline: none;
    border-color: var(--primary-orange);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.filter-actions {
    display: flex;
    gap: 0.5rem;
}

.filter-actions .btn {
    flex: 1;
    min-width: 0;
}

/* Vehicle Section */
.vehicle-section {
    border: 1px solid var(--medium-gray);
    border-radius: var(--radius-lg);
    padding: 1.5rem;
    background: rgba(255, 107, 53, 0.01);
}

.vehicle-section:not(:last-child) {
    margin-bottom: 1.5rem;
}

/* Action Buttons */
.action-buttons {
    display: flex;
    gap: 0.5rem;
    opacity: 0;
    transition: var(--transition-fast);
}

.commission-tier-item:hover .action-buttons {
    opacity: 1;
}

.action-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 28px;
    height: 28px;
    border-radius: var(--radius-sm);
    border: none;
    cursor: pointer;
    transition: var(--transition-fast);
    text-decoration: none;
    font-size: 0.8rem;
}

.action-edit {
    background: #dbeafe;
    color: #2563eb;
}

.action-edit:hover {
    background: #2563eb;
    color: white;
    transform: scale(1.1);
}

.action-toggle {
    background: #f3f4f6;
    color: #6b7280;
}

.action-toggle:hover {
    background: #6b7280;
    color: white;
    transform: scale(1.1);
}

.action-delete {
    background: #fee2e2;
    color: #dc2626;
}

.action-delete:hover {
    background: #dc2626;
    color: white;
    transform: scale(1.1);
}

/* Empty State */
.empty-state {
    padding: 4rem 2rem;
    text-align: center;
}

.empty-content {
    display: flex;
    flex-direction: column;
    align-items: center;
}

/* Modal Styles */
.modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.6);
    z-index: 9999;
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(4px);
}

.modal-content {
    background: white;
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-xl);
    max-width: 800px;
    width: 90%;
    max-height: 90vh;
    overflow-y: auto;
    animation: modalSlideIn 0.3s ease-out;
}

@keyframes modalSlideIn {
    from {
        opacity: 0;
        transform: translateY(-20px) scale(0.95);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.modal-header {
    padding: 1.5rem 2rem;
    border-bottom: 1px solid var(--medium-gray);
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.modal-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--dark-gray);
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0;
}

.modal-close {
    background: none;
    border: none;
    color: var(--gray);
    cursor: pointer;
    padding: 0.5rem;
    border-radius: var(--radius-sm);
    transition: var(--transition-fast);
}

.modal-close:hover {
    background: var(--light-gray);
    color: var(--dark-gray);
}

.modal-body {
    padding: 2rem;
}

/* Commission Preview */
.commission-preview {
    font-size: 0.875rem;
    color: var(--dark-gray);
    margin-top: 0.5rem;
}

.loading-text {
    color: var(--gray);
    font-style: italic;
}

/* Button Variants */
.btn-sm {
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
}

.btn-info {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
}

.btn-info:hover {
    background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
    transform: translateY(-1px);
}

.btn-success {
    background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
    color: white;
}

.btn-success:hover {
    background: linear-gradient(135deg, #16a34a 0%, #15803d 100%);
    transform: translateY(-1px);
}

.btn-warning {
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    color: white;
}

.btn-warning:hover {
    background: linear-gradient(135deg, #d97706 0%, #b45309 100%);
    transform: translateY(-1px);
}

.btn-secondary {
    background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
    color: white;
}

.btn-secondary:hover {
    background: linear-gradient(135deg, #4b5563 0%, #374151 100%);
    transform: translateY(-1px);
}

/* Responsive Design */
@media (max-width: 1200px) {
    .filter-grid {
        grid-template-columns: minmax(180px, 1fr) minmax(120px, 1fr) minmax(120px, 1fr) minmax(100px, 1fr);
        gap: 0.75rem;
    }
    
    .content-container {
        padding-left: 0.75rem;
        padding-right: 0.75rem;
    }
}

@media (max-width: 992px) {
    .filter-grid {
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
    }
}

@media (max-width: 768px) {
    .content-container {
        padding-left: 0.5rem;
        padding-right: 0.5rem;
    }
    
    .filter-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .dashboard-grid {
        grid-template-columns: 1fr;
    }
    
    .action-buttons {
        opacity: 1;
    }
    
    .page-header .flex {
        flex-direction: column;
        align-items: stretch;
    }
    
    .modal-content {
        width: 95%;
        margin: 1rem;
    }
    
    .modal-header,
    .modal-body {
        padding: 1rem;
    }
}

@media (max-width: 480px) {
    .content-container {
        padding-left: 0.25rem;
        padding-right: 0.25rem;
    }
    
    .form-control {
        padding: 0.6rem 0.8rem 0.6rem 2.2rem;
        font-size: 0.9rem;
    }
    
    .input-icon {
        left: 0.6rem;
        font-size: 0.85rem;
    }
    
    .commission-tier-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
        padding: 1rem;
    }
    
    .vehicle-section {
        padding: 1rem;
    }
    
    .page-header,
    .modern-card {
        margin-left: 0;
        margin-right: 0;
        border-radius: 8px;
    }
}

/* Hide horizontal scrollbar but keep functionality */
::-webkit-scrollbar:horizontal {
    height: 0px;
    background: transparent;
}

/* Additional overflow fixes */
.main-content {
    overflow-x: hidden;
}

.modern-card-body {
    overflow-x: auto;
}

.flex {
    min-width: 0;
}

.flex > * {
    min-width: 0;
}
</style>

<!-- Enhanced JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Global variables
let calculatorChart = null;

// Show calculator modal
function showCalculator() {
    document.getElementById('calculatorModal').style.display = 'flex';
    document.body.style.overflow = 'hidden';
}

// Close calculator modal
function closeCalculator() {
    document.getElementById('calculatorModal').style.display = 'none';
    document.body.style.overflow = '';
    document.getElementById('calculatorResult').style.display = 'none';
}

// Filter by status
function filterByStatus(status) {
    const url = new URL(window.location);
    url.searchParams.set('status', status);
    window.location.href = url.toString();
}

// Add rate for specific warehouse
function addRateForWarehouse(warehouseCode) {
    const url = `<?php echo e(route('admin.commission-rates.create')); ?>?warehouse=${warehouseCode}`;
    window.location.href = url;
}

// Edit rate
function editRate(rateId) {
    const url = `<?php echo e(route('admin.commission-rates.index')); ?>/${rateId}/edit`;
    window.location.href = url;
}

// Toggle rate status
function toggleRateStatus(rateId) {
    Swal.fire({
        title: 'ยืนยันการเปลี่ยนสถานะ',
        text: 'คุณต้องการเปลี่ยนสถานะการใช้งานของอัตรานี้หรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ยืนยัน',
        cancelButtonText: 'ยกเลิก',
        showLoaderOnConfirm: true,
        preConfirm: () => {
            return fetch(`/admin/commission-rates/${rateId}/toggle`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    throw new Error(data.message || 'เกิดข้อผิดพลาด');
                }
                return data;
            })
            .catch(error => {
                Swal.showValidationMessage(`เกิดข้อผิดพลาด: ${error.message}`);
            });
        }
    }).then((result) => {
        if (result.isConfirmed && result.value) {
            Swal.fire({
                icon: 'success',
                title: 'สำเร็จ!',
                text: result.value.message,
                confirmButtonColor: '#FF6B35'
            }).then(() => {
                location.reload();
            });
        }
    });
}

// Delete rate
function deleteRate(rateId) {
    Swal.fire({
        title: 'ยืนยันการลบ',
        text: 'คุณต้องการลบอัตราค่าคอมมิชชั่นนี้หรือไม่? การดำเนินการนี้ไม่สามารถยกเลิกได้',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#EF4444',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก',
        showLoaderOnConfirm: true,
        preConfirm: () => {
            return fetch(`/admin/commission-rates/${rateId}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    throw new Error(data.message || 'เกิดข้อผิดพลาด');
                }
                return data;
            })
            .catch(error => {
                Swal.showValidationMessage(`เกิดข้อผิดพลาด: ${error.message}`);
            });
        }
    }).then((result) => {
        if (result.isConfirmed && result.value) {
            Swal.fire({
                icon: 'success',
                title: 'สำเร็จ!',
                text: result.value.message,
                confirmButtonColor: '#FF6B35'
            }).then(() => {
                location.reload();
            });
        }
    });
}

// Preview commission calculation
function previewCommission(warehouseCode, vehicleType) {
    // Set values in calculator modal
    document.getElementById('calc_warehouse').value = warehouseCode;
    document.getElementById('calc_vehicle').value = vehicleType;
    document.getElementById('calc_packages').value = 150; // Default example
    
    showCalculator();
    
    // Auto calculate
    setTimeout(() => {
        document.getElementById('calculatorForm').dispatchEvent(new Event('submit'));
    }, 500);
}

// Export rates
function exportRates() {
    const params = new URLSearchParams(window.location.search);
    params.set('format', 'export');
    
    // Show loading
    Swal.fire({
        title: 'กำลังเตรียมข้อมูล',
        text: 'กรุณารอสักครู่...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    // Create temporary link for download
    const link = document.createElement('a');
    link.href = `/admin/commission-rates/export?${params.toString()}`;
    link.download = `commission_rates_${new Date().toISOString().split('T')[0]}.csv`;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    
    // Close loading
    setTimeout(() => {
        Swal.close();
        
        const toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });
        
        toast.fire({
            icon: 'success',
            title: 'ส่งออกข้อมูลสำเร็จ!'
        });
    }, 1000);
}

// Bulk actions
function bulkAction(warehouseCode) {
    Swal.fire({
        title: 'เลือกการดำเนินการ',
        text: `จัดการอัตราทั้งหมดของคลัง ${warehouseCode}`,
        icon: 'question',
        showCancelButton: true,
        showDenyButton: true,
        confirmButtonText: 'เปิดใช้งานทั้งหมด',
        denyButtonText: 'ปิดใช้งานทั้งหมด',
        cancelButtonText: 'ยกเลิก',
        confirmButtonColor: '#22C55E',
        denyButtonColor: '#EF4444',
        cancelButtonColor: '#6B7280'
    }).then((result) => {
        if (result.isConfirmed) {
            performBulkAction('activate', warehouseCode);
        } else if (result.isDenied) {
            performBulkAction('deactivate', warehouseCode);
        }
    });
}

// Perform bulk action
function performBulkAction(action, warehouseCode) {
    Swal.fire({
        title: 'กำลังดำเนินการ...',
        text: 'กรุณารอสักครู่',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    fetch(`/admin/commission-rates/bulk`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            action: action,
            warehouse: warehouseCode
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'สำเร็จ!',
                text: data.message,
                confirmButtonColor: '#FF6B35'
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'เกิดข้อผิดพลาด!',
                text: data.message,
                confirmButtonColor: '#FF6B35'
            });
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            icon: 'error',
            title: 'เกิดข้อผิดพลาด!',
            text: 'ไม่สามารถดำเนินการได้',
            confirmButtonColor: '#FF6B35'
        });
    });
}

// Initialize page
document.addEventListener('DOMContentLoaded', function() {
    // Calculator form submission
    document.getElementById('calculatorForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const data = Object.fromEntries(formData);
        
        if (!data.warehouse_code || !data.vehicle_type || !data.package_count) {
            Swal.fire({
                icon: 'warning',
                title: 'กรอกข้อมูลไม่ครบ',
                text: 'กรุณากรอกข้อมูลให้ครบถ้วน',
                confirmButtonColor: '#FF6B35'
            });
            return;
        }
        
        // Show loading
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> กำลังคำนวณ...';
        submitBtn.disabled = true;
        
        fetch(`/admin/commission-rates/calculate`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                displayCalculationResult(data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'เกิดข้อผิดพลาด!',
                    text: data.message,
                    confirmButtonColor: '#FF6B35'
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'เกิดข้อผิดพลาด!',
                text: 'ไม่สามารถคำนวณได้',
                confirmButtonColor: '#FF6B35'
            });
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });
    
    // Load commission previews for each warehouse/vehicle combination
    loadCommissionPreviews();
    
    // Close modals on ESC key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeCalculator();
        }
    });
});

// Display calculation result
function displayCalculationResult(data) {
    const resultDiv = document.getElementById('calculatorResult');
    
    let breakdownHtml = '';
    if (data.breakdown && data.breakdown.length > 0) {
        breakdownHtml = data.breakdown.map(tier => `
            <div class="commission-tier-item">
                <span class="tier-count">ขั้นที่ ${tier.tier}</span>
                <span class="tier-label">:</span>
                <span class="tier-range">${tier.range}</span>
                <span class="tier-mult">×</span>
                <span class="tier-count">${tier.packages_in_tier}</span>
                <span class="tier-label">ชิ้น ×</span>
                <span class="tier-rate">${tier.rate_per_package}</span>
                <span class="tier-currency">บาท =</span>
                <span class="tier-sum">${tier.formatted_commission}</span>
            </div>
        `).join('');
    }
    
    resultDiv.innerHTML = `
        <div class="commission-tier-box">
            <div class="commission-title">
                <i class="fas fa-calculator"></i>
                ผลการคำนวณค่าคอมมิชชั่น
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                <div class="bg-blue-50 p-4 rounded-lg text-center">
                    <div class="text-2xl font-bold text-blue-600">${data.package_count || 0}</div>
                    <div class="text-sm text-blue-600">ชิ้น</div>
                </div>
                <div class="bg-green-50 p-4 rounded-lg text-center">
                    <div class="text-2xl font-bold text-green-600">${data.formatted_total || '0.00'}</div>
                    <div class="text-sm text-green-600">ค่าคอมมิชชั่นรวม</div>
                </div>
                <div class="bg-orange-50 p-4 rounded-lg text-center">
                    <div class="text-2xl font-bold text-orange-600">${data.formatted_average || '0.00'}</div>
                    <div class="text-sm text-orange-600">เฉลี่ยต่อชิ้น</div>
                </div>
            </div>
            
            ${breakdownHtml ? `
                <ul class="commission-tier-list">
                    ${breakdownHtml}
                </ul>
                
                <div class="commission-total">
                    <i class="fas fa-coins"></i>
                    <span class="label">ค่าคอมมิชชั่นรวม:</span>
                    <span class="amount">${data.formatted_total || '0.00'}</span>
                </div>
            ` : `
                <div class="text-center py-4 text-gray-500">
                    <i class="fas fa-exclamation-circle text-2xl mb-2"></i>
                    <div>ไม่พบอัตราค่าคอมมิชชั่นสำหรับเงื่อนไขนี้</div>
                </div>
            `}
        </div>
    `;
    
    resultDiv.style.display = 'block';
}

// Load commission previews
function loadCommissionPreviews() {
    document.querySelectorAll('[id^="preview-"]').forEach(previewElement => {
        const id = previewElement.id;
        const parts = id.split('-');
        if (parts.length >= 3) {
            const warehouseCode = parts[1];
            const vehicleType = parts[2];
            
            // Calculate preview for 150 packages
            fetch(`/admin/commission-rates/calculate`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    warehouse_code: warehouseCode,
                    vehicle_type: vehicleType,
                    package_count: 150
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    previewElement.innerHTML = `
                        <div class="flex items-center justify-between">
                            <span>ค่าคอมมิชชั่น: <strong class="text-orange-600">${data.formatted_total || '0.00'}</strong></span>
                            <span class="text-sm text-gray-500">(เฉลี่ย ${data.formatted_average || '0.00'})</span>
                        </div>
                    `;
                } else {
                    previewElement.innerHTML = `
                        <div class="text-red-500 text-sm">
                            <i class="fas fa-exclamation-triangle"></i> ไม่สามารถคำนวณได้
                        </div>
                    `;
                }
            })
            .catch(error => {
                console.error('Preview calculation error:', error);
                previewElement.innerHTML = `
                    <div class="text-gray-400 text-sm">
                        <i class="fas fa-calculator"></i> ไม่สามารถโหลดตัวอย่างได้
                    </div>
                `;
            });
        }
    });
}

// Show success/error messages from session
<?php if(session('success')): ?>
    document.addEventListener('DOMContentLoaded', function() {
        const toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 4000,
            timerProgressBar: true
        });
        
        toast.fire({
            icon: 'success',
            title: '<?php echo e(session('success')); ?>'
        });
    });
<?php endif; ?>

<?php if(session('error')): ?>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: 'error',
            title: 'เกิดข้อผิดพลาด!',
            text: '<?php echo e(session('error')); ?>',
            confirmButtonColor: '#FF6B35'
        });
    });
<?php endif; ?>

// Auto-refresh previews every 30 seconds
setInterval(loadCommissionPreviews, 30000);

// Keyboard shortcuts
document.addEventListener('keydown', function(e) {
    // Escape to close modals
    if (e.key === 'Escape') {
        closeCalculator();
    }
    
    // Ctrl/Cmd + N to add new rate
    if ((e.ctrlKey || e.metaKey) && e.key === 'n') {
        e.preventDefault();
        window.location.href = '<?php echo e(route('admin.commission-rates.create')); ?>';
    }
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/admin/commission-rates/index.blade.php ENDPATH**/ ?>