

<?php $__env->startSection('content'); ?>
<div class="finance-reports-container">
    <!-- Page Header -->
    <div class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">
                <i class="fas fa-chart-pie"></i>
                รายงานตามหมวดหมู่
            </h1>
            <p class="page-subtitle">วิเคราะห์รายรับ-รายจ่ายแยกตามหมวดหมู่</p>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="filter-section">
        <form method="GET" action="<?php echo e(route('finance.reports.category')); ?>" class="filter-form">
            <div class="form-group">
                <label class="form-label">ช่วงเวลา</label>
                <select name="period" class="form-control" onchange="toggleDateInput(this.value)">
                    <option value="month" <?php echo e($period == 'month' ? 'selected' : ''); ?>>รายเดือน</option>
                    <option value="year" <?php echo e($period == 'year' ? 'selected' : ''); ?>>รายปี</option>
                </select>
            </div>

            <div class="form-group" id="monthInput" style="<?php echo e($period == 'year' ? 'display:none' : ''); ?>">
                <label class="form-label">เดือน</label>
                <input type="month" name="date" value="<?php echo e($period == 'month' ? $date : ''); ?>" 
                       class="form-control" max="<?php echo e(date('Y-m')); ?>">
            </div>

            <div class="form-group" id="yearInput" style="<?php echo e($period == 'month' ? 'display:none' : ''); ?>">
                <label class="form-label">ปี</label>
                <input type="number" name="date" value="<?php echo e($period == 'year' ? $date : ''); ?>" 
                       class="form-control" min="2020" max="<?php echo e(date('Y')); ?>">
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> ดูรายงาน
            </button>
        </form>
    </div>

    <!-- Income Section -->
    <?php if(isset($categoryData['income']) && $categoryData['income']->count() > 0): ?>
    <div class="category-section">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-arrow-up text-success"></i>
                รายรับตามหมวดหมู่
            </h2>
            <span class="total-amount text-success">
                รวม <?php echo e(number_format($categoryData['income']->sum('amount'), 2)); ?> บาท
            </span>
        </div>

        <div class="category-grid">
            <?php $__currentLoopData = $categoryData['income']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="category-card income-card">
                <div class="category-icon" style="background-color: <?php echo e($category['color']); ?>20; color: <?php echo e($category['color']); ?>">
                    <i class="fas <?php echo e($category['icon']); ?>"></i>
                </div>
                <div class="category-info">
                    <h3 class="category-name"><?php echo e($category['category']); ?></h3>
                    <div class="category-amount"><?php echo e(number_format($category['amount'], 2)); ?> บาท</div>
                    <div class="category-meta">
                        <span class="category-percentage"><?php echo e($category['percentage']); ?>%</span>
                        <span class="category-count"><?php echo e($category['count']); ?> รายการ</span>
                    </div>
                </div>
                <div class="category-chart">
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: <?php echo e($category['percentage']); ?>%; background-color: <?php echo e($category['color']); ?>"></div>
                    </div>
                </div>
                
                <?php if($category['records']->count() > 0): ?>
                <div class="recent-transactions">
                    <h4>รายการล่าสุด</h4>
                    <ul class="transaction-list">
                        <?php $__currentLoopData = $category['records']->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="transaction-item">
                            <span class="transaction-date"><?php echo e($record->record_date->format('d/m')); ?></span>
                            <span class="transaction-note"><?php echo e(Str::limit($record->note ?? '-', 30)); ?></span>
                            <span class="transaction-amount">+<?php echo e(number_format($record->amount, 0)); ?></span>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Expense Section -->
    <?php if(isset($categoryData['expense']) && $categoryData['expense']->count() > 0): ?>
    <div class="category-section">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-arrow-down text-danger"></i>
                รายจ่ายตามหมวดหมู่
            </h2>
            <span class="total-amount text-danger">
                รวม <?php echo e(number_format($categoryData['expense']->sum('amount'), 2)); ?> บาท
            </span>
        </div>

        <div class="category-grid">
            <?php $__currentLoopData = $categoryData['expense']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="category-card expense-card">
                <div class="category-icon" style="background-color: <?php echo e($category['color']); ?>20; color: <?php echo e($category['color']); ?>">
                    <i class="fas <?php echo e($category['icon']); ?>"></i>
                </div>
                <div class="category-info">
                    <h3 class="category-name"><?php echo e($category['category']); ?></h3>
                    <div class="category-amount"><?php echo e(number_format($category['amount'], 2)); ?> บาท</div>
                    <div class="category-meta">
                        <span class="category-percentage"><?php echo e($category['percentage']); ?>%</span>
                        <span class="category-count"><?php echo e($category['count']); ?> รายการ</span>
                    </div>
                </div>
                <div class="category-chart">
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: <?php echo e($category['percentage']); ?>%; background-color: <?php echo e($category['color']); ?>"></div>
                    </div>
                </div>
                
                <?php if($category['records']->count() > 0): ?>
                <div class="recent-transactions">
                    <h4>รายการล่าสุด</h4>
                    <ul class="transaction-list">
                        <?php $__currentLoopData = $category['records']->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="transaction-item">
                            <span class="transaction-date"><?php echo e($record->record_date->format('d/m')); ?></span>
                            <span class="transaction-note"><?php echo e(Str::limit($record->note ?? '-', 30)); ?></span>
                            <span class="transaction-amount">-<?php echo e(number_format($record->amount, 0)); ?></span>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Summary Charts -->
    <div class="charts-section">
        <div class="chart-container">
            <h3 class="chart-title">สัดส่วนรายรับ</h3>
            <canvas id="incomeChart"></canvas>
        </div>
        <div class="chart-container">
            <h3 class="chart-title">สัดส่วนรายจ่าย</h3>
            <canvas id="expenseChart"></canvas>
        </div>
    </div>

    <!-- Export Options -->
    <div class="export-section">
        <h3>ส่งออกรายงาน</h3>
        <div class="export-buttons">
            <form action="<?php echo e(route('finance.reports.export')); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" value="category">
                <input type="hidden" name="period" value="<?php echo e($date); ?>">
                <input type="hidden" name="format" value="csv">
                <button type="submit" class="btn btn-outline">
                    <i class="fas fa-file-csv"></i> ส่งออก CSV
                </button>
            </form>
            <form action="<?php echo e(route('finance.reports.export')); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" value="category">
                <input type="hidden" name="period" value="<?php echo e($date); ?>">
                <input type="hidden" name="format" value="pdf">
                <button type="submit" class="btn btn-outline">
                    <i class="fas fa-file-pdf"></i> ส่งออก PDF
                </button>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.finance-reports-container {
    max-width: 1200px;
    margin: 0 auto;
}

.category-section {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: var(--shadow-sm);
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
    padding-bottom: 1rem;
    border-bottom: 2px solid var(--medium-gray);
}

.section-title {
    font-size: 1.5rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.total-amount {
    font-size: 1.25rem;
    font-weight: 600;
}

.category-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
    gap: 1.5rem;
}

.category-card {
    background: var(--light-gray);
    border-radius: var(--radius-md);
    padding: 1.5rem;
    transition: var(--transition-fast);
    border: 1px solid var(--medium-gray);
}

.category-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.income-card {
    border-left: 4px solid var(--success);
}

.expense-card {
    border-left: 4px solid var(--danger);
}

.category-icon {
    width: 60px;
    height: 60px;
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    margin-bottom: 1rem;
}

.category-info {
    margin-bottom: 1rem;
}

.category-name {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin-bottom: 0.5rem;
}

.category-amount {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--primary-orange);
    margin-bottom: 0.5rem;
}

.category-meta {
    display: flex;
    gap: 1rem;
    font-size: 0.9rem;
    color: var(--gray);
}

.category-percentage {
    font-weight: 600;
}

.progress-bar {
    height: 8px;
    background: var(--medium-gray);
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 1rem;
}

.progress-fill {
    height: 100%;
    transition: width 0.5s ease;
    border-radius: 4px;
}

.recent-transactions {
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid var(--medium-gray);
}

.recent-transactions h4 {
    font-size: 0.9rem;
    color: var(--gray);
    margin-bottom: 0.5rem;
}

.transaction-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.transaction-item {
    display: grid;
    grid-template-columns: auto 1fr auto;
    gap: 0.5rem;
    padding: 0.25rem 0;
    font-size: 0.85rem;
}

.transaction-date {
    color: var(--gray);
}

.transaction-note {
    color: var(--dark-gray);
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.transaction-amount {
    font-weight: 600;
}

.charts-section {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
    margin-bottom: 2rem;
}

.chart-container {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 2rem;
    box-shadow: var(--shadow-sm);
}

.chart-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1.5rem;
    text-align: center;
}

.export-section {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 2rem;
    box-shadow: var(--shadow-sm);
    text-align: center;
}

.export-section h3 {
    margin-bottom: 1rem;
}

.export-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
}

.btn-outline {
    background: var(--white);
    border: 2px solid var(--primary-orange);
    color: var(--primary-orange);
}

.btn-outline:hover {
    background: var(--primary-orange);
    color: var(--white);
}

.text-success {
    color: var(--success);
}

.text-danger {
    color: var(--danger);
}

.d-inline {
    display: inline;
}

@media (max-width: 768px) {
    .category-grid {
        grid-template-columns: 1fr;
    }
    
    .charts-section {
        grid-template-columns: 1fr;
    }
    
    .section-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
    
    .export-buttons {
        flex-direction: column;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Toggle date input based on period selection
function toggleDateInput(period) {
    const monthInput = document.getElementById('monthInput');
    const yearInput = document.getElementById('yearInput');
    
    if (period === 'month') {
        monthInput.style.display = '';
        yearInput.style.display = 'none';
    } else {
        monthInput.style.display = 'none';
        yearInput.style.display = '';
    }
}

// Prepare chart data
const incomeData = <?php echo json_encode($categoryData['income'] ?? collect([]), 15, 512) ?>;
const expenseData = <?php echo json_encode($categoryData['expense'] ?? collect([]), 15, 512) ?>;

// Income Chart
if (incomeData.length > 0) {
    const incomeCtx = document.getElementById('incomeChart').getContext('2d');
    new Chart(incomeCtx, {
        type: 'doughnut',
        data: {
            labels: incomeData.map(item => item.category),
            datasets: [{
                data: incomeData.map(item => item.amount),
                backgroundColor: incomeData.map(item => item.color || '#FF6B35'),
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 15,
                        font: {
                            size: 12
                        }
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = new Intl.NumberFormat('th-TH').format(context.parsed);
                            const percentage = incomeData[context.dataIndex].percentage;
                            return `${label}: ${value} บาท (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });
}

// Expense Chart
if (expenseData.length > 0) {
    const expenseCtx = document.getElementById('expenseChart').getContext('2d');
    new Chart(expenseCtx, {
        type: 'doughnut',
        data: {
            labels: expenseData.map(item => item.category),
            datasets: [{
                data: expenseData.map(item => item.amount),
                backgroundColor: expenseData.map(item => item.color || '#FF6B35'),
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 15,
                        font: {
                            size: 12
                        }
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = new Intl.NumberFormat('th-TH').format(context.parsed);
                            const percentage = expenseData[context.dataIndex].percentage;
                            return `${label}: ${value} บาท (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/finance/reports/category.blade.php ENDPATH**/ ?>