
<?php $__env->startSection('title', 'คำนวณค่าคอมมิชชั่น'); ?>

<?php $__env->startSection('content'); ?>
<main class="main-content" style="width:100%;max-width:100vw;min-width:0;margin:0;padding:0;overflow-x:hidden;">
    <div class="content-container" style="width:100%;max-width:100vw;min-width:0;padding:2rem;overflow-x:hidden;">
        
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-calculator"></i>
                คำนวณค่าคอมมิชชั่น
            </h1>
            <p class="page-subtitle">เครื่องมือคำนวณค่าคอมมิชชั่นสำหรับการจัดส่งพัสดุ</p>
        </div>

        <!-- Back Button -->
        <div class="mb-3">
            <a href="<?php echo e(route('vehicle.dashboard')); ?>" class="btn" style="background: var(--gray); color: white;">
                <i class="fas fa-arrow-left"></i> กลับหน้าแดชบอร์ด
            </a>
        </div><br>

        <div class="row">
            <!-- Calculator Form -->
            <div class="col-md-6">
                <div class="table-container">
                    <div class="table-header">
                        <h3 class="table-title">
                            <i class="fas fa-calculator"></i>
                            คำนวณค่าคอมมิชชั่น
                        </h3>
                    </div>
                    <div style="padding: 2rem;">
                        <form method="GET" id="calculator-form">
                            <div class="form-group mb-3">
                                <label for="parcel_count" class="form-label">
                                    <i class="fas fa-box"></i> จำนวนพัสดุ (ชิ้น)
                                </label><br>
                                <input type="number" name="parcel_count" id="parcel_count" 
                                       class="form-control" min="1" step="1"
                                       value="<?php echo e(request('parcel_count')); ?>" 
                                       placeholder="กรอกจำนวนพัสดุ"><br>
                            </div>
                            
                            <button type="submit" class="btn btn-primary" style="width: 100%;">
                                <i class="fas fa-calculator"></i> คำนวณ
                            </button>
                        </form><br>

                        <!-- Current User Info -->
                        <div class="mt-4" style="background: #f8f9fa; padding: 1rem; border-radius: 8px;">
                            <h6 style="color: var(--dark-gray); margin-bottom: 0.5rem;">ข้อมูลของคุณ</h6>
                            <div style="font-size: 0.9rem; color: var(--gray);">
                                <div><strong>ตำแหน่ง:</strong> <?php echo e(auth()->user()->role); ?></div>
                                <div><strong>คลัง:</strong> <?php echo e(auth()->user()->warehouse->name ?? '-'); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Calculation Result -->
            <div class="col-md-6">
                <?php if($preview): ?>
                    <div class="table-container">
                        <div class="table-header">
                            <h3 class="table-title">
                                <i class="fas fa-chart-bar"></i>
                                ผลการคำนวณ
                            </h3>
                        </div>
                        <div style="padding: 2rem;">
                            <!-- Total Commission -->
                            <div style="background: var(--primary-gradient); color: white; padding: 1.5rem; border-radius: 12px; text-align: center; margin-bottom: 1.5rem;">
                                <div style="font-size: 0.9rem; opacity: 0.9; margin-bottom: 0.5rem;">ค่าคอมมิชชั่นรวม</div>
                                <div style="font-size: 2rem; font-weight: 700;">
                                    <?php echo e(number_format($preview['total_commission'], 2)); ?> บาท
                                </div>
                                <div style="font-size: 0.85rem; opacity: 0.8; margin-top: 0.5rem;">
                                    สำหรับ <?php echo e(number_format(request('parcel_count'))); ?> ชิ้น
                                </div>
                            </div>

                            <!-- Tier Breakdown -->
                            <?php if(count($preview['tiers']) > 0): ?>
                                <h6 style="color: var(--dark-gray); margin-bottom: 1rem;">รายละเอียดการคำนวณ</h6>
                                <?php $__currentLoopData = $preview['tiers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div style="background: white; padding: 1rem; margin-bottom: 0.75rem; border-radius: 8px; border-left: 4px solid var(--primary-orange); box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                        <div style="display: flex; justify-content: space-between; align-items: center;">
                                            <div>
                                                <div style="font-weight: 500; color: var(--dark-gray);">
                                                    ช่วง <?php echo e($tier['range']); ?> ชิ้น
                                                </div>
                                                <div style="color: var(--gray); font-size: 0.9rem;">
                                                    <?php echo e(number_format($tier['count'])); ?> × <?php echo e(number_format($tier['rate'], 2)); ?> บาท
                                                </div>
                                            </div>
                                            <div style="font-weight: 600; color: var(--success); font-size: 1.1rem;">
                                                <?php echo e(number_format($tier['sum'], 2)); ?> บาท
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            <!-- Average Rate -->
                            <?php if(request('parcel_count') > 0): ?>
                                <div style="background: #e7f3ff; padding: 1rem; border-radius: 8px; text-align: center;">
                                    <div style="color: var(--info); font-weight: 500;">
                                        อัตราเฉลี่ย: <?php echo e(number_format($preview['total_commission'] / request('parcel_count'), 2)); ?> บาท/ชิ้น
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="table-container">
                        <div class="table-header">
                            <h3 class="table-title">
                                <i class="fas fa-info-circle"></i>
                                คำแนะนำการใช้งาน
                            </h3>
                        </div>
                        <div style="padding: 2rem; text-align: center;">
                            <div style="color: var(--gray); margin-bottom: 2rem;">
                                <i class="fas fa-calculator" style="font-size: 4rem; margin-bottom: 1rem; display: block;"></i>
                            </div>
                            <h5 style="color: var(--dark-gray); margin-bottom: 1rem;">กรอกจำนวนพัสดุเพื่อคำนวณค่าคอมมิชชั่น</h5>
                            <p style="color: var(--gray); line-height: 1.6;">
                                ระบบจะคำนวณค่าคอมมิชชั่นแบบขั้นบันได (Tier-based) 
                                ตามอัตราที่กำหนดไว้สำหรับตำแหน่งและคลังของคุณ
                            </p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Commission Rate Table
        <div class="table-container mt-4">
            <div class="table-header">
                <h3 class="table-title">
                    <i class="fas fa-table"></i>
                    อัตราค่าคอมมิชชั่นของคุณ
                </h3>
            </div>
            
            <?php if($commissionRates->isEmpty()): ?>
                <div style="padding: 3rem 2rem; text-align: center;">
                    <div style="color: var(--gray); margin-bottom: 1.5rem;">
                        <i class="fas fa-exclamation-triangle" style="font-size: 3rem; margin-bottom: 1rem; display: block;"></i>
                    </div>
                    <h5 style="color: var(--dark-gray); margin-bottom: 1rem;">ยังไม่มีอัตราค่าคอมมิชชั่น</h5>
                    <p style="color: var(--gray);">
                        กรุณาติดต่อผู้ดูแลระบบเพื่อกำหนดอัตราค่าคอมมิชชั่นสำหรับตำแหน่งและคลังของคุณ
                    </p>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>ช่วงจำนวนพัสดุ</th>
                                <th>อัตราต่อชิ้น (บาท)</th>
                                <th>ตัวอย่างรายได้</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $commissionRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if($rate->max_parcels): ?>
                                            <span style="color: var(--dark-gray); font-weight: 500;">
                                                <?php echo e(number_format($rate->min_parcels)); ?> - <?php echo e(number_format($rate->max_parcels)); ?> ชิ้น
                                            </span>
                                        <?php else: ?>
                                            <span style="color: var(--dark-gray); font-weight: 500;">
                                                <?php echo e(number_format($rate->min_parcels)); ?>+ ชิ้น
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span style="color: var(--success); font-weight: 600; font-size: 1.1rem;">
                                            <?php echo e(number_format($rate->rate_per_parcel, 2)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php
                                            $example = $rate->min_parcels + (($rate->max_parcels ?? $rate->min_parcels + 50) - $rate->min_parcels) / 2;
                                            $exampleCommission = $example * $rate->rate_per_parcel;
                                        ?>
                                        <span style="color: var(--gray); font-size: 0.9rem;">
                                            <?php echo e(number_format($example)); ?> ชิ้น = <?php echo e(number_format($exampleCommission, 2)); ?> บาท
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div> -->

        <!-- Commission Projections -->
        <?php if(!empty($projections)): ?>
            <div class="table-container mt-4">
                <div class="table-header">
                    <h3 class="table-title">
                        <i class="fas fa-chart-line"></i>
                        ตารางเปรียบเทียบรายได้
                    </h3>
                </div>
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>จำนวนพัสดุ</th>
                                <th>ค่าคอมมิชชั่น</th>
                                <th>เฉลี่ย/ชิ้น</th>
                                <th>ช่วงอัตราที่ใช้</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $projections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <span style="color: var(--primary-orange); font-weight: 600;">
                                            <?php echo e(number_format($projection['parcel_count'])); ?> ชิ้น
                                        </span>
                                    </td>
                                    <td>
                                        <span style="color: var(--success); font-weight: 600; font-size: 1.1rem;">
                                            <?php echo e(number_format($projection['commission'], 2)); ?> บาท
                                        </span>
                                    </td>
                                    <td>
                                        <span style="color: var(--gray);">
                                            <?php echo e(number_format($projection['average_per_parcel'], 2)); ?> บาท/ชิ้น
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge" style="background: var(--info); color: white;">
                                            <?php echo e($projection['tiers_used']); ?> ช่วง
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>

        <!-- Quick Calculator Links -->
        <div class="mt-4 text-center">
            <h5 style="color: var(--dark-gray); margin-bottom: 1rem;">คำนวณด่วน</h5>
            <div style="display: flex; gap: 1rem; justify-content: center; flex-wrap: wrap;">
                <?php $__currentLoopData = [50, 100, 150, 200, 250, 300]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quickCalc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('vehicle.calculator', ['parcel_count' => $quickCalc])); ?>" 
                       class="btn <?php echo e(request('parcel_count') == $quickCalc ? 'btn-primary' : ''); ?>" 
                       style="<?php echo e(request('parcel_count') == $quickCalc ? '' : 'background: var(--light-gray); color: var(--dark-gray); border: 1px solid var(--medium-gray);'); ?>">
                        <?php echo e($quickCalc); ?> ชิ้น
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div><br>

        <!-- Action Buttons -->
        <div class="mt-4 text-center" style="display: flex; gap: 1rem; justify-content: center; flex-wrap: wrap;">
            <div style="display: flex; gap: 1rem; justify-content: center; flex-wrap: wrap;">
                <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> บันทึกการจัดส่งใหม่
                </a>
                <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="btn" style="background: var(--info); color: white;">
                    <i class="fas fa-history"></i> ดูประวัติการจัดส่ง
                </a>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const parcelInput = document.getElementById('parcel_count');
    const form = document.getElementById('calculator-form');
    
    // Auto-submit form when input changes (with debounce)
    let timeout;
    parcelInput.addEventListener('input', function() {
        clearTimeout(timeout);
        timeout = setTimeout(() => {
            if (this.value && this.value > 0) {
                form.submit();
            }
        }, 500);
    });

    // Focus on input when page loads
    parcelInput.focus();
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -0.75rem;
}

.col-md-6 {
    flex: 0 0 50%;
    max-width: 50%;
    padding: 0 0.75rem;
    margin-bottom: 1.5rem;
}

.badge {
    padding: 0.25rem 0.75rem;
    border-radius: 1rem;
    font-size: 0.75rem;
    font-weight: 600;
}

@media (max-width: 768px) {
    .col-md-6 {
        flex: 0 0 100%;
        max-width: 100%;
    }
    
    .quick-calc-buttons {
        grid-template-columns: repeat(3, 1fr) !important;
        gap: 0.5rem !important;
    }
    
    .quick-calc-buttons .btn {
        font-size: 0.9rem !important;
        padding: 0.5rem !important;
    }
}

.quick-calc-buttons {
    display: grid;
    grid-template-columns: repeat(6, 1fr);
    gap: 1rem;
}

.btn:hover {
    transform: translateY(-1px);
    transition: all 0.2s ease;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/vehicle/calculator.blade.php ENDPATH**/ ?>