

<?php $__env->startSection('content'); ?>
<div class="delivery-create-container"><br><br>
    <!-- Page Header -->
    <div class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">
                <i class="fas fa-plus-circle"></i>
                บันทึกการจัดส่ง
            </h1>
            <p class="page-subtitle">บันทึกข้อมูลการจัดส่งพัสดุประจำวัน</p>
        </div>
        <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> ย้อนกลับ
        </a>
    </div>

    <!-- Form Section -->
    <div class="form-container">
        <div class="form-column">
            <!-- User Info Card -->
            <div class="info-card">
                <div class="info-card-header">
                    <i class="fas fa-user"></i>
                    ข้อมูลพนักงาน
                </div>
                <div class="info-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-label">ชื่อ-นามสกุล:</span>
                            <span class="info-value"><?php echo e($user->name); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">รหัสพนักงาน:</span>
                            <span class="info-value"><?php echo e($user->id); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">คลังสินค้า:</span>
                            <span class="info-value"><?php echo e($user->warehouse->name ?? $warehouse_code); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">ประเภทรถ:</span>
                            <span class="info-value">
                                <i class="fas fa-<?php echo e($user->role == '2wheel' ? 'motorcycle' : 'truck'); ?>"></i>
                                <?php echo e($user->role == '2wheel' ? 'รถ 2 ล้อ' : 'รถ 4 ล้อ'); ?>

                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Delivery Form Card -->
            <div class="form-card">
                <div class="form-card-header">
                    <i class="fas fa-box"></i>
                    ข้อมูลการจัดส่ง
                </div>
                <div class="form-card-body">
                    <form action="<?php echo e(route('vehicle.deliveries.store')); ?>" method="POST" id="deliveryForm">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Delivery Date -->
                        <div class="form-group">
                            <label class="form-label required">วันที่จัดส่ง</label>
                            <input type="date" 
                                   name="delivery_date" 
                                   id="delivery_date"
                                   class="form-control <?php $__errorArgs = ['delivery_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   value="<?php echo e(old('delivery_date', date('Y-m-d'))); ?>"
                                   max="<?php echo e(date('Y-m-d')); ?>"
                                   required>
                            <?php $__errorArgs = ['delivery_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-message"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <span class="form-hint">เลือกวันที่ที่ทำการจัดส่งพัสดุ</span>
                        </div>

                        <!-- Parcel Count -->
                        <div class="form-group">
                            <label class="form-label required">จำนวนพัสดุ (ชิ้น)</label>
                            <div class="input-with-icon">
                                <i class="fas fa-boxes"></i>
                                <input type="number" 
                                       name="parcel_count" 
                                       id="parcel_count"
                                       class="form-control <?php $__errorArgs = ['parcel_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       value="<?php echo e(old('parcel_count')); ?>"
                                       min="1"
                                       placeholder="กรอกจำนวนพัสดุ"
                                       required>
                            </div>
                            <?php $__errorArgs = ['parcel_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-message"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <span class="form-hint">กรอกจำนวนพัสดุทั้งหมดที่จัดส่งในวันนี้</span>
                        </div>

                        <!-- Commission Preview -->
                        <div class="commission-preview" id="commissionPreview" style="display: none;">
                            <div class="preview-header">
                                <i class="fas fa-calculator"></i>
                                ค่าคอมมิชชั่นโดยประมาณ
                            </div>
                            <div class="preview-body">
                                <div class="preview-loading">
                                    <i class="fas fa-spinner fa-spin"></i> กำลังคำนวณ...
                                </div>
                                <div class="preview-result" style="display: none;">
                                    <div class="preview-amount">
                                        <span class="currency">฿</span>
                                        <span class="amount">0.00</span>
                                    </div>
                                    <div class="preview-breakdown"></div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Commission Rates Info -->
        <?php if($commissionRates->count() > 0): ?>
        <div class="rates-info-card">
            <div class="rates-header">
                <i class="fas fa-info-circle"></i>
                อัตราค่าคอมมิชชั่นปัจจุบัน
            </div>
            <div class="rates-table">
                <table>
                    <thead>
                        <tr>
                            <th>ขั้นที่</th>
                            <th>ช่วงจำนวนพัสดุ</th>
                            <th>อัตรา/ชิ้น</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $commissionRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="tier"><?php echo e($rate->tier); ?></td>
                            <td><?php echo e($rate->range_display); ?></td>
                            <td class="rate"><?php echo e(number_format($rate->rate_per_package, 2)); ?> บาท</td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Form Actions -->
    <div class="form-actions">
        <button type="button" class="btn btn-outline" onclick="window.history.back()">
            <i class="fas fa-times"></i> ยกเลิก
        </button>
        <button type="submit" class="btn btn-primary" id="submitBtn" form="deliveryForm">
            <i class="fas fa-save"></i> บันทึกข้อมูล
        </button>
    </div><br><br>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.delivery-create-container {
    max-width: 100%;
    margin: 0;
    padding: 1rem;
    width: 100%;
    box-sizing: border-box;
}

.page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 1.25rem 1.5rem;
    box-shadow: var(--shadow-sm);
}

.page-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0;
}

.page-subtitle {
    font-size: 0.9rem;
    color: var(--gray);
    margin: 0.25rem 0 0 0;
}

.form-container {
    display: grid;
    grid-template-columns: 1fr minmax(300px, 400px);
    gap: 1.5rem;
    align-items: start;
}

.form-column {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.info-card,
.form-card,
.rates-info-card {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-sm);
    overflow: hidden;
}

.info-card-header,
.form-card-header,
.rates-header {
    background: linear-gradient(135deg, rgba(255, 107, 53, 0.05) 0%, rgba(255, 140, 97, 0.05) 100%);
    padding: 0.875rem 1.25rem;
    font-weight: 600;
    font-size: 1.05rem;
    color: var(--dark-gray);
    border-bottom: 1px solid var(--medium-gray);
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.info-card-body,
.form-card-body {
    padding: 1.25rem;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.info-label {
    font-size: 0.85rem;
    color: var(--gray);
}

.info-value {
    font-weight: 500;
    color: var(--dark-gray);
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group:last-child {
    margin-bottom: 0;
}

.form-label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
    color: var(--dark-gray);
}

.form-label.required::after {
    content: ' *';
    color: var(--danger);
}

.input-with-icon {
    position: relative;
}

.input-with-icon i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray);
}

.input-with-icon .form-control {
    padding-left: 2.75rem;
}

.form-control {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 2px solid var(--medium-gray);
    border-radius: var(--radius-md);
    font-family: inherit;
    font-size: 1rem;
    transition: var(--transition-fast);
}

.form-control:focus {
    outline: none;
    border-color: var(--primary-orange);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.form-control.is-invalid {
    border-color: var(--danger);
}

.error-message {
    display: block;
    color: var(--danger);
    font-size: 0.875rem;
    margin-top: 0.25rem;
}

.form-hint {
    display: block;
    color: var(--gray);
    font-size: 0.875rem;
    margin-top: 0.25rem;
}

.commission-preview {
    background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
    border: 2px solid #60a5fa;
    border-radius: var(--radius-md);
    padding: 1.5rem;
    margin-top: 1rem;
}

.preview-header {
    font-weight: 600;
    color: #2563eb;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.preview-loading {
    text-align: center;
    color: #60a5fa;
    padding: 1rem;
}

.preview-amount {
    text-align: center;
    margin-bottom: 1rem;
}

.preview-amount .currency {
    font-size: 1.5rem;
    color: #2563eb;
}

.preview-amount .amount {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2563eb;
}

.preview-breakdown {
    font-size: 0.875rem;
    color: #64748b;
}

.rates-info-card {
    margin-top: 1rem;
}

.rates-table {
    padding: 0.75rem;
    overflow-x: auto;
}

.rates-table table {
    width: 100%;
    border-collapse: collapse;
    font-size: 0.9rem;
}

.rates-table th {
    background: var(--light-gray);
    padding: 0.6rem;
    text-align: left;
    font-weight: 600;
    color: var(--dark-gray);
    font-size: 0.85rem;
}

.rates-table td {
    padding: 0.6rem;
    border-top: 1px solid var(--medium-gray);
}

.form-actions {
    display: flex;
    gap: 1rem;
    justify-content: flex-end;
    margin-top: 1.5rem;
    padding: 1.25rem;
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-sm);
}

.btn {
    padding: 0.625rem 1.25rem;
    border: none;
    border-radius: var(--radius-md);
    font-weight: 500;
    font-size: 0.95rem;
    cursor: pointer;
    transition: var(--transition-fast);
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

/* Responsive breakpoints */
@media (max-width: 1200px) {
    .form-container {
        grid-template-columns: 1fr;
    }
    
    .rates-info-card {
        order: 3;
    }
}

@media (max-width: 768px) {
    .delivery-create-container {
        padding: 0.75rem;
    }
    
    .page-header {
        flex-direction: column;
        align-items: stretch;
        gap: 0.75rem;
        padding: 1rem;
    }
    
    .page-title {
        font-size: 1.25rem;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    
    .form-actions {
        flex-direction: column-reverse;
        padding: 1rem;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
    
    .commission-preview {
        padding: 1rem;
    }
    
    .preview-amount .amount {
        font-size: 1.75rem;
    }
}

/* Ensure content fits viewport */
.main-content {
    overflow-x: hidden;
}

* {
    box-sizing: border-box;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const parcelInput = document.getElementById('parcel_count');
    const dateInput = document.getElementById('delivery_date');
    const previewDiv = document.getElementById('commissionPreview');
    const form = document.getElementById('deliveryForm');
    const submitBtn = document.getElementById('submitBtn');
    let calculationTimeout;

    // Preview คอมมิชชั่น
    parcelInput.addEventListener('input', function() {
        clearTimeout(calculationTimeout);
        const count = parseInt(this.value);
        if (count > 0) {
            previewDiv.style.display = 'block';
            document.querySelector('.preview-loading').style.display = 'block';
            document.querySelector('.preview-result').style.display = 'none';
            calculationTimeout = setTimeout(() => {
                calculateCommission(count);
            }, 500);
        } else {
            previewDiv.style.display = 'none';
        }
    });

    function calculateCommission(parcelCount) {
        fetch('<?php echo e(route("vehicle.deliveries.preview-commission")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ parcel_count: parcelCount })
        })
        .then(response => response.json())
        .then(data => {
            document.querySelector('.preview-loading').style.display = 'none';
            document.querySelector('.preview-result').style.display = 'block';
            document.querySelector('.preview-amount .amount').textContent = 
                new Intl.NumberFormat('th-TH', { minimumFractionDigits: 2 }).format(data.commission);
            if (data.preview_html) {
                document.querySelector('.preview-breakdown').innerHTML = data.preview_html;
            }
        });
    }

    // Validate วันที่
    dateInput.addEventListener('change', function() {
        fetch('<?php echo e(route("vehicle.deliveries.validate-date")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ delivery_date: this.value })
        })
        .then(response => response.json())
        .then(data => {
            if (!data.valid) {
                dateInput.classList.add('is-invalid');
                let errorMsg = dateInput.parentNode.querySelector('.error-message');
                if (!errorMsg) {
                    errorMsg = document.createElement('span');
                    errorMsg.className = 'error-message';
                    dateInput.parentNode.appendChild(errorMsg);
                }
                errorMsg.textContent = data.message;
                submitBtn.disabled = true;
            } else {
                dateInput.classList.remove('is-invalid');
                const errorMsg = dateInput.parentNode.querySelector('.error-message');
                if (errorMsg) errorMsg.remove();
                submitBtn.disabled = false;
            }
        });
    });

    // ใช้ SweetAlert2 แทน confirm
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        const parcelCount = parcelInput.value;
        const deliveryDate = dateInput.value;
        const commission = document.querySelector('.preview-amount .amount').textContent || "0.00";
        Swal.fire({
            title: 'ยืนยันการบันทึก?',
            html: `<b>วันที่:</b> ${deliveryDate}<br><b>จำนวนพัสดุ:</b> ${parcelCount} ชิ้น<br><b>ค่าคอมมิชชั่น:</b> ${commission} บาท`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'บันทึก',
            cancelButtonText: 'ยกเลิก'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });

    // SweetAlert2 แจ้งสำเร็จหลังบันทึก
    <?php if(session('success')): ?>
        Swal.fire({
            title: 'สำเร็จ!',
            text: '<?php echo e(session("success")); ?>',
            icon: 'success',
            confirmButtonText: 'ตกลง'
        });
    <?php endif; ?>
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/vehicle/deliveries/create.blade.php ENDPATH**/ ?>