
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'EazyCom Plus'); ?></title>
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="https://cdn.niendsitekungz.com/img/eazy-favicon.png">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#667eea">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="EazyCom Plus">
    
    <!-- Meta Tags for SEO and Social -->
    <meta name="description" content="EazyCom Plus ระบบจัดการค่าคอมมิชชั่นสำหรับรถส่งของ">
    <meta property="og:title" content="<?php echo $__env->yieldContent('title', 'EazyCom Plus'); ?>">
    <meta property="og:description" content="EazyCom Plus ระบบจัดการค่าคอมมิชชั่นสำหรับรถส่งของ">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://cdn.niendsitekungz.com/img/eazy-com-plus.png">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        -webkit-tap-highlight-color: transparent;
    }

    :root {
        /* Orange Theme for Mobile */
        --primary-orange: #FF6B35;
        --primary-orange-dark: #E85D2F;
        --primary-orange-light: #FF8C61;
        --orange-gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
        --orange-gradient-soft: linear-gradient(135deg, #FFE5DB 0%, #FFD4C4 100%);
        --orange-shadow: 0 8px 24px rgba(255, 107, 53, 0.25);
        
        /* Desktop Theme (Original) */
        --primary-gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
        --secondary-gradient: linear-gradient(135deg, #f97316 0%, #ea580c 100%);
        --success-gradient: linear-gradient(135deg, #10b981 0%, #059669 100%);
        --danger-gradient: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        
        /* Layout */
        --nav-height: 70px;
        --safe-area-bottom: env(safe-area-inset-bottom, 0);
        
        /* Colors */
        --white: #FFFFFF;
        --off-white: #FFF9F7;
        --light-gray: #F8F9FA;
        --medium-gray: #E9ECEF;
        --gray: #6C757D;
        --dark-gray: #343A40;
    }

    body {
        font-family: 'Kanit', sans-serif;
        background: linear-gradient(180deg, #FFF5F1 0%, #FFFFFF 100%);
        min-height: 100vh;
        position: relative;
        padding-bottom: calc(var(--nav-height) + var(--safe-area-bottom) + 10px);
    }

    /* Loading Screen */
    .page-loading {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 9999;
        transition: opacity 0.3s ease;
    }

    .page-loading.hide {
        opacity: 0;
        pointer-events: none;
    }

    .spinner {
        width: 50px;
        height: 50px;
        border: 4px solid #FFE5DB;
        border-top-color: var(--primary-orange);
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        to { transform: rotate(360deg); }
    }

    /* Main Content Area */
    .main-content {
        padding: 20px;
        max-width: 1200px;
        margin: 0 auto;
        animation: fadeIn 0.5s ease;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* Desktop Sidebar - Hidden on Mobile */
    .desktop-sidebar {
        display: none;
    }

    /* Mobile Top Bar - Orange Theme */
    .mobile-header {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        height: 65px;
        background: white;
        box-shadow: 0 2px 15px rgba(255, 107, 53, 0.08);
        z-index: 998;
        display: none;
        align-items: center;
        justify-content: space-between;
        padding: 0 20px;
        border-bottom: 1px solid rgba(255, 107, 53, 0.08);
    }

    .mobile-header.show {
        display: flex;
        animation: slideDown 0.3s ease;
    }

    @keyframes slideDown {
        from { transform: translateY(-100%); }
        to { transform: translateY(0); }
    }

    .header-logo {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .header-logo i {
        font-size: 24px;
        color: var(--primary-orange);
    }

    .header-title {
        font-size: 18px;
        font-weight: 600;
        color: var(--primary-orange);
    }

    .header-actions {
        display: flex;
        gap: 12px;
    }

    .header-btn {
        width: 40px;
        height: 40px;
        border-radius: 12px;
        background: var(--orange-gradient-soft);
        border: none;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
    }

    .header-btn:active {
        transform: scale(0.95);
    }

    .header-btn i {
        color: var(--primary-orange);
        font-size: 18px;
    }

    /* Mobile Bottom Navigation - Orange Theme */
    .mobile-nav {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        height: calc(var(--nav-height) + var(--safe-area-bottom));
        background: rgba(255, 255, 255, 0.98);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        box-shadow: 0 -4px 20px rgba(255, 107, 53, 0.08);
        z-index: 1000;
        padding-bottom: var(--safe-area-bottom);
        border-top: 1px solid rgba(255, 107, 53, 0.08);
    }

    .nav-container {
        height: var(--nav-height);
        display: flex;
        justify-content: space-around;
        align-items: center;
        padding: 0 10px;
    }

    .nav-item {
        flex: 1;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
        border: none;
        background: transparent;
        -webkit-user-select: none;
        user-select: none;
    }

    .nav-item i {
        font-size: 24px;
        color: #94a3b8;
        transition: all 0.3s ease;
        margin-bottom: 4px;
    }

    .nav-item span {
        font-size: 11px;
        color: #94a3b8;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    /* Active state with orange theme */
    .nav-item.active i,
    .nav-item.active span {
        color: var(--primary-orange);
    }

    .nav-item.active::after {
        content: '';
        position: absolute;
        bottom: -8px;
        width: 45px;
        height: 45px;
        background: var(--orange-gradient);
        border-radius: 50%;
        opacity: 0.1;
        animation: pulse 2s infinite;
    }

    .nav-item.active::before {
        content: '';
        position: absolute;
        top: 0;
        width: 45px;
        height: 3px;
        background: var(--orange-gradient);
        border-radius: 0 0 3px 3px;
        animation: slideIn 0.3s ease;
    }

    @keyframes pulse {
        0%, 100% { transform: scale(0.8); opacity: 0.1; }
        50% { transform: scale(1); opacity: 0.15; }
    }

    @keyframes slideIn {
        from { width: 0; opacity: 0; }
        to { width: 45px; opacity: 1; }
    }

    .nav-item:active {
        transform: scale(0.92);
    }

    /* Floating Action Button - Orange Theme */
    .fab-container {
        position: fixed;
        bottom: calc(var(--nav-height) + var(--safe-area-bottom) + 25px);
        right: 20px;
        z-index: 999;
    }

    .fab {
        width: 60px;
        height: 60px;
        border-radius: 20px;
        background: var(--orange-gradient);
        color: white;
        border: none;
        box-shadow: var(--orange-shadow);
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .fab::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        background: rgba(255, 255, 255, 0.3);
        border-radius: 50%;
        transform: translate(-50%, -50%);
        transition: width 0.5s, height 0.5s;
    }

    .fab:active::before {
        width: 100px;
        height: 100px;
    }

    .fab:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 32px rgba(255, 107, 53, 0.4);
    }

    .fab:active {
        transform: scale(0.95);
    }

    .fab i {
        font-size: 26px;
        transition: transform 0.3s ease;
        z-index: 1;
    }

    .fab.active {
        border-radius: 50%;
        background: white;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
    }

    .fab.active i {
        transform: rotate(45deg);
        color: var(--primary-orange);
    }

    /* Quick Actions Menu - Orange Theme */
    .quick-actions {
        position: absolute;
        bottom: 75px;
        right: 0;
        display: flex;
        flex-direction: column;
        gap: 15px;
        opacity: 0;
        pointer-events: none;
        transition: all 0.3s ease;
    }

    .quick-actions.active {
        opacity: 1;
        pointer-events: auto;
    }

    .quick-action-item {
        display: flex;
        align-items: center;
        gap: 12px;
        transform: translateX(20px);
        opacity: 0;
        transition: all 0.3s ease;
    }

    .quick-actions.active .quick-action-item {
        transform: translateX(0);
        opacity: 1;
    }

    .quick-actions.active .quick-action-item:nth-child(1) { transition-delay: 0.05s; }
    .quick-actions.active .quick-action-item:nth-child(2) { transition-delay: 0.1s; }
    .quick-actions.active .quick-action-item:nth-child(3) { transition-delay: 0.15s; }

    .quick-action-label {
        background: white;
        padding: 10px 16px;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        font-size: 14px;
        font-weight: 500;
        white-space: nowrap;
        color: var(--dark-gray);
        border: 1px solid rgba(255, 107, 53, 0.1);
    }

    .quick-action-btn {
        width: 50px;
        height: 50px;
        border-radius: 15px;
        background: white;
        border: 2px solid rgba(255, 107, 53, 0.15);
        box-shadow: 0 4px 16px rgba(255, 107, 53, 0.15);
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .quick-action-btn:hover {
        background: var(--orange-gradient);
        border-color: transparent;
        transform: scale(1.05);
    }

    .quick-action-btn:active {
        transform: scale(0.95);
    }

    .quick-action-btn i {
        font-size: 20px;
        color: var(--primary-orange);
        transition: color 0.3s ease;
    }

    .quick-action-btn:hover i {
        color: white;
    }

    /* Slide Menu - Orange Theme */
    .slide-menu {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        background: white;
        border-top-left-radius: 30px;
        border-top-right-radius: 30px;
        z-index: 1001;
        transform: translateY(100%);
        transition: transform 0.4s cubic-bezier(0.32, 0.72, 0, 1);
        max-height: 85vh;
        overflow: hidden;
        padding-bottom: var(--safe-area-bottom);
        box-shadow: 0 -4px 30px rgba(0, 0, 0, 0.15);
    }

    .slide-menu.active {
        transform: translateY(0);
    }

    .menu-handle {
        width: 45px;
        height: 5px;
        background: #E2E8F0;
        border-radius: 3px;
        margin: 12px auto 8px;
    }

    .menu-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 0 20px 20px;
        border-bottom: 1px solid #F1F5F9;
    }

    .menu-title {
        font-size: 20px;
        font-weight: 600;
        color: var(--primary-orange);
    }

    .close-menu {
        width: 40px;
        height: 40px;
        border-radius: 12px;
        background: var(--orange-gradient-soft);
        border: none;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .close-menu:active {
        transform: scale(0.95);
    }

    .close-menu i {
        color: var(--primary-orange);
        font-size: 18px;
    }

    .menu-content {
        overflow-y: auto;
        max-height: calc(85vh - 100px);
        padding: 20px;
    }

    .menu-section {
        margin-bottom: 25px;
    }

    .menu-section-title {
        font-size: 12px;
        font-weight: 600;
        color: var(--primary-orange);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 15px;
        padding-left: 5px;
    }

    /* User Profile Card - Orange Theme */
    .user-profile-card {
        display: flex;
        align-items: center;
        gap: 15px;
        padding: 20px;
        background: var(--orange-gradient);
        border-radius: 20px;
        margin-bottom: 25px;
        box-shadow: 0 8px 24px rgba(255, 107, 53, 0.2);
    }

    .user-avatar {
        width: 65px;
        height: 65px;
        background: white;
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        font-size: 22px;
        color: var(--primary-orange);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .user-info {
        flex: 1;
    }

    .user-name {
        color: white;
        font-weight: 600;
        font-size: 18px;
        margin-bottom: 4px;
    }

    .user-role {
        color: rgba(255, 255, 255, 0.9);
        font-size: 14px;
    }

    .menu-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 15px;
    }

    .menu-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        aspect-ratio: 1;
        background: linear-gradient(135deg, #FFF5F1 0%, #FFE5DB 100%);
        border-radius: 20px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        border: 2px solid transparent;
        position: relative;
        overflow: hidden;
    }

    .menu-item::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        background: var(--orange-gradient);
        border-radius: 50%;
        transform: translate(-50%, -50%);
        transition: width 0.5s, height 0.5s;
        opacity: 0.1;
    }

    .menu-item:active::before {
        width: 150px;
        height: 150px;
    }

    .menu-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 20px rgba(255, 107, 53, 0.15);
        background: white;
        border-color: rgba(255, 107, 53, 0.2);
    }

    .menu-item:active {
        transform: scale(0.95);
    }

    .menu-item i {
        font-size: 26px;
        color: var(--primary-orange);
        margin-bottom: 8px;
    }

    .menu-item span {
        font-size: 11px;
        color: var(--dark-gray);
        font-weight: 500;
        text-align: center;
    }

    /* Menu List Items - Orange Theme */
    .menu-list {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .menu-list-item {
        display: flex;
        align-items: center;
        gap: 15px;
        padding: 14px 16px;
        background: linear-gradient(135deg, #FFF9F7 0%, #FFF5F1 100%);
        border-radius: 16px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        border: 1px solid rgba(255, 107, 53, 0.08);
    }

    .menu-list-item:hover {
        background: white;
        box-shadow: 0 4px 12px rgba(255, 107, 53, 0.1);
        transform: translateX(5px);
        border-color: rgba(255, 107, 53, 0.15);
    }

    .menu-list-item:active {
        transform: scale(0.98);
    }

    .menu-list-item i {
        width: 45px;
        height: 45px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: white;
        border-radius: 12px;
        color: var(--primary-orange);
        font-size: 20px;
        box-shadow: 0 2px 8px rgba(255, 107, 53, 0.1);
    }

    .menu-list-item-text {
        flex: 1;
    }

    .menu-list-item-title {
        font-size: 15px;
        font-weight: 500;
        color: var(--dark-gray);
        margin-bottom: 2px;
    }

    .menu-list-item-subtitle {
        font-size: 12px;
        color: #94a3b8;
    }

    /* Overlay */
    .overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease;
        z-index: 999;
        backdrop-filter: blur(4px);
    }

    .overlay.active {
        opacity: 1;
        pointer-events: auto;
    }

    /* Notification Badge */
    .nav-badge {
        position: absolute;
        top: 5px;
        right: calc(50% - 18px);
        background: #ef4444;
        color: white;
        font-size: 10px;
        min-width: 18px;
        height: 18px;
        padding: 0 5px;
        border-radius: 9px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        box-shadow: 0 2px 8px rgba(239, 68, 68, 0.3);
    }

    /* Toast Notifications - Orange Theme */
    .toast-container {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 2000;
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .toast {
        background: white;
        border-radius: 14px;
        padding: 16px;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
        display: flex;
        align-items: center;
        gap: 12px;
        min-width: 320px;
        animation: slideInRight 0.3s ease;
        position: relative;
        overflow: hidden;
        border: 1px solid rgba(255, 107, 53, 0.1);
    }

    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }

    .toast::before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        bottom: 0;
        width: 4px;
    }

    .toast.success::before { background: #10b981; }
    .toast.error::before { background: #ef4444; }
    .toast.warning::before { background: #f97316; }
    .toast.info::before { background: #3b82f6; }

    .toast-icon {
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 10px;
    }

    .toast.success .toast-icon { 
        background: rgba(16, 185, 129, 0.1);
        color: #10b981; 
    }
    
    .toast.error .toast-icon { 
        background: rgba(239, 68, 68, 0.1);
        color: #ef4444; 
    }
    
    .toast.warning .toast-icon { 
        background: rgba(245, 158, 11, 0.1);
        color: #f97316; 
    }
    
    .toast.info .toast-icon { 
        background: rgba(59, 130, 246, 0.1);
        color: #3b82f6; 
    }

    .toast-content {
        flex: 1;
    }

    .toast-title {
        font-size: 14px;
        font-weight: 600;
        color: var(--dark-gray);
        margin-bottom: 2px;
    }

    .toast-message {
        font-size: 13px;
        color: var(--gray);
    }

    .toast-close {
        width: 28px;
        height: 28px;
        border: none;
        background: transparent;
        color: #94a3b8;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 8px;
        transition: all 0.2s ease;
    }

    .toast-close:hover {
        background: rgba(0, 0, 0, 0.05);
    }

    /* Desktop Styles - Keep Original Orange Theme */
    @media (min-width: 769px) {
        body {
            padding-bottom: 0;
            padding-left: 280px;
            background: #f8fafc;
        }

        .main-content {
            padding: 30px;
        }

        .mobile-nav,
        .mobile-header,
        .fab-container,
        .slide-menu,
        .overlay {
            display: none !important;
        }

        .desktop-sidebar {
            display: block;
            position: fixed;
            left: 0;
            top: 0;
            width: 280px;
            height: 100vh;
            background: white;
            box-shadow: 2px 0 15px rgba(0, 0, 0, 0.05);
            overflow-y: auto;
            z-index: 100;
        }

        /* Orange theme for desktop sidebar */
        .sidebar-header {
            padding: 30px 25px;
            background: var(--orange-gradient);
            color: white;
        }

        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.5rem;
            font-weight: 600;
        }

        .sidebar-nav {
            padding: 20px 0;
        }

        .nav-section-title {
            padding: 10px 25px;
            font-size: 12px;
            font-weight: 600;
            color: #94a3b8;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-top: 10px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 12px 25px;
            color: #64748b;
            text-decoration: none;
            transition: all 0.3s ease;
            position: relative;
        }

        .nav-link:hover {
            background: rgba(255, 107, 53, 0.05);
            color: var(--primary-orange);
        }

        .nav-link.active {
            background: linear-gradient(90deg, rgba(255, 107, 53, 0.1) 0%, rgba(255, 140, 97, 0.05) 100%);
            color: var(--primary-orange);
        }

        .nav-link.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background: var(--primary-orange);
        }

        .sidebar-profile {
            padding: 20px;
            border-top: 1px solid #f1f5f9;
            margin-top: auto;
        }

        .profile-info {
            display: flex;
            align-items: center;
            gap: 12px;
            cursor: pointer;
            padding: 12px;
            border-radius: 12px;
            transition: all 0.3s ease;
        }

        .profile-info:hover {
            background: rgba(255, 107, 53, 0.05);
        }

        .profile-avatar {
            width: 40px;
            height: 40px;
            border-radius: 12px;
            background: var(--orange-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }

        .profile-details {
            flex: 1;
        }

        .profile-name {
            font-size: 14px;
            font-weight: 600;
            color: #1e293b;
        }

        .profile-role {
            font-size: 12px;
            color: #94a3b8;
        }
    }

    /* Tablet optimizations */
    @media (max-width: 768px) and (min-width: 481px) {
        .menu-grid {
            grid-template-columns: repeat(5, 1fr);
        }
    }

    /* Small phone optimizations */
    @media (max-width: 380px) {
        .menu-grid {
            grid-template-columns: repeat(3, 1fr);
        }
        
        .nav-item span {
            font-size: 10px;
        }
        
        .nav-item i {
            font-size: 20px;
        }
    }
</style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Loading Screen -->
    <div class="page-loading" id="pageLoading">
        <div class="spinner"></div>
    </div>

    <!-- Toast Container -->
    <div class="toast-container" id="toastContainer"></div>

    <!-- Desktop Sidebar -->
    <nav class="desktop-sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="fas fa-truck-fast"></i>
                <span>EazyCom Plus</span>
            </div>
        </div>
        <div class="sidebar-nav">
            <ul class="nav-menu" style="list-style: none; padding: 0;">
                <?php if(auth()->guard()->check()): ?>
                    <?php if(auth()->user()->isAdmin()): ?>
                        <!-- Admin Navigation -->
                        <li class="nav-section-title">การจัดการ</li>
                        <li>
                            <a href="<?php echo e(route('admin.dashboard')); ?>" 
                               class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                                <i class="fas fa-tachometer-alt"></i>
                                <span>แดชบอร์ด</span>
                            </a>
                        </li>
                        <!-- Add more admin links -->
                    <?php elseif(auth()->user()->isVehicleUser()): ?>
                        <!-- Vehicle User Navigation -->
                        <li class="nav-section-title">รายงานการจัดส่ง</li>
                        <li>
                            <a href="<?php echo e(route('vehicle.dashboard')); ?>" 
                               class="nav-link <?php echo e(request()->routeIs('vehicle.dashboard') ? 'active' : ''); ?>">
                                <i class="fas fa-tachometer-alt"></i>
                                <span>แดชบอร์ด</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" 
                               class="nav-link <?php echo e(request()->routeIs('vehicle.deliveries.create') ? 'active' : ''); ?>">
                                <i class="fas fa-clipboard-list"></i>
                                <span>บันทึกการจัดส่ง</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" 
                               class="nav-link <?php echo e(request()->routeIs('vehicle.deliveries.index') ? 'active' : ''); ?>">
                                <i class="fas fa-history"></i>
                                <span>ดูประวัติการจัดส่ง</span>
                            </a>
                        </li>
                        
                        <li class="nav-section-title">บัญชีการเงิน</li>
                        <li>
                            <a href="<?php echo e(route('finance.dashboard')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('finance.dashboard') ? 'active' : ''); ?>">
                                <i class="fas fa-chart-line"></i>
                                <span>ภาพรวมการเงิน</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('finance.records.index')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('finance.records.*') ? 'active' : ''); ?>">
                                <i class="fas fa-list"></i>
                                <span>รายรับ-รายจ่าย</span>
                            </a>
                        </li>
                        <!-- Add more vehicle user links -->
                    <?php endif; ?>

                    <li class="nav-section-title">บัญชี</li>
                    <li>
                        <a href="<?php echo e(route('profile.edit')); ?>" 
                           class="nav-link <?php echo e(request()->routeIs('profile.*') ? 'active' : ''); ?>">
                            <i class="fas fa-user-cog"></i>
                            <span>ตั้งค่าโปรไฟล์</span>
                        </a>
                    </li>
                    <li>
                        <form method="POST" action="<?php echo e(route('logout')); ?>" id="logoutFormDesktop">
                            <?php echo csrf_field(); ?>
                            <a href="#" class="nav-link" onclick="confirmLogout(event, 'desktop')">
                                <i class="fas fa-sign-out-alt"></i>
                                <span>ออกจากระบบ</span>
                            </a>
                        </form>
                    </li>
                <?php endif; ?>
        </div>
    </nav>

    <!-- Floating Action Button -->
    <div class="fab-container">
        <div class="quick-actions" id="quickActions">
            <?php if(auth()->user()->isVehicleUser()): ?>
                <div class="quick-action-item">
                    <span class="quick-action-label">คำนวณคอมมิชชั่น</span>
                    <button class="quick-action-btn" onclick="quickAction('calculator')">
                        <i class="fas fa-calculator"></i>
                    </button>
                </div>
                <div class="quick-action-item">
                    <span class="quick-action-label">สแกนเอกสาร</span>
                    <button class="quick-action-btn" onclick="quickAction('camera')">
                        <i class="fas fa-camera"></i>
                    </button>
                </div>
                <div class="quick-action-item">
                    <span class="quick-action-label">บันทึกการจัดส่ง</span>
                    <button class="quick-action-btn" onclick="quickAction('add')">
                        <i class="fas fa-plus"></i>
                    </button>
                </div>
            <?php endif; ?>
        </div>
        <button class="fab" onclick="toggleQuickActions()" id="fabButton">
            <i class="fas fa-plus"></i>
        </button>
    </div>

    <!-- Slide Menu -->
    <div class="slide-menu" id="slideMenu">
        <div class="menu-handle"></div>
        <div class="menu-header">
            <h3 class="menu-title">เมนูทั้งหมด</h3>
            <button class="close-menu" onclick="closeSlideMenu()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="menu-content">
            <?php if(auth()->guard()->check()): ?>
                <!-- User Profile Section -->
                <div class="menu-section">
                    <div style="display: flex; align-items: center; gap: 15px; padding: 15px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 16px; margin-bottom: 20px;">
                        <div style="width: 60px; height: 60px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #667eea; font-weight: 600; font-size: 20px;">
                            <?php echo e(strtoupper(substr(auth()->user()->name ?? 'U', 0, 2))); ?>

                        </div>
                        <div style="flex: 1;">
                            <div style="color: white; font-weight: 600; font-size: 16px;"><?php echo e(auth()->user()->name ?? 'ผู้ใช้'); ?></div>
                            <div style="color: rgba(255,255,255,0.8); font-size: 14px;"><?php echo e(auth()->user()->role_display_name ?? 'ผู้ใช้งาน'); ?></div>
                        </div>
                    </div>
                </div>

                <?php if(auth()->user()->isVehicleUser()): ?>
                    <!-- Quick Access Grid -->
                    <div class="menu-section">
                        <div class="menu-section-title">เมนูลัด</div>
                        <div class="menu-grid">
                            <a href="<?php echo e(route('vehicle.dashboard')); ?>" class="menu-item">
                                <i class="fas fa-tachometer-alt"></i>
                                <span>แดชบอร์ด</span>
                            </a>
                            <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="menu-item">
                                <i class="fas fa-plus-circle"></i>
                                <span>บันทึกใหม่</span>
                            </a>
                            <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="menu-item">
                                <i class="fas fa-history"></i>
                                <span>ประวัติ</span>
                            </a>
                            <a href="<?php echo e(route('vehicle.calculator')); ?>" class="menu-item">
                                <i class="fas fa-calculator"></i>
                                <span>คำนวณ</span>
                            </a>
                        </div>
                    </div>

                    <!-- Finance Menu -->
                    <div class="menu-section">
                        <div class="menu-section-title">บัญชีการเงิน</div>
                        <div class="menu-list">
                            <a href="<?php echo e(route('finance.dashboard')); ?>" class="menu-list-item">
                                <i class="fas fa-chart-line"></i>
                                <div class="menu-list-item-text">
                                    <div class="menu-list-item-title">ภาพรวมการเงิน</div>
                                    <div class="menu-list-item-subtitle">ดูสรุปรายรับ-รายจ่าย</div>
                                </div>
                            </a>
                            <a href="<?php echo e(route('finance.records.index')); ?>" class="menu-list-item">
                                <i class="fas fa-list"></i>
                                <div class="menu-list-item-text">
                                    <div class="menu-list-item-title">รายรับ-รายจ่าย</div>
                                    <div class="menu-list-item-subtitle">บันทึกและจัดการ</div>
                                </div>
                            </a>
                            <a href="<?php echo e(route('finance.budgets.index')); ?>" class="menu-list-item">
                                <i class="fas fa-file-invoice-dollar"></i>
                                <div class="menu-list-item-text">
                                    <div class="menu-list-item-title">งบประมาณ</div>
                                    <div class="menu-list-item-subtitle">วางแผนการเงิน</div>
                                </div>
                            </a>
                            <a href="<?php echo e(route('finance.goals.index')); ?>" class="menu-list-item">
                                <i class="fas fa-piggy-bank"></i>
                                <div class="menu-list-item-text">
                                    <div class="menu-list-item-title">เป้าหมายการออม</div>
                                    <div class="menu-list-item-subtitle">ตั้งเป้าและติดตาม</div>
                                </div>
                            </a>
                            <a href="<?php echo e(route('finance.reports.index')); ?>" class="menu-list-item">
                                <i class="fas fa-file-chart-line"></i>
                                <div class="menu-list-item-text">
                                    <div class="menu-list-item-title">รายงาน</div>
                                    <div class="menu-list-item-subtitle">วิเคราะห์การเงิน</div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php elseif(auth()->user()->isAdmin()): ?>
                    <!-- Admin Quick Access -->
                    <div class="menu-section">
                        <div class="menu-section-title">การจัดการ</div>
                        <div class="menu-grid">
                            <a href="<?php echo e(route('admin.dashboard')); ?>" class="menu-item">
                                <i class="fas fa-tachometer-alt"></i>
                                <span>แดชบอร์ด</span>
                            </a>
                            <a href="<?php echo e(route('admin.users.index')); ?>" class="menu-item">
                                <i class="fas fa-users"></i>
                                <span>ผู้ใช้</span>
                            </a>
                            <a href="<?php echo e(route('admin.warehouses.index')); ?>" class="menu-item">
                                <i class="fas fa-warehouse"></i>
                                <span>คลัง</span>
                            </a>
                            <a href="<?php echo e(route('admin.commission-rates.index')); ?>" class="menu-item">
                                <i class="fas fa-percentage"></i>
                                <span>อัตรา</span>
                            </a>
                        </div>
                    </div>

                    <!-- Admin Reports -->
                    <div class="menu-section">
                        <div class="menu-section-title">รายงาน</div>
                        <div class="menu-list">
                            <a href="<?php echo e(route('admin.reports.index')); ?>" class="menu-list-item">
                                <i class="fas fa-chart-line"></i>
                                <div class="menu-list-item-text">
                                    <div class="menu-list-item-title">รายงานการจัดส่ง</div>
                                    <div class="menu-list-item-subtitle">วิเคราะห์ผลการดำเนินงาน</div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Settings Section -->
                <div class="menu-section">
                    <div class="menu-section-title">ตั้งค่า</div>
                    <div class="menu-list">
                        <a href="<?php echo e(route('profile.edit')); ?>" class="menu-list-item">
                            <i class="fas fa-user-cog"></i>
                            <div class="menu-list-item-text">
                                <div class="menu-list-item-title">ตั้งค่าโปรไฟล์</div>
                                <div class="menu-list-item-subtitle">แก้ไขข้อมูลส่วนตัว</div>
                            </div>
                        </a>
                        <form method="POST" action="<?php echo e(route('logout')); ?>" id="logoutFormMobile">
                            <?php echo csrf_field(); ?>
                            <a href="#" class="menu-list-item" onclick="confirmLogout(event, 'mobile')">
                                <i class="fas fa-sign-out-alt"></i>
                                <div class="menu-list-item-text">
                                    <div class="menu-list-item-title">ออกจากระบบ</div>
                                    <div class="menu-list-item-subtitle">ลงชื่อออกจากแอพ</div>
                                </div>
                            </a>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

     </ul>
        </div>
    </nav>

    <!-- Mobile Header (Optional - shows on scroll) -->
    <header class="mobile-header" id="mobileHeader">
        <h1 class="header-title"><?php echo $__env->yieldContent('header-title', 'EazyCom Plus'); ?></h1>
        <div class="header-actions">
            <button class="header-btn">
                <i class="fas fa-bell"></i>
                <span class="nav-badge">3</span>
            </button>
            <button class="header-btn" onclick="openSlideMenu()">
                <i class="fas fa-user"></i>
            </button>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Mobile Bottom Navigation -->
    <nav class="mobile-nav">
        <div class="nav-container">
            <?php if(auth()->guard()->check()): ?>
                <?php if(auth()->user()->isVehicleUser()): ?>
                    <button class="nav-item <?php echo e(request()->routeIs('vehicle.dashboard') ? 'active' : ''); ?>"
                            onclick="navigate('<?php echo e(route('vehicle.dashboard')); ?>', this)">
                        <i class="fas fa-home"></i>
                        <span>หน้าหลัก</span>
                    </button>
                    
                    <button class="nav-item <?php echo e(request()->routeIs('vehicle.deliveries.*') ? 'active' : ''); ?>"
                            onclick="navigate('<?php echo e(route('vehicle.deliveries.index')); ?>', this)">
                        <i class="fas fa-clipboard-list"></i>
                        <span>จัดส่ง</span>
                        <?php if(isset($pendingDeliveries) && $pendingDeliveries > 0): ?>
                            <span class="nav-badge"><?php echo e($pendingDeliveries); ?></span>
                        <?php endif; ?>
                    </button>
                    
                    <button class="nav-item <?php echo e(request()->routeIs('vehicle.calculator') ? 'active' : ''); ?>"
                            onclick="navigate('<?php echo e(route('vehicle.calculator')); ?>', this)">
                        <i class="fas fa-calculator"></i>
                        <span>คำนวณ</span>
                    </button>
                    
                    <button class="nav-item <?php echo e(request()->routeIs('finance.*') ? 'active' : ''); ?>"
                            onclick="navigate('<?php echo e(route('finance.dashboard')); ?>', this)">
                        <i class="fas fa-wallet"></i>
                        <span>การเงิน</span>
                    </button>
                    
                    <button class="nav-item" onclick="openSlideMenu()">
                        <i class="fas fa-bars"></i>
                        <span>เมนู</span>
                    </button>
                <?php elseif(auth()->user()->isAdmin()): ?>
                    <button class="nav-item <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>"
                            onclick="navigate('<?php echo e(route('admin.dashboard')); ?>', this)">
                        <i class="fas fa-home"></i>
                        <span>หน้าหลัก</span>
                    </button>
                    
                    <button class="nav-item <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>"
                            onclick="navigate('<?php echo e(route('admin.users.index')); ?>', this)">
                        <i class="fas fa-users"></i>
                        <span>ผู้ใช้</span>
                    </button>
                    
                    <button class="nav-item <?php echo e(request()->routeIs('admin.warehouses.*') ? 'active' : ''); ?>"
                            onclick="navigate('<?php echo e(route('admin.warehouses.index')); ?>', this)">
                        <i class="fas fa-warehouse"></i>
                        <span>คลัง</span>
                    </button>
                    
                    <button class="nav-item <?php echo e(request()->routeIs('admin.reports.*') ? 'active' : ''); ?>"
                            onclick="navigate('<?php echo e(route('admin.reports.index')); ?>', this)">
                        <i class="fas fa-chart-line"></i>
                        <span>รายงาน</span>
                    </button>
                    
                    <button class="nav-item" onclick="openSlideMenu()">
                        <i class="fas fa-bars"></i>
                        <span>เมนู</span>
                    </button>
                <?php endif; ?>
            <?php endif; ?>

    <!-- Overlay -->
    <div class="overlay" id="overlay" onclick="closeSlideMenu()"></div>

    <!-- Scripts -->
    <script>
        // Navigation Functions
        function navigate(url, element) {
            // Add loading animation
            showLoading();
            
            // Haptic feedback
            if (navigator.vibrate) {
                navigator.vibrate(10);
            }
            
            // Navigate to URL
            window.location.href = url;
        }

        // Toggle Quick Actions
        function toggleQuickActions() {
            const quickActions = document.getElementById('quickActions');
            const fab = document.getElementById('fabButton');
            
            quickActions.classList.toggle('active');
            fab.classList.toggle('active');
            
            if (navigator.vibrate) {
                navigator.vibrate(20);
            }
        }

        // Quick Action Handler
        function quickAction(type) {
            toggleQuickActions();
            
            switch(type) {
                case 'calculator':
                    window.location.href = '<?php echo e(route("vehicle.calculator")); ?>';
                    break;
                case 'camera':
                    // Implement camera functionality
                    showToast('กำลังเปิดกล้อง...', 'info');
                    break;
                case 'add':
                    window.location.href = '<?php echo e(route("vehicle.deliveries.create")); ?>';
                    break;
            }
        }

        // Slide Menu Functions
        function openSlideMenu() {
            const slideMenu = document.getElementById('slideMenu');
            const overlay = document.getElementById('overlay');
            
            slideMenu.classList.add('active');
            overlay.classList.add('active');
            document.body.style.overflow = 'hidden';
            
            if (navigator.vibrate) {
                navigator.vibrate(15);
            }
        }

        function closeSlideMenu() {
            const slideMenu = document.getElementById('slideMenu');
            const overlay = document.getElementById('overlay');
            
            slideMenu.classList.remove('active');
            overlay.classList.remove('active');
            document.body.style.overflow = '';
        }

        // Toast Notification
        function showToast(message, type = 'info', duration = 3000) {
            const toastContainer = document.getElementById('toastContainer');
            
            const toast = document.createElement('div');
            toast.className = `toast ${type}`;
            
            const iconMap = {
                success: 'fa-check-circle',
                error: 'fa-exclamation-circle',
                warning: 'fa-exclamation-triangle',
                info: 'fa-info-circle'
            };
            
            const titleMap = {
                success: 'สำเร็จ!',
                error: 'เกิดข้อผิดพลาด!',
                warning: 'คำเตือน!',
                info: 'แจ้งเตือน'
            };
            
            toast.innerHTML = `
                <div class="toast-icon">
                    <i class="fas ${iconMap[type]}"></i>
                </div>
                <div class="toast-content">
                    <div class="toast-title">${titleMap[type]}</div>
                    <div class="toast-message">${message}</div>
                </div>
                <button class="toast-close" onclick="this.parentElement.remove()">
                    <i class="fas fa-times"></i>
                </button>
            `;
            
            toastContainer.appendChild(toast);
            
            setTimeout(() => {
                toast.style.animation = 'slideInRight 0.3s ease reverse';
                setTimeout(() => toast.remove(), 300);
            }, duration);
        }

        // Loading Functions
        function showLoading() {
            document.getElementById('pageLoading').classList.remove('hide');
        }

        function hideLoading() {
            document.getElementById('pageLoading').classList.add('hide');
        }

        // Logout Confirmation
        function confirmLogout(event, form = 'desktop') {
            event.preventDefault();
            
            Swal.fire({
                title: 'ยืนยันการออกจากระบบ',
                text: 'คุณต้องการออกจากระบบหรือไม่?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#667eea',
                cancelButtonColor: '#94a3b8',
                confirmButtonText: 'ออกจากระบบ',
                cancelButtonText: 'ยกเลิก'
            }).then((result) => {
                if (result.isConfirmed) {
                    const formId = form === 'mobile' ? 'logoutFormMobile' : 'logoutFormDesktop';
                    document.getElementById(formId).submit();
                }
            });
        }

        // Handle swipe gestures
        let touchStartY = 0;
        let touchEndY = 0;

        document.getElementById('slideMenu').addEventListener('touchstart', function(e) {
            touchStartY = e.changedTouches[0].screenY;
        });

        document.getElementById('slideMenu').addEventListener('touchend', function(e) {
            touchEndY = e.changedTouches[0].screenY;
            if (touchEndY > touchStartY + 50) {
                closeSlideMenu();
            }
        });

        // Close quick actions when clicking outside
        document.addEventListener('click', function(e) {
            const fabContainer = document.querySelector('.fab-container');
            const quickActions = document.getElementById('quickActions');
            
            if (!fabContainer.contains(e.target) && quickActions.classList.contains('active')) {
                quickActions.classList.remove('active');
                document.getElementById('fabButton').classList.remove('active');
            }
        });

        // Mobile header on scroll
        let lastScrollTop = 0;
        window.addEventListener('scroll', function() {
            if (window.innerWidth <= 768) {
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                const mobileHeader = document.getElementById('mobileHeader');
                
                if (scrollTop > 100 && scrollTop > lastScrollTop) {
                    // Scrolling down
                    mobileHeader.classList.remove('show');
                } else if (scrollTop < lastScrollTop) {
                    // Scrolling up
                    mobileHeader.classList.add('show');
                }
                
                lastScrollTop = scrollTop;
            }
        });

        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            // Hide loading screen
            setTimeout(() => {
                hideLoading();
            }, 500);

            // Display flash messages
            <?php if(session('success')): ?>
                showToast('<?php echo e(session('success')); ?>', 'success');
            <?php endif; ?>

            <?php if(session('error')): ?>
                showToast('<?php echo e(session('error')); ?>', 'error');
            <?php endif; ?>

            <?php if(session('warning')): ?>
                showToast('<?php echo e(session('warning')); ?>', 'warning');
            <?php endif; ?>

            // Check PWA installation
            if (window.matchMedia('(display-mode: standalone)').matches) {
                console.log('Running as PWA');
            }

            // PWA Install Prompt
            let deferredPrompt;
            window.addEventListener('beforeinstallprompt', (e) => {
                e.preventDefault();
                deferredPrompt = e;
                // You can show install button here
            });

            // Service Worker Registration
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.register('/sw.js')
                    .then(registration => console.log('SW registered'))
                    .catch(error => console.log('SW registration failed'));
            }
        });

         // Global App Functions
    window.CommissionApp = {
        // Sidebar Functions
        toggleSidebar: function() {
                const sidebar = document.getElementById('sidebar');
                const overlay = document.getElementById('sidebarOverlay');
                
                sidebar.classList.toggle('active');
                overlay.classList.toggle('active');
                
                // Prevent body scroll when sidebar is open on mobile
                if (sidebar.classList.contains('active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            },

            closeSidebar: function() {
                const sidebar = document.getElementById('sidebar');
                const overlay = document.getElementById('sidebarOverlay');
                
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
                document.body.style.overflow = '';
            },

            toggleSidebarCollapse: function() {
                const sidebar = document.getElementById('sidebar');
                const toggleIcon = document.querySelector('#sidebarToggle i');
                
                sidebar.classList.toggle('collapsed');
                
                if (sidebar.classList.contains('collapsed')) {
                    toggleIcon.classList.remove('fa-chevron-left');
                    toggleIcon.classList.add('fa-chevron-right');
                } else {
                    toggleIcon.classList.remove('fa-chevron-right');
                    toggleIcon.classList.add('fa-chevron-left');
                }
                
                // Store preference
                localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed'));
            },

            // Toast Functions
            showToast: function(message, type = 'info', duration = 5000) {
                const toast = document.createElement('div');
                toast.className = `toast toast-${type} show`;
                
                const iconMap = {
                    success: 'fa-check-circle text-green-500',
                    error: 'fa-exclamation-circle text-red-500',
                    warning: 'fa-exclamation-triangle text-yellow-500',
                    info: 'fa-info-circle text-blue-500'
                };
                
                toast.innerHTML = `
                    <div class="flex items-center">
                        <i class="fas ${iconMap[type]} mr-3"></i>
                        <div class="text-sm">${message}</div>
                        <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-gray-400 hover:text-gray-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                `;
                
                document.body.appendChild(toast);
                
                // Auto remove
                setTimeout(() => {
                    if (toast.parentElement) {
                        toast.classList.remove('show');
                        setTimeout(() => toast.remove(), 300);
                    }
                }, duration);
            },

            // Loading Functions
            showLoading: function() {
                document.getElementById('pageLoading').style.display = 'flex';
            },

            hideLoading: function() {
                document.getElementById('pageLoading').style.display = 'none';
            },

            // AJAX Helper
            request: function(url, options = {}) {
                const defaultOptions = {
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    }
                };

                return fetch(url, { ...defaultOptions, ...options })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }
                        return response.json();
                    });
            }
        };

        // Make functions globally available
        window.toggleSidebar = CommissionApp.toggleSidebar;
        window.closeSidebar = CommissionApp.closeSidebar;
        window.toggleSidebarCollapse = CommissionApp.toggleSidebarCollapse;

        // Logout confirmation
        function confirmLogout(event) {
            event.preventDefault();
            
            if (window.Swal) {
                Swal.fire({
                    title: 'ยืนยันการออกจากระบบ',
                    text: 'คุณต้องการออกจากระบบหรือไม่?',
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#FF6B35',
                    cancelButtonColor: '#6B7280',
                    confirmButtonText: 'ออกจากระบบ',
                    cancelButtonText: 'ยกเลิก'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('logoutForm').submit();
                    }
                });
            } else {
                if (confirm('คุณต้องการออกจากระบบหรือไม่?')) {
                    document.getElementById('logoutForm').submit();
                }
            }
        }

        // Profile menu toggle
        function toggleProfileMenu() {
            // Add profile menu functionality here if needed
            console.log('Profile menu clicked');
        }

        // Initialize app
        document.addEventListener('DOMContentLoaded', function() {
            // Hide loading screen
            setTimeout(() => {
                CommissionApp.hideLoading();
            }, 500);

            // Restore sidebar collapse state
            const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
            if (sidebarCollapsed) {
                document.getElementById('sidebar').classList.add('collapsed');
                const toggleIcon = document.querySelector('#sidebarToggle i');
                toggleIcon.classList.remove('fa-chevron-left');
                toggleIcon.classList.add('fa-chevron-right');
            }

            // Auto-hide toasts
            document.querySelectorAll('.toast.show').forEach(toast => {
                setTimeout(() => {
                    toast.classList.remove('show');
                    setTimeout(() => toast.remove(), 300);
                }, 5000);
            });

            // Handle window resize
            let resizeTimer;
            window.addEventListener('resize', function() {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function() {
                    // Close mobile sidebar on resize to desktop
                    if (window.innerWidth > 768) {
                        CommissionApp.closeSidebar();
                    }
                }, 250);
            });

            // Handle escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    CommissionApp.closeSidebar();
                }
            });

            // Add navigation animation delays
            document.querySelectorAll('.nav-item').forEach((item, index) => {
                item.style.animationDelay = `${index * 50}ms`;
            });
        });

        // Service Worker Registration (for PWA)
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('/sw.js')
                    .then(function(registration) {
                        console.log('SW registered: ', registration);
                    })
                    .catch(function(registrationError) {
                        console.log('SW registration failed: ', registrationError);
                    });
            });
        }

        document.addEventListener('DOMContentLoaded', () => {
    const openMobileMenu = document.getElementById('openMobileMenu');
    const closeMobileMenu = document.getElementById('closeMobileMenu');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebarOverlay');

    openMobileMenu.addEventListener('click', () => {
        sidebar.classList.add('active');
        sidebarOverlay.classList.add('active');
    });

    closeMobileMenu.addEventListener('click', () => {
        sidebar.classList.remove('active');
        sidebarOverlay.classList.remove('active');
    });

    sidebarOverlay.addEventListener('click', () => {
        sidebar.classList.remove('active');
        sidebarOverlay.classList.remove('active');
    });
});
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>