


<?php $__env->startSection('title', 'เพิ่มผู้ใช้ใหม่ - ระบบจัดการค่าคอมมิชชั่น'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-container">
    <!-- Page Header -->
    <div class="page-header">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="page-title">เพิ่มผู้ใช้ใหม่</h1>
                <p class="page-subtitle">เพิ่มข้อมูลผู้ใช้งานใหม่เข้าสู่ระบบ</p>
            </div>
            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i>กลับไปรายการ
            </a>
        </div>
    </div>

    <!-- Form Container -->
    <div class="modern-card">
        <div class="modern-card-header">
            <h3 class="modern-card-title">
                <i class="fas fa-user-plus text-orange-500"></i>
                ข้อมูลผู้ใช้
            </h3>
        </div>
        
        <div class="modern-card-body">
            <form method="POST" action="<?php echo e(route('admin.users.store')); ?>" id="userForm" class="space-y-6">
                <?php echo csrf_field(); ?>
                
                <!-- Personal Information Section -->
                <div class="section-divider">
                    <h4 class="section-title">ข้อมูลส่วนตัว</h4>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- First Name -->
                    <div class="form-group">
                        <label for="first_name" class="form-label required">ชื่อ</label>
                        <div class="input-with-icon">
                            <i class="fas fa-user input-icon"></i>
                            <input type="text" id="first_name" name="first_name" value="<?php echo e(old('first_name')); ?>" 
                                   class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   placeholder="กรอกชื่อ" required>
                        </div>
                        <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Last Name -->
                    <div class="form-group">
                        <label for="last_name" class="form-label required">นามสกุล</label>
                        <div class="input-with-icon">
                            <i class="fas fa-user input-icon"></i>
                            <input type="text" id="last_name" name="last_name" value="<?php echo e(old('last_name')); ?>" 
                                   class="form-control <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   placeholder="กรอกนามสกุล" required>
                        </div>
                        <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Email -->
                    <div class="form-group md:col-span-2">
                        <label for="email" class="form-label required">อีเมล</label>
                        <div class="input-with-icon">
                            <i class="fas fa-envelope input-icon"></i>
                            <input type="email" id="email" name="email" value="<?php echo e(old('email')); ?>" 
                                   class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   placeholder="example@email.com" required>
                        </div>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Security Section -->
                <div class="section-divider">
                    <h4 class="section-title">ข้อมูลรักษาความปลอดภัย</h4>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Password -->
                    <div class="form-group">
                        <label for="password" class="form-label required">รหัสผ่าน</label>
                        <div class="input-with-icon">
                            <i class="fas fa-lock input-icon"></i>
                            <input type="password" id="password" name="password" 
                                   class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> pr-12" 
                                   placeholder="อย่างน้อย 8 ตัวอักษร" required>
                            <button type="button" onclick="togglePassword('password')" 
                                    class="password-toggle">
                                <i class="fas fa-eye" id="password-icon"></i>
                            </button>
                        </div>
                        <div class="password-strength" id="password-strength"></div>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <p class="form-hint">รหัสผ่านต้องมีอย่างน้อย 8 ตัวอักษร</p>
                    </div>

                    <!-- Password Confirmation -->
                    <div class="form-group">
                        <label for="password_confirmation" class="form-label required">ยืนยันรหัสผ่าน</label>
                        <div class="input-with-icon">
                            <i class="fas fa-lock input-icon"></i>
                            <input type="password" id="password_confirmation" name="password_confirmation" 
                                   class="form-control pr-12" 
                                   placeholder="ยืนยันรหัสผ่าน" required>
                            <button type="button" onclick="togglePassword('password_confirmation')" 
                                    class="password-toggle">
                                <i class="fas fa-eye" id="password_confirmation-icon"></i>
                            </button>
                        </div>
                        <div class="password-match" id="password-match"></div>
                    </div>
                </div>

                <!-- Role & Warehouse Section -->
                <div class="section-divider">
                    <h4 class="section-title">บทบาทและคลังสินค้า</h4>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Role -->
                    <div class="form-group">
                        <label for="role" class="form-label required">บทบาท</label>
                        <div class="input-with-icon">
                            <i class="fas fa-user-tag input-icon"></i>
                            <select id="role" name="role" class="form-control <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">เลือกบทบาท</option>
                                <option value="admin" <?php echo e(old('role') === 'admin' ? 'selected' : ''); ?>>
                                    👑 ผู้ดูแลระบบ
                                </option>
                                <option value="2wheel" <?php echo e(old('role') === '2wheel' ? 'selected' : ''); ?>>
                                    🏍️ รถ 2 ล้อ
                                </option>
                                <option value="4wheel" <?php echo e(old('role') === '4wheel' ? 'selected' : ''); ?>>
                                    🚚 รถ 4 ล้อ
                                </option>
                            </select>
                        </div>
                        <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Warehouse -->
                    <div class="form-group" id="warehouse-group" style="display: none;">
                        <label for="warehouse_code" class="form-label required">คลังสินค้า</label>
                        <div class="input-with-icon">
                            <i class="fas fa-warehouse input-icon"></i>
                            <select id="warehouse_code" name="warehouse_code" class="form-control <?php $__errorArgs = ['warehouse_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">เลือกคลังสินค้า</option>
                                <?php $__currentLoopData = $warehouses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($warehouse->code); ?>" <?php echo e(old('warehouse_code') === $warehouse->code ? 'selected' : ''); ?>>
                                        <?php echo e($warehouse->code); ?> - <?php echo e($warehouse->name); ?>

                                        <?php if($warehouse->location): ?>
                                            (<?php echo e($warehouse->location); ?>)
                                        <?php endif; ?>
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php $__errorArgs = ['warehouse_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <p class="form-hint">จำเป็นสำหรับผู้ใช้ประเภทรถ</p>
                    </div>
                </div>

                <!-- Status Section -->
                <div class="section-divider">
                    <h4 class="section-title">สถานะการใช้งาน</h4>
                </div>

                <div class="form-group">
                    <label class="form-label">สถานะผู้ใช้</label>
                    <div class="radio-group">
                        <label class="radio-option active">
                            <input type="radio" name="is_active" value="1" 
                                   <?php echo e(old('is_active', '1') === '1' ? 'checked' : ''); ?>>
                            <span class="radio-custom"></span>
                            <div class="radio-content">
                                <i class="fas fa-user-check text-green-500"></i>
                                <span>ใช้งานอยู่</span>
                            </div>
                        </label>
                        <label class="radio-option">
                            <input type="radio" name="is_active" value="0" 
                                   <?php echo e(old('is_active') === '0' ? 'checked' : ''); ?>>
                            <span class="radio-custom"></span>
                            <div class="radio-content">
                                <i class="fas fa-user-slash text-red-500"></i>
                                <span>ปิดใช้งาน</span>
                            </div>
                        </label>
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div class="form-actions">
                    <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-times"></i>ยกเลิก
                    </a>
                    <button type="submit" class="btn btn-primary" id="submit-btn">
                        <i class="fas fa-save"></i>
                        <span>บันทึกข้อมูล</span>
                        <div class="btn-loader" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i>
                        </div>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Enhanced Styles -->
<style>
/* Modern Card Styling */
.modern-card {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-lg);
    border: 1px solid var(--medium-gray);
    overflow: hidden;
    margin-bottom: 2rem;
}

.modern-card-header {
    background: linear-gradient(135deg, rgba(255, 107, 53, 0.05) 0%, rgba(255, 140, 97, 0.05) 100%);
    padding: 1.5rem 2rem;
    border-bottom: 1px solid var(--medium-gray);
}

.modern-card-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--dark-gray);
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin: 0;
}

.modern-card-body {
    padding: 2rem;
}

/* Section Dividers */
.section-divider {
    margin: 2rem 0 1.5rem;
    position: relative;
}

.section-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--primary-orange);
    margin: 0;
    position: relative;
    padding-bottom: 0.5rem;
}

.section-title::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 3rem;
    height: 2px;
    background: var(--primary-gradient);
    border-radius: 1px;
}

/* Enhanced Form Controls */
.form-group {
    margin-bottom: 1.5rem;
}

.form-label {
    display: block;
    font-weight: 500;
    color: var(--dark-gray);
    margin-bottom: 0.5rem;
    font-size: 0.95rem;
}

.form-label.required::after {
    content: '*';
    color: #EF4444;
    margin-left: 0.25rem;
}

.input-with-icon {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray);
    font-size: 0.9rem;
    z-index: 10;
}

.form-control {
    width: 100%;
    padding: 0.875rem 1rem 0.875rem 2.75rem;
    border: 2px solid var(--medium-gray);
    border-radius: var(--radius-md);
    font-family: inherit;
    font-size: 0.95rem;
    transition: var(--transition-fast);
    background: var(--white);
}

.form-control:focus {
    outline: none;
    border-color: var(--primary-orange);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.form-control.error {
    border-color: #EF4444;
    box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
}

/* Password Toggle */
.password-toggle {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: var(--gray);
    cursor: pointer;
    font-size: 0.9rem;
    z-index: 10;
    transition: var(--transition-fast);
}

.password-toggle:hover {
    color: var(--primary-orange);
}

/* Password Strength Indicator */
.password-strength {
    height: 4px;
    border-radius: 2px;
    margin-top: 0.5rem;
    transition: var(--transition-fast);
}

.password-strength.weak {
    background: #EF4444;
    width: 33%;
}

.password-strength.medium {
    background: #F59E0B;
    width: 66%;
}

.password-strength.strong {
    background: #22C55E;
    width: 100%;
}

/* Password Match Indicator */
.password-match {
    margin-top: 0.5rem;
    font-size: 0.85rem;
    font-weight: 500;
}

.password-match.match {
    color: #22C55E;
}

.password-match.no-match {
    color: #EF4444;
}

/* Radio Group */
.radio-group {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.radio-option {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem;
    border: 2px solid var(--medium-gray);
    border-radius: var(--radius-md);
    cursor: pointer;
    transition: var(--transition-fast);
    flex: 1;
    min-width: 200px;
    position: relative;
}

.radio-option:hover {
    border-color: var(--primary-orange);
    background: rgba(255, 107, 53, 0.02);
}

.radio-option input[type="radio"] {
    display: none;
}

.radio-custom {
    width: 20px;
    height: 20px;
    border: 2px solid var(--medium-gray);
    border-radius: 50%;
    position: relative;
    transition: var(--transition-fast);
}

.radio-option input[type="radio"]:checked + .radio-custom {
    border-color: var(--primary-orange);
    background: var(--primary-orange);
}

.radio-option input[type="radio"]:checked + .radio-custom::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 8px;
    height: 8px;
    background: white;
    border-radius: 50%;
}

.radio-content {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 500;
}

/* Error Messages */
.error-message {
    color: #EF4444;
    font-size: 0.85rem;
    margin-top: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.error-message::before {
    content: '⚠️';
    font-size: 0.8rem;
}

/* Form Hints */
.form-hint {
    color: var(--gray);
    font-size: 0.85rem;
    margin-top: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.form-hint::before {
    content: 'ℹ️';
    font-size: 0.8rem;
}

/* Form Actions */
.form-actions {
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 1px solid var(--medium-gray);
}

/* Button Enhancements */
.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 0.875rem 1.5rem;
    border: none;
    border-radius: var(--radius-md);
    font-family: inherit;
    font-weight: 500;
    font-size: 0.95rem;
    cursor: pointer;
    transition: var(--transition-fast);
    text-decoration: none;
    white-space: nowrap;
    position: relative;
    overflow: hidden;
}

.btn-primary {
    background: var(--primary-gradient);
    color: var(--white);
    box-shadow: var(--shadow-sm);
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-primary:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.btn-secondary {
    background: #6B7280;
    color: white;
}

.btn-secondary:hover {
    background: #4B5563;
    transform: translateY(-1px);
}

.btn-loader {
    position: absolute;
    inset: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    background: inherit;
}

/* Responsive Design */
@media (max-width: 768px) {
    .modern-card-body {
        padding: 1.5rem;
    }
    
    .grid.md\\:grid-cols-2 {
        grid-template-columns: 1fr;
    }
    
    .radio-group {
        flex-direction: column;
    }
    
    .radio-option {
        min-width: auto;
    }
    
    .form-actions {
        flex-direction: column-reverse;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
}

/* Loading Animation */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.modern-card {
    animation: fadeIn 0.3s ease-out;
}
</style>

<!-- Enhanced JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('userForm');
    const roleSelect = document.getElementById('role');
    const warehouseGroup = document.getElementById('warehouse-group');
    const warehouseSelect = document.getElementById('warehouse_code');
    const passwordField = document.getElementById('password');
    const confirmPasswordField = document.getElementById('password_confirmation');
    const submitBtn = document.getElementById('submit-btn');

    // Role-based warehouse visibility
    function toggleWarehouseVisibility() {
        const role = roleSelect.value;
        
        if (role === '2wheel' || role === '4wheel') {
            warehouseGroup.style.display = 'block';
            warehouseSelect.required = true;
            
            // Add animation
            warehouseGroup.style.opacity = '0';
            warehouseGroup.style.transform = 'translateY(-10px)';
            
            setTimeout(() => {
                warehouseGroup.style.transition = 'all 0.3s ease';
                warehouseGroup.style.opacity = '1';
                warehouseGroup.style.transform = 'translateY(0)';
            }, 50);
        } else {
            warehouseGroup.style.display = 'none';
            warehouseSelect.required = false;
            warehouseSelect.value = '';
        }
    }

    roleSelect.addEventListener('change', toggleWarehouseVisibility);
    
    // Initialize on page load
    if (roleSelect.value) {
        toggleWarehouseVisibility();
    }

    // Password strength indicator
    function checkPasswordStrength(password) {
        const strengthIndicator = document.getElementById('password-strength');
        let strength = 0;
        
        if (password.length >= 8) strength++;
        if (/[a-z]/.test(password)) strength++;
        if (/[A-Z]/.test(password)) strength++;
        if (/[0-9]/.test(password)) strength++;
        if (/[^A-Za-z0-9]/.test(password)) strength++;
        
        strengthIndicator.className = 'password-strength';
        
        if (strength < 2) {
            strengthIndicator.classList.add('weak');
        } else if (strength < 4) {
            strengthIndicator.classList.add('medium');
        } else {
            strengthIndicator.classList.add('strong');
        }
    }

    passwordField.addEventListener('input', function() {
        checkPasswordStrength(this.value);
        checkPasswordMatch();
    });

    // Password match indicator
    function checkPasswordMatch() {
        const matchIndicator = document.getElementById('password-match');
        const password = passwordField.value;
        const confirmPassword = confirmPasswordField.value;
        
        if (confirmPassword === '') {
            matchIndicator.textContent = '';
            matchIndicator.className = 'password-match';
            return;
        }
        
        if (password === confirmPassword) {
            matchIndicator.textContent = '✓ รหัสผ่านตรงกัน';
            matchIndicator.className = 'password-match match';
            confirmPasswordField.classList.remove('error');
        } else {
            matchIndicator.textContent = '✗ รหัสผ่านไม่ตรงกัน';
            matchIndicator.className = 'password-match no-match';
            confirmPasswordField.classList.add('error');
        }
    }

    confirmPasswordField.addEventListener('input', checkPasswordMatch);

    // Form submission with loading state
    form.addEventListener('submit', function(e) {
        const password = passwordField.value;
        const confirmPassword = confirmPasswordField.value;
        
        // Validation
        if (password !== confirmPassword) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'ข้อผิดพลาด',
                text: 'รหัสผ่านและการยืนยันรหัสผ่านไม่ตรงกัน',
                confirmButtonColor: '#FF6B35'
            });
            return false;
        }
        
        if (password.length < 8) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'ข้อผิดพลาด',
                text: 'รหัสผ่านต้องมีอย่างน้อย 8 ตัวอักษร',
                confirmButtonColor: '#FF6B35'
            });
            return false;
        }

        // Show loading state
        submitBtn.disabled = true;
        submitBtn.querySelector('span').style.display = 'none';
        submitBtn.querySelector('.btn-loader').style.display = 'flex';
        
        // Re-enable after 10 seconds as fallback
        setTimeout(() => {
            submitBtn.disabled = false;
            submitBtn.querySelector('span').style.display = 'inline';
            submitBtn.querySelector('.btn-loader').style.display = 'none';
        }, 10000);
    });

    // Radio option styling
    document.querySelectorAll('.radio-option input[type="radio"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.radio-option').forEach(option => {
                option.classList.remove('active');
            });
            
            if (this.checked) {
                this.closest('.radio-option').classList.add('active');
            }
        });
    });

    // Initialize active radio option
    const checkedRadio = document.querySelector('.radio-option input[type="radio"]:checked');
    if (checkedRadio) {
        checkedRadio.closest('.radio-option').classList.add('active');
    }
});

// Toggle password visibility
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = document.getElementById(fieldId + '-icon');
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// Show success message if redirected back with success
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: '<?php echo e(session('success')); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

// Show error messages
<?php if($errors->any()): ?>
    Swal.fire({
        icon: 'error',
        title: 'มีข้อผิดพลาด',
        html: '<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($error); ?><br><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/admin/users/create.blade.php ENDPATH**/ ?>