

<?php $__env->startSection('content'); ?>
<div class="records-container">
    <!-- Header -->
    <div class="records-header">
        <div class="header-left">
            <h1 class="records-title">
                <i class="fas fa-list"></i>
                รายการบันทึกรายรับ-รายจ่าย
            </h1>
        </div>
        <div class="header-right">
            <a href="<?php echo e(route('finance.records.create', ['type' => 'income'])); ?>" class="btn btn-income">
                <i class="fas fa-plus-circle"></i> เพิ่มรายรับ
            </a>
            <a href="<?php echo e(route('finance.records.create', ['type' => 'expense'])); ?>" class="btn btn-expense">
                <i class="fas fa-minus-circle"></i> เพิ่มรายจ่าย
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="filters-section">
        <form method="GET" action="<?php echo e(route('finance.records.index')); ?>" class="filters-form">
            <div class="filter-group">
                <label>ประเภท</label>
                <select name="type" class="form-control" onchange="this.form.submit()">
                    <option value="">ทั้งหมด</option>
                    <option value="income" <?php echo e(request('type') == 'income' ? 'selected' : ''); ?>>รายรับ</option>
                    <option value="expense" <?php echo e(request('type') == 'expense' ? 'selected' : ''); ?>>รายจ่าย</option>
                </select>
            </div>

            <div class="filter-group">
                <label>หมวดหมู่</label>
                <select name="category" class="form-control" onchange="this.form.submit()">
                    <option value="">ทั้งหมด</option>
                    <optgroup label="รายรับ">
                        <?php $__currentLoopData = $categories['income']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cat->slug); ?>" <?php echo e(request('category') == $cat->slug ? 'selected' : ''); ?>>
                                <?php echo e($cat->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </optgroup>
                    <optgroup label="รายจ่าย">
                        <?php $__currentLoopData = $categories['expense']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cat->slug); ?>" <?php echo e(request('category') == $cat->slug ? 'selected' : ''); ?>>
                                <?php echo e($cat->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </optgroup>
                </select>
            </div>

            <div class="filter-group">
                <label>เดือน</label>
                <input type="month" name="month" class="form-control" 
                       value="<?php echo e(request('month')); ?>" onchange="this.form.submit()">
            </div>

            <div class="filter-group">
                <label>ค้นหา</label>
                <input type="text" name="search" class="form-control" 
                       placeholder="ค้นหาหมายเหตุ..." value="<?php echo e(request('search')); ?>">
            </div>

            <button type="submit" class="btn btn-filter">
                <i class="fas fa-search"></i> ค้นหา
            </button>

            <?php if(request()->hasAny(['type', 'category', 'month', 'search'])): ?>
                <a href="<?php echo e(route('finance.records.index')); ?>" class="btn btn-reset">
                    <i class="fas fa-redo"></i> ล้างตัวกรอง
                </a>
            <?php endif; ?>
        </form>
    </div>

    <!-- Summary Stats -->
    <?php
        $totalIncome = $records->where('type', 'income')->sum('amount');
        $totalExpense = $records->where('type', 'expense')->sum('amount');
        $netAmount = $totalIncome - $totalExpense;
    ?>
    <div class="summary-stats">
        <div class="stat-item income">
            <span class="stat-label">รายรับ</span>
            <span class="stat-value">฿<?php echo e(number_format($totalIncome, 2)); ?></span>
        </div>
        <div class="stat-item expense">
            <span class="stat-label">รายจ่าย</span>
            <span class="stat-value">฿<?php echo e(number_format($totalExpense, 2)); ?></span>
        </div>
        <div class="stat-item <?php echo e($netAmount >= 0 ? 'positive' : 'negative'); ?>">
            <span class="stat-label">คงเหลือ</span>
            <span class="stat-value">฿<?php echo e(number_format($netAmount, 2)); ?></span>
        </div>
    </div>

    <!-- Records Table -->
    <div class="records-table-container">
        <?php if($records->count() > 0): ?>
            <div class="table-actions">
                <button class="btn btn-sm btn-outline" onclick="toggleSelectAll()">
                    <i class="fas fa-check-square"></i> เลือกทั้งหมด
                </button>
                <button class="btn btn-sm btn-danger" onclick="bulkDelete()" style="display: none;" id="bulkDeleteBtn">
                    <i class="fas fa-trash"></i> ลบที่เลือก
                </button>
            </div>

            <table class="records-table">
                <thead>
                    <tr>
                        <th width="40">
                            <input type="checkbox" id="selectAll">
                        </th>
                        <th>วันที่</th>
                        <th>ประเภท</th>
                        <th>หมวดหมู่</th>
                        <th>รายการ</th>
                        <th class="text-right">จำนวนเงิน</th>
                        <th>แหล่งที่มา</th>
                        <th width="100">จัดการ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="record-row <?php echo e($record->type); ?>">
                        <td>
                            <?php if($record->source === 'manual'): ?>
                                <input type="checkbox" class="record-checkbox" value="<?php echo e($record->id); ?>">
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="date-display">
                                <span class="date-day"><?php echo e($record->record_date->format('d')); ?></span>
                                <span class="date-month"><?php echo e($record->record_date->locale('th')->monthName); ?></span>
                            </div>
                        </td>
                        <td>
                            <span class="type-badge <?php echo e($record->type); ?>">
                                <i class="fas <?php echo e($record->type === 'income' ? 'fa-arrow-up' : 'fa-arrow-down'); ?>"></i>
                                <?php echo e($record->type === 'income' ? 'รายรับ' : 'รายจ่าย'); ?>

                            </span>
                        </td>
                        <td>
                            <div class="category-display" style="color: <?php echo e($record->categoryInfo->color ?? '#6B7280'); ?>">
                                <i class="fas <?php echo e($record->categoryInfo->icon ?? 'fa-circle'); ?>"></i>
                                <?php echo e($record->categoryInfo->name ?? $record->category); ?>

                            </div>
                        </td>
                        <td>
                            <div class="note-display">
                                <?php echo e($record->note ?? '-'); ?>

                                <?php if($record->source === 'delivery'): ?>
                                    <span class="badge-delivery">จากการจัดส่ง</span>
                                <?php endif; ?>
                                <?php if($record->is_recurring): ?>
                                    <span class="badge-recurring">รายการซ้ำ</span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="text-right">
                            <span class="amount <?php echo e($record->type); ?>">
                                <?php echo e($record->type === 'income' ? '+' : '-'); ?>฿<?php echo e($record->formatted_amount); ?>

                            </span>
                        </td>
                        <td>
                            <span class="source-badge <?php echo e($record->source); ?>">
                                <?php echo e($record->source === 'delivery' ? 'ระบบ' : 'บันทึกเอง'); ?>

                            </span>
                        </td>
                        <td>
                            <div class="action-buttons">
                                <?php if($record->source === 'manual'): ?>
                                    <a href="<?php echo e(route('finance.records.edit', $record)); ?>" 
                                       class="btn-action edit" title="แก้ไข">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button onclick="deleteRecord(<?php echo e($record->id); ?>)" 
                                            class="btn-action delete" title="ลบ">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                <?php else: ?>
                                    <button onclick="duplicateRecord(<?php echo e($record->id); ?>)" 
                                            class="btn-action duplicate" title="คัดลอก">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <!-- Pagination -->
                <?php if($records->hasPages()): ?>
                <div class="custom-pagination-wrapper">
                    <div class="custom-pagination-info">
                        แสดง <?php echo e($records->firstItem()); ?> - <?php echo e($records->lastItem()); ?> จาก <?php echo e(number_format($records->total())); ?> รายการ
                    </div>
                    <div class="custom-pagination">
                        <?php echo e($records->links('vendor.pagination.custom')); ?>

                    </div>
                </div>
                <?php endif; ?>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>ไม่พบรายการ</h3>
                <p>ยังไม่มีรายการตามเงื่อนไขที่เลือก</p>
                <div class="empty-actions">
                    <a href="<?php echo e(route('finance.records.create', ['type' => 'income'])); ?>" class="btn btn-income">
                        <i class="fas fa-plus-circle"></i> เพิ่มรายรับ
                    </a>
                    <a href="<?php echo e(route('finance.records.create', ['type' => 'expense'])); ?>" class="btn btn-expense">
                        <i class="fas fa-minus-circle"></i> เพิ่มรายจ่าย
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.records-container {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 0 1rem;
}

/* Header */
.records-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
    flex-wrap: wrap;
    gap: 1rem;
}

.records-title {
    font-size: 1.8rem;
    font-weight: 700;
    color: #1f2937;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.header-right {
    display: flex;
    gap: 0.75rem;
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.25rem;
    border: none;
    border-radius: 12px;
    font-size: 0.95rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    text-decoration: none;
}

.btn-income {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
}

.btn-income:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
}

.btn-expense {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(239, 68, 68, 0.3);
}

.btn-expense:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(239, 68, 68, 0.4);
}

/* Filters */
.filters-section {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
}

.filters-form {
    display: flex;
    gap: 1rem;
    align-items: flex-end;
    flex-wrap: wrap;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
    flex: 1;
    min-width: 150px;
}

.filter-group label {
    font-size: 0.875rem;
    font-weight: 600;
    color: #6b7280;
}

.form-control {
    padding: 0.625rem 1rem;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 0.95rem;
    transition: all 0.3s;
}

.form-control:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.btn-filter {
    background: #667eea;
    color: white;
}

.btn-filter:hover {
    background: #5a5fcd;
}

.btn-reset {
    background: #f3f4f6;
    color: #6b7280;
}

.btn-reset:hover {
    background: #e5e7eb;
}

/* Summary Stats */
.summary-stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.stat-item {
    background: white;
    border-radius: 12px;
    padding: 1.25rem;
    text-align: center;
    box-shadow: 0 3px 10px rgba(0, 0, 0, 0.08);
}

.stat-item.income {
    border-top: 3px solid #10b981;
}

.stat-item.expense {
    border-top: 3px solid #ef4444;
}

.stat-item.positive {
    border-top: 3px solid #3b82f6;
}

.stat-item.negative {
    border-top: 3px solid #f59e0b;
}

.stat-label {
    display: block;
    font-size: 0.875rem;
    color: #6b7280;
    margin-bottom: 0.5rem;
}

.stat-value {
    display: block;
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

/* Table */
.records-table-container {
    background: white;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
}

.table-actions {
    padding: 1rem 1.5rem;
    border-bottom: 1px solid #e5e7eb;
    display: flex;
    gap: 0.75rem;
}

.btn-sm {
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
}

.btn-outline {
    background: transparent;
    border: 2px solid #e5e7eb;
    color: #6b7280;
}

.btn-outline:hover {
    background: #f3f4f6;
}

.btn-danger {
    background: #ef4444;
    color: white;
}

.records-table {
    width: 100%;
    border-collapse: collapse;
}

.records-table th {
    background: #f9fafb;
    padding: 1rem 1.5rem;
    text-align: left;
    font-weight: 600;
    color: #6b7280;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.records-table td {
    padding: 1rem 1.5rem;
    border-bottom: 1px solid #f3f4f6;
}

.record-row:hover {
    background: #f9fafb;
}

.text-right {
    text-align: right;
}

/* Date Display */
.date-display {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.25rem;
}

.date-day {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1f2937;
}

.date-month {
    font-size: 0.75rem;
    color: #6b7280;
}

/* Badges */
.type-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.375rem 0.75rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 600;
}

.type-badge.income {
    background: #10b98120;
    color: #10b981;
}

.type-badge.expense {
    background: #ef444420;
    color: #ef4444;
}

.category-display {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 500;
}

.note-display {
    max-width: 300px;
    line-height: 1.5;
}

.badge-delivery,
.badge-recurring {
    display: inline-block;
    margin-left: 0.5rem;
    padding: 0.125rem 0.5rem;
    border-radius: 10px;
    font-size: 0.75rem;
    font-weight: 600;
}

.badge-delivery {
    background: #ff6b3520;
    color: #ff6b35;
}

.badge-recurring {
    background: #667eea20;
    color: #667eea;
}

.amount {
    font-size: 1.1rem;
    font-weight: 700;
}

.amount.income {
    color: #10b981;
}

.amount.expense {
    color: #ef4444;
}

.source-badge {
    display: inline-block;
    padding: 0.375rem 0.75rem;
    border-radius: 8px;
    font-size: 0.875rem;
    font-weight: 500;
}

.source-badge.manual {
    background: #f3f4f6;
    color: #6b7280;
}

.source-badge.delivery {
    background: #fef3c7;
    color: #92400e;
}

/* Action Buttons */
.action-buttons {
    display: flex;
    gap: 0.5rem;
}

.btn-action {
    width: 32px;
    height: 32px;
    border: none;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-action.edit {
    background: #3b82f620;
    color: #3b82f6;
}

.btn-action.edit:hover {
    background: #3b82f6;
    color: white;
}

.btn-action.delete {
    background: #ef444420;
    color: #ef4444;
}

.btn-action.delete:hover {
    background: #ef4444;
    color: white;
}

.btn-action.duplicate {
    background: #f59e0b20;
    color: #f59e0b;
}

.btn-action.duplicate:hover {
    background: #f59e0b;
    color: white;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 4rem 2rem;
}

.empty-state i {
    font-size: 4rem;
    color: #e5e7eb;
    margin-bottom: 1rem;
}

.empty-state h3 {
    font-size: 1.5rem;
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
}

.empty-state p {
    color: #6b7280;
    margin-bottom: 2rem;
}

.empty-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
}

/* Responsive */
@media (max-width: 768px) {
    .records-header {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .filters-form {
        flex-direction: column;
    }
    
    .filter-group {
        width: 100%;
    }
    
    .summary-stats {
        grid-template-columns: 1fr;
    }
    
    .records-table {
        font-size: 0.875rem;
    }
    
    .records-table th,
    .records-table td {
        padding: 0.75rem;
    }
    
    .note-display {
        max-width: 150px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Select All
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.record-checkbox');
    checkboxes.forEach(cb => cb.checked = this.checked);
    updateBulkActions();
});

// Individual checkbox
document.querySelectorAll('.record-checkbox').forEach(cb => {
    cb.addEventListener('change', updateBulkActions);
});

function updateBulkActions() {
    const checkedBoxes = document.querySelectorAll('.record-checkbox:checked');
    const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');
    
    if (checkedBoxes.length > 0) {
        bulkDeleteBtn.style.display = 'inline-flex';
        bulkDeleteBtn.textContent = `ลบที่เลือก (${checkedBoxes.length})`;
    } else {
        bulkDeleteBtn.style.display = 'none';
    }
}

// Delete single record
function deleteRecord(id) {
    if (!confirm('คุณต้องการลบรายการนี้ใช่หรือไม่?')) {
        return;
    }

    fetch("<?php echo e(route('finance.records.destroy', ':id')); ?>".replace(':id', id), {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message || 'เกิดข้อผิดพลาด');
        }
    });
}


// Bulk delete
function bulkDelete() {
    const checkedBoxes = document.querySelectorAll('.record-checkbox:checked');
    const ids = Array.from(checkedBoxes).map(cb => cb.value);
    
    if (ids.length === 0) return;
    
    if (!confirm(`คุณต้องการลบ ${ids.length} รายการที่เลือกใช่หรือไม่?`)) {
        return;
    }
    
    fetch('<?php echo e(route('finance.records.bulk-delete')); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ ids: ids })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message || 'เกิดข้อผิดพลาด');
        }
    });
}

// Duplicate record
function duplicateRecord(id) {
    if (!confirm('คุณต้องการคัดลอกรายการนี้ใช่หรือไม่?')) {
        return;
    }

    fetch("<?php echo e(route('finance.records.duplicate', ':id')); ?>".replace(':id', id), {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            if (data.redirect) {
                window.location.href = data.redirect;
            } else {
                location.reload();
            }
        } else {
            alert(data.message || 'เกิดข้อผิดพลาด');
        }
    });
}


// Toggle select all
function toggleSelectAll() {
    const selectAll = document.getElementById('selectAll');
    selectAll.checked = !selectAll.checked;
    selectAll.dispatchEvent(new Event('change'));
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/finance/records/index.blade.php ENDPATH**/ ?>