@extends('layouts.app')

@section('content')
<div class="reports-container">
    <!-- Page Header -->
    <div class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">
                <i class="fas fa-coins"></i>
                {{ $title }}
            </h1>
            <p class="page-subtitle">
                วิเคราะห์ข้อมูลค่าคอมมิชชั่นและผลตอบแทน
            </p>
        </div>
        <div class="header-actions">
            <button class="btn btn-outline" onclick="window.print()">
                <i class="fas fa-print"></i> พิมพ์
            </button>
            <button class="btn btn-primary" onclick="exportReport()">
                <i class="fas fa-download"></i> ส่งออก
            </button>
        </div>
    </div>

    <!-- Summary Stats -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon bg-success">
                <i class="fas fa-wallet"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">฿{{ number_format($stats['total'] ?? 0, 2) }}</div>
                <div class="stat-label">ค่าคอมมิชชั่นรวม</div>
                <div class="stat-change positive">
                    <i class="fas fa-arrow-up"></i> 15.2% จากเดือนที่แล้ว
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon bg-info">
                <i class="fas fa-calendar-alt"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">฿{{ number_format($stats['this_month'] ?? 0, 2) }}</div>
                <div class="stat-label">คอมมิชชั่นเดือนนี้</div>
                <div class="stat-change positive">
                    <i class="fas fa-arrow-up"></i> 8.7% จากเดือนที่แล้ว
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon bg-warning">
                <i class="fas fa-chart-bar"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">฿{{ number_format($stats['average'] ?? 0, 2) }}</div>
                <div class="stat-label">เฉลี่ยต่อคน/เดือน</div>
                <div class="stat-change neutral">
                    <i class="fas fa-minus"></i> คงที่
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon bg-primary">
                <i class="fas fa-percentage"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">3.85%</div>
                <div class="stat-label">อัตราคอมมิชชั่นเฉลี่ย</div>
                <div class="stat-change positive">
                    <i class="fas fa-arrow-up"></i> 0.2% จากเดือนที่แล้ว
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="filter-section">
        <form method="GET" action="{{ route('admin.reports.commission') }}" class="filter-form">
            <div class="filter-group">
                <label class="filter-label">ช่วงเวลา</label>
                <select name="period" class="form-control" onchange="this.form.submit()">
                    <option value="month" selected>เดือนนี้</option>
                    <option value="quarter">ไตรมาสนี้</option>
                    <option value="year">ปีนี้</option>
                    <option value="custom">กำหนดเอง</option>
                </select>
            </div>

            <div class="filter-group">
                <label class="filter-label">คลังสินค้า</label>
                <select name="warehouse" class="form-control">
                    <option value="">ทั้งหมด</option>
                    @foreach(\App\Models\Warehouse::active()->get() as $warehouse)
                        <option value="{{ $warehouse->code }}">{{ $warehouse->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="filter-group">
                <label class="filter-label">ประเภทรถ</label>
                <select name="vehicle_type" class="form-control">
                    <option value="">ทั้งหมด</option>
                    <option value="2wheel">รถ 2 ล้อ</option>
                    <option value="4wheel">รถ 4 ล้อ</option>
                </select>
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-filter"></i> กรองข้อมูล
            </button>
        </form>
    </div>

    <!-- Charts Section -->
    <div class="charts-grid">
        <!-- Monthly Commission Trend -->
        <div class="chart-card">
            <div class="chart-header">
                <h3 class="chart-title">แนวโน้มค่าคอมมิชชั่นรายเดือน</h3>
                <div class="chart-options">
                    <select class="chart-select" onchange="updateChart()">
                        <option value="6">6 เดือน</option>
                        <option value="12" selected>12 เดือน</option>
                        <option value="24">24 เดือน</option>
                    </select>
                </div>
            </div>
            <div class="chart-body">
                <canvas id="monthlyTrendChart"></canvas>
            </div>
        </div>

        <!-- Commission by Tier -->
        <div class="chart-card half">
            <div class="chart-header">
                <h3 class="chart-title">คอมมิชชั่นตามช่วงการจัดส่ง</h3>
            </div>
            <div class="chart-body">
                <canvas id="tierChart"></canvas>
            </div>
        </div>

        <!-- Top Earners -->
        <div class="chart-card half">
            <div class="chart-header">
                <h3 class="chart-title">พนักงานรายได้สูงสุด</h3>
            </div>
            <div class="chart-body">
                <canvas id="topEarnersChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Commission Breakdown Table -->
    <div class="table-section">
        <div class="section-header">
            <h3 class="section-title">
                <i class="fas fa-list-alt"></i>
                รายละเอียดค่าคอมมิชชั่นตามคลัง
            </h3>
            <span class="section-subtitle">เดือน {{ now()->format('F Y') }}</span>
        </div>
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th width="20%">คลังสินค้า</th>
                        <th width="15%" class="text-center">จำนวนพนักงาน</th>
                        <th width="15%" class="text-center">รถ 2 ล้อ</th>
                        <th width="15%" class="text-center">รถ 4 ล้อ</th>
                        <th width="15%" class="text-right">รวมพัสดุ</th>
                        <th width="20%" class="text-right">รวมคอมมิชชั่น</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $warehouses = \App\Models\Warehouse::withCount('users')->get();
                        $grandTotal = 0;
                    @endphp
                    @foreach($warehouses as $warehouse)
                    <tr>
                        <td>
                            <div class="warehouse-info">
                                <i class="fas fa-warehouse"></i>
                                {{ $warehouse->name }}
                            </div>
                        </td>
                        <td class="text-center">{{ $warehouse->users_count }}</td>
                        <td class="text-center">{{ rand(5, 15) }}</td>
                        <td class="text-center">{{ rand(3, 8) }}</td>
                        <td class="text-right">{{ number_format(rand(10000, 50000)) }}</td>
                        <td class="text-right">
                            @php $commission = rand(50000, 200000); $grandTotal += $commission; @endphp
                            <strong class="text-success">฿{{ number_format($commission, 2) }}</strong>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="table-summary">
                        <td colspan="5" class="text-right"><strong>รวมทั้งหมด</strong></td>
                        <td class="text-right">
                            <strong class="text-primary">฿{{ number_format($grandTotal, 2) }}</strong>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Commission Rate Analysis -->
    <div class="analysis-section">
        <div class="section-header">
            <h3 class="section-title">
                <i class="fas fa-chart-pie"></i>
                วิเคราะห์อัตราค่าคอมมิชชั่น
            </h3>
        </div>
        <div class="analysis-grid">
            <div class="analysis-card">
                <h4 class="analysis-title">อัตราต่ำสุด - สูงสุด</h4>
                <div class="rate-range">
                    <div class="rate-item">
                        <span class="rate-label">ต่ำสุด</span>
                        <span class="rate-value">฿2.50/ชิ้น</span>
                    </div>
                    <div class="rate-divider">-</div>
                    <div class="rate-item">
                        <span class="rate-label">สูงสุด</span>
                        <span class="rate-value">฿5.00/ชิ้น</span>
                    </div>
                </div>
            </div>

            <div class="analysis-card">
                <h4 class="analysis-title">อัตราที่ใช้มากที่สุด</h4>
                <div class="popular-rates">
                    <div class="popular-rate">
                        <span class="rate-tier">ขั้นที่ 2 (101-200 ชิ้น)</span>
                        <span class="rate-usage">45%</span>
                    </div>
                    <div class="popular-rate">
                        <span class="rate-tier">ขั้นที่ 3 (201-300 ชิ้น)</span>
                        <span class="rate-usage">30%</span>
                    </div>
                    <div class="popular-rate">
                        <span class="rate-tier">ขั้นที่ 1 (1-100 ชิ้น)</span>
                        <span class="rate-usage">25%</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
/* Inherit styles from delivery report */
@include('admin.reports.styles.common')

/* Additional styles for commission report */
.warehouse-info {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.warehouse-info i {
    color: var(--primary-orange);
}

.table-summary {
    background: var(--light-gray);
    font-size: 1.1rem;
}

.table-summary td {
    padding: 1rem 1.5rem;
}

/* Analysis Section */
.analysis-section {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-sm);
    overflow: hidden;
    margin-top: 2rem;
}

.analysis-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
    padding: 1.5rem;
}

.analysis-card {
    background: var(--light-gray);
    border-radius: var(--radius-md);
    padding: 1.5rem;
}

.analysis-title {
    font-size: 1rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin-bottom: 1rem;
}

.rate-range {
    display: flex;
    align-items: center;
    justify-content: space-around;
}

.rate-item {
    text-align: center;
}

.rate-label {
    display: block;
    font-size: 0.875rem;
    color: var(--gray);
    margin-bottom: 0.5rem;
}

.rate-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--primary-orange);
}

.rate-divider {
    font-size: 1.5rem;
    color: var(--gray);
}

.popular-rates {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.popular-rate {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem;
    background: var(--white);
    border-radius: var(--radius-sm);
}

.rate-tier {
    font-size: 0.9rem;
    color: var(--dark-gray);
}

.rate-usage {
    font-weight: 600;
    color: var(--primary-orange);
}

.chart-select {
    padding: 0.375rem 0.75rem;
    border: 1px solid var(--medium-gray);
    border-radius: var(--radius-sm);
    font-size: 0.875rem;
    color: var(--dark-gray);
    background: var(--white);
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .analysis-grid {
        grid-template-columns: 1fr;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Monthly Trend Chart
const monthlyCtx = document.getElementById('monthlyTrendChart').getContext('2d');
new Chart(monthlyCtx, {
    type: 'line',
    data: {
        labels: ['ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.', 'พ.ค.', 'มิ.ย.', 'ก.ค.', 'ส.ค.', 'ก.ย.', 'ต.ค.', 'พ.ย.', 'ธ.ค.'],
        datasets: [{
            label: 'ค่าคอมมิชชั่น',
            data: [850000, 920000, 780000, 950000, 1100000, 980000, 1050000, 1200000, 1150000, 1300000, 1250000, 1400000],
            borderColor: '#FF6B35',
            backgroundColor: 'rgba(255, 107, 53, 0.1)',
            tension: 0.3,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { display: false },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return 'คอมมิชชั่น: ฿' + context.parsed.y.toLocaleString();
                    }
                }
            }
        },
        scales: {
            y: {
                ticks: {
                    callback: function(value) {
                        return '฿' + (value / 1000) + 'k';
                    }
                }
            }
        }
    }
});

// Tier Chart
const tierCtx = document.getElementById('tierChart').getContext('2d');
new Chart(tierCtx, {
    type: 'bar',
    data: {
        labels: ['ขั้น 1', 'ขั้น 2', 'ขั้น 3', 'ขั้น 4', 'ขั้น 5+'],
        datasets: [{
            label: 'จำนวนครั้ง',
            data: [450, 820, 650, 320, 150],
            backgroundColor: '#FF6B35'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { display: false }
        }
    }
});

// Top Earners Chart
const earnersCtx = document.getElementById('topEarnersChart').getContext('2d');
new Chart(earnersCtx, {
    type: 'horizontalBar',
    data: {
        labels: ['พนักงาน A', 'พนักงาน B', 'พนักงาน C', 'พนักงาน D', 'พนักงาน E'],
        datasets: [{
            label: 'คอมมิชชั่น',
            data: [45000, 42000, 38000, 35000, 32000],
            backgroundColor: ['#FF6B35', '#FF8C61', '#FFA94D', '#FFD93D', '#FFE5A3']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { display: false }
        },
        scales: {
            x: {
                ticks: {
                    callback: function(value) {
                        return '฿' + (value / 1000) + 'k';
                    }
                }
            }
        }
    }
});

// Export function
function exportReport() {
    alert('ฟังก์ชันส่งออกรายงาน - กำลังพัฒนา');
}

// Update chart function
function updateChart() {
    // Update chart based on selected period
    console.log('Updating chart...');
}
</script>
@endpush
@endsection