<?php

namespace App\Http\Controllers;

use App\Models\WebNotification;
use Illuminate\Http\Request;

class TestNotificationController extends Controller
{
    public function test()
    {
        try {
            $userId = auth()->id();
            $count = WebNotification::forUser($userId)->unread()->count();
            return response()->json(['success' => true, 'count' => (int)$count, 'user_id' => (int)$userId]);
        } catch (\Exception $e) {
            return response()->json(['error' => htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8')], 500);
        }
    }
}