<?php

namespace App\Http\Controllers;

use App\Models\Vehicle;
use App\Services\VehicleNotificationService;
use Illuminate\Http\Request;

class VehicleNotificationController extends Controller
{
    public function __construct(
        private VehicleNotificationService $notificationService
    ) {}

    public function sendTestNotification(Request $request, Vehicle $vehicle)
    {
        $type = $request->input('type', 'login');
        
        switch ($type) {
            case 'login':
                $this->notificationService->sendLoginNotification($vehicle, $request->ip());
                break;
            case 'password':
                $this->notificationService->sendPasswordChangedNotification($vehicle);
                break;
            case 'profile':
                $this->notificationService->sendProfileUpdatedNotification($vehicle, ['test' => 'ทดสอบ']);
                break;
            case 'report':
                $this->notificationService->sendReportNotification($vehicle, 'รายงานรายวัน', [
                    'deliveries' => 5,
                    'distance' => 120,
                    'commission' => 1500
                ], 'วันที่ ' . now()->format('d/m/Y'));
                break;
        }

        return response()->json(['message' => 'ส่งการแจ้งเตือนเรียบร้อย']);
    }
}