<?php

namespace App\Http\Middleware;

use App\Models\Vehicle;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TrackVehicleLogin
{
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        if (Auth::check() && $request->user()->isVehicleUser()) {
            $userId = (int) $request->user()->id;
            $vehicle = Vehicle::where('user_id', $userId)->first();
            
            if ($vehicle && !session('login_tracked_' . $vehicle->id)) {
                $vehicle->recordLogin($request->ip());
                session(['login_tracked_' . $vehicle->id => true]);
            }
        }

        return $response;
    }
}