<?php

namespace App\Listeners;

use App\Events\VehicleLoggedIn;
use App\Notifications\VehicleLoginNotification;
use App\Notifications\VehiclePasswordChangedNotification;
use App\Notifications\VehicleProfileUpdatedNotification;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendVehicleNotifications implements ShouldQueue
{
    public function handle(VehicleLoggedIn $event): void
    {
        $vehicle = $event->vehicle;
        $user = $vehicle->user;
        
        if ($user && $user->email) {
            $user->notify(new VehicleLoginNotification(
                $vehicle,
                now(),
                $event->ipAddress
            ));
        }
    }
}