<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class VehicleReportNotification extends Notification
{
    use Queueable;

    public function __construct(
        public $vehicle,
        public $reportType,
        public $reportData,
        public $period
    ) {}

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('รายงานผล: ' . $this->reportType . ' - ' . $this->vehicle->license_plate)
            ->view('emails.vehicle.report', [
                'vehicle' => $this->vehicle,
                'user' => $notifiable,
                'reportType' => $this->reportType,
                'reportData' => $this->reportData,
                'period' => $this->period
            ]);
    }
}