<?php

namespace App\Observers;

use App\Models\User;
use App\Models\Vehicle;

class UserObserver
{
    public function updated(User $user): void
    {
        if ($user->isDirty('password') && $user->isVehicleUser()) {
            $vehicle = Vehicle::where('user_id', $user->id)->first();
            if ($vehicle) {
                $vehicle->recordPasswordChange();
            }
        }
        
        if ($user->isDirty(['first_name', 'last_name', 'email']) && $user->isVehicleUser()) {
            $vehicle = Vehicle::where('user_id', $user->id)->first();
            if ($vehicle) {
                $updatedFields = [];
                if ($user->isDirty('first_name')) $updatedFields['ชื่อ'] = $user->first_name;
                if ($user->isDirty('last_name')) $updatedFields['นามสกุล'] = $user->last_name;
                if ($user->isDirty('email')) $updatedFields['อีเมล'] = $user->email;
                
                $vehicle->recordProfileUpdate($updatedFields);
            }
        }
    }
}