<?php

namespace App\Services;

use App\Models\Vehicle;
use App\Services\WebNotificationService;
use App\Notifications\VehicleLoginNotification;
use App\Notifications\VehiclePasswordChangedNotification;
use App\Notifications\VehicleProfileUpdatedNotification;
use App\Notifications\VehicleReportNotification;

class VehicleNotificationService
{
    public function __construct(
        private WebNotificationService $webNotificationService
    ) {}

    public function sendLoginNotification(Vehicle $vehicle, $ipAddress = null)
    {
        $user = $vehicle->user;
        if ($user && $user->email) {
            $user->notify(new VehicleLoginNotification($vehicle, now(), $ipAddress));
        }
        
        // Web notification
        $this->webNotificationService->notifyVehicleLogin($vehicle, $ipAddress);
    }

    public function sendPasswordChangedNotification(Vehicle $vehicle)
    {
        $user = $vehicle->user;
        if ($user && $user->email) {
            $user->notify(new VehiclePasswordChangedNotification($vehicle, now()));
        }
        
        // Web notification
        $this->webNotificationService->notifyPasswordChanged($vehicle);
    }

    public function sendProfileUpdatedNotification(Vehicle $vehicle, array $updatedFields)
    {
        $user = $vehicle->user;
        if ($user && $user->email) {
            $user->notify(new VehicleProfileUpdatedNotification($vehicle, $updatedFields, now()));
        }
        
        // Web notification
        $this->webNotificationService->notifyProfileUpdated($vehicle, $updatedFields);
    }

    public function sendReportNotification(Vehicle $vehicle, string $reportType, array $reportData, string $period)
    {
        $user = $vehicle->user;
        if ($user && $user->email) {
            $user->notify(new VehicleReportNotification($vehicle, $reportType, $reportData, $period));
        }
    }
}