<?php

namespace App\Services;

use App\Models\WebNotification;
use App\Models\User;

class WebNotificationService
{
    public function create($userId, $title, $message, $type = 'info', $data = null)
    {
        return WebNotification::create([
            'user_id' => $userId,
            'title' => $title,
            'message' => $message,
            'type' => $type,
            'data' => $data,
            'expires_at' => now()->addDays(30)
        ]);
    }

    public function notifyVehicleLogin($vehicle, $ipAddress = null)
    {
        return $this->create(
            $vehicle->user_id,
            'เข้าสู่ระบบสำเร็จ',
            "เข้าสู่ระบบด้วยรถ {$vehicle->license_plate} เมื่อ " . now()->format('H:i:s'),
            'success',
            ['vehicle_id' => $vehicle->id, 'ip' => $ipAddress]
        );
    }

    public function notifyPasswordChanged($vehicle)
    {
        return $this->create(
            $vehicle->user_id,
            'เปลี่ยนรหัสผ่านแล้ว',
            "เปลี่ยนรหัสผ่านสำหรับรถ {$vehicle->license_plate} เรียบร้อย",
            'warning',
            ['vehicle_id' => $vehicle->id]
        );
    }

    public function notifyProfileUpdated($vehicle, $fields)
    {
        return $this->create(
            $vehicle->user_id,
            'อัปเดตข้อมูลแล้ว',
            "อัปเดตข้อมูลรถ {$vehicle->license_plate}: " . implode(', ', array_keys($fields)),
            'info',
            ['vehicle_id' => $vehicle->id, 'fields' => $fields]
        );
    }

    public function notifyDeliveryAdded($delivery)
    {
        return $this->create(
            $delivery->user_id,
            'เพิ่มรายการส่งแล้ว',
            "เพิ่มรายการส่งใหม่ ค่าคอมมิชชั่น " . number_format($delivery->commission_amount, 2) . " บาท",
            'success',
            ['delivery_id' => $delivery->id]
        );
    }

    public function getUnreadCount($userId)
    {
        return WebNotification::forUser($userId)->unread()->count();
    }

    public function getRecent($userId, $limit = 10)
    {
        return WebNotification::forUser($userId)
            ->orderBy('created_at', 'desc')
            ->limit($limit)
            ->get();
    }

    public function markAllAsRead($userId)
    {
        return WebNotification::forUser($userId)->unread()->update(['read_at' => now()]);
    }
}