// Mobile Menu Handler
(function() {
    'use strict';
    
    // Wait for DOM to be ready
    document.addEventListener('DOMContentLoaded', function() {
        initializeMobileMenu();
    });
    
    function initializeMobileMenu() {
        console.log('Initializing mobile menu...');
        
        // Get all menu buttons
        const menuButtons = [
            document.getElementById('menuButton'),
            document.getElementById('adminMenuButton'), 
            document.getElementById('headerMenuButton')
        ].filter(btn => btn !== null);
        
        console.log('Found menu buttons:', menuButtons.length);
        
        // Add event listeners to all menu buttons
        menuButtons.forEach(function(button, index) {
            if (button) {
                console.log('Adding listeners to button', index);
                
                // Remove existing onclick to prevent conflicts
                button.removeAttribute('onclick');
                
                // Add touch event (for mobile)
                button.addEventListener('touchend', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    console.log('Touch event triggered on button', index);
                    openSlideMenu();
                }, { passive: false });
                
                // Add click event (for desktop/fallback)
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    console.log('Click event triggered on button', index);
                    openSlideMenu();
                });
                
                // Add visual feedback
                button.addEventListener('touchstart', function() {
                    button.style.transform = 'scale(0.95)';
                }, { passive: true });
                
                button.addEventListener('touchend', function() {
                    setTimeout(() => {
                        button.style.transform = '';
                    }, 150);
                }, { passive: true });
            }
        });
        
        // Initialize slide menu close functionality
        initializeSlideMenuClose();
    }
    
    function initializeSlideMenuClose() {
        const closeButton = document.querySelector('.close-menu');
        const overlay = document.getElementById('overlay');
        
        if (closeButton) {
            closeButton.addEventListener('click', closeSlideMenu);
            closeButton.addEventListener('touchend', function(e) {
                e.preventDefault();
                closeSlideMenu();
            });
        }
        
        if (overlay) {
            overlay.addEventListener('click', closeSlideMenu);
            overlay.addEventListener('touchend', function(e) {
                e.preventDefault();
                closeSlideMenu();
            });
        }
    }
    
    // Make functions globally available
    window.openSlideMenu = function() {
        console.log('openSlideMenu called');
        
        const slideMenu = document.getElementById('slideMenu');
        const overlay = document.getElementById('overlay');
        
        if (!slideMenu) {
            console.error('Slide menu element not found!');
            return;
        }
        
        console.log('Opening slide menu...');
        
        slideMenu.classList.add('active');
        if (overlay) {
            overlay.classList.add('active');
        }
        
        document.body.style.overflow = 'hidden';
        
        // Haptic feedback
        if (navigator.vibrate) {
            navigator.vibrate(15);
        }
        
        console.log('Slide menu opened successfully');
    };
    
    window.closeSlideMenu = function() {
        console.log('closeSlideMenu called');
        
        const slideMenu = document.getElementById('slideMenu');
        const overlay = document.getElementById('overlay');
        
        if (slideMenu) {
            slideMenu.classList.remove('active');
        }
        if (overlay) {
            overlay.classList.remove('active');
        }
        
        document.body.style.overflow = '';
        
        console.log('Slide menu closed');
    };
    
})();