@extends('layouts.app')

@section('title', 'เพิ่มผู้ใช้ใหม่ - EazyCom Plus')
@section('page-title', 'เพิ่มผู้ใช้ใหม่')
@section('mobile-title', 'เพิ่มผู้ใช้ใหม่')

@section('content')
<div class="create-user-page">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-info">
                <div class="header-title">
                    <div class="title-icon">
                        <i class="fas fa-user-plus"></i>
                    </div>
                    <div class="title-text">
                        <h1>เพิ่มผู้ใช้ใหม่</h1>
                        <p>สร้างบัญชีผู้ใช้งานใหม่เข้าสู่ระบบ</p>
                    </div>
                </div>
                <div class="header-actions">
                    <a href="{{ route('admin.users.index') }}" class="action-btn secondary-btn">
                        <i class="fas fa-arrow-left"></i>
                        <span>กลับ</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Container -->
    <div class="form-container">
        <form method="POST" action="{{ route('admin.users.store') }}" id="createUserForm" class="user-form">
            @csrf
            
            <!-- Personal Information Card -->
            <div class="form-card">
                <div class="card-header">
                    <div class="card-title">
                        <i class="fas fa-user"></i>
                        <span>ข้อมูลส่วนตัว</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="first_name" class="form-label required">ชื่อ</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-user"></i>
                                </div>
                                <input type="text" id="first_name" name="first_name" 
                                       value="{{ old('first_name') }}" 
                                       class="form-input @error('first_name') error @enderror" 
                                       placeholder="กรอกชื่อ" required>
                            </div>
                            @error('first_name')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="last_name" class="form-label required">นามสกุล</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-user"></i>
                                </div>
                                <input type="text" id="last_name" name="last_name" 
                                       value="{{ old('last_name') }}" 
                                       class="form-input @error('last_name') error @enderror" 
                                       placeholder="กรอกนามสกุล" required>
                            </div>
                            @error('last_name')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group full-width">
                            <label for="email" class="form-label required">อีเมล</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <input type="email" id="email" name="email" 
                                       value="{{ old('email') }}" 
                                       class="form-input @error('email') error @enderror" 
                                       placeholder="example@email.com" required>
                            </div>
                            @error('email')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Security Information Card -->
            <div class="form-card">
                <div class="card-header">
                    <div class="card-title">
                        <i class="fas fa-shield-alt"></i>
                        <span>ข้อมูลรักษาความปลอดภัย</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="password" class="form-label required">รหัสผ่าน</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-lock"></i>
                                </div>
                                <input type="password" id="password" name="password" 
                                       class="form-input @error('password') error @enderror" 
                                       placeholder="อย่างน้อย 8 ตัวอักษร" required>
                                <button type="button" class="password-toggle" onclick="togglePassword('password')">
                                    <i class="fas fa-eye" id="password-icon"></i>
                                </button>
                            </div>
                            <div class="password-strength" id="password-strength"></div>
                            @error('password')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                            <div class="form-hint">รหัสผ่านต้องมีอย่างน้อย 8 ตัวอักษร</div>
                        </div>

                        <div class="form-group">
                            <label for="password_confirmation" class="form-label required">ยืนยันรหัสผ่าน</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-lock"></i>
                                </div>
                                <input type="password" id="password_confirmation" name="password_confirmation" 
                                       class="form-input" 
                                       placeholder="ยืนยันรหัสผ่าน" required>
                                <button type="button" class="password-toggle" onclick="togglePassword('password_confirmation')">
                                    <i class="fas fa-eye" id="password_confirmation-icon"></i>
                                </button>
                            </div>
                            <div class="password-match" id="password-match"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Role & Warehouse Card -->
            <div class="form-card">
                <div class="card-header">
                    <div class="card-title">
                        <i class="fas fa-user-tag"></i>
                        <span>บทบาทและคลังสินค้า</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="role" class="form-label required">บทบาท</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-user-tag"></i>
                                </div>
                                <select id="role" name="role" class="form-select @error('role') error @enderror" required>
                                    <option value="">เลือกบทบาท</option>
                                    <option value="admin" {{ old('role') === 'admin' ? 'selected' : '' }}>
                                        👑 ผู้ดูแลระบบ
                                    </option>
                                    <option value="2wheel" {{ old('role') === '2wheel' ? 'selected' : '' }}>
                                        🏍️ รถ 2 ล้อ
                                    </option>
                                    <option value="4wheel" {{ old('role') === '4wheel' ? 'selected' : '' }}>
                                        🚚 รถ 4 ล้อ
                                    </option>
                                </select>
                            </div>
                            @error('role')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group" id="warehouse-group" style="display: none;">
                            <label for="warehouse_code" class="form-label required">คลังสินค้า</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-warehouse"></i>
                                </div>
                                <select id="warehouse_code" name="warehouse_code" class="form-select @error('warehouse_code') error @enderror">
                                    <option value="">เลือกคลังสินค้า</option>
                                    @foreach($warehouses ?? [] as $warehouse)
                                        <option value="{{ $warehouse->code }}" {{ old('warehouse_code') === $warehouse->code ? 'selected' : '' }}>
                                            {{ $warehouse->code }} - {{ $warehouse->name }}
                                            @if($warehouse->location)
                                                ({{ $warehouse->location }})
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            @error('warehouse_code')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                            <div class="form-hint">จำเป็นสำหรับผู้ใช้ประเภทรถ</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Status Card -->
            <div class="form-card">
                <div class="card-header">
                    <div class="card-title">
                        <i class="fas fa-toggle-on"></i>
                        <span>สถานะการใช้งาน</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="status-options">
                        <label class="status-option active">
                            <input type="radio" name="is_active" value="1" 
                                   {{ old('is_active', '1') === '1' ? 'checked' : '' }}>
                            <div class="option-content">
                                <div class="option-icon active">
                                    <i class="fas fa-user-check"></i>
                                </div>
                                <div class="option-text">
                                    <div class="option-title">ใช้งานอยู่</div>
                                    <div class="option-desc">ผู้ใช้สามารถเข้าสู่ระบบได้</div>
                                </div>
                            </div>
                        </label>
                        
                        <label class="status-option">
                            <input type="radio" name="is_active" value="0" 
                                   {{ old('is_active') === '0' ? 'checked' : '' }}>
                            <div class="option-content">
                                <div class="option-icon inactive">
                                    <i class="fas fa-user-slash"></i>
                                </div>
                                <div class="option-text">
                                    <div class="option-title">ปิดใช้งาน</div>
                                    <div class="option-desc">ผู้ใช้ไม่สามารถเข้าสู่ระบบได้</div>
                                </div>
                            </div>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="form-actions">
                <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>ยกเลิก</span>
                </a>
                <button type="submit" class="btn btn-primary" id="submit-btn">
                    <i class="fas fa-save"></i>
                    <span>บันทึกข้อมูล</span>
                    <div class="btn-loader" style="display: none;">
                        <i class="fas fa-spinner fa-spin"></i>
                    </div>
                </button>
            </div>
        </form>
    </div>
</div>

<style>
/* Create User Page Styles */
.create-user-page {
    min-height: 100vh;
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
}

/* Page Header */
.page-header {
    background: white;
    border-bottom: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    margin-bottom: 2rem;
}

.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem;
}

.header-info {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 2rem;
}

.header-title {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.title-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 24px;
    box-shadow: 0 4px 12px rgba(255, 107, 53, 0.3);
}

.title-text h1 {
    font-size: 2rem;
    font-weight: 600;
    color: #1e293b;
    margin: 0;
}

.title-text p {
    color: #64748b;
    margin: 0.5rem 0 0;
    font-size: 1rem;
}

.header-actions {
    display: flex;
    gap: 1rem;
}

.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
}

.secondary-btn {
    background: #f1f5f9;
    color: #475569;
    border: 1px solid #e2e8f0;
}

.secondary-btn:hover {
    background: #e2e8f0;
    transform: translateY(-1px);
}

/* Form Container */
.form-container {
    max-width: 800px;
    margin: 0 auto;
    padding: 0 2rem 2rem;
}

.user-form {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

/* Form Cards */
.form-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    border: 1px solid #e2e8f0;
    overflow: hidden;
    transition: all 0.3s ease;
}

.form-card:hover {
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.card-header {
    background: linear-gradient(135deg, rgba(255, 107, 53, 0.05) 0%, rgba(255, 140, 97, 0.05) 100%);
    padding: 1.5rem 2rem;
    border-bottom: 1px solid #e2e8f0;
}

.card-title {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    font-size: 1.125rem;
    font-weight: 600;
    color: #1e293b;
}

.card-title i {
    color: #FF6B35;
    font-size: 1.25rem;
}

.card-body {
    padding: 2rem;
}

/* Form Grid */
.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1.5rem;
}

.form-group.full-width {
    grid-column: 1 / -1;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-label {
    font-weight: 500;
    color: #374151;
    font-size: 0.95rem;
}

.form-label.required::after {
    content: '*';
    color: #ef4444;
    margin-left: 0.25rem;
}

/* Input Wrapper */
.input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.input-icon {
    position: absolute;
    left: 1rem;
    color: #9ca3af;
    font-size: 0.9rem;
    z-index: 10;
}

.form-input,
.form-select {
    width: 100%;
    padding: 0.875rem 1rem 0.875rem 2.75rem;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    font-size: 0.95rem;
    transition: all 0.3s ease;
    background: white;
    font-family: inherit;
}

.form-input:focus,
.form-select:focus {
    outline: none;
    border-color: #FF6B35;
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.form-input.error,
.form-select.error {
    border-color: #ef4444;
    box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
}

/* Password Toggle */
.password-toggle {
    position: absolute;
    right: 1rem;
    background: none;
    border: none;
    color: #9ca3af;
    cursor: pointer;
    font-size: 0.9rem;
    z-index: 10;
    transition: color 0.3s ease;
}

.password-toggle:hover {
    color: #FF6B35;
}

/* Password Strength */
.password-strength {
    height: 4px;
    border-radius: 2px;
    margin-top: 0.5rem;
    transition: all 0.3s ease;
}

.password-strength.weak {
    background: #ef4444;
    width: 33%;
}

.password-strength.medium {
    background: #f59e0b;
    width: 66%;
}

.password-strength.strong {
    background: #22c55e;
    width: 100%;
}

/* Password Match */
.password-match {
    margin-top: 0.5rem;
    font-size: 0.85rem;
    font-weight: 500;
}

.password-match.match {
    color: #22c55e;
}

.password-match.no-match {
    color: #ef4444;
}

/* Status Options */
.status-options {
    display: flex;
    gap: 1rem;
}

.status-option {
    flex: 1;
    cursor: pointer;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    padding: 1.5rem;
    transition: all 0.3s ease;
    background: white;
}

.status-option:hover {
    border-color: #FF6B35;
    background: rgba(255, 107, 53, 0.02);
}

.status-option input[type="radio"] {
    display: none;
}

.status-option input[type="radio"]:checked + .option-content {
    color: #FF6B35;
}

.status-option input[type="radio"]:checked {
    & ~ * {
        border-color: #FF6B35;
    }
}

.status-option.active {
    border-color: #FF6B35;
    background: rgba(255, 107, 53, 0.05);
}

.option-content {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.option-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    color: white;
}

.option-icon.active {
    background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
}

.option-icon.inactive {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
}

.option-text {
    flex: 1;
}

.option-title {
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 0.25rem;
}

.option-desc {
    font-size: 0.85rem;
    color: #64748b;
}

/* Error Messages */
.error-message {
    color: #ef4444;
    font-size: 0.85rem;
    margin-top: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.error-message::before {
    content: '⚠️';
    font-size: 0.8rem;
}

/* Form Hints */
.form-hint {
    color: #64748b;
    font-size: 0.85rem;
    margin-top: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.form-hint::before {
    content: 'ℹ️';
    font-size: 0.8rem;
}

/* Form Actions */
.form-actions {
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
    padding: 2rem;
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    border: 1px solid #e2e8f0;
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 0.875rem 2rem;
    border: none;
    border-radius: 12px;
    font-family: inherit;
    font-weight: 500;
    font-size: 0.95rem;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    position: relative;
    overflow: hidden;
}

.btn-primary {
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(255, 107, 53, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.4);
}

.btn-primary:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.btn-secondary {
    background: #f1f5f9;
    color: #475569;
    border: 1px solid #e2e8f0;
}

.btn-secondary:hover {
    background: #e2e8f0;
    transform: translateY(-1px);
}

.btn-loader {
    position: absolute;
    inset: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    background: inherit;
}

/* Responsive Design */
@media (max-width: 768px) {
    .header-content {
        padding: 1.5rem 1rem;
    }
    
    .header-info {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .form-container {
        padding: 0 1rem 2rem;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .status-options {
        flex-direction: column;
    }
    
    .form-actions {
        flex-direction: column-reverse;
        padding: 1.5rem;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
    
    .title-text h1 {
        font-size: 1.5rem;
    }
}

/* Animation */
@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.form-card {
    animation: fadeIn 0.5s ease-out;
}

.form-card:nth-child(1) { animation-delay: 0.1s; }
.form-card:nth-child(2) { animation-delay: 0.2s; }
.form-card:nth-child(3) { animation-delay: 0.3s; }
.form-card:nth-child(4) { animation-delay: 0.4s; }
</style>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('createUserForm');
    const roleSelect = document.getElementById('role');
    const warehouseGroup = document.getElementById('warehouse-group');
    const warehouseSelect = document.getElementById('warehouse_code');
    const passwordField = document.getElementById('password');
    const confirmPasswordField = document.getElementById('password_confirmation');
    const submitBtn = document.getElementById('submit-btn');

    // Role-based warehouse visibility
    function toggleWarehouseVisibility() {
        const role = roleSelect.value;
        
        if (role === '2wheel' || role === '4wheel') {
            warehouseGroup.style.display = 'block';
            warehouseSelect.required = true;
            
            // Add animation
            warehouseGroup.style.opacity = '0';
            warehouseGroup.style.transform = 'translateY(-10px)';
            
            setTimeout(() => {
                warehouseGroup.style.transition = 'all 0.3s ease';
                warehouseGroup.style.opacity = '1';
                warehouseGroup.style.transform = 'translateY(0)';
            }, 50);
        } else {
            warehouseGroup.style.display = 'none';
            warehouseSelect.required = false;
            warehouseSelect.value = '';
        }
    }

    roleSelect.addEventListener('change', toggleWarehouseVisibility);
    
    // Initialize on page load
    if (roleSelect.value) {
        toggleWarehouseVisibility();
    }

    // Password strength indicator
    function checkPasswordStrength(password) {
        const strengthIndicator = document.getElementById('password-strength');
        let strength = 0;
        
        if (password.length >= 8) strength++;
        if (/[a-z]/.test(password)) strength++;
        if (/[A-Z]/.test(password)) strength++;
        if (/[0-9]/.test(password)) strength++;
        if (/[^A-Za-z0-9]/.test(password)) strength++;
        
        strengthIndicator.className = 'password-strength';
        
        if (strength < 2) {
            strengthIndicator.classList.add('weak');
        } else if (strength < 4) {
            strengthIndicator.classList.add('medium');
        } else {
            strengthIndicator.classList.add('strong');
        }
    }

    passwordField.addEventListener('input', function() {
        checkPasswordStrength(this.value);
        checkPasswordMatch();
    });

    // Password match indicator
    function checkPasswordMatch() {
        const matchIndicator = document.getElementById('password-match');
        const password = passwordField.value;
        const confirmPassword = confirmPasswordField.value;
        
        if (confirmPassword === '') {
            matchIndicator.textContent = '';
            matchIndicator.className = 'password-match';
            return;
        }
        
        if (password === confirmPassword) {
            matchIndicator.textContent = '✓ รหัสผ่านตรงกัน';
            matchIndicator.className = 'password-match match';
            confirmPasswordField.classList.remove('error');
        } else {
            matchIndicator.textContent = '✗ รหัสผ่านไม่ตรงกัน';
            matchIndicator.className = 'password-match no-match';
            confirmPasswordField.classList.add('error');
        }
    }

    confirmPasswordField.addEventListener('input', checkPasswordMatch);

    // Form submission with loading state
    form.addEventListener('submit', function(e) {
        const password = passwordField.value;
        const confirmPassword = confirmPasswordField.value;
        
        // Validation
        if (password !== confirmPassword) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'ข้อผิดพลาด',
                text: 'รหัสผ่านและการยืนยันรหัสผ่านไม่ตรงกัน',
                confirmButtonColor: '#FF6B35'
            });
            return false;
        }
        
        if (password.length < 8) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'ข้อผิดพลาด',
                text: 'รหัสผ่านต้องมีอย่างน้อย 8 ตัวอักษร',
                confirmButtonColor: '#FF6B35'
            });
            return false;
        }

        // Show loading state
        submitBtn.disabled = true;
        submitBtn.querySelector('span').style.display = 'none';
        submitBtn.querySelector('.btn-loader').style.display = 'flex';
        
        // Re-enable after 10 seconds as fallback
        setTimeout(() => {
            submitBtn.disabled = false;
            submitBtn.querySelector('span').style.display = 'inline';
            submitBtn.querySelector('.btn-loader').style.display = 'none';
        }, 10000);
    });

    // Status option styling
    document.querySelectorAll('.status-option input[type="radio"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.status-option').forEach(option => {
                option.classList.remove('active');
            });
            
            if (this.checked) {
                this.closest('.status-option').classList.add('active');
            }
        });
    });

    // Initialize active status option
    const checkedRadio = document.querySelector('.status-option input[type="radio"]:checked');
    if (checkedRadio) {
        checkedRadio.closest('.status-option').classList.add('active');
    }
});

// Toggle password visibility
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = document.getElementById(fieldId + '-icon');
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// Show success message if redirected back with success
@if(session('success'))
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: '{{ session('success') }}',
        confirmButtonColor: '#FF6B35'
    });
@endif

// Show error messages
@if($errors->any())
    Swal.fire({
        icon: 'error',
        title: 'มีข้อผิดพลาด',
        html: '@foreach($errors->all() as $error){{ $error }}<br>@endforeach',
        confirmButtonColor: '#FF6B35'
    });
@endif
</script>
@endsection