@extends('layouts.app')

@section('title', 'แดชบอร์ด - EazyCom Plus')
@section('page-title', 'แดชบอร์ด')
@section('mobile-title', 'แดชบอร์ด')

@push('styles')
<style>
/* Enhanced Responsive Dashboard Styles */
.dashboard-container {
    padding: clamp(1rem, 4vw, 2rem);
    max-width: 1400px;
    margin: 0 auto;
}

.stats-grid {
    display: grid;
    gap: clamp(1rem, 3vw, 1.5rem);
    grid-template-columns: 1fr;
    margin-bottom: clamp(2rem, 5vw, 3rem);
}

@media (min-width: 640px) {
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (min-width: 1024px) {
    .stats-grid {
        grid-template-columns: repeat(4, 1fr);
    }
}

.stat-card {
    background: linear-gradient(135deg, #fff 0%, #f8fafc 100%);
    border-radius: clamp(12px, 3vw, 20px);
    padding: clamp(1.25rem, 4vw, 2rem);
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    border: 1px solid rgba(255, 107, 53, 0.1);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: var(--gradient);
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 30px rgba(255, 107, 53, 0.15);
}

.stat-icon {
    width: clamp(48px, 8vw, 64px);
    height: clamp(48px, 8vw, 64px);
    border-radius: clamp(12px, 3vw, 16px);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: clamp(1rem, 3vw, 1.5rem);
    font-size: clamp(20px, 4vw, 28px);
    color: white;
}

.stat-value {
    font-size: clamp(1.75rem, 5vw, 2.5rem);
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 0.5rem;
    line-height: 1.1;
}

.stat-label {
    font-size: clamp(0.875rem, 2.5vw, 1rem);
    color: var(--gray-600);
    font-weight: 500;
}

.stat-change {
    font-size: clamp(0.75rem, 2vw, 0.875rem);
    font-weight: 600;
    margin-top: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.stat-change.positive {
    color: #10b981;
}

.stat-change.negative {
    color: #ef4444;
}

.content-grid {
    display: grid;
    gap: clamp(1.5rem, 4vw, 2rem);
    grid-template-columns: 1fr;
}

@media (min-width: 1024px) {
    .content-grid {
        grid-template-columns: 2fr 1fr;
    }
}

.chart-card, .activity-card {
    background: white;
    border-radius: clamp(16px, 4vw, 24px);
    padding: clamp(1.5rem, 4vw, 2rem);
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    border: 1px solid rgba(255, 107, 53, 0.05);
}

.card-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: clamp(1rem, 3vw, 1.5rem);
    flex-wrap: wrap;
    gap: 1rem;
}

.card-title {
    font-size: clamp(1.125rem, 3vw, 1.5rem);
    font-weight: 600;
    color: var(--gray-900);
}

.card-action {
    padding: clamp(0.5rem, 2vw, 0.75rem) clamp(1rem, 3vw, 1.25rem);
    background: var(--gradient-soft);
    color: var(--primary);
    border: none;
    border-radius: clamp(8px, 2vw, 12px);
    font-size: clamp(0.875rem, 2vw, 1rem);
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
}

.card-action:hover {
    background: var(--gradient);
    color: white;
    transform: translateY(-1px);
}

.activity-item {
    display: flex;
    align-items: center;
    gap: clamp(0.75rem, 2vw, 1rem);
    padding: clamp(0.75rem, 2vw, 1rem);
    border-radius: clamp(8px, 2vw, 12px);
    transition: background 0.2s ease;
}

.activity-item:hover {
    background: rgba(255, 107, 53, 0.05);
}

.activity-icon {
    width: clamp(36px, 6vw, 48px);
    height: clamp(36px, 6vw, 48px);
    border-radius: clamp(8px, 2vw, 12px);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: clamp(14px, 3vw, 18px);
    color: white;
    flex-shrink: 0;
}

.activity-content {
    flex: 1;
    min-width: 0;
}

.activity-title {
    font-size: clamp(0.875rem, 2.5vw, 1rem);
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 0.25rem;
}

.activity-desc {
    font-size: clamp(0.75rem, 2vw, 0.875rem);
    color: var(--gray-600);
}

.activity-time {
    font-size: clamp(0.75rem, 2vw, 0.875rem);
    color: var(--gray-500);
    flex-shrink: 0;
}

/* Quick Actions Grid */
.quick-actions {
    display: grid;
    gap: clamp(0.75rem, 2vw, 1rem);
    grid-template-columns: 1fr;
    margin-bottom: clamp(2rem, 5vw, 3rem);
}

@media (min-width: 640px) {
    .quick-actions {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (min-width: 1024px) {
    .quick-actions {
        grid-template-columns: repeat(4, 1fr);
    }
}

.quick-action {
    display: flex;
    align-items: center;
    gap: clamp(0.75rem, 2vw, 1rem);
    padding: clamp(1rem, 3vw, 1.5rem);
    background: white;
    border-radius: clamp(12px, 3vw, 16px);
    text-decoration: none;
    color: var(--gray-900);
    box-shadow: 0 2px 12px rgba(0, 0, 0, 0.08);
    border: 1px solid rgba(255, 107, 53, 0.1);
    transition: all 0.3s ease;
    min-height: clamp(60px, 10vw, 80px);
}

.quick-action:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.15);
    border-color: var(--primary);
}

.quick-action-icon {
    width: clamp(40px, 7vw, 56px);
    height: clamp(40px, 7vw, 56px);
    border-radius: clamp(10px, 2.5vw, 14px);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: clamp(18px, 4vw, 24px);
    color: white;
    flex-shrink: 0;
}

.quick-action-content {
    flex: 1;
    min-width: 0;
}

.quick-action-title {
    font-size: clamp(0.875rem, 2.5vw, 1rem);
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.quick-action-desc {
    font-size: clamp(0.75rem, 2vw, 0.875rem);
    color: var(--gray-600);
}

/* Responsive Chart Container */
.chart-container {
    position: relative;
    height: clamp(200px, 40vw, 400px);
    width: 100%;
}

/* Mobile Optimizations */
@media (max-width: 768px) {
    .dashboard-container {
        padding: 1rem;
    }
    
    .card-header {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .activity-item {
        flex-direction: column;
        text-align: center;
        gap: 0.5rem;
    }
    
    .activity-time {
        align-self: flex-end;
    }
}
</style>
@endpush

@section('content')
<div class="dashboard-container">
    <!-- Quick Actions -->
    <div class="quick-actions">
        <a href="{{ route('vehicle.deliveries.create') }}" class="quick-action">
            <div class="quick-action-icon" style="background: linear-gradient(135deg, #10B981 0%, #047857 100%);">
                <i class="fas fa-plus"></i>
            </div>
            <div class="quick-action-content">
                <div class="quick-action-title">บันทึกการจัดส่ง</div>
                <div class="quick-action-desc">เพิ่มรายการใหม่</div>
            </div>
        </a>
        
        <a href="{{ route('vehicle.calculator') }}" class="quick-action">
            <div class="quick-action-icon" style="background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);">
                <i class="fas fa-calculator"></i>
            </div>
            <div class="quick-action-content">
                <div class="quick-action-title">คำนวณคอมมิชชั่น</div>
                <div class="quick-action-desc">คำนวณรายได้</div>
            </div>
        </a>
        
        <a href="{{ route('finance.dashboard') }}" class="quick-action">
            <div class="quick-action-icon" style="background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);">
                <i class="fas fa-wallet"></i>
            </div>
            <div class="quick-action-content">
                <div class="quick-action-title">การเงิน</div>
                <div class="quick-action-desc">จัดการรายรับ-รายจ่าย</div>
            </div>
        </a>
        
        <a href="{{ route('vehicle.deliveries.index') }}" class="quick-action">
            <div class="quick-action-icon" style="background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);">
                <i class="fas fa-history"></i>
            </div>
            <div class="quick-action-content">
                <div class="quick-action-title">ประวัติ</div>
                <div class="quick-action-desc">ดูรายการที่ผ่านมา</div>
            </div>
        </a>
    </div>

    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #10B981 0%, #047857 100%);">
                <i class="fas fa-truck"></i>
            </div>
            <div class="stat-value">{{ $totalDeliveries ?? '0' }}</div>
            <div class="stat-label">การจัดส่งทั้งหมด</div>
            <div class="stat-change positive">
                <i class="fas fa-arrow-up"></i>
                +12% จากเดือนที่แล้ว
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);">
                <i class="fas fa-coins"></i>
            </div>
            <div class="stat-value">฿{{ number_format($totalCommission ?? 0) }}</div>
            <div class="stat-label">คอมมิชชั่นรวม</div>
            <div class="stat-change positive">
                <i class="fas fa-arrow-up"></i>
                +8% จากเดือนที่แล้ว
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-value">{{ $pendingDeliveries ?? '0' }}</div>
            <div class="stat-label">รอดำเนินการ</div>
            <div class="stat-change negative">
                <i class="fas fa-arrow-down"></i>
                -5% จากเดือนที่แล้ว
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="stat-value">{{ $monthlyGrowth ?? '0' }}%</div>
            <div class="stat-label">การเติบโต</div>
            <div class="stat-change positive">
                <i class="fas fa-arrow-up"></i>
                เพิ่มขึ้นต่อเนื่อง
            </div>
        </div>
    </div>

    <!-- Content Grid -->
    <div class="content-grid">
        <!-- Chart Card -->
        <div class="chart-card">
            <div class="card-header">
                <h3 class="card-title">ภาพรวมรายได้</h3>
                <button class="card-action">
                    <i class="fas fa-expand-alt"></i>
                    ดูรายละเอียด
                </button>
            </div>
            <div class="chart-container">
                <canvas id="revenueChart"></canvas>
            </div>
        </div>

        <!-- Activity Card -->
        <div class="activity-card">
            <div class="card-header">
                <h3 class="card-title">กิจกรรมล่าสุด</h3>
                <button class="card-action">
                    <i class="fas fa-history"></i>
                    ดูทั้งหมด
                </button>
            </div>
            <div class="activity-list">
                <div class="activity-item">
                    <div class="activity-icon" style="background: linear-gradient(135deg, #10B981 0%, #047857 100%);">
                        <i class="fas fa-check"></i>
                    </div>
                    <div class="activity-content">
                        <div class="activity-title">การจัดส่งสำเร็จ</div>
                        <div class="activity-desc">จัดส่ง 150 ชิ้น ไปยังคลัง A</div>
                    </div>
                    <div class="activity-time">2 นาทีที่แล้ว</div>
                </div>
                
                <div class="activity-item">
                    <div class="activity-icon" style="background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);">
                        <i class="fas fa-coins"></i>
                    </div>
                    <div class="activity-content">
                        <div class="activity-title">ได้รับคอมมิชชั่น</div>
                        <div class="activity-desc">฿2,250 จากการจัดส่งเมื่อวาน</div>
                    </div>
                    <div class="activity-time">1 ชั่วโมงที่แล้ว</div>
                </div>
                
                <div class="activity-item">
                    <div class="activity-icon" style="background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);">
                        <i class="fas fa-truck"></i>
                    </div>
                    <div class="activity-content">
                        <div class="activity-title">เริ่มการจัดส่ง</div>
                        <div class="activity-desc">รับงาน 200 ชิ้น ไปยังคลัง B</div>
                    </div>
                    <div class="activity-time">3 ชั่วโมงที่แล้ว</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Responsive Chart
const ctx = document.getElementById('revenueChart');
if (ctx) {
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.', 'พ.ค.', 'มิ.ย.'],
            datasets: [{
                label: 'รายได้ (บาท)',
                data: [12000, 19000, 15000, 25000, 22000, 30000],
                borderColor: '#FF6B35',
                backgroundColor: 'rgba(255, 107, 53, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });
}
</script>
@endpush