<!DOCTYPE html>
<html lang="{{ str_replace('_','-', app()->getLocale()) }}" dir="{{ \App\Helpers\LocaleHelper::getDirection() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    <title>@yield('title', __('app.name'))</title>

    <!-- Fonts & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="https://cdn.niendsitekungz.com/img/eazy-favicon.png">

    <!-- PWA Meta -->
    <meta name="theme-color" content="#FF6B35">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="{{ __('app.pwa_name') }}">

    <!-- Social -->
    <meta name="description" content="{{ __('app.description') }}">
    <meta property="og:title" content="@yield('title', config('app.name'))">
    <meta property="og:description" content="{{ __('app.description') }}">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://cdn.niendsitekungz.com/img/eazy-com-plus.png">
    <meta property="og:url" content="{{ url()->current() }}">

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11" defer></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    
    <!-- Notification Sounds -->
    <script src="{{ asset('sounds/notification.js') }}" defer></script>
    
    <!-- Responsive Utilities -->
    <script src="{{ asset('js/responsive-utils.js') }}" defer></script>

    <style>
        /* --------------------
           Design Tokens
        -------------------- */
        :root {
            /* Primary brand (orange) */
            --primary: #FF6B35;
            --primary-dark: #E85D2F;
            --primary-light: #FF8C61;
            --gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
            --gradient-soft: linear-gradient(135deg, #FFE5DB 0%, #FFD4C4 100%);

            /* Aliases for older code (orange theme) */
            --primary-orange: var(--primary);
            --orange-gradient: var(--gradient);
            --orange-gradient-soft: var(--gradient-soft);
            --orange-shadow: 0 8px 24px rgba(255, 107, 53, 0.25);

            /* Layout */
            --sidebar-width: 280px;
            --header-height: 70px;
            --nav-height: 70px;
            --safe-top: env(safe-area-inset-top, 0);
            --safe-bottom: env(safe-area-inset-bottom, 0);

            /* Palette */
            --white: #FFFFFF;
            --gray-50: #F8FAFC;
            --gray-100: #F1F5F9;
            --gray-200: #E2E8F0;
            --gray-400: #94A3B8;
            --gray-500: #64748B;
            --gray-700: #334155;
            --gray-900: #1E293B;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; -webkit-tap-highlight-color: transparent; }
        html, body { height: 100%; }
        body { font-family: 'Kanit', sans-serif; background: var(--gray-50); color: var(--gray-900); }

        /* --------------------
           Desktop Layout
        -------------------- */
        @media (min-width: 769px) {
            body { padding-left: var(--sidebar-width); background: var(--gray-100); }

            .desktop-sidebar {
                position: fixed; inset: 0 auto 0 0; width: var(--sidebar-width);
                background: var(--white); border-right: 1px solid var(--gray-200);
                box-shadow: 2px 0 10px rgba(0,0,0,.05); z-index: 1000; overflow-y: auto;
            }
            .sidebar-header { padding: 30px 25px; background: var(--gradient); color: var(--white); }
            .sidebar-logo { display:flex; align-items:center; gap:12px; font-size:1.5rem; font-weight:600; }
            .sidebar-nav { padding: 20px 0 24px; }
            .nav-section-title { padding: 10px 25px; font-size:12px; font-weight:600; color: var(--gray-400); text-transform:uppercase; letter-spacing:.5px; }
            .nav-link { display:flex; align-items:center; gap:15px; padding:12px 25px; color: var(--gray-500); text-decoration:none; position:relative; transition:.2s; }
            .nav-link:hover { background: rgba(255,107,53,.05); color: var(--primary); }
            .nav-link.active { background: linear-gradient(90deg, rgba(255,107,53,.1) 0%, rgba(255,140,97,.05) 100%); color: var(--primary); font-weight:600; }
            .nav-link.active::before { content:''; position:absolute; left:0; top:0; bottom:0; width:4px; background: var(--primary); border-radius:0 2px 2px 0; }

            .desktop-header {
                position: fixed; left: var(--sidebar-width); right: 0; top: 0; height: var(--header-height);
                background: rgba(255,255,255,.95); backdrop-filter: blur(10px); border-bottom: 1px solid var(--gray-200);
                display:flex; align-items:center; justify-content:space-between; padding: 0 30px; z-index: 999;
            }
            .header-title { font-size:24px; font-weight:600; color: var(--gray-900); }
            .header-actions { display:flex; gap:15px; align-items:center; }

            .main-content { margin-top: var(--header-height); padding: 30px; min-height: calc(100vh - var(--header-height)); }

            /* Hide mobile elements */
            .mobile-header, .mobile-nav, .fab-container, .slide-menu, .overlay { display:none !important; }
        }

        /* --------------------
           Mobile Layout
        -------------------- */
        @media (max-width: 768px) {
            body { padding-left: 0; padding-bottom: calc(var(--nav-height) + var(--safe-bottom)); background: linear-gradient(180deg, #FFF5F1 0%, #FFFFFF 100%); }
            
            /* Hide desktop elements on mobile */
            .desktop-sidebar,
            .desktop-header {
                display: none !important;
            }
            
            .main-content {
                margin-top: 60px;
                padding: 20px 16px;
            }

            .mobile-header { position: fixed; top: 0; left: 0; right: 0; height: 60px; padding: 0 16px; z-index: 1001;
                background: rgba(255,255,255,.95); backdrop-filter: blur(15px); border-bottom: 1px solid rgba(255,107,53,.08);
                display:flex; align-items:center; justify-content:space-between; }
            .mobile-header-left { display:flex; align-items:center; gap:12px; }
            .mobile-logo { width:36px; height:36px; border-radius:12px; background: var(--gradient); color:#fff; display:flex; align-items:center; justify-content:center; font-size:18px; }
            .mobile-title { font-size:18px; font-weight:600; color: var(--primary); }
            .mobile-header-right { display:flex; gap:10px; }

            .mobile-main { margin-top: 60px; padding: 20px 16px; animation: fadeIn .5s ease; }

            .mobile-nav { position: fixed; left:0; right:0; bottom:0; height: calc(var(--nav-height) + var(--safe-bottom)); z-index: 1001;
                background: rgba(255,255,255,.98); border-top: 1px solid rgba(255,107,53,.08); backdrop-filter: blur(20px);
                padding-bottom: var(--safe-bottom);
            }
            .nav-container { height: var(--nav-height); display:flex; justify-content:space-around; align-items:center; padding: 0 12px; }
            .nav-item { flex:1; display:flex; flex-direction:column; align-items:center; justify-content:center; padding:8px; border:none; background:transparent; cursor:pointer; position:relative; transition:.3s; }
            .nav-item i { font-size:22px; color: #94A3B8; margin-bottom:4px; transition:.3s; }
            .nav-item span { font-size:11px; color:#94A3B8; font-weight:500; transition:.3s; }
            .nav-item.active i, .nav-item.active span { color: var(--primary); }
            .nav-item.active::before { content:''; position:absolute; top:-2px; width:40px; height:3px; background: var(--gradient); border-radius:0 0 3px 3px; }
            .nav-item:active { transform: scale(.92); }
        }

        /* --------------------
           Shared UI
        -------------------- */
        .header-btn, .mobile-header-btn { width:40px; height:40px; border-radius:12px; border:none; background: var(--gradient-soft); display:flex; align-items:center; justify-content:center; cursor:pointer; transition:.3s; position:relative; }
        #headerMenuButton { display: none; }
        .header-btn i, .mobile-header-btn i { color: var(--primary); font-size:16px; }
        .header-btn:hover { background: var(--gradient); transform: translateY(-1px); }
        .header-btn:hover i { color: #fff; }
        .header-btn:active, .mobile-header-btn:active { transform: scale(.95); }

        .profile-avatar { width:44px; height:44px; border-radius:12px; background: var(--gradient); color:#fff; display:flex; align-items:center; justify-content:center; font-weight:600; }
        .notification-badge { position:absolute; top:-2px; right:-2px; min-width:18px; height:18px; border-radius:9px; background:#EF4444; color:#fff; font-size:10px; display:flex; align-items:center; justify-content:center; font-weight:700; }
        .nav-badge { position:absolute; top:5px; right:calc(50% - 18px); min-width:18px; height:18px; padding:0 5px; border-radius:9px; background:#EF4444; color:#fff; font-size:10px; font-weight:700; display:flex; align-items:center; justify-content:center; box-shadow:0 2px 8px rgba(239,68,68,.3); }

        @keyframes fadeIn { from { opacity:0; transform: translateY(20px); } to { opacity:1; transform: none; } }

        /* Loading screen */
        .page-loading { position:fixed; inset:0; display:none; align-items:center; justify-content:center; background:rgba(255,255,255,.6); backdrop-filter: blur(3px); z-index: 1200; }
        .page-loading.show { display:flex; }
        .spinner { width:42px; height:42px; border:4px solid #fff; border-top-color: var(--primary); border-radius:50%; animation: spin 1s linear infinite; box-shadow: var(--orange-shadow); }
        @keyframes spin { to { transform: rotate(360deg); } }

        /* Toasts */
        .toast-container { position: fixed; top: 20px; right: 20px; z-index: 1300; display:flex; flex-direction:column; gap:10px; }
        .toast { background:#fff; border:1px solid rgba(255,107,53,.1); border-radius:14px; padding:16px; display:flex; gap:12px; min-width:280px; box-shadow:0 8px 24px rgba(0,0,0,.1); position:relative; overflow:hidden; }
        .toast::before { content:''; position:absolute; left:0; top:0; bottom:0; width:4px; }
        .toast.success::before { background:#10b981; }
        .toast.error::before { background:#ef4444; }
        .toast.warning::before { background:#f97316; }
        .toast.info::before { background:#3b82f6; }
        .toast-icon { width:32px; height:32px; display:flex; align-items:center; justify-content:center; border-radius:10px; }
        .toast-content { flex:1; }
        .toast-title { font-size:14px; font-weight:600; margin-bottom:2px; }
        .toast-message { font-size:13px; color: var(--gray-700); }
        .toast-close { width:28px; height:28px; border:none; background:transparent; color:#94A3B8; cursor:pointer; border-radius:8px; }
        .toast-close:hover { background: rgba(0,0,0,.05); }

        /* Modern FAB */
        .fab-container { position:fixed; right:20px; bottom:calc(var(--nav-height) + var(--safe-bottom) + 25px); z-index:1100; cursor:move; user-select:none; }
        .fab-main { width:64px; height:64px; border-radius:20px; background:var(--gradient); color:white; border:none; box-shadow:0 8px 24px rgba(255,107,53,0.4); cursor:pointer; display:flex; align-items:center; justify-content:center; transition:all 0.3s cubic-bezier(0.68,-0.55,0.265,1.55); position:relative; backdrop-filter:blur(10px); }
        .fab-main:hover { transform:translateY(-4px) scale(1.05); box-shadow:0 12px 32px rgba(255,107,53,0.5); }
        .fab-main:active { transform:scale(0.95); }
        .fab-main i { font-size:24px; transition:all 0.3s; }
        .fab-main.active { border-radius:50%; }
        .fab-main.active i { transform:rotate(45deg); }

        .fab-actions { position:absolute; right:0; bottom:80px; display:flex; flex-direction:column; gap:16px; opacity:0; visibility:hidden; transform:translateY(20px) scale(0.8); pointer-events:none; transition:all 0.4s cubic-bezier(0.68,-0.55,0.265,1.55); }
        .fab-actions.active { opacity:1; visibility:visible; transform:translateY(0) scale(1); pointer-events:auto; }
        .fab-action-item { display:flex; align-items:center; gap:12px; opacity:0; transform:translateX(60px); }
        .fab-actions.active .fab-action-item { animation:fabSlideIn 0.4s ease forwards; }
        .fab-actions.active .fab-action-item:nth-child(1) { animation-delay:0.1s; }
        .fab-actions.active .fab-action-item:nth-child(2) { animation-delay:0.2s; }
        .fab-actions.active .fab-action-item:nth-child(3) { animation-delay:0.3s; }
        @keyframes fabSlideIn { to { opacity:1; transform:translateX(0); } }
        
        .fab-label { background:rgba(0,0,0,0.85); color:white; padding:10px 16px; border-radius:24px; font-size:12px; font-weight:500; white-space:nowrap; backdrop-filter:blur(20px); box-shadow:0 4px 16px rgba(0,0,0,0.2); border:1px solid rgba(255,255,255,0.1); }
        .fab-action-btn { width:56px; height:56px; border-radius:16px; background:white; border:none; box-shadow:0 6px 20px rgba(0,0,0,0.15); cursor:pointer; display:flex; align-items:center; justify-content:center; transition:all 0.3s; font-size:20px; }
        .fab-action-btn:hover { transform:translateY(-2px) scale(1.05); box-shadow:0 8px 25px rgba(0,0,0,0.2); }
        .fab-action-btn:active { transform:scale(0.95); }
        .fab-action-btn.calculator { color:#8B5CF6; }
        .fab-action-btn.finance { color:#10B981; }
        .fab-action-btn.delivery { color:var(--primary); }
        .fab-action-btn.income { color:#10B981; }
        .fab-action-btn.expense { color:#EF4444; }
        .fab-action-btn.reports { color:#3B82F6; }
        .fab-action-btn.history { color:#F59E0B; }

        /* Slide Menu */
        .slide-menu { position:fixed; left:-100%; top:0; width:320px; height:100vh; background:white; box-shadow:4px 0 20px rgba(0,0,0,0.15); transition:all 0.3s ease; z-index:9999; overflow-y:auto; }
        .slide-menu.active { left:0; }
        .menu-handle { position:absolute; right:-20px; top:50%; transform:translateY(-50%); width:20px; height:60px; background:var(--gradient); border-radius:0 10px 10px 0; cursor:pointer; }

        /* Menu Header */
        .menu-header { background:var(--gradient); padding:20px; color:white; }
        .menu-header-content { display:flex; align-items:center; justify-content:space-between; }
        .menu-title { font-size:18px; font-weight:600; display:flex; align-items:center; gap:8px; }
        .close-menu { width:36px; height:36px; border:none; background:rgba(255,255,255,0.2); color:white; border-radius:50%; cursor:pointer; display:flex; align-items:center; justify-content:center; transition:all 0.3s; }
        .close-menu:hover { background:rgba(255,255,255,0.3); transform:scale(1.1); }

        /* Menu Content */
        .menu-content { padding:20px 20px 40px; }

        /* User Profile Card */
        .user-profile-card { display:flex; align-items:center; gap:12px; padding:16px; background:var(--gradient-soft); border-radius:16px; margin-bottom:24px; border:1px solid rgba(255,107,53,0.1); }
        .profile-avatar { position:relative; }
        .avatar-circle { width:48px; height:48px; background:white; border-radius:50%; display:flex; align-items:center; justify-content:center; font-weight:700; font-size:16px; color:var(--primary); box-shadow:0 2px 8px rgba(255,107,53,0.2); }
        .profile-info { flex:1; }
        .profile-name { font-size:14px; font-weight:600; color:var(--gray-900); margin-bottom:2px; }
        .profile-role { font-size:12px; color:var(--gray-600); }
        .profile-status { display:flex; align-items:center; }
        .status-dot { width:8px; height:8px; border-radius:50%; background:#10B981; }

        /* Menu Section */
        .menu-section { margin-bottom:24px; }
        .section-header { display:flex; align-items:center; gap:8px; font-size:14px; font-weight:600; color:var(--gray-700); margin-bottom:12px; padding:0 4px; }
        .section-header i { color:var(--primary); }

        /* Quick Actions */
        .quick-actions { display:grid; grid-template-columns:repeat(4,1fr); gap:12px; }
        .quick-action { display:flex; flex-direction:column; align-items:center; gap:8px; padding:16px 8px; background:white; border-radius:12px; text-decoration:none; color:var(--gray-700); border:1px solid var(--gray-200); transition:all 0.3s; }
        .quick-action:hover { transform:translateY(-2px); box-shadow:0 4px 12px rgba(0,0,0,0.1); border-color:var(--primary); }
        .action-icon { width:40px; height:40px; border-radius:10px; display:flex; align-items:center; justify-content:center; font-size:16px; color:white; }
        .action-icon.dashboard { background:linear-gradient(135deg,#3B82F6 0%,#1D4ED8 100%); }
        .action-icon.create { background:linear-gradient(135deg,#10B981 0%,#047857 100%); }
        .action-icon.history { background:linear-gradient(135deg,#F59E0B 0%,#D97706 100%); }
        .action-icon.calculator { background:linear-gradient(135deg,#8B5CF6 0%,#7C3AED 100%); }
        .quick-action span { font-size:11px; font-weight:500; text-align:center; }

        /* Menu List */
        .menu-list { display:flex; flex-direction:column; gap:4px; }
        .menu-item { display:flex; align-items:center; gap:12px; padding:12px; background:white; border-radius:12px; text-decoration:none; color:var(--gray-900); border:1px solid var(--gray-100); transition:all 0.3s; }
        .menu-item:hover { background:var(--gray-50); border-color:var(--primary); transform:translateX(4px); }
        .menu-item.logout:hover { background:rgba(239,68,68,0.05); border-color:#EF4444; }
        .item-icon { width:36px; height:36px; border-radius:8px; display:flex; align-items:center; justify-content:center; font-size:14px; color:white; }
        .item-icon.finance { background:linear-gradient(135deg,#3B82F6 0%,#1D4ED8 100%); }
        .item-icon.records { background:linear-gradient(135deg,#10B981 0%,#047857 100%); }
        .item-icon.budget { background:linear-gradient(135deg,#F59E0B 0%,#D97706 100%); }
        .item-icon.goals { background:linear-gradient(135deg,#EC4899 0%,#BE185D 100%); }
        .item-icon.reports { background:linear-gradient(135deg,#8B5CF6 0%,#7C3AED 100%); }
        .item-icon.profile { background:linear-gradient(135deg,#6366F1 0%,#4F46E5 100%); }
        .item-icon.logout { background:linear-gradient(135deg,#EF4444 0%,#DC2626 100%); }
        .item-content { flex:1; }
        .item-title { font-size:14px; font-weight:600; color:var(--gray-900); margin-bottom:2px; }
        .item-subtitle { font-size:12px; color:var(--gray-500); }
        .item-arrow { color:var(--gray-400); font-size:12px; transition:all 0.3s; }
        .menu-item:hover .item-arrow { color:var(--primary); transform:translateX(2px); }

        /* Scrollbar */
        .slide-menu::-webkit-scrollbar { width:4px; }
        .slide-menu::-webkit-scrollbar-track { background:transparent; }
        .slide-menu::-webkit-scrollbar-thumb { background:var(--gray-300); border-radius:2px; }
        .slide-menu::-webkit-scrollbar-thumb:hover { background:var(--gray-400); }

        /* Overlay */
        .overlay { position:fixed; inset:0; background: rgba(0,0,0,.5); opacity:0; visibility:hidden; transition:.3s; z-index: 1090; backdrop-filter: blur(4px); }
        .overlay.active { opacity:1; visibility:visible; }

        /* Responsive tweaks */
        @media (max-width: 768px) and (min-width: 481px) { .quick-actions { grid-template-columns: repeat(4, 1fr); } }
        @media (max-width: 380px) { .quick-actions { grid-template-columns: repeat(2, 1fr); } .nav-item span { font-size:10px; } .nav-item i { font-size:20px; } }
        
        /* Notification Dropdown Styles */
        .notification-dropdown { background:rgba(255,255,255,0.95); backdrop-filter:blur(20px); border:1px solid rgba(255,107,53,0.1); box-shadow:0 25px 50px rgba(255,107,53,0.15); border-radius:16px; }
        .notification-header { background:linear-gradient(135deg,#FFE5DB 0%,#FFD4C4 100%); border-bottom:1px solid rgba(255,107,53,0.1); position:relative; overflow:hidden; }
        .notification-header::before { content:''; position:absolute; inset:0; background:linear-gradient(135deg,rgba(255,255,255,0.2),transparent); }
        .notification-item { position:relative; transition:all 0.3s; border-left:4px solid transparent; background:rgba(255,255,255,0.8); }
        .notification-item::before { content:''; position:absolute; left:0; top:0; bottom:0; width:0; background:linear-gradient(90deg,var(--primary),transparent); transition:width 0.3s; }
        .notification-item:hover::before { width:100%; opacity:0.05; }
        .notification-item.unread { border-left-color:var(--primary); background:linear-gradient(90deg,rgba(255,107,53,0.08),rgba(255,255,255,0.9)); }
        .notification-item:hover { transform:translateX(4px); box-shadow:0 8px 25px rgba(255,107,53,0.1); }
        .notification-icon { width:36px; height:36px; border-radius:10px; display:flex; align-items:center; justify-content:center; box-shadow:0 4px 12px rgba(0,0,0,0.1); }
        .notification-icon::after { content:''; position:absolute; inset:2px; border-radius:8px; background:linear-gradient(135deg,rgba(255,255,255,0.3),rgba(255,255,255,0.1)); pointer-events:none; }
        .notification-badge { background:linear-gradient(135deg,#EF4444,#DC2626); box-shadow:0 4px 12px rgba(239,68,68,0.4); animation:badgePulse 2s ease-in-out infinite; }
        @keyframes badgePulse { 0%,100%{transform:scale(1);box-shadow:0 4px 12px rgba(239,68,68,0.4)} 50%{transform:scale(1.1);box-shadow:0 6px 20px rgba(239,68,68,0.6)} }
        .notification-type-badge { font-size:10px; font-weight:600; padding:4px 8px; border-radius:20px; text-transform:uppercase; letter-spacing:0.5px; backdrop-filter:blur(10px); border:1px solid rgba(255,255,255,0.2); }
        .notification-scroll::-webkit-scrollbar { width:6px; }
        .notification-scroll::-webkit-scrollbar-track { background:rgba(255,107,53,0.05); border-radius:3px; }
        .notification-scroll::-webkit-scrollbar-thumb { background:linear-gradient(180deg,var(--primary),var(--primary-dark)); border-radius:3px; box-shadow:inset 0 0 2px rgba(255,255,255,0.3); }
        .notification-empty { background:linear-gradient(135deg,#F8FAFC,#F1F5F9); border:2px dashed rgba(255,107,53,0.2); border-radius:12px; }
        .notification-empty-icon { background:linear-gradient(135deg,#FFE5DB,#FFD4C4); box-shadow:0 8px 25px rgba(255,107,53,0.15); }
        
        /* Toast Styles */
        .toast-notification { backdrop-filter:blur(20px); border:1px solid rgba(255,255,255,0.2); }
        .toast-notification::before { content:''; position:absolute; top:0; left:0; right:0; height:4px; background:var(--primary); }
        .toast-notification.success::before { background:#10B981; }
        .toast-notification.warning::before { background:#F59E0B; }
        .toast-notification.error::before { background:#EF4444; }
        .toast-notification.info::before { background:#3B82F6; }
        .toast-icon { width:40px; height:40px; border-radius:12px; display:flex; align-items:center; justify-content:center; }
        .toast-icon.success { background:linear-gradient(135deg,#10B981,#059669); }
        .toast-icon.warning { background:linear-gradient(135deg,#F59E0B,#D97706); }
        .toast-icon.error { background:linear-gradient(135deg,#EF4444,#DC2626); }
        .toast-icon.info { background:linear-gradient(135deg,#3B82F6,#2563EB); }
        .toast-progress { position:absolute; bottom:0; left:0; height:3px; background:var(--primary); animation:progressShrink 5s linear; }
        @keyframes progressShrink { from{width:100%} to{width:0%} }
        
        /* === NOTIFICATION BELL COMPONENT === */
        .notification-bell {
            position: relative;
            display: inline-block;
        }

        .bell-button {
            width: 44px;
            height: 44px;
            border: none;
            border-radius: 14px;
            background: var(--gradient-soft);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            box-shadow: 0 2px 8px rgba(255, 107, 53, 0.1);
        }

        .bell-button:hover {
            background: var(--gradient);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(255, 107, 53, 0.25);
        }

        .bell-button i {
            color: var(--primary);
            font-size: 18px;
            transition: all 0.3s;
        }

        .bell-button:hover i {
            color: white;
        }

        @keyframes bellShake {
            0%, 50%, 100% { transform: rotate(0deg); }
            10%, 30% { transform: rotate(-10deg); }
            20%, 40% { transform: rotate(10deg); }
        }

        .notification-badge {
            position: absolute;
            top: -4px;
            right: -4px;
            min-width: 20px;
            height: 20px;
            border-radius: 10px;
            background: linear-gradient(135deg, #EF4444, #DC2626);
            color: white;
            font-size: 11px;
            font-weight: 700;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.4);
            animation: badgePulse 2s ease-in-out infinite;
            border: 2px solid white;
        }

        /* === NOTIFICATION DROPDOWN === */
        .notification-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            width: 360px;
            max-height: 500px;
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 107, 53, 0.1);
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(255, 107, 53, 0.15);
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px) scale(0.95);
            transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            overflow: hidden;
        }

        .notification-dropdown.active {
            opacity: 1;
            visibility: visible;
            transform: translateY(8px) scale(1);
        }
        
        .notification-header {
            background: var(--gradient-soft);
            padding: 20px;
            border-bottom: 1px solid rgba(255, 107, 53, 0.1);
            position: relative;
            overflow: hidden;
        }

        .notification-header::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), transparent);
        }

        .notification-header h3 {
            font-size: 18px;
            font-weight: 600;
            color: var(--gray-900);
            margin-bottom: 4px;
            position: relative;
        }

        .notification-subtitle {
            font-size: 14px;
            color: var(--gray-600);
            position: relative;
        }

        .header-actions {
            position: absolute;
            top: 20px;
            right: 20px;
            display: flex;
            gap: 8px;
        }

        .action-btn {
            width: 32px;
            height: 32px;
            border: none;
            border-radius: 8px;
            background: rgba(255, 107, 53, 0.1);
            color: var(--primary);
            cursor: pointer;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .action-btn:hover {
            background: var(--primary);
            color: white;
            transform: scale(1.1);
        }
        
        /* === NOTIFICATION LIST === */
        .notification-scroll {
            max-height: 400px;
            overflow-y: auto;
        }

        .notification-scroll::-webkit-scrollbar {
            width: 6px;
        }

        .notification-scroll::-webkit-scrollbar-track {
            background: rgba(255, 107, 53, 0.05);
            border-radius: 3px;
        }

        .notification-scroll::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, var(--primary), var(--primary-dark));
            border-radius: 3px;
            box-shadow: inset 0 0 2px rgba(255, 255, 255, 0.3);
        }

        .notification-item {
            display: flex;
            align-items: flex-start;
            gap: 12px;
            padding: 16px 20px;
            cursor: pointer;
            position: relative;
            transition: all 0.3s;
            border-left: 4px solid transparent;
            background: rgba(255, 255, 255, 0.8);
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        .notification-item::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 0;
            background: linear-gradient(90deg, var(--primary), transparent);
            transition: width 0.3s;
        }

        .notification-item:hover::before {
            width: 100%;
            opacity: 0.05;
        }

        .notification-item.unread {
            border-left-color: var(--primary);
            background: linear-gradient(90deg, rgba(255, 107, 53, 0.08), rgba(255, 255, 255, 0.9));
        }

        .notification-item:hover {
            transform: translateX(4px);
            box-shadow: 0 8px 25px rgba(255, 107, 53, 0.1);
        }

        .notification-icon {
            width: 40px;
            height: 40px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            flex-shrink: 0;
        }

        .notification-icon::after {
            content: '';
            position: absolute;
            inset: 2px;
            border-radius: 10px;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.3), rgba(255, 255, 255, 0.1));
            pointer-events: none;
        }

        .notification-icon.delivery {
            background: var(--gradient);
            color: white;
        }

        .notification-icon.commission {
            background: linear-gradient(135deg, var(--success), #059669);
            color: white;
        }

        .notification-icon.system {
            background: linear-gradient(135deg, var(--info), #2563EB);
            color: white;
        }

        .notification-icon.warning {
            background: linear-gradient(135deg, var(--warning), #D97706);
            color: white;
        }

        .notification-icon.success {
            background: linear-gradient(135deg, var(--success), #059669);
            color: white;
        }

        .notification-icon.error {
            background: linear-gradient(135deg, var(--error), #DC2626);
            color: white;
        }

        .notification-icon.info {
            background: linear-gradient(135deg, var(--info), #2563EB);
            color: white;
        }

        .notification-content {
            flex: 1;
            min-width: 0;
        }

        .notification-title {
            font-size: 14px;
            font-weight: 600;
            color: var(--gray-900);
            margin-bottom: 4px;
            line-height: 1.4;
        }

        .notification-message {
            font-size: 13px;
            color: var(--gray-600);
            line-height: 1.5;
            margin-bottom: 6px;
        }

        .notification-meta {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-top: 8px;
        }

        .notification-time {
            font-size: 11px;
            color: var(--gray-400);
        }

        .notification-type-badge {
            font-size: 10px;
            font-weight: 600;
            padding: 4px 8px;
            border-radius: 20px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .type-delivery {
            background: rgba(255, 107, 53, 0.1);
            color: var(--primary);
        }

        .type-commission {
            background: rgba(16, 185, 129, 0.1);
            color: var(--success);
        }

        .type-system {
            background: rgba(59, 130, 246, 0.1);
            color: var(--info);
        }

        .type-success {
            background: rgba(16, 185, 129, 0.1);
            color: var(--success);
        }

        .type-warning {
            background: rgba(245, 158, 11, 0.1);
            color: var(--warning);
        }

        .type-error {
            background: rgba(239, 68, 68, 0.1);
            color: var(--error);
        }

        .type-info {
            background: rgba(59, 130, 246, 0.1);
            color: var(--info);
        }

        .unread-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: var(--primary);
            margin-left: auto;
            flex-shrink: 0;
        }
        
        /* === EMPTY STATE === */
        .notification-empty {
            padding: 40px 20px;
            text-align: center;
            background: linear-gradient(135deg, #F8FAFC, #F1F5F9);
            border: 2px dashed rgba(255, 107, 53, 0.2);
            border-radius: 12px;
            margin: 20px;
        }

        .notification-empty-icon {
            width: 60px;
            height: 60px;
            border-radius: 20px;
            background: var(--gradient-soft);
            color: var(--primary);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 16px;
            box-shadow: 0 8px 25px rgba(255, 107, 53, 0.15);
        }

        .notification-empty h4 {
            font-size: 16px;
            font-weight: 600;
            color: var(--gray-700);
            margin-bottom: 8px;
        }

        .notification-empty p {
            font-size: 14px;
            color: var(--gray-500);
        }

        /* === TOAST NOTIFICATIONS === */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1300;
            display: flex;
            flex-direction: column;
            gap: 12px;
            max-width: 420px;
        }

        .toast-notification {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 16px;
            padding: 16px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
        }

        .toast-notification::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--primary);
        }

        .toast-notification.success::before {
            background: var(--success);
        }

        .toast-notification.warning::before {
            background: var(--warning);
        }

        .toast-notification.error::before {
            background: var(--error);
        }

        .toast-notification.info::before {
            background: var(--info);
        }

        .toast-icon {
            width: 40px;
            height: 40px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            flex-shrink: 0;
        }

        .toast-icon.success {
            background: linear-gradient(135deg, var(--success), #059669);
        }

        .toast-icon.warning {
            background: linear-gradient(135deg, var(--warning), #D97706);
        }

        .toast-icon.error {
            background: linear-gradient(135deg, var(--error), #DC2626);
        }

        .toast-icon.info {
            background: linear-gradient(135deg, var(--info), #2563EB);
        }

        .toast-content {
            flex: 1;
            min-width: 0;
        }

        .toast-title {
            font-size: 14px;
            font-weight: 600;
            color: var(--gray-900);
            margin-bottom: 4px;
        }

        .toast-message {
            font-size: 13px;
            color: var(--gray-600);
            line-height: 1.4;
        }

        .toast-close {
            width: 28px;
            height: 28px;
            border: none;
            background: transparent;
            color: var(--gray-400);
            cursor: pointer;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
            flex-shrink: 0;
        }

        .toast-close:hover {
            background: rgba(0, 0, 0, 0.05);
            color: var(--gray-600);
        }

        .toast-progress {
            position: absolute;
            bottom: 0;
            left: 0;
            height: 3px;
            background: var(--primary);
            animation: progressShrink 5s linear forwards;
        }

        .toast-progress.success {
            background: var(--success);
        }

        .toast-progress.warning {
            background: var(--warning);
        }

        .toast-progress.error {
            background: var(--error);
        }

        .toast-progress.info {
            background: var(--info);
        }

        /* === MOBILE RESPONSIVE === */
        @media (max-width: 768px) {
            .notification-dropdown {
                width: calc(100vw - 40px);
                right: -100px;
            }

            .toast-container {
                left: 20px;
                right: 20px;
                max-width: none;
            }
        }
    </style>

    @stack('styles')
</head>
<body>
    <!-- Loading -->
    <div class="page-loading" id="pageLoading"><div class="spinner"></div></div>

    <!-- Toasts -->
    <div class="toast-container" id="toastContainer"></div>

    <!-- Desktop Sidebar -->
    <nav class="desktop-sidebar" id="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="fas fa-truck-fast"></i>
                <span>{{ __('app.name') }}</span>
            </div>
        </div>

        <div class="sidebar-nav">
            <ul class="nav-menu" style="list-style:none; padding:0;">
                @auth
                    @if(Auth::user() && method_exists(Auth::user(), 'isAdmin') && Auth::user()->isAdmin())
                        <li class="nav-section-title">{{ __('admin.management') }}</li>
                        <li><a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                            <i class="fas fa-tachometer-alt"></i><span>{{ __('common.dashboard') }}</span></a></li>
                        <li><a href="{{ route('admin.users.index') }}" class="nav-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                            <i class="fas fa-users"></i><span>{{ __('admin.users') }}</span></a></li>
                        <li><a href="{{ route('admin.warehouses.index') }}" class="nav-link {{ request()->routeIs('admin.warehouses.*') ? 'active' : '' }}">
                            <i class="fas fa-warehouse"></i><span>{{ __('admin.warehouses') }}</span></a></li>
                        <li><a href="{{ route('admin.commission-rates.index') }}" class="nav-link {{ request()->routeIs('admin.commission-rates.*') ? 'active' : '' }}">
                            <i class="fas fa-percentage"></i><span>{{ __('admin.commission_rates') }}</span></a></li>
                        <li class="nav-section-title">{{ __('admin.reports') }}</li>
                        <li><a href="{{ route('admin.reports.index') }}" class="nav-link {{ request()->routeIs('admin.reports.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-line"></i><span>{{ __('admin.delivery_reports') }}</span></a></li>
                    @elseif(Auth::user() && method_exists(Auth::user(), 'isVehicleUser') && Auth::user()->isVehicleUser())
                        <li class="nav-section-title">{{ __('delivery.reports') }}</li>
                        <li><a href="{{ route('vehicle.dashboard') }}" class="nav-link {{ request()->routeIs('vehicle.dashboard') ? 'active' : '' }}">
                            <i class="fas fa-tachometer-alt"></i><span>{{ __('common.dashboard') }}</span></a></li>
                        <li><a href="{{ route('vehicle.deliveries.create') }}" class="nav-link {{ request()->routeIs('vehicle.deliveries.create') ? 'active' : '' }}">
                            <i class="fas fa-clipboard-list"></i><span>{{ __('delivery.create_delivery') }}</span></a></li>
                        <li><a href="{{ route('vehicle.deliveries.index') }}" class="nav-link {{ request()->routeIs('vehicle.deliveries.index') ? 'active' : '' }}">
                            <i class="fas fa-history"></i><span>{{ __('delivery.delivery_history') }}</span></a></li>

                        <li class="nav-section-title">{{ __('finance.accounting') }}</li>
                        <li><a href="{{ route('finance.dashboard') }}" class="nav-link {{ request()->routeIs('finance.dashboard') ? 'active' : '' }}">
                            <i class="fas fa-chart-line"></i><span>{{ __('finance.dashboard') }}</span></a></li>
                        <li><a href="{{ route('finance.records.index') }}" class="nav-link {{ request()->routeIs('finance.records.*') ? 'active' : '' }}">
                            <i class="fas fa-list"></i><span>{{ __('finance.records') }}</span></a></li>
                    @endif

                    <li class="nav-section-title">{{ __('common.account') }}</li>
                    <li>
                        <a href="{{ route('profile.edit') }}" class="nav-link {{ request()->routeIs('profile.*') ? 'active' : '' }}">
                            <i class="fas fa-user-cog"></i><span>{{ __('common.profile') }}</span>
                        </a>
                    </li>
                    <li>
                        <form method="POST" action="{{ route('language.switch.redirect') }}" style="display:inline;">
                            @csrf
                            <input type="hidden" name="locale" value="{{ app()->getLocale() === 'th' ? 'en' : 'th' }}">
                            <button type="submit" class="nav-link" style="background:none; border:none; width:100%; text-align:left;">
                                <i class="fas fa-globe"></i>
                                <span>{{ __('common.language') }} ({{ app()->getLocale() === 'th' ? __('common.english') : __('common.thai') }})</span>
                            </button>
                        </form>
                    </li>
                    <li>
                        <form method="POST" action="{{ route('logout') }}" id="logoutFormDesktop">
                            @csrf
                            <a href="#" class="nav-link" onclick="confirmLogout(event)">
                                <i class="fas fa-sign-out-alt"></i><span>{{ __('common.logout') }}</span>
                            </a>
                        </form>
                    </li>
                @endauth
            </ul>
        </div>
    </nav>

    <!-- Desktop Header -->
    <header class="desktop-header">
        <h1 class="header-title">@yield('page-title', __('common.dashboard'))</h1>
        <div class="header-actions">
            <button class="header-btn" id="headerMenuButton" title="{{ __('common.menu') }}">
                <i class="fas fa-bars"></i>
            </button>
            <button class="header-btn" title="{{ __('common.search') }}"><i class="fas fa-search"></i></button>
            @include('components.notification-bell')
            <div class="profile-avatar" title="{{ __('common.profile') }}">{{ strtoupper(substr(Auth::user()->name ?? 'U', 0, 2)) }}</div>
        </div>
    </header>

    <!-- Mobile Header -->
    <header class="mobile-header">
        <div class="mobile-header-left">
            <div class="mobile-logo"><i class="fas fa-truck-fast"></i></div>
            <div class="mobile-title">@yield('mobile-title', __('app.name'))</div>
        </div>
        <div class="mobile-header-right">
            <button class="mobile-header-btn" title="{{ __('common.search') }}"><i class="fas fa-search"></i></button>
            @include('components.notification-bell')
            <button class="mobile-header-btn" id="menuButton" title="{{ __('common.menu') }}"><i class="fas fa-bars"></i></button>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        @yield('content')
    </main>

    <!-- Mobile Bottom Navigation -->
    <nav class="mobile-nav">
        <div class="nav-container">
            @auth
                @if(Auth::user() && method_exists(Auth::user(), 'isVehicleUser') && Auth::user()->isVehicleUser())
                    <button class="nav-item {{ request()->routeIs('vehicle.dashboard') ? 'active' : '' }}" onclick="navigate('{{ route('vehicle.dashboard') }}', this)">
                        <i class="fas fa-home"></i><span>{{ __('common.home') }}</span>
                    </button>
                    <button class="nav-item {{ request()->routeIs('vehicle.deliveries.*') ? 'active' : '' }}" onclick="navigate('{{ route('vehicle.deliveries.index') }}', this)">
                        <i class="fas fa-clipboard-list"></i><span>{{ __('delivery.delivery') }}</span>
                        @if(isset($pendingDeliveries) && $pendingDeliveries > 0)
                            <span class="nav-badge">{{ $pendingDeliveries }}</span>
                        @endif
                    </button>
                    <button class="nav-item {{ request()->routeIs('vehicle.calculator') ? 'active' : '' }}" onclick="navigate('{{ route('vehicle.calculator') }}', this)">
                        <i class="fas fa-calculator"></i><span>{{ __('delivery.calculate') }}</span>
                    </button>
                    <button class="nav-item {{ request()->routeIs('finance.*') ? 'active' : '' }}" onclick="navigate('{{ route('finance.dashboard') }}', this)">
                        <i class="fas fa-wallet"></i><span>{{ __('finance.finance') }}</span>
                    </button>
                    <button class="nav-item" onclick="openSlideMenu()">
                        <i class="fas fa-bars"></i><span>{{ __('common.menu') }}</span>
                    </button>
                @elseif(Auth::user() && method_exists(Auth::user(), 'isAdmin') && Auth::user()->isAdmin())
                    <button class="nav-item {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" onclick="navigate('{{ route('admin.dashboard') }}', this)">
                        <i class="fas fa-home"></i><span>{{ __('common.home') }}</span>
                    </button>
                    <button class="nav-item {{ request()->routeIs('admin.users.*') ? 'active' : '' }}" onclick="navigate('{{ route('admin.users.index') }}', this)">
                        <i class="fas fa-users"></i><span>{{ __('admin.users') }}</span>
                    </button>
                    <button class="nav-item {{ request()->routeIs('admin.warehouses.*') ? 'active' : '' }}" onclick="navigate('{{ route('admin.warehouses.index') }}', this)">
                        <i class="fas fa-warehouse"></i><span>{{ __('admin.warehouses') }}</span>
                    </button>
                    <button class="nav-item {{ request()->routeIs('admin.reports.*') ? 'active' : '' }}" onclick="navigate('{{ route('admin.reports.index') }}', this)">
                        <i class="fas fa-chart-line"></i><span>{{ __('admin.reports') }}</span>
                    </button>
                    <button class="nav-item" onclick="openSlideMenu()">
                        <i class="fas fa-bars"></i><span>{{ __('common.menu') }}</span>
                    </button>
                @endif
            @endauth
        </div>
    </nav>

    <!-- Floating Action Button (only shown for vehicle users) -->
    @auth
    @if(Auth::user() && method_exists(Auth::user(), 'isVehicleUser') && Auth::user()->isVehicleUser())
    <div class="fab-container" id="fabContainer">
        <div class="fab-actions" id="fabActions">
            @if(request()->routeIs('finance.*'))
                <!-- Finance Actions -->
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('finance.reports') }}</span>
                    <button class="fab-action-btn reports" onclick="quickAction('reports')">
                        <i class="fas fa-chart-bar"></i>
                    </button>
                </div>
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('finance.add_expense') }}</span>
                    <button class="fab-action-btn expense" onclick="quickAction('expense')">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('finance.add_income') }}</span>
                    <button class="fab-action-btn income" onclick="quickAction('income')">
                        <i class="fas fa-plus"></i>
                    </button>
                </div>
            @elseif(request()->routeIs('vehicle.deliveries.*'))
                <!-- Delivery Actions -->
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('delivery.calculate_commission') }}</span>
                    <button class="fab-action-btn calculator" onclick="quickAction('calculator')">
                        <i class="fas fa-calculator"></i>
                    </button>
                </div>
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('delivery.delivery_history') }}</span>
                    <button class="fab-action-btn history" onclick="quickAction('history')">
                        <i class="fas fa-history"></i>
                    </button>
                </div>
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('delivery.create_delivery') }}</span>
                    <button class="fab-action-btn delivery" onclick="quickAction('add')">
                        <i class="fas fa-plus"></i>
                    </button>
                </div>
            @else
                <!-- Default Actions -->
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('delivery.calculate_commission') }}</span>
                    <button class="fab-action-btn calculator" onclick="quickAction('calculator')">
                        <i class="fas fa-calculator"></i>
                    </button>
                </div>
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('finance.view_finance') }}</span>
                    <button class="fab-action-btn finance" onclick="quickAction('finance')">
                        <i class="fas fa-wallet"></i>
                    </button>
                </div>
                <div class="fab-action-item">
                    <span class="fab-label">{{ __('delivery.create_delivery') }}</span>
                    <button class="fab-action-btn delivery" onclick="quickAction('add')">
                        <i class="fas fa-plus"></i>
                    </button>
                </div>
            @endif
        </div>
        <button class="fab-main" onclick="toggleFabActions()" id="fabMain">
            <i class="fas fa-plus"></i>
        </button>
    </div>
    @endif
    @endauth

    <!-- Slide Menu -->
    <div class="slide-menu" id="slideMenu" aria-hidden="true">
        <div class="menu-handle"></div>
        
        <!-- Menu Header -->
        <div class="menu-header">
            <div class="menu-header-content">
                <div class="menu-title">
                    <i class="fas fa-bars"></i>
                    {{ __('common.all_menu') }}
                </div>
                <button class="close-menu" onclick="closeSlideMenu()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        
        <div class="menu-content">
            @auth
                <!-- User Profile Card -->
                <div class="user-profile-card">
                    <div class="profile-avatar">
                        <div class="avatar-circle">{{ strtoupper(substr(Auth::user()->name ?? 'U', 0, 2)) }}</div>
                    </div>
                    <div class="profile-info">
                        <div class="profile-name">{{ Auth::user()->name ?? __('common.user') }}</div>
                        <div class="profile-role">{{ Auth::user()->role_display_name ?? __('common.user') }}</div>
                    </div>
                    <div class="profile-status">
                        <div class="status-dot active"></div>
                    </div>
                </div>

                @if(Auth::user() && method_exists(Auth::user(), 'isVehicleUser') && Auth::user()->isVehicleUser())
                    <!-- Quick Actions -->
                    <div class="menu-section">
                        <div class="section-header">
                            <i class="fas fa-bolt"></i>
                            <span>{{ __('common.quick_menu') }}</span>
                        </div>
                        <div class="quick-actions">
                            <a href="{{ route('vehicle.dashboard') }}" class="quick-action">
                                <div class="action-icon dashboard">
                                    <i class="fas fa-tachometer-alt"></i>
                                </div>
                                <span>{{ __('common.dashboard') }}</span>
                            </a>
                            <a href="{{ route('vehicle.deliveries.create') }}" class="quick-action">
                                <div class="action-icon create">
                                    <i class="fas fa-plus"></i>
                                </div>
                                <span>{{ __('delivery.new_record') }}</span>
                            </a>
                            <a href="{{ route('vehicle.deliveries.index') }}" class="quick-action">
                                <div class="action-icon history">
                                    <i class="fas fa-history"></i>
                                </div>
                                <span>{{ __('delivery.history') }}</span>
                            </a>
                            <a href="{{ route('vehicle.calculator') }}" class="quick-action">
                                <div class="action-icon calculator">
                                    <i class="fas fa-calculator"></i>
                                </div>
                                <span>{{ __('delivery.calculate') }}</span>
                            </a>
                        </div>
                    </div>

                    <!-- Finance Section -->
                    <div class="menu-section">
                        <div class="section-header">
                            <i class="fas fa-wallet"></i>
                            <span>{{ __('finance.accounting') }}</span>
                        </div>
                        <div class="menu-list">
                            <a href="{{ route('finance.dashboard') }}" class="menu-item">
                                <div class="item-icon finance">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ __('finance.financial_overview') }}</div>
                                    <div class="item-subtitle">{{ __('finance.view_income_expense_summary') }}</div>
                                </div>
                                <div class="item-arrow">
                                    <i class="fas fa-chevron-right"></i>
                                </div>
                            </a>
                            <a href="{{ route('finance.records.index') }}" class="menu-item">
                                <div class="item-icon records">
                                    <i class="fas fa-list"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ __('finance.income_expense') }}</div>
                                    <div class="item-subtitle">{{ __('finance.record_and_manage') }}</div>
                                </div>
                                <div class="item-arrow">
                                    <i class="fas fa-chevron-right"></i>
                                </div>
                            </a>
                            <a href="{{ route('finance.budgets.index') }}" class="menu-item">
                                <div class="item-icon budget">
                                    <i class="fas fa-file-invoice-dollar"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ __('finance.budget') }}</div>
                                    <div class="item-subtitle">{{ __('finance.financial_planning') }}</div>
                                </div>
                                <div class="item-arrow">
                                    <i class="fas fa-chevron-right"></i>
                                </div>
                            </a>
                            <a href="{{ route('finance.goals.index') }}" class="menu-item">
                                <div class="item-icon goals">
                                    <i class="fas fa-piggy-bank"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ __('finance.saving_goals') }}</div>
                                    <div class="item-subtitle">{{ __('finance.set_goals_and_track') }}</div>
                                </div>
                                <div class="item-arrow">
                                    <i class="fas fa-chevron-right"></i>
                                </div>
                            </a>
                            <a href="{{ route('finance.reports.index') }}" class="menu-item">
                                <div class="item-icon reports">
                                    <i class="fas fa-chart-bar"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ __('finance.reports') }}</div>
                                    <div class="item-subtitle">{{ __('finance.financial_analysis') }}</div>
                                </div>
                                <div class="item-arrow">
                                    <i class="fas fa-chevron-right"></i>
                                </div>
                            </a>
                        </div>
                    </div>
                @elseif(Auth::user() && method_exists(Auth::user(), 'isAdmin') && Auth::user()->isAdmin())
                    <!-- Admin Quick Actions -->
                    <div class="menu-section">
                        <div class="section-header">
                            <i class="fas fa-cogs"></i>
                            <span>{{ __('admin.management') }}</span>
                        </div>
                        <div class="quick-actions">
                            <a href="{{ route('admin.dashboard') }}" class="quick-action">
                                <div class="action-icon dashboard">
                                    <i class="fas fa-tachometer-alt"></i>
                                </div>
                                <span>{{ __('common.dashboard') }}</span>
                            </a>
                            <a href="{{ route('admin.users.index') }}" class="quick-action">
                                <div class="action-icon create">
                                    <i class="fas fa-users"></i>
                                </div>
                                <span>{{ __('admin.users') }}</span>
                            </a>
                            <a href="{{ route('admin.warehouses.index') }}" class="quick-action">
                                <div class="action-icon history">
                                    <i class="fas fa-warehouse"></i>
                                </div>
                                <span>{{ __('admin.warehouses') }}</span>
                            </a>
                            <a href="{{ route('admin.commission-rates.index') }}" class="quick-action">
                                <div class="action-icon calculator">
                                    <i class="fas fa-percentage"></i>
                                </div>
                                <span>{{ __('admin.commission_rates') }}</span>
                            </a>
                        </div>
                    </div>
                    <div class="menu-section">
                        <div class="section-header">
                            <i class="fas fa-chart-line"></i>
                            <span>{{ __('admin.reports') }}</span>
                        </div>
                        <div class="menu-list">
                            <a href="{{ route('admin.reports.index') }}" class="menu-item">
                                <div class="item-icon reports">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ __('admin.delivery_reports') }}</div>
                                    <div class="item-subtitle">{{ __('admin.analyze_performance') }}</div>
                                </div>
                                <div class="item-arrow">
                                    <i class="fas fa-chevron-right"></i>
                                </div>
                            </a>
                        </div>
                    </div>
                @endif

                <!-- Settings Section -->
                <div class="menu-section" style="margin-bottom:60px;">
                    <div class="section-header">
                        <i class="fas fa-cog"></i>
                        <span>{{ __('common.settings') }}</span>
                    </div>
                    <div class="menu-list">
                        <a href="{{ route('profile.edit') }}" class="menu-item">
                            <div class="item-icon profile">
                                <i class="fas fa-user-cog"></i>
                            </div>
                            <div class="item-content">
                                <div class="item-title">{{ __('common.profile_settings') }}</div>
                                <div class="item-subtitle">{{ __('common.edit_personal_info') }}</div>
                            </div>
                            <div class="item-arrow">
                                <i class="fas fa-chevron-right"></i>
                            </div>
                        </a>
                        <form method="POST" action="{{ route('logout') }}" id="logoutFormMobile">
                            @csrf
                            <a href="#" class="menu-item logout" onclick="confirmLogout(event)">
                                <div class="item-icon logout">
                                    <i class="fas fa-sign-out-alt"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ __('common.logout') }}</div>
                                    <div class="item-subtitle">{{ __('common.sign_out_app') }}</div>
                                </div>
                                <div class="item-arrow">
                                    <i class="fas fa-chevron-right"></i>
                                </div>
                            </a>
                        </form>
                    </div>
                </div>
            @endauth
        </div>
    </div>

    <!-- Overlay -->
    <div class="overlay" id="overlay" onclick="closeSlideMenu()"></div>

    <!-- Toast Notifications -->
    @include('components.toast-notifications')

    <script>
    // ------- Utilities -------
    const $ = (sel) => document.querySelector(sel);

    function showLoading() { $('#pageLoading')?.classList.add('show'); }
    function hideLoading() { $('#pageLoading')?.classList.remove('show'); }

    function showToast(message, type = 'info', duration = 3000) {
        if (window.Swal) {
            Swal.fire({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: duration,
                timerProgressBar: true,
                icon: type,
                title: message
            });
        }
    }

    // ------- Navigation -------
    function navigate(url, el) {
        showLoading();
        window.location.href = url;
    }

    // ------- Modern FAB -------
    function toggleFabActions() {
        const actions = $('#fabActions');
        const fab = $('#fabMain');
        actions?.classList.toggle('active');
        fab?.classList.toggle('active');
    }

    function quickAction(type) {
        toggleFabActions();
        const map = {
            calculator: '{{ route('vehicle.calculator') }}',
            finance: '{{ route('finance.dashboard') }}',
            add: '{{ route('vehicle.deliveries.create') }}',
            income: '{{ route('finance.records.create', ['type' => 'income']) }}',
            expense: '{{ route('finance.records.create', ['type' => 'expense']) }}',
            reports: '{{ route('finance.reports.index') }}',
            history: '{{ route('vehicle.deliveries.index') }}'
        };
        const url = map[type];
        if (url) navigate(url);
    }

    // FAB Dragging
    (() => {
        const container = $('#fabContainer');
        if (!container) return;
        let isDragging = false, startX = 0, startY = 0, initialX = 0, initialY = 0;
        
        container.addEventListener('touchstart', (e) => {
            isDragging = true;
            startX = e.touches[0].clientX;
            startY = e.touches[0].clientY;
            const rect = container.getBoundingClientRect();
            initialX = rect.left;
            initialY = rect.top;
            container.style.transition = 'none';
        }, { passive: true });
        
        container.addEventListener('touchmove', (e) => {
            if (!isDragging) return;
            e.preventDefault();
            const currentX = e.touches[0].clientX;
            const currentY = e.touches[0].clientY;
            const deltaX = currentX - startX;
            const deltaY = currentY - startY;
            
            const newX = Math.max(20, Math.min(window.innerWidth - 84, initialX + deltaX));
            const newY = Math.max(20, Math.min(window.innerHeight - 150, initialY + deltaY));
            
            container.style.left = newX + 'px';
            container.style.top = newY + 'px';
            container.style.right = 'auto';
            container.style.bottom = 'auto';
        });
        
        container.addEventListener('touchend', () => {
            isDragging = false;
            container.style.transition = 'all 0.3s ease';
        });
    })();

    // ------- Slide Menu -------
    function openSlideMenu() {
        $('#slideMenu')?.classList.add('active');
        $('#overlay')?.classList.add('active');
        document.body.style.overflow = 'hidden';
    }
    function closeSlideMenu() {
        $('#slideMenu')?.classList.remove('active');
        $('#overlay')?.classList.remove('active');
        document.body.style.overflow = '';
    }

    // Swipe to close on mobile
    (() => {
        const el = $('#slideMenu');
        let startY = 0, endY = 0;
        if (!el) return;
        el.addEventListener('touchstart', (e) => { startY = e.changedTouches[0].screenY; }, { passive:true });
        el.addEventListener('touchend',   (e) => { endY = e.changedTouches[0].screenY; if (endY > startY + 50) closeSlideMenu(); }, { passive:true });
    })();

    // ------- Notifications -------
    function showNotifications() {
        const notifications = [
            { title: 'การจัดส่งล่าสุด', message: 'คุณมีการจัดส่ง 260 ชิ้น', time: '2 นาทีที่แล้ว' },
            { title: 'คอมมิชชั่น', message: 'คุณได้รับคอมมิชชั่น 2,232 บาท', time: '5 นาทีที่แล้ว' },
            { title: 'ระบบอัปเดต', message: 'มีการอัปเดตระบบใหม่', time: '1 วันที่แล้ว' }
        ];
        if (window.Swal) {
            Swal.fire({
                title: 'การแจ้งเตือน',
                html: notifications.map(n => `
                    <div style=\"text-align:left; padding:10px; border-bottom:1px solid #eee; margin-bottom:10px;\">
                        <div style=\"font-weight:600; color:#FF6B35;\">${n.title}</div>
                        <div style=\"font-size:14px; color:#666; margin:5px 0;\">${n.message}</div>
                        <div style=\"font-size:12px; color:#999;\">${n.time}</div>
                    </div>`).join(''),
                confirmButtonColor: '#FF6B35', confirmButtonText: 'ปิด', width: '90%', showCloseButton: true
            });
        } else { alert(notifications.map(n => `${n.title}: ${n.message}`).join('\n')); }
        const badge = document.getElementById('notificationCount');
        if (badge) { badge.textContent = '0'; badge.style.display = 'none'; }
        const badgeM = document.getElementById('notificationCountMobile');
        if (badgeM) { badgeM.textContent = '0'; badgeM.style.display = 'none'; }
    }

    // ------- Logout -------
    function confirmLogout(event) {
        event?.preventDefault?.();
        if (window.Swal) {
            Swal.fire({
                title: 'ยืนยันการออกจากระบบ', text: 'คุณต้องการออกจากระบบหรือไม่?', icon: 'question',
                showCancelButton: true, confirmButtonColor: '#FF6B35', cancelButtonColor: '#94a3b8',
                confirmButtonText: 'ออกจากระบบ', cancelButtonText: 'ยกเลิก'
            }).then((r) => {
                if (r.isConfirmed) {
                    const f = document.createElement('form');
                    f.method = 'POST'; f.action = '{{ route('logout') }}';
                    const t = document.createElement('input'); t.type = 'hidden'; t.name = '_token'; t.value = document.querySelector('meta[name="csrf-token"]').content;
                    f.appendChild(t); document.body.appendChild(f); f.submit();
                }
            });
        } else {
            if (confirm('คุณต้องการออกจากระบบหรือไม่?')) { window.location.href = '{{ route('logout') }}'; }
        }
    }

    // ------- Init -------
    document.addEventListener('DOMContentLoaded', function() {
        // Loading
        setTimeout(hideLoading, 400);

        // Hook menu buttons
        ['#menuButton', '#adminMenuButton', '#headerMenuButton'].forEach(id => {
            const el = document.querySelector(id);
            if (!el) return;
            el.addEventListener('click', (e) => { e.preventDefault(); openSlideMenu(); });
            el.addEventListener('touchstart', (e) => { e.preventDefault(); openSlideMenu(); }, { passive:false });
        });

        // Touch feedback for buttons
        document.querySelectorAll('.mobile-header-btn, .header-btn').forEach(btn => {
            btn.addEventListener('touchstart', () => btn.style.transform = 'scale(0.95)');
            btn.addEventListener('touchend', () => btn.style.transform = '');
        });

        // Session messages
        @if(session('success')) showToast(`{{ session('success') }}`, 'success'); @endif
        @if(session('error'))   showToast(`{{ session('error') }}`, 'error');   @endif
        @if(session('warning')) showToast(`{{ session('warning') }}`, 'warning'); @endif

        // PWA service worker
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.register('/sw.js').catch(() => {});
        }
    });
    </script>

    @stack('scripts')
</body>
</html>
