@extends('layouts.app')

@section('title', 'Privacy Policy')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card shadow-sm">
                <div class="card-body p-5">
                    <h1 class="text-center mb-5">Privacy Policy</h1>
                    
                    <div class="text-muted text-center mb-5">
                        <small>Effective Date: {{ now()->format('F d, Y') }}</small>
                    </div>

                    <div class="privacy-content">
                        <section class="mb-5">
                            <h2 class="h4 mb-3">1. Introduction</h2>
                            <p>
                                The Warehouse and Commission Management System ("System") values the protection of our users' personal data. 
                                This Privacy Policy explains how we collect, use, disclose, and protect your information.
                            </p>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">2. Information We Collect</h2>
                            <p>We collect the following types of information:</p>
                            
                            <h5 class="mt-3">2.1 Personal Information</h5>
                            <ul>
                                <li>Full name</li>
                                <li>Email address</li>
                                <li>Phone number (if provided)</li>
                                <li>Employee ID</li>
                                <li>Assigned warehouse information</li>
                            </ul>

                            <h5 class="mt-3">2.2 Work Information</h5>
                            <ul>
                                <li>Delivery history</li>
                                <li>Number of parcels delivered</li>
                                <li>Commission data</li>
                                <li>Vehicle type used</li>
                                <li>Working dates and times</li>
                            </ul>

                            <h5 class="mt-3">2.3 Financial Information</h5>
                            <ul>
                                <li>Income and expenses</li>
                                <li>Savings data</li>
                                <li>Monthly budgets</li>
                                <li>Transaction history</li>
                            </ul>

                            <h5 class="mt-3">2.4 Technical Information</h5>
                            <ul>
                                <li>IP address</li>
                                <li>Browser type</li>
                                <li>Access times</li>
                                <li>Pages visited</li>
                            </ul>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">3. How We Use Your Information</h2>
                            <p>We use your information to:</p>
                            <ul>
                                <li>Manage and operate the system services</li>
                                <li>Calculate commissions and earnings</li>
                                <li>Generate reports and work statistics</li>
                                <li>Improve and develop our services</li>
                                <li>Communicate with you about system usage</li>
                                <li>Prevent fraud and maintain security</li>
                                <li>Comply with legal requirements</li>
                            </ul>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">4. Information Disclosure</h2>
                            <p>We may disclose your information in the following cases:</p>
                            <ul>
                                <li><strong>Management and Supervisors:</strong> For performance evaluation and personnel management</li>
                                <li><strong>Accounting and Finance:</strong> For commission payments and tax management</li>
                                <li><strong>Third-party Service Providers:</strong> Who assist in system operations (under confidentiality agreements)</li>
                                <li><strong>Government Agencies:</strong> When legally required</li>
                            </ul>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">5. Data Security</h2>
                            <p>We implement appropriate security measures including:</p>
                            <ul>
                                <li>SSL/TLS encryption</li>
                                <li>Password hashing</li>
                                <li>Role-based access control</li>
                                <li>Regular data backups</li>
                                <li>System access monitoring and logging</li>
                            </ul>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">6. Data Retention</h2>
                            <p>We retain your data for the following periods:</p>
                            <ul>
                                <li><strong>Work data:</strong> 5 years after employment ends</li>
                                <li><strong>Financial data:</strong> 5 years as per tax requirements</li>
                                <li><strong>Login data:</strong> 90 days</li>
                                <li><strong>Other personal data:</strong> For the duration of your system usage</li>
                            </ul>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">7. Your Rights</h2>
                            <p>Under data protection laws, you have the following rights:</p>
                            <ul>
                                <li><strong>Right to Access:</strong> Request copies of your personal data</li>
                                <li><strong>Right to Rectification:</strong> Correct inaccurate or incomplete data</li>
                                <li><strong>Right to Erasure:</strong> Request deletion of data in certain circumstances</li>
                                <li><strong>Right to Object:</strong> Object to certain types of processing</li>
                                <li><strong>Right to Portability:</strong> Receive data in machine-readable format</li>
                                <li><strong>Right to Withdraw:</strong> Withdraw consent (where applicable)</li>
                            </ul>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">8. Cookies</h2>
                            <p>
                                We use cookies to improve your user experience. Cookies help the system remember your settings and login sessions. 
                                You can disable cookies in your browser, but this may affect certain system functions.
                            </p>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">9. Policy Updates</h2>
                            <p>
                                We may update this Privacy Policy from time to time. 
                                If there are significant changes, we will notify you via email or system announcement.
                            </p>
                        </section>

                        <section class="mb-5">
                            <h2 class="h4 mb-3">10. Contact Us</h2>
                            <p>If you have questions about this Privacy Policy or wish to exercise your rights, please contact:</p>
                            <div class="bg-light p-4 rounded">
                                <p class="mb-2"><strong>Data Protection Officer</strong></p>
                                <p class="mb-1">Email: privacy@warehouse-system.com</p>
                                <p class="mb-1">Phone: +66 2-XXX-XXXX</p>
                                <p class="mb-0">Address: [Company Address]</p>
                            </div>
                        </section>

                        <div class="text-center mt-5">
                            <a href="{{ url()->previous() }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .privacy-content {
        line-height: 1.8;
        color: #333;
    }
    
    .privacy-content h2 {
        color: #2c3e50;
        margin-top: 2rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #e9ecef;
    }
    
    .privacy-content h5 {
        color: #34495e;
        font-weight: 600;
    }
    
    .privacy-content ul {
        list-style-type: disc;
        padding-left: 2rem;
    }
    
    .privacy-content ul li {
        margin-bottom: 0.5rem;
    }
    
    .privacy-content p {
        text-align: justify;
        margin-bottom: 1rem;
    }
    
    @media print {
        .btn {
            display: none;
        }
        
        .card {
            box-shadow: none !important;
            border: none !important;
        }
    }
</style>
@endpush