@extends('layouts.app')
@section('title', 'แก้ไขบันทึกการจัดส่งพัสดุ')
@section('page-title', 'แก้ไขบันทึกการจัดส่ง')
@section('mobile-title', 'แก้ไขการจัดส่ง')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Modern Page Header -->
    <div class="mb-8">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div class="flex-1">
                <div class="flex items-center gap-3 mb-2">
                    <div class="w-12 h-12 bg-gradient-to-br from-orange-500 to-orange-600 rounded-xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-edit text-white text-xl"></i>
                    </div>
                    <div>
                        <h1 class="text-2xl lg:text-3xl font-bold text-gray-900">แก้ไขบันทึกการจัดส่งพัสดุ</h1>
                        <p class="text-gray-600 mt-1">แก้ไขข้อมูลการจัดส่งพัสดุของคุณ</p>
                    </div>
                </div>
            </div>
            <div class="flex flex-col sm:flex-row gap-3">
                <a href="{{ route('vehicle.dashboard') }}" 
                   class="inline-flex items-center justify-center px-4 py-2.5 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-all duration-200">
                    <i class="fas fa-arrow-left mr-2"></i>กลับหน้าแดชบอร์ด
                </a>
                <a href="{{ route('vehicle.deliveries.index') }}" 
                   class="inline-flex items-center justify-center px-4 py-2.5 bg-gradient-to-r from-blue-500 to-blue-600 text-white font-medium rounded-xl hover:from-blue-600 hover:to-blue-700 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                    <i class="fas fa-list mr-2"></i>ไปหน้าประวัติ
                </a>
            </div>
        </div>
    </div>
        
    <!-- Current Record Info -->
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-8">
        <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-6 py-4 border-b border-gray-200">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <i class="fas fa-info-circle text-white"></i>
                </div>
                <h3 class="text-lg font-semibold text-gray-900">ข้อมูลเดิม</h3>
            </div>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <div class="text-center p-4 bg-gradient-to-br from-orange-50 to-orange-100 rounded-xl border border-orange-200">
                    <div class="text-sm font-medium text-gray-600 mb-1">วันที่จัดส่ง</div>
                    <div class="text-xl font-bold text-orange-600">
                        {{ \Carbon\Carbon::parse($delivery->delivery_date)->format('d/m/Y') }}
                    </div>
                </div>
                <div class="text-center p-4 bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl border border-blue-200">
                    <div class="text-sm font-medium text-gray-600 mb-1">จำนวนพัสดุ</div>
                    <div class="text-xl font-bold text-blue-600">
                        {{ number_format($delivery->parcel_count) }} ชิ้น
                    </div>
                </div>
                <div class="text-center p-4 bg-gradient-to-br from-green-50 to-green-100 rounded-xl border border-green-200">
                    <div class="text-sm font-medium text-gray-600 mb-1">ค่าคอมมิชชั่น</div>
                    <div class="text-xl font-bold text-green-600">
                        {{ number_format($delivery->commission_amount, 2) }} บาท
                    </div>
                </div>
                <div class="text-center p-4 bg-gradient-to-br from-gray-50 to-gray-100 rounded-xl border border-gray-200">
                    <div class="text-sm font-medium text-gray-600 mb-1">บันทึกเมื่อ</div>
                    <div class="text-lg font-bold text-gray-700">
                        {{ \Carbon\Carbon::parse($delivery->created_at)->format('d/m/Y H:i') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
        
    <!-- Form Container -->
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="bg-gradient-to-r from-orange-500 to-orange-600 px-6 py-6">
            <div class="flex items-center gap-3">
                <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center">
                    <i class="fas fa-edit text-white text-xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-white">แก้ไขข้อมูลการจัดส่ง</h3>
            </div>
        </div>
        
        <form method="POST" action="{{ route('vehicle.deliveries.update', $delivery) }}" autocomplete="off" id="delivery-form" class="p-6">
            @csrf
            @method('PUT')
            
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- วันที่จัดส่ง -->
                <div class="space-y-2">
                    <label for="delivery_date" class="block text-sm font-semibold text-gray-700">
                        <i class="fas fa-calendar-alt text-orange-500 mr-2"></i>วันที่จัดส่ง <span class="text-red-500">*</span>
                    </label>
                    <input type="date" name="delivery_date" id="delivery_date"
                        class="block w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition-all duration-200 @error('delivery_date') border-red-500 ring-2 ring-red-200 @enderror"
                        value="{{ old('delivery_date', \Carbon\Carbon::parse($delivery->delivery_date)->format('Y-m-d')) }}" required>
                    @error('delivery_date')
                        <p class="text-red-500 text-sm flex items-center gap-1">
                            <i class="fas fa-exclamation-circle"></i>{{ $message }}
                        </p>
                    @enderror
                    <p class="text-amber-600 text-sm flex items-center gap-1 bg-amber-50 px-3 py-2 rounded-lg">
                        <i class="fas fa-exclamation-triangle"></i>
                        การเปลี่ยนวันที่อาจส่งผลต่อการคำนวณสถิติรายเดือน
                    </p>
                </div>

                <!-- จำนวนพัสดุ -->
                <div class="space-y-2">
                    <label for="parcel_count" class="block text-sm font-semibold text-gray-700">
                        <i class="fas fa-box text-blue-500 mr-2"></i>จำนวนพัสดุที่จัดส่งสำเร็จ (ชิ้น) <span class="text-red-500">*</span>
                    </label>
                    <input type="number" min="1" step="1"
                        class="block w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition-all duration-200 @error('parcel_count') border-red-500 ring-2 ring-red-200 @enderror"
                        id="parcel_count" name="parcel_count" placeholder="กรอกจำนวนพัสดุ"
                        value="{{ old('parcel_count', $delivery->parcel_count) }}" required>
                    @error('parcel_count')
                        <p class="text-red-500 text-sm flex items-center gap-1">
                            <i class="fas fa-exclamation-circle"></i>{{ $message }}
                        </p>
                    @enderror
                </div>
            </div>

            <!-- ข้อมูลผู้ใช้ -->
            <div class="mt-6 space-y-2">
                <label class="block text-sm font-semibold text-gray-700">
                    <i class="fas fa-user text-purple-500 mr-2"></i>ข้อมูลของคุณ
                </label>
                <div class="bg-gradient-to-r from-gray-50 to-gray-100 rounded-xl p-4 border border-gray-200">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                                <i class="fas fa-id-badge text-white"></i>
                            </div>
                            <div>
                                <div class="text-sm font-medium text-gray-600">ตำแหน่ง</div>
                                <div class="font-semibold text-gray-900">{{ auth()->user()->role }}</div>
                            </div>
                        </div>
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                                <i class="fas fa-warehouse text-white"></i>
                            </div>
                            <div>
                                <div class="text-sm font-medium text-gray-600">คลัง</div>
                                <div class="font-semibold text-gray-900">
                                    {{ auth()->user()->warehouse->warehouse_name ?? auth()->user()->warehouse_code ?? '-' }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Commission Preview -->
            <div class="mt-6 space-y-2">
                <label class="block text-sm font-semibold text-gray-700">
                    <i class="fas fa-calculator text-green-500 mr-2"></i>การคำนวณค่าคอมมิชชั่นใหม่
                </label>
                <div id="commission-preview" class="bg-gradient-to-br from-green-50 to-green-100 rounded-xl p-6 border border-green-200">
                    <div id="rate-info">
                        <div class="text-center text-gray-600 py-8">
                            <div class="w-16 h-16 bg-green-200 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-calculator text-green-600 text-2xl"></i>
                            </div>
                            <p class="text-lg font-medium">กำลังคำนวณค่าคอมมิชชั่น...</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Comparison Section -->
            <div class="mt-6" id="comparison-section" style="display: none;">
                <label class="block text-sm font-semibold text-gray-700 mb-3">
                    <i class="fas fa-exchange-alt text-purple-500 mr-2"></i>เปรียบเทียบการเปลี่ยนแปลง
                </label>
                <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl p-6 border border-blue-200">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div class="bg-white rounded-xl p-4 text-center shadow-sm">
                            <div class="text-sm font-medium text-gray-600 mb-2">ค่าคอมมิชชั่นเดิม</div>
                            <div class="text-2xl font-bold text-orange-600">
                                {{ number_format($delivery->commission_amount, 2) }} บาท
                            </div>
                        </div>
                        <div class="bg-white rounded-xl p-4 text-center shadow-sm">
                            <div class="text-sm font-medium text-gray-600 mb-2">ค่าคอมมิชชั่นใหม่</div>
                            <div id="new-commission" class="text-2xl font-bold text-green-600">
                                คำนวณ...
                            </div>
                        </div>
                    </div>
                    <div id="difference-info" class="text-center py-3 px-4 rounded-xl font-medium">
                        <!-- Difference will be shown here -->
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center mt-8 pt-6 border-t border-gray-200">
                <button type="submit" 
                        class="inline-flex items-center justify-center px-8 py-3 bg-gradient-to-r from-orange-500 to-orange-600 text-white font-semibold rounded-xl hover:from-orange-600 hover:to-orange-700 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                    <i class="fas fa-save mr-2"></i>บันทึกการแก้ไข
                </button>
                <a href="{{ route('vehicle.deliveries.index') }}" 
                   class="inline-flex items-center justify-center px-8 py-3 bg-gray-100 text-gray-700 font-semibold rounded-xl hover:bg-gray-200 transition-all duration-200">
                    <i class="fas fa-times mr-2"></i>ยกเลิก
                </a>
                <button type="button" onclick="deleteRecord({{ $delivery->id }})"
                        class="inline-flex items-center justify-center px-8 py-3 bg-gradient-to-r from-red-500 to-red-600 text-white font-semibold rounded-xl hover:from-red-600 hover:to-red-700 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                    <i class="fas fa-trash mr-2"></i>ลบบันทึก
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('styles')
<script>
  const originalWarn = console.warn;
  console.warn = function(...args) {
    if (args[0] && args[0].includes('cdn.tailwindcss.com should not be used in production')) {
      return;
    }
    originalWarn.apply(console, args);
  };
</script>
<script src="https://cdn.tailwindcss.com"></script>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const parcelInput = document.getElementById('parcel_count');
    const rateInfo = document.getElementById('rate-info');
    const comparisonSection = document.getElementById('comparison-section');
    const newCommissionEl = document.getElementById('new-commission');
    const differenceInfo = document.getElementById('difference-info');
    const oldCommission = {{ $delivery->commission_amount }};

    function fetchPreview() {
        const count = parcelInput.value;

        if (!count || count <= 0) {
            rateInfo.innerHTML = `
                <div style="text-align: center; color: var(--gray); padding: 2rem;">
                    <i class="fas fa-calculator" style="font-size: 3rem; margin-bottom: 1rem; display: block; opacity: 0.5;"></i>
                    <p style="margin: 0; font-size: 1.1rem;">กรอกจำนวนพัสดุเพื่อดูการคำนวณค่าคอมมิชชั่น</p>
                </div>
            `;
            comparisonSection.style.display = 'none';
            return;
        }
        
        rateInfo.innerHTML = `
            <div style="text-align: center; color: var(--info); padding: 2rem;">
                <i class="fas fa-spinner fa-spin" style="font-size: 3rem; margin-bottom: 1rem; display: block;"></i>
                <p style="margin: 0; font-size: 1.1rem;">กำลังคำนวณค่าคอมมิชชั่น...</p>
            </div>
        `;
        
        fetch("{{ route('vehicle.deliveries.preview-commission') }}", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                parcel_count: count
            })
        })
        .then(res => {
            if (!res.ok) throw new Error('Network response was not ok');
            return res.json();
        })
        .then(data => {
            rateInfo.innerHTML = data.preview_html;
            
            // Show comparison
            const newCommission = parseFloat(data.commission);
            newCommissionEl.textContent = newCommission.toLocaleString('th-TH', {minimumFractionDigits: 2}) + ' บาท';
            
            const difference = newCommission - oldCommission;
            let diffHtml = '';
            let diffClass = '';
            
            if (difference > 0) {
                diffHtml = `<i class="fas fa-arrow-up"></i> เพิ่มขึ้น ${difference.toLocaleString('th-TH', {minimumFractionDigits: 2})} บาท`;
                diffClass = 'background: #d4edda; color: #155724; border: 1px solid #c3e6cb;';
            } else if (difference < 0) {
                diffHtml = `<i class="fas fa-arrow-down"></i> ลดลง ${Math.abs(difference).toLocaleString('th-TH', {minimumFractionDigits: 2})} บาท`;
                diffClass = 'background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;';
            } else {
                diffHtml = `<i class="fas fa-equals"></i> ไม่เปลี่ยนแปลง`;
                diffClass = 'background: #e2e3e5; color: #383d41; border: 1px solid #d6d8db;';
            }
            
            differenceInfo.innerHTML = diffHtml;
            differenceInfo.style.cssText = diffClass;
            comparisonSection.style.display = 'block';
        })
        .catch((error) => {
            console.error('Error:', error);
            Swal.fire({
                toast:true, position:'top-end',
                icon: 'error',
                title: 'เกิดข้อผิดพลาด',
                text: 'ไม่สามารถคำนวณค่าคอมมิชชั่นได้ กรุณาลองใหม่อีกครั้ง'
            });
            rateInfo.innerHTML = `
                <div style="text-align: center; color: #F44336; padding: 2rem;">
                    <i class="fas fa-exclamation-triangle" style="font-size: 3rem; margin-bottom: 1rem; display: block;"></i>
                    <p style="margin: 0; font-size: 1.1rem;">เกิดข้อผิดพลาดในการคำนวณ</p>
                    <button onclick="fetchPreview()" class="btn btn-sm" style="background: var(--info); color: white; margin-top: 1rem;">
                        <i class="fas fa-redo"></i> ลองใหม่
                    </button>
                </div>
            `;
        });
    }

    // Event listener for parcel count input
    parcelInput.addEventListener('input', function() {
        clearTimeout(this.timeout);
        this.timeout = setTimeout(fetchPreview, 500); // Debounce 500ms
    });

    // Validate delivery date for duplicates (exclude current record)
    document.getElementById('delivery_date').addEventListener('change', function() {
        const date = this.value;
        if (!date) return;

        fetch("/api/validate-delivery-date", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                delivery_date: date,
                delivery_id: {{ $delivery->id }}
            })
        })
        .then(res => res.json())
        .then(data => {
            if (!data.valid) {
                Swal.fire({
                    icon: 'warning',
                    title: 'วันที่ซ้ำ',
                    text: data.message,
                    confirmButtonText: 'เข้าใจแล้ว'
                });
                this.style.borderColor = '#dc3545';
                this.style.boxShadow = '0 0 0 0.2rem rgba(220, 53, 69, 0.25)';
            } else {
                this.style.borderColor = '#28a745';
                this.style.boxShadow = '0 0 0 0.2rem rgba(40, 167, 69, 0.25)';
            }
        })
        .catch(error => {
            console.error('Validation error:', error);
        });
    });

    // Initial calculation
    fetchPreview();
});

// Delete record function
function deleteRecord(id) {
    Swal.fire({
        title: 'ยืนยันการลบ',
        text: 'คุณต้องการลบบันทึกการจัดส่งนี้หรือไม่? การลบจะไม่สามารถกู้คืนได้',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก',
        confirmButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/vehicle/deliveries/${id}`;
            
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '{{ csrf_token() }}';
            
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'DELETE';
            
            form.appendChild(csrfToken);
            form.appendChild(methodField);
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Show validation errors
@if($errors->any())
    Swal.fire({
        icon: 'error',
        title: 'ข้อมูลไม่ถูกต้อง',
        html: `{!! implode('<br>', $errors->all()) !!}`,
        confirmButtonText: 'ตกลง'
    });
@endif

// Show success message
@if(session('success'))
    Swal.fire({
        icon: 'success',
        title: 'แก้ไขสำเร็จ',
        text: '{{ session('success') }}',
        timer: 2000,
        showConfirmButton: false
    });
@endif
</script>
@endpush

@push('styles')
<style>
/* Modern Delivery Edit Styles */
.max-w-7xl {
    max-width: 80rem;
}

.mx-auto {
    margin-left: auto;
    margin-right: auto;
}

.px-4 {
    padding-left: 1rem;
    padding-right: 1rem;
}

.py-8 {
    padding-top: 2rem;
    padding-bottom: 2rem;
}

.mb-8 {
    margin-bottom: 2rem;
}

.flex {
    display: flex;
}

.flex-col {
    flex-direction: column;
}

.items-center {
    align-items: center;
}

.justify-center {
    justify-content: center;
}

.gap-3 {
    gap: 0.75rem;
}

.gap-4 {
    gap: 1rem;
}

.gap-6 {
    gap: 1.5rem;
}

.w-12 {
    width: 3rem;
}

.h-12 {
    height: 3rem;
}

.w-10 {
    width: 2.5rem;
}

.h-10 {
    height: 2.5rem;
}

.w-16 {
    width: 4rem;
}

.h-16 {
    height: 4rem;
}

.bg-gradient-to-br {
    background-image: linear-gradient(to bottom right, var(--tw-gradient-stops));
}

.bg-gradient-to-r {
    background-image: linear-gradient(to right, var(--tw-gradient-stops));
}

.from-orange-500 {
    --tw-gradient-from: #f97316;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(249, 115, 22, 0));
}

.to-orange-600 {
    --tw-gradient-to: #ea580c;
}

.from-blue-500 {
    --tw-gradient-from: #3b82f6;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(59, 130, 246, 0));
}

.to-blue-600 {
    --tw-gradient-to: #2563eb;
}

.from-green-500 {
    --tw-gradient-from: #22c55e;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(34, 197, 94, 0));
}

.to-green-600 {
    --tw-gradient-to: #16a34a;
}

.from-red-500 {
    --tw-gradient-from: #ef4444;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(239, 68, 68, 0));
}

.to-red-600 {
    --tw-gradient-to: #dc2626;
}

.from-purple-500 {
    --tw-gradient-from: #8b5cf6;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(139, 92, 246, 0));
}

.to-purple-600 {
    --tw-gradient-to: #7c3aed;
}

.rounded-xl {
    border-radius: 0.75rem;
}

.rounded-2xl {
    border-radius: 1rem;
}

.rounded-lg {
    border-radius: 0.5rem;
}

.rounded-full {
    border-radius: 9999px;
}

.shadow-lg {
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
}

.shadow-sm {
    box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
}

.shadow-xl {
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
}

.text-white {
    color: #ffffff;
}

.text-xl {
    font-size: 1.25rem;
}

.text-2xl {
    font-size: 1.5rem;
}

.text-3xl {
    font-size: 1.875rem;
}

.text-lg {
    font-size: 1.125rem;
}

.text-sm {
    font-size: 0.875rem;
}

.font-bold {
    font-weight: 700;
}

.font-semibold {
    font-weight: 600;
}

.font-medium {
    font-weight: 500;
}

.text-gray-900 {
    color: #111827;
}

.text-gray-700 {
    color: #374151;
}

.text-gray-600 {
    color: #4b5563;
}

.text-orange-600 {
    color: #ea580c;
}

.text-blue-600 {
    color: #2563eb;
}

.text-green-600 {
    color: #16a34a;
}

.text-red-500 {
    color: #ef4444;
}

.text-amber-600 {
    color: #d97706;
}

.text-purple-500 {
    color: #8b5cf6;
}

.text-blue-500 {
    color: #3b82f6;
}

.text-green-500 {
    color: #22c55e;
}

.grid {
    display: grid;
}

.grid-cols-1 {
    grid-template-columns: repeat(1, minmax(0, 1fr));
}

.grid-cols-2 {
    grid-template-columns: repeat(2, minmax(0, 1fr));
}

@media (min-width: 768px) {
    .md\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
}

@media (min-width: 1024px) {
    .lg\:grid-cols-4 {
        grid-template-columns: repeat(4, minmax(0, 1fr));
    }
    .lg\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
    .lg\:flex-row {
        flex-direction: row;
    }
    .lg\:items-center {
        align-items: center;
    }
    .lg\:justify-between {
        justify-content: space-between;
    }
    .lg\:text-3xl {
        font-size: 1.875rem;
    }
}

@media (min-width: 640px) {
    .sm\:px-6 {
        padding-left: 1.5rem;
        padding-right: 1.5rem;
    }
    .sm\:flex-row {
        flex-direction: row;
    }
    .sm\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
}

.bg-white {
    background-color: #ffffff;
}

.bg-gray-100 {
    background-color: #f3f4f6;
}

.bg-amber-50 {
    background-color: #fffbeb;
}

.bg-green-200 {
    background-color: #bbf7d0;
}

.p-6 {
    padding: 1.5rem;
}

.p-4 {
    padding: 1rem;
}

.px-4 {
    padding-left: 1rem;
    padding-right: 1rem;
}

.py-3 {
    padding-top: 0.75rem;
    padding-bottom: 0.75rem;
}

.px-8 {
    padding-left: 2rem;
    padding-right: 2rem;
}

.px-3 {
    padding-left: 0.75rem;
    padding-right: 0.75rem;
}

.py-2 {
    padding-top: 0.5rem;
    padding-bottom: 0.5rem;
}

.py-8 {
    padding-top: 2rem;
    padding-bottom: 2rem;
}

.border {
    border-width: 1px;
}

.border-gray-100 {
    border-color: #f3f4f6;
}

.border-gray-200 {
    border-color: #e5e7eb;
}

.border-gray-300 {
    border-color: #d1d5db;
}

.border-orange-200 {
    border-color: #fed7aa;
}

.border-blue-200 {
    border-color: #bfdbfe;
}

.border-green-200 {
    border-color: #bbf7d0;
}

.border-red-500 {
    border-color: #ef4444;
}

.border-t {
    border-top-width: 1px;
}

.overflow-hidden {
    overflow: hidden;
}

.transition-all {
    transition-property: all;
    transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
    transition-duration: 150ms;
}

.duration-200 {
    transition-duration: 200ms;
}

.flex-1 {
    flex: 1 1 0%;
}

.mb-1 {
    margin-bottom: 0.25rem;
}

.mb-2 {
    margin-bottom: 0.5rem;
}

.mb-4 {
    margin-bottom: 1rem;
}

.mt-1 {
    margin-top: 0.25rem;
}

.mt-6 {
    margin-top: 1.5rem;
}

.mt-8 {
    margin-top: 2rem;
}

.mr-2 {
    margin-right: 0.5rem;
}

.mx-auto {
    margin-left: auto;
    margin-right: auto;
}

.block {
    display: block;
}

.inline-flex {
    display: inline-flex;
}

.space-y-2 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 0.5rem;
}

.w-full {
    width: 100%;
}

.focus\:ring-2:focus {
    box-shadow: 0 0 0 2px rgba(249, 115, 22, 0.5);
}

.focus\:ring-orange-500:focus {
    --tw-ring-color: #f97316;
}

.focus\:border-orange-500:focus {
    border-color: #f97316;
}

.ring-2 {
    box-shadow: 0 0 0 2px rgba(239, 68, 68, 0.2);
}

.ring-red-200 {
    --tw-ring-color: #fecaca;
}

.hover\:bg-gray-200:hover {
    background-color: #e5e7eb;
}

.hover\:from-orange-600:hover {
    --tw-gradient-from: #ea580c;
}

.hover\:to-orange-700:hover {
    --tw-gradient-to: #c2410c;
}

.hover\:from-blue-600:hover {
    --tw-gradient-from: #2563eb;
}

.hover\:to-blue-700:hover {
    --tw-gradient-to: #1d4ed8;
}

.hover\:from-red-600:hover {
    --tw-gradient-from: #dc2626;
}

.hover\:to-red-700:hover {
    --tw-gradient-to: #b91c1c;
}

.hover\:shadow-xl:hover {
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
}

.transform {
    transform: var(--tw-transform);
}

.hover\:-translate-y-0\.5:hover {
    --tw-translate-y: -0.125rem;
    transform: translateY(var(--tw-translate-y));
}

.text-center {
    text-align: center;
}

@media (max-width: 768px) {
    .grid-cols-1 {
        grid-template-columns: repeat(1, minmax(0, 1fr)) !important;
    }
    
    .flex-col {
        flex-direction: column !important;
    }
}
</style>
@endpush