@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-2xl font-bold mb-6">การแจ้งเตือน</h2>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- ทดสอบการแจ้งเตือน -->
            <div class="bg-blue-50 p-4 rounded-lg">
                <h3 class="text-lg font-semibold mb-4">ทดสอบการแจ้งเตือน</h3>
                
                <div class="space-y-3">
                    <button onclick="sendTestNotification('login')" 
                            class="w-full bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                        ทดสอบแจ้งเตือนเข้าสู่ระบบ
                    </button>
                    
                    <button onclick="sendTestNotification('password')" 
                            class="w-full bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                        ทดสอบแจ้งเตือนเปลี่ยนรหัสผ่าน
                    </button>
                    
                    <button onclick="sendTestNotification('profile')" 
                            class="w-full bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">
                        ทดสอบแจ้งเตือนอัปเดตข้อมูล
                    </button>
                    
                    <button onclick="sendTestNotification('report')" 
                            class="w-full bg-purple-500 text-white px-4 py-2 rounded hover:bg-purple-600">
                        ทดสอบส่งรายงาน
                    </button>
                </div>
            </div>
            
            <!-- ข้อมูลการแจ้งเตือน -->
            <div class="bg-gray-50 p-4 rounded-lg">
                <h3 class="text-lg font-semibold mb-4">ข้อมูลการแจ้งเตือน</h3>
                
                <div class="space-y-2 text-sm">
                    <p><strong>อีเมล:</strong> {{ auth()->user()->email }}</p>
                    <p><strong>ทะเบียนรถ:</strong> {{ $vehicle->license_plate ?? 'ไม่พบข้อมูล' }}</p>
                    <p><strong>ประเภทรถ:</strong> {{ $vehicle->vehicle_type ?? 'ไม่พบข้อมูล' }}</p>
                    <p><strong>เข้าสู่ระบบล่าสุด:</strong> 
                        {{ $vehicle->last_login_at ? $vehicle->last_login_at->format('d/m/Y H:i:s') : 'ไม่เคยเข้าสู่ระบบ' }}
                    </p>
                </div>
            </div>
        </div>
        
        <!-- คำอธิบายการแจ้งเตือน -->
        <div class="mt-6 bg-yellow-50 p-4 rounded-lg">
            <h3 class="text-lg font-semibold mb-3">ประเภทการแจ้งเตือน</h3>
            <ul class="space-y-2 text-sm">
                <li>🔐 <strong>การเข้าสู่ระบบ:</strong> แจ้งเตือนทุกครั้งที่มีการเข้าสู่ระบบ</li>
                <li>🔑 <strong>เปลี่ยนรหัสผ่าน:</strong> แจ้งเตือนเมื่อมีการเปลี่ยนรหัสผ่าน</li>
                <li>📝 <strong>อัปเดตข้อมูล:</strong> แจ้งเตือนเมื่อมีการแก้ไขข้อมูลส่วนตัว</li>
                <li>📊 <strong>รายงานผล:</strong> ส่งรายงานประจำวัน/สัปดาห์/เดือน</li>
            </ul>
        </div>
    </div>
</div>

<script>
function sendTestNotification(type) {
    const vehicleId = {{ $vehicle->id ?? 0 }};
    
    if (!vehicleId) {
        alert('ไม่พบข้อมูลรถ');
        return;
    }
    
    fetch(`/vehicle/notifications/test/${vehicleId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ type: type })
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message);
    })
    .catch(error => {
        console.error('Error:', error);
        alert('เกิดข้อผิดพลาด');
    });
}
</script>
@endsection