<?php $__env->startSection('title', 'จัดการคลังสินค้า - EazyCom Plus'); ?>
<?php $__env->startSection('page-title', 'จัดการคลังสินค้า'); ?>
<?php $__env->startSection('mobile-title', 'คลังสินค้า'); ?>

<?php $__env->startPush('styles'); ?>
<style>
:root {
    --primary: #FF6B35;
    --primary-dark: #E85D2F;
    --primary-light: #FF8C61;
    --gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    --gradient-soft: linear-gradient(135deg, #FFE5DB 0%, #FFD4C4 100%);
    --success: #22C55E;
    --warning: #F59E0B;
    --danger: #EF4444;
    --info: #3B82F6;
    --purple: #8B5CF6;
    --white: #FFFFFF;
    --gray-50: #F8FAFC;
    --gray-100: #F1F5F9;
    --gray-200: #E2E8F0;
    --gray-400: #94A3B8;
    --gray-500: #64748B;
    --gray-600: #475569;
    --gray-700: #334155;
    --gray-900: #0F172A;
    --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    --shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
    --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    --radius-md: 12px;
    --radius-lg: 16px;
    --radius-xl: 20px;
    --transition: all 0.2s ease;
}

.warehouses-page {
    padding: clamp(1rem, 4vw, 2rem);
    padding-bottom: clamp(2rem, 6vw, 4rem);
    background: var(--gray-50);
    min-height: 100vh;
}

.page-header {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: clamp(1.5rem, 4vw, 2rem);
    margin-bottom: clamp(1.5rem, 4vw, 2rem);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 1.5rem;
    flex-wrap: wrap;
}

.header-info {
    flex: 1;
    min-width: 280px;
}

.header-title {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 0.75rem;
}

.title-icon {
    width: clamp(40px, 8vw, 48px);
    height: clamp(40px, 8vw, 48px);
    background: var(--gradient);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--white);
    font-size: clamp(1rem, 3vw, 1.25rem);
    box-shadow: var(--shadow-md);
}

.title-text h1 {
    font-size: clamp(1.5rem, 4vw, 1.875rem);
    font-weight: 700;
    color: var(--gray-900);
    margin: 0;
    line-height: 1.2;
}

.title-text p {
    font-size: clamp(0.875rem, 2.5vw, 1rem);
    color: var(--gray-600);
    margin: 0;
}

.header-actions {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: clamp(0.625rem, 2vw, 0.75rem) clamp(1rem, 3vw, 1.25rem);
    border-radius: var(--radius-md);
    font-weight: 600;
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: var(--transition);
    white-space: nowrap;
}

.primary-btn {
    background: var(--gradient);
    color: var(--white);
    box-shadow: var(--shadow-md);
}

.primary-btn:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: var(--white);
}

.export-btn {
    background: var(--white);
    color: var(--info);
    border: 2px solid var(--info);
}

.export-btn:hover {
    background: var(--info);
    color: var(--white);
    transform: translateY(-2px);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: clamp(1rem, 3vw, 1.5rem);
    margin-bottom: clamp(1.5rem, 4vw, 2rem);
}

.stat-card {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: clamp(1.25rem, 3vw, 1.5rem);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    transition: var(--transition);
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: var(--gradient);
}

.stat-card.active::before { background: linear-gradient(135deg, var(--success) 0%, #16a34a 100%); }
.stat-card.users::before { background: linear-gradient(135deg, var(--purple) 0%, #7c3aed 100%); }
.stat-card.rates::before { background: linear-gradient(135deg, var(--warning) 0%, #d97706 100%); }

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: var(--shadow-lg);
}

.stat-content {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: clamp(48px, 8vw, 56px);
    height: clamp(48px, 8vw, 56px);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: clamp(1.25rem, 3vw, 1.5rem);
    color: var(--white);
    background: var(--gradient);
    flex-shrink: 0;
}

.stat-card.active .stat-icon { background: linear-gradient(135deg, var(--success) 0%, #16a34a 100%); }
.stat-card.users .stat-icon { background: linear-gradient(135deg, var(--purple) 0%, #7c3aed 100%); }
.stat-card.rates .stat-icon { background: linear-gradient(135deg, var(--warning) 0%, #d97706 100%); }

.stat-info {
    flex: 1;
}

.stat-number {
    font-size: clamp(1.75rem, 4vw, 2.25rem);
    font-weight: 800;
    color: var(--gray-900);
    line-height: 1;
    margin-bottom: 0.25rem;
}

.stat-label {
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    font-weight: 600;
    color: var(--gray-600);
    margin-bottom: 0.5rem;
}

.stat-trend {
    display: flex;
    align-items: center;
    gap: 0.375rem;
    font-size: clamp(0.7rem, 1.8vw, 0.75rem);
    color: var(--gray-500);
}

.filter-section {
    background: var(--white);
    border-radius: var(--radius-lg);
    margin-bottom: clamp(1.5rem, 4vw, 2rem);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    overflow: hidden;
}

.filter-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: clamp(1rem, 3vw, 1.25rem) clamp(1.25rem, 3vw, 1.5rem);
    background: var(--gradient-soft);
    border-bottom: 1px solid var(--gray-200);
}

.filter-title {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: var(--gray-900);
    font-size: clamp(0.875rem, 2.5vw, 1rem);
}

.filter-toggle {
    background: none;
    border: none;
    color: var(--primary);
    font-size: 1rem;
    cursor: pointer;
    padding: 0.5rem;
    border-radius: var(--radius-md);
    transition: var(--transition);
}

.filter-toggle:hover {
    background: rgba(255, 107, 53, 0.1);
}

.filter-content {
    padding: clamp(1rem, 3vw, 1.5rem);
    display: none;
}

.filter-content.show {
    display: block;
    animation: slideDown 0.3s ease;
}

@keyframes slideDown {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.filter-form {
    display: grid;
    gap: clamp(1rem, 3vw, 1.5rem);
}

.filter-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: clamp(0.75rem, 2vw, 1rem);
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.filter-label {
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    font-weight: 600;
    color: var(--gray-700);
}

.input-group {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray-400);
    font-size: 0.875rem;
    z-index: 1;
}

.filter-input, .filter-select {
    width: 100%;
    padding: clamp(0.625rem, 2vw, 0.75rem) clamp(2.5rem, 5vw, 2.75rem) clamp(0.625rem, 2vw, 0.75rem) clamp(0.75rem, 2vw, 1rem);
    border: 2px solid var(--gray-200);
    border-radius: var(--radius-md);
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    transition: var(--transition);
    background: var(--white);
}

.filter-input:focus, .filter-select:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.filter-actions {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.filter-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: clamp(0.625rem, 2vw, 0.75rem) clamp(1rem, 3vw, 1.25rem);
    border-radius: var(--radius-md);
    font-weight: 600;
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: var(--transition);
}

.search-btn {
    background: var(--gradient);
    color: var(--white);
}

.search-btn:hover {
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.clear-btn {
    background: var(--white);
    color: var(--gray-600);
    border: 2px solid var(--gray-300);
}

.clear-btn:hover {
    background: var(--gray-100);
    color: var(--gray-700);
}

.warehouses-container {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    overflow: hidden;
}

.container-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: clamp(1rem, 3vw, 1.25rem) clamp(1.25rem, 3vw, 1.5rem);
    background: var(--gradient-soft);
    border-bottom: 1px solid var(--gray-200);
}

.container-title {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: var(--gray-900);
    font-size: clamp(0.875rem, 2.5vw, 1rem);
}

.container-count {
    font-size: clamp(0.75rem, 2vw, 0.875rem);
    color: var(--gray-600);
    background: var(--white);
    padding: 0.375rem 0.75rem;
    border-radius: var(--radius-md);
    border: 1px solid var(--gray-200);
}

.desktop-table {
    display: block;
    overflow-x: auto;
}

@media (max-width: 768px) {
    .desktop-table {
        display: none;
    }
}

.warehouses-table {
    width: 100%;
    border-collapse: collapse;
}

.warehouses-table th {
    background: var(--gray-50);
    padding: 1rem;
    text-align: left;
    font-weight: 600;
    color: var(--gray-700);
    font-size: 0.875rem;
    border-bottom: 2px solid var(--gray-200);
    white-space: nowrap;
}

.warehouses-table td {
    padding: 1rem;
    border-bottom: 1px solid var(--gray-200);
    vertical-align: middle;
}

.warehouse-row {
    transition: var(--transition);
    cursor: pointer;
}

.warehouse-row:hover {
    background: rgba(255, 107, 53, 0.02);
}

.warehouse-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.warehouse-avatar {
    width: 40px;
    height: 40px;
    border-radius: var(--radius-md);
    background: var(--gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--white);
    font-weight: 600;
    font-size: 0.875rem;
    flex-shrink: 0;
}

.warehouse-details {
    min-width: 0;
}

.warehouse-code {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
    margin-bottom: 0.125rem;
}

.warehouse-name {
    font-size: 0.75rem;
    color: var(--gray-500);
    margin-bottom: 0.125rem;
}

.warehouse-location {
    font-size: 0.7rem;
    color: var(--gray-400);
}

.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.375rem 0.75rem;
    border-radius: var(--radius-md);
    font-size: 0.75rem;
    font-weight: 600;
    white-space: nowrap;
}

.status-badge.status-active {
    background: rgba(34, 197, 94, 0.1);
    color: var(--success);
    border: 1px solid rgba(34, 197, 94, 0.2);
}

.status-badge.status-inactive {
    background: rgba(239, 68, 68, 0.1);
    color: var(--danger);
    border: 1px solid rgba(239, 68, 68, 0.2);
}

.count-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.375rem 0.75rem;
    border-radius: var(--radius-md);
    font-size: 0.75rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.count-users {
    background: rgba(139, 92, 246, 0.1);
    color: var(--purple);
    border: 1px solid rgba(139, 92, 246, 0.2);
}

.count-rates {
    background: rgba(245, 158, 11, 0.1);
    color: var(--warning);
    border: 1px solid rgba(245, 158, 11, 0.2);
}

.count-detail {
    font-size: 0.7rem;
    color: var(--gray-500);
    text-align: center;
}

.date-info {
    display: flex;
    flex-direction: column;
    gap: 0.125rem;
}

.date-main {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
}

.date-time {
    font-size: 0.75rem;
    color: var(--gray-500);
}

.action-buttons {
    display: flex;
    gap: 0.375rem;
    align-items: center;
}

.action-buttons .action-btn {
    width: 32px;
    height: 32px;
    padding: 0;
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.875rem;
    border: none;
    cursor: pointer;
    transition: var(--transition);
}

.edit-btn {
    background: rgba(59, 130, 246, 0.1);
    color: var(--info);
}

.edit-btn:hover {
    background: var(--info);
    color: var(--white);
    transform: translateY(-1px);
}

.toggle-btn {
    background: rgba(245, 158, 11, 0.1);
    color: var(--warning);
}

.toggle-btn:hover {
    background: var(--warning);
    color: var(--white);
    transform: translateY(-1px);
}

.commission-btn {
    background: rgba(139, 92, 246, 0.1);
    color: var(--purple);
}

.commission-btn:hover {
    background: var(--purple);
    color: var(--white);
    transform: translateY(-1px);
}

.delete-btn {
    background: rgba(239, 68, 68, 0.1);
    color: var(--danger);
}

.delete-btn:hover {
    background: var(--danger);
    color: var(--white);
    transform: translateY(-1px);
}

.mobile-cards {
    display: none;
    padding: 1rem;
    gap: 1rem;
    flex-direction: column;
}

@media (max-width: 768px) {
    .mobile-cards {
        display: flex;
    }
}

.warehouse-card {
    background: var(--white);
    border: 1px solid var(--gray-200);
    border-radius: var(--radius-lg);
    padding: 1rem;
    transition: var(--transition);
}

.warehouse-card:hover {
    box-shadow: var(--shadow-md);
    border-color: var(--primary);
}

.card-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1rem;
}

.card-header .warehouse-info {
    flex: 1;
}

.card-menu-btn {
    width: 32px;
    height: 32px;
    border: none;
    background: var(--gray-100);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--gray-600);
    cursor: pointer;
    transition: var(--transition);
}

.card-menu-btn:hover {
    background: var(--primary);
    color: var(--white);
}

.card-body {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.card-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 0.5rem;
}

.row-label {
    font-size: 0.875rem;
    color: var(--gray-600);
    font-weight: 500;
    flex-shrink: 0;
}

.row-value {
    font-size: 0.875rem;
    color: var(--gray-900);
    font-weight: 600;
    text-align: right;
}

.card-actions {
    display: none;
    flex-direction: column;
    gap: 0.5rem;
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid var(--gray-200);
    animation: slideDown 0.3s ease;
}

.card-action-btn {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem;
    border: none;
    background: var(--gray-50);
    border-radius: var(--radius-md);
    font-size: 0.875rem;
    font-weight: 500;
    color: var(--gray-700);
    cursor: pointer;
    transition: var(--transition);
    text-decoration: none;
}

.card-action-btn.edit:hover {
    background: rgba(59, 130, 246, 0.1);
    color: var(--info);
}

.card-action-btn.toggle:hover {
    background: rgba(245, 158, 11, 0.1);
    color: var(--warning);
}

.card-action-btn.commission:hover {
    background: rgba(139, 92, 246, 0.1);
    color: var(--purple);
}

.card-action-btn.delete:hover {
    background: rgba(239, 68, 68, 0.1);
    color: var(--danger);
}

.empty-state, .empty-state-mobile {
    text-align: center;
    padding: clamp(2rem, 6vw, 4rem);
}

.empty-icon {
    width: clamp(64px, 12vw, 80px);
    height: clamp(64px, 12vw, 80px);
    margin: 0 auto 1.5rem;
    background: var(--gradient-soft);
    border-radius: var(--radius-xl);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: clamp(1.5rem, 4vw, 2rem);
    color: var(--primary);
}

.empty-text h3 {
    font-size: clamp(1.125rem, 3vw, 1.25rem);
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 0.5rem;
}

.empty-text p {
    font-size: clamp(0.875rem, 2.5vw, 1rem);
    color: var(--gray-600);
    margin-bottom: 1.5rem;
}

.empty-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: var(--gradient);
    color: var(--white);
    border-radius: var(--radius-md);
    text-decoration: none;
    font-weight: 600;
    transition: var(--transition);
}

.empty-btn:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: var(--white);
}

.bulk-actions {
    display: none;
    align-items: center;
    justify-content: space-between;
    background: var(--gradient);
    color: var(--white);
    padding: 1rem 1.5rem;
    border-radius: var(--radius-lg);
    margin-bottom: 1rem;
    box-shadow: var(--shadow-md);
}

.bulk-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.bulk-icon {
    width: 32px;
    height: 32px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
}

.bulk-text {
    font-weight: 600;
}

.bulk-buttons {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.bulk-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.5rem 1rem;
    border: none;
    border-radius: var(--radius-md);
    font-size: 0.875rem;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition);
    background: rgba(255, 255, 255, 0.2);
    color: var(--white);
}

.bulk-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-1px);
}

.pagination-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem 1.5rem;
    background: var(--gray-50);
    border-top: 1px solid var(--gray-200);
    flex-wrap: wrap;
    gap: 1rem;
}

.pagination-info {
    font-size: 0.875rem;
    color: var(--gray-600);
}

@media (max-width: 640px) {
    .header-content {
        flex-direction: column;
        align-items: stretch;
    }
    
    .header-actions {
        justify-content: stretch;
    }
    
    .action-btn {
        flex: 1;
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .filter-row {
        grid-template-columns: 1fr;
    }
    
    .filter-actions {
        justify-content: stretch;
    }
    
    .filter-btn {
        flex: 1;
        justify-content: center;
    }
}

@media (max-width: 480px) {
    .warehouses-page {
        padding: 1rem;
        padding-bottom: 3rem;
    }
    
    .stat-content {
        flex-direction: column;
        text-align: center;
        gap: 0.75rem;
    }
    
    .container-header {
        flex-direction: column;
        gap: 0.75rem;
        align-items: stretch;
    }
}

.table-checkbox, .card-checkbox {
    width: 18px;
    height: 18px;
    accent-color: var(--primary);
    cursor: pointer;
}

.loading {
    opacity: 0.6;
    pointer-events: none;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.fade-in {
    animation: fadeIn 0.3s ease;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="warehouses-page">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-info">
                <div class="header-title">
                    <div class="title-icon">
                        <i class="fas fa-warehouse"></i>
                    </div>
                    <div class="title-text">
                        <h1>จัดการคลังสินค้า</h1>
                        <p>จัดการข้อมูลคลังสินค้าและอัตราค่าคอมมิชชั่น</p>
                    </div>
                </div>
            </div>
            <div class="header-actions">
                <button onclick="exportWarehouses()" class="action-btn export-btn">
                    <i class="fas fa-download"></i>
                    <span>Export</span>
                </button>
                <a href="<?php echo e(route('admin.warehouses.create')); ?>" class="action-btn primary-btn">
                    <i class="fas fa-plus"></i>
                    <span>เพิ่มคลัง</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="stats-grid">
        <div class="stat-card total">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fas fa-warehouse"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-number"><?php echo e(number_format($stats['total'] ?? 0)); ?></div>
                    <div class="stat-label">คลังทั้งหมด</div>
                    <div class="stat-trend">
                        <i class="fas fa-chart-line"></i>
                        <span>ทั้งระบบ</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card active">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-number"><?php echo e(number_format($stats['active'] ?? 0)); ?></div>
                    <div class="stat-label">ใช้งานอยู่</div>
                    <div class="stat-trend">
                        <i class="fas fa-check"></i>
                        <span>Active</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card users">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-number"><?php echo e(number_format($stats['with_users'] ?? 0)); ?></div>
                    <div class="stat-label">มีผู้ใช้งาน</div>
                    <div class="stat-trend">
                        <i class="fas fa-user-check"></i>
                        <span>Users</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card rates">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fas fa-percentage"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-number"><?php echo e(number_format($stats['with_rates'] ?? 0)); ?></div>
                    <div class="stat-label">มีอัตราคอมมิชชั่น</div>
                    <div class="stat-trend">
                        <i class="fas fa-calculator"></i>
                        <span>Rates</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Search & Filter Section -->
    <div class="filter-section">
        <div class="filter-header">
            <div class="filter-title">
                <i class="fas fa-filter"></i>
                <span>ค้นหาและกรอง</span>
            </div>
            <button class="filter-toggle" onclick="toggleFilters()">
                <i class="fas fa-chevron-down"></i>
            </button>
        </div>
        <div class="filter-content" id="filterContent">
            <form method="GET" action="<?php echo e(route('admin.warehouses.index')); ?>" class="filter-form">
                <div class="filter-row">
                    <div class="filter-group">
                        <label class="filter-label">ค้นหา</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-search"></i>
                            </div>
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                                   class="filter-input" placeholder="รหัสคลัง, ชื่อ หรือที่อยู่">
                        </div>
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">สถานะ</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-toggle-on"></i>
                            </div>
                            <select name="status" class="filter-select">
                                <option value="">ทั้งหมด</option>
                                <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>✅ ใช้งานอยู่</option>
                                <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>❌ ปิดใช้งาน</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">ประเภท</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-layer-group"></i>
                            </div>
                            <select name="type" class="filter-select">
                                <option value="">ทั้งหมด</option>
                                <option value="with_users" <?php echo e(request('type') === 'with_users' ? 'selected' : ''); ?>>👥 มีผู้ใช้งาน</option>
                                <option value="with_rates" <?php echo e(request('type') === 'with_rates' ? 'selected' : ''); ?>>💰 มีอัตราคอมมิชชั่น</option>
                                <option value="empty" <?php echo e(request('type') === 'empty' ? 'selected' : ''); ?>>📦 ว่าง</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="filter-actions">
                        <button type="submit" class="filter-btn search-btn">
                            <i class="fas fa-search"></i>
                            <span>ค้นหา</span>
                        </button>
                        <a href="<?php echo e(route('admin.warehouses.index')); ?>" class="filter-btn clear-btn">
                            <i class="fas fa-times"></i>
                            <span>ล้าง</span>
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Bulk Actions Bar -->
    <div class="bulk-actions" id="bulkActions" style="display: none;">
        <div class="bulk-info">
            <div class="bulk-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="bulk-text">
                เลือกแล้ว <span id="selectedCount">0</span> รายการ
            </div>
        </div>
        <div class="bulk-buttons">
            <button onclick="bulkAction('activate')" class="bulk-btn activate-btn">
                <i class="fas fa-check"></i>
                <span>เปิดใช้งาน</span>
            </button>
            <button onclick="bulkAction('deactivate')" class="bulk-btn deactivate-btn">
                <i class="fas fa-ban"></i>
                <span>ปิดใช้งาน</span>
            </button>
            <button onclick="clearSelection()" class="bulk-btn cancel-btn">
                <i class="fas fa-times"></i>
                <span>ยกเลิก</span>
            </button>
        </div>
    </div>

    <!-- Warehouses List -->
    <div class="warehouses-container">
        <div class="container-header">
            <div class="container-title">
                <i class="fas fa-list"></i>
                <span>รายการคลังสินค้า</span>
            </div>
            <div class="container-count">
                ทั้งหมด <?php echo e(($warehouses ?? collect())->total() ?? 0); ?> รายการ
            </div>
        </div>
        
        <div class="warehouses-content">
            <!-- Desktop Table -->
            <div class="desktop-table">
                <table class="warehouses-table">
                    <thead>
                        <tr>
                            <th class="checkbox-col">
                                <input type="checkbox" id="selectAll" class="table-checkbox">
                            </th>
                            <th class="warehouse-col">คลังสินค้า</th>
                            <th class="status-col">สถานะ</th>
                            <th class="users-col">ผู้ใช้งาน</th>
                            <th class="rates-col">อัตราคอมมิชชั่น</th>
                            <th class="date-col">สร้างเมื่อ</th>
                            <th class="actions-col">การดำเนินการ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $warehouses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="warehouse-row" data-warehouse-id="<?php echo e($warehouse->id); ?>">
                            <td class="checkbox-cell">
                                <input type="checkbox" class="warehouse-checkbox table-checkbox" value="<?php echo e($warehouse->id); ?>">
                            </td>
                            <td class="warehouse-cell">
                                <div class="warehouse-info">
                                    <div class="warehouse-avatar">
                                        <?php echo e(strtoupper(substr($warehouse->code ?? 'W', 0, 2))); ?>

                                    </div>
                                    <div class="warehouse-details">
                                        <div class="warehouse-code"><?php echo e($warehouse->code ?? 'ไม่ระบุรหัส'); ?></div>
                                        <div class="warehouse-name"><?php echo e($warehouse->name ?? 'ไม่ระบุชื่อ'); ?></div>
                                        <?php if($warehouse->location): ?>
                                            <div class="warehouse-location"><?php echo e(Str::limit($warehouse->location, 50)); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td class="status-cell">
                                <div class="status-badge status-<?php echo e(($warehouse->is_active ?? false) ? 'active' : 'inactive'); ?>">
                                    <?php if($warehouse->is_active ?? false): ?>
                                        <i class="fas fa-check-circle"></i>
                                        <span>ใช้งานอยู่</span>
                                    <?php else: ?>
                                        <i class="fas fa-times-circle"></i>
                                        <span>ปิดใช้งาน</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="users-cell">
                                <div class="text-center">
                                    <div class="count-badge count-users">
                                        <i class="fas fa-users"></i>
                                        <?php echo e($warehouse->users_count ?? 0); ?>

                                    </div>
                                    <?php if(($warehouse->users_count ?? 0) > 0): ?>
                                        <div class="count-detail"><?php echo e($warehouse->active_users_count ?? 0); ?> ใช้งาน</div>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="rates-cell">
                                <div class="text-center">
                                    <div class="count-badge count-rates">
                                        <i class="fas fa-percentage"></i>
                                        <?php echo e($warehouse->commission_rates_count ?? 0); ?>

                                    </div>
                                    <?php if(($warehouse->commission_rates_count ?? 0) > 0): ?>
                                        <div class="count-detail"><?php echo e($warehouse->active_rates_count ?? 0); ?> ใช้งาน</div>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="date-cell">
                                <?php if($warehouse->created_at): ?>
                                    <div class="date-info">
                                        <div class="date-main"><?php echo e($warehouse->created_at->format('d/m/Y')); ?></div>
                                        <div class="date-time"><?php echo e($warehouse->created_at->format('H:i')); ?></div>
                                    </div>
                                <?php else: ?>
                                    <span class="no-data">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="actions-cell">
                                <div class="action-buttons">
                                    <a href="<?php echo e(route('admin.warehouses.edit', $warehouse)); ?>" class="action-btn edit-btn" title="แก้ไข">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button onclick="toggleWarehouseStatus(<?php echo e($warehouse->id); ?>)" 
                                            class="action-btn toggle-btn" 
                                            title="<?php echo e(($warehouse->is_active ?? false) ? 'ปิดใช้งาน' : 'เปิดใช้งาน'); ?>">
                                        <i class="fas fa-<?php echo e(($warehouse->is_active ?? false) ? 'eye-slash' : 'eye'); ?>"></i>
                                    </button>
                                    <a href="<?php echo e(route('admin.commission-rates.index', ['warehouse' => $warehouse->code])); ?>" 
                                       class="action-btn commission-btn" title="จัดการอัตราคอมมิชชั่น">
                                        <i class="fas fa-percentage"></i>
                                    </a>
                                    <?php if(($warehouse->users_count ?? 0) === 0): ?>
                                        <button onclick="deleteWarehouse(<?php echo e($warehouse->id); ?>)" 
                                                class="action-btn delete-btn" title="ลบคลัง">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="empty-state">
                                <div class="empty-content">
                                    <div class="empty-icon">
                                        <i class="fas fa-warehouse"></i>
                                    </div>
                                    <div class="empty-text">
                                        <h3>ไม่มีคลังสินค้า</h3>
                                        <p>ยังไม่มีคลังสินค้าในระบบ หรือไม่พบผลการค้นหา</p>
                                    </div>
                                    <div class="empty-action">
                                        <a href="<?php echo e(route('admin.warehouses.create')); ?>" class="empty-btn">
                                            <i class="fas fa-plus"></i>
                                            <span>เพิ่มคลังแรก</span>
                                        </a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Mobile Cards -->
            <div class="mobile-cards">
                <?php $__empty_1 = true; $__currentLoopData = $warehouses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="warehouse-card" data-warehouse-id="<?php echo e($warehouse->id); ?>">
                    <div class="card-header">
                        <input type="checkbox" class="warehouse-checkbox card-checkbox" value="<?php echo e($warehouse->id); ?>">
                        <div class="warehouse-info">
                            <div class="warehouse-avatar">
                                <?php echo e(strtoupper(substr($warehouse->code ?? 'W', 0, 2))); ?>

                            </div>
                            <div class="warehouse-details">
                                <div class="warehouse-code"><?php echo e($warehouse->code ?? 'ไม่ระบุรหัส'); ?></div>
                                <div class="warehouse-name"><?php echo e($warehouse->name ?? 'ไม่ระบุชื่อ'); ?></div>
                            </div>
                        </div>
                        <button class="card-menu-btn" onclick="toggleCardMenu(<?php echo e($warehouse->id); ?>)">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                    </div>
                    
                    <div class="card-body">
                        <div class="card-row">
                            <span class="row-label">สถานะ:</span>
                            <div class="status-badge status-<?php echo e(($warehouse->is_active ?? false) ? 'active' : 'inactive'); ?>">
                                <?php if($warehouse->is_active ?? false): ?>
                                    <i class="fas fa-check-circle"></i> ใช้งาน
                                <?php else: ?>
                                    <i class="fas fa-times-circle"></i> ปิดใช้งาน
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">ผู้ใช้งาน:</span>
                            <span class="row-value"><?php echo e($warehouse->users_count ?? 0); ?> คน</span>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">อัตราคอมมิชชั่น:</span>
                            <span class="row-value"><?php echo e($warehouse->commission_rates_count ?? 0); ?> อัตรา</span>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">สร้างเมื่อ:</span>
                            <span class="row-value">
                                <?php echo e($warehouse->created_at ? $warehouse->created_at->format('d/m/Y H:i') : '-'); ?>

                            </span>
                        </div>
                    </div>
                    
                    <div class="card-actions" id="card-actions-<?php echo e($warehouse->id); ?>" style="display: none;">
                        <a href="<?php echo e(route('admin.warehouses.edit', $warehouse)); ?>" class="card-action-btn edit">
                            <i class="fas fa-edit"></i> แก้ไข
                        </a>
                        <button onclick="toggleWarehouseStatus(<?php echo e($warehouse->id); ?>)" class="card-action-btn toggle">
                            <i class="fas fa-<?php echo e(($warehouse->is_active ?? false) ? 'eye-slash' : 'eye'); ?>"></i>
                            <?php echo e(($warehouse->is_active ?? false) ? 'ปิดใช้งาน' : 'เปิดใช้งาน'); ?>

                        </button>
                        <a href="<?php echo e(route('admin.commission-rates.index', ['warehouse' => $warehouse->code])); ?>" class="card-action-btn commission">
                            <i class="fas fa-percentage"></i> จัดการอัตรา
                        </a>
                        <?php if(($warehouse->users_count ?? 0) === 0): ?>
                            <button onclick="deleteWarehouse(<?php echo e($warehouse->id); ?>)" class="card-action-btn delete">
                                <i class="fas fa-trash"></i> ลบ
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="empty-state-mobile">
                    <div class="empty-icon">
                        <i class="fas fa-warehouse"></i>
                    </div>
                    <div class="empty-text">
                        <h3>ไม่มีคลังสินค้า</h3>
                        <p>ยังไม่มีคลังสินค้าในระบบ</p>
                    </div>
                    <div class="empty-action">
                        <a href="<?php echo e(route('admin.warehouses.create')); ?>" class="empty-btn">
                            <i class="fas fa-plus"></i>
                            <span>เพิ่มคลังแรก</span>
                        </a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Pagination -->
        <?php if(isset($warehouses) && $warehouses->hasPages()): ?>
        <div class="pagination-section">
            <div class="pagination-info">
                แสดง <?php echo e($warehouses->firstItem() ?? 0); ?> ถึง <?php echo e($warehouses->lastItem() ?? 0); ?> 
                จาก <?php echo e($warehouses->total() ?? 0); ?> รายการ
            </div>
            <div class="pagination-links">
                <?php echo e($warehouses->links()); ?>

            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.warehouses.index-scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\crs\resources\views/admin/warehouses/index.blade.php ENDPATH**/ ?>