<?php $__env->startSection('title', 'รายงานคลังสินค้า - ระบบจัดการค่าคอมมิชชั่น'); ?>

<?php $__env->startSection('content'); ?>
<div class="warehouse-reports-container">
    <!-- Header Card -->
    <div class="header-card">
        <div class="header-content">
            <div class="header-info">
                <div class="header-icon">
                    <i class="fas fa-warehouse"></i>
                </div>
                <div class="header-text">
                    <h1 class="header-title">รายงานคลังสินค้า</h1>
                    <p class="header-subtitle">ประสิทธิภาพคลังสินค้า การเปรียบเทียบ และการจัดอันดับ</p>
                </div>
            </div>
            <div class="header-actions">
                <button onclick="exportReport()" class="btn btn-primary">
                    <i class="fas fa-download"></i>
                    <span>ส่งออกรายงาน</span>
                </button>
                <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i>
                    <span>กลับ</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="filters-card">
        <div class="filters-header">
            <h3 class="filters-title">
                <i class="fas fa-filter"></i>
                ตัวกรองข้อมูล
            </h3>
            <button onclick="resetFilters()" class="btn-reset">
                <i class="fas fa-undo"></i>
                รีเซ็ต
            </button>
        </div>
        <form method="GET" action="<?php echo e(route('admin.reports.warehouse')); ?>" class="filters-form">
            <div class="filters-grid">
                <div class="filter-group">
                    <label>วันที่เริ่มต้น</label>
                    <input type="date" name="start_date" value="<?php echo e($startDate); ?>" class="filter-input">
                </div>
                <div class="filter-group">
                    <label>วันที่สิ้นสุด</label>
                    <input type="date" name="end_date" value="<?php echo e($endDate); ?>" class="filter-input">
                </div>
                <div class="filter-group">
                    <label>คลังสินค้า</label>
                    <select name="warehouse" class="filter-select">
                        <option value="">ทั้งหมด</option>
                        <?php $__currentLoopData = $allWarehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($warehouse->code); ?>" <?php echo e($warehouseCode == $warehouse->code ? 'selected' : ''); ?>>
                                <?php echo e($warehouse->code); ?> - <?php echo e($warehouse->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="filter-actions">
                    <button type="submit" class="btn-filter">
                        <i class="fas fa-search"></i>
                        ค้นหา
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Overall Stats -->
    <div class="stats-grid">
        <div class="stat-card blue">
            <div class="stat-icon">
                <i class="fas fa-warehouse"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($overallStats['total_warehouses'])); ?></div>
                <div class="stat-label">คลังสินค้าทั้งหมด</div>
            </div>
        </div>

        <div class="stat-card green">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($overallStats['total_users'])); ?></div>
                <div class="stat-label">พนักงานทั้งหมด</div>
            </div>
        </div>

        <div class="stat-card orange">
            <div class="stat-icon">
                <i class="fas fa-truck"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($overallStats['total_deliveries'])); ?></div>
                <div class="stat-label">การจัดส่งทั้งหมด</div>
            </div>
        </div>

        <div class="stat-card purple">
            <div class="stat-icon">
                <i class="fas fa-boxes"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($overallStats['total_parcels'])); ?></div>
                <div class="stat-label">พัสดุทั้งหมด</div>
            </div>
        </div>
    </div>

    <!-- Performance Ranking -->
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon gold">
                <i class="fas fa-trophy"></i>
            </div>
            <div class="section-info">
                <h2 class="section-title">อันดับประสิทธิภาพคลังสินค้า</h2>
                <p class="section-subtitle">จัดอันดับตามจำนวนพัสดุที่จัดส่ง</p>
            </div>
        </div>

        <div class="ranking-grid">
            <?php $__currentLoopData = $performanceRanking; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="ranking-card <?php echo e($index < 3 ? 'rank-' . ($index + 1) : ''); ?>">
                    <div class="ranking-header">
                        <div class="ranking-position">
                            <?php if($index < 3): ?>
                                <i class="fas fa-medal"></i>
                            <?php endif; ?>
                            #<?php echo e($index + 1); ?>

                        </div>
                        <div class="warehouse-info">
                            <h4 class="warehouse-code"><?php echo e($warehouse->code); ?></h4>
                            <p class="warehouse-name"><?php echo e($warehouse->name); ?></p>
                        </div>
                    </div>
                    
                    <div class="ranking-stats">
                        <div class="ranking-stat primary">
                            <span class="stat-number"><?php echo e(number_format($warehouse->deliveryStats->total_parcels ?? 0)); ?></span>
                            <span class="stat-text">พัสดุ</span>
                        </div>
                        <div class="ranking-stat secondary">
                            <span class="stat-number"><?php echo e(number_format($warehouse->deliveryStats->total_deliveries ?? 0)); ?></span>
                            <span class="stat-text">การจัดส่ง</span>
                        </div>
                        <div class="ranking-stat tertiary">
                            <span class="stat-number"><?php echo e(number_format($warehouse->userStats['total_users'] ?? 0)); ?></span>
                            <span class="stat-text">พนักงาน</span>
                        </div>
                    </div>

                    <div class="efficiency-bar">
                        <div class="efficiency-label">ประสิทธิภาพ</div>
                        <div class="efficiency-progress">
                            <div class="efficiency-fill" style="width: <?php echo e(min($warehouse->efficiency ?? 0, 100)); ?>%"></div>
                        </div>
                        <div class="efficiency-value"><?php echo e(number_format($warehouse->efficiency ?? 0, 1)); ?>%</div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Trend Chart -->
    <div class="chart-section">
        <div class="chart-card">
            <div class="chart-header">
                <h3 class="chart-title">
                    <i class="fas fa-chart-area"></i>
                    แนวโน้มประสิทธิภาพ 6 เดือน
                </h3>
            </div>
            <div class="chart-container">
                <canvas id="trendChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Warehouse Details -->
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon blue">
                <i class="fas fa-list-alt"></i>
            </div>
            <div class="section-info">
                <h2 class="section-title">รายละเอียดคลังสินค้า</h2>
                <p class="section-subtitle">ข้อมูลครบถ้วนของแต่ละคลัง</p>
            </div>
        </div>

        <div class="warehouse-details-grid">
            <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="warehouse-detail-card">
                    <div class="warehouse-detail-header">
                        <div class="warehouse-badge"><?php echo e($warehouse->code); ?></div>
                        <div class="warehouse-detail-info">
                            <h4 class="warehouse-detail-name"><?php echo e($warehouse->name); ?></h4>
                            <p class="warehouse-location"><?php echo e($warehouse->location ?? 'ไม่ระบุที่อยู่'); ?></p>
                        </div>
                    </div>

                    <div class="warehouse-metrics">
                        <div class="metric-row">
                            <div class="metric-item">
                                <div class="metric-icon users">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="metric-content">
                                    <div class="metric-value"><?php echo e(number_format($warehouse->userStats['total_users'] ?? 0)); ?></div>
                                    <div class="metric-label">พนักงานทั้งหมด</div>
                                </div>
                            </div>
                            <div class="metric-item">
                                <div class="metric-icon active">
                                    <i class="fas fa-user-check"></i>
                                </div>
                                <div class="metric-content">
                                    <div class="metric-value"><?php echo e(number_format($warehouse->userStats['active_users'] ?? 0)); ?></div>
                                    <div class="metric-label">พนักงานที่ใช้งาน</div>
                                </div>
                            </div>
                        </div>

                        <div class="metric-row">
                            <div class="metric-item">
                                <div class="metric-icon vehicle-2">
                                    <i class="fas fa-motorcycle"></i>
                                </div>
                                <div class="metric-content">
                                    <div class="metric-value"><?php echo e(number_format($warehouse->userStats['vehicle_2wheel'] ?? 0)); ?></div>
                                    <div class="metric-label">รถ 2 ล้อ</div>
                                </div>
                            </div>
                            <div class="metric-item">
                                <div class="metric-icon vehicle-4">
                                    <i class="fas fa-truck"></i>
                                </div>
                                <div class="metric-content">
                                    <div class="metric-value"><?php echo e(number_format($warehouse->userStats['vehicle_4wheel'] ?? 0)); ?></div>
                                    <div class="metric-label">รถ 4 ล้อ</div>
                                </div>
                            </div>
                        </div>

                        <div class="performance-metrics">
                            <div class="performance-item">
                                <span class="performance-label">การจัดส่งทั้งหมด</span>
                                <span class="performance-value"><?php echo e(number_format($warehouse->deliveryStats->total_deliveries ?? 0)); ?></span>
                            </div>
                            <div class="performance-item">
                                <span class="performance-label">จำนวนพัสดุ</span>
                                <span class="performance-value"><?php echo e(number_format($warehouse->deliveryStats->total_parcels ?? 0)); ?></span>
                            </div>
                            <div class="performance-item">
                                <span class="performance-label">ค่าคอมมิชชั่น</span>
                                <span class="performance-value">฿<?php echo e(number_format($warehouse->deliveryStats->total_commission ?? 0, 2)); ?></span>
                            </div>
                            <div class="performance-item">
                                <span class="performance-label">เฉลี่ยพัสดุต่อวัน</span>
                                <span class="performance-value"><?php echo e(number_format($warehouse->avgParcelsPerDay ?? 0, 1)); ?></span>
                            </div>
                            <div class="performance-item">
                                <span class="performance-label">เฉลี่ยต่อพนักงาน</span>
                                <span class="performance-value"><?php echo e(number_format($warehouse->avgParcelsPerUser ?? 0, 1)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Container */
.warehouse-reports-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 50%, #cbd5e1 100%);
    padding: 2rem;
}

/* Header Card */
.header-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 24px;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
    margin-bottom: 2rem;
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1.5rem;
}

.header-info {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.header-icon {
    width: 64px;
    height: 64px;
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
    box-shadow: 0 10px 25px rgba(59, 130, 246, 0.3);
}

.header-title {
    font-size: 2rem;
    font-weight: 700;
    background: linear-gradient(135deg, #1f2937 0%, #6b7280 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin: 0 0 0.5rem 0;
}

.header-subtitle {
    color: #6b7280;
    margin: 0;
    font-size: 1rem;
}

.header-actions {
    display: flex;
    gap: 0.75rem;
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    font-weight: 500;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    color: white;
    box-shadow: 0 10px 25px rgba(59, 130, 246, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 15px 35px rgba(59, 130, 246, 0.4);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.9);
    color: #374151;
    border: 1px solid #e5e7eb;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
}

/* Filters Card */
.filters-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
    margin-bottom: 2rem;
}

.filters-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
}

.filters-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1f2937;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0;
}

.btn-reset {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    background: #f3f4f6;
    color: #6b7280;
    border: none;
    border-radius: 8px;
    font-size: 0.875rem;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-reset:hover {
    background: #e5e7eb;
}

.filters-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.filter-group label {
    font-weight: 500;
    color: #374151;
    font-size: 0.875rem;
}

.filter-input, .filter-select {
    padding: 0.75rem;
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    font-size: 0.875rem;
    transition: border-color 0.3s ease;
}

.filter-input:focus, .filter-select:focus {
    outline: none;
    border-color: #3B82F6;
}

.btn-filter {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    color: white;
    border: none;
    border-radius: 8px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-filter:hover {
    transform: translateY(-1px);
    box-shadow: 0 10px 25px rgba(16, 185, 129, 0.3);
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 16px;
    padding: 2rem;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
    position: relative;
    overflow: hidden;
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
}

.stat-card.blue {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    color: white;
}

.stat-card.green {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    color: white;
}

.stat-card.orange {
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
    color: white;
}

.stat-card.purple {
    background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
    color: white;
}

.stat-icon {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    margin-bottom: 1rem;
}

.stat-value {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.stat-label {
    font-size: 0.875rem;
    opacity: 0.9;
}

/* Section Cards */
.section-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 24px;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
    margin-bottom: 2rem;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
}

.section-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    color: white;
}

.section-icon.gold {
    background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);
}

.section-icon.blue {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
}

.section-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
}

.section-subtitle {
    color: #6b7280;
    font-size: 0.9rem;
    margin: 0.25rem 0 0 0;
}

/* Ranking Grid */
.ranking-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 1.5rem;
}

.ranking-card {
    background: #f8f9fa;
    border-radius: 16px;
    padding: 2rem;
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.ranking-card:hover {
    background: white;
    border-color: #3B82F6;
    transform: translateY(-4px);
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
}

.ranking-card.rank-1 {
    background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
    color: white;
}

.ranking-card.rank-2 {
    background: linear-gradient(135deg, #C0C0C0 0%, #A9A9A9 100%);
    color: white;
}

.ranking-card.rank-3 {
    background: linear-gradient(135deg, #CD7F32 0%, #B8860B 100%);
    color: white;
}

.ranking-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.ranking-position {
    font-size: 2rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.warehouse-code {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0;
}

.warehouse-name {
    font-size: 0.875rem;
    opacity: 0.8;
    margin: 0;
}

.ranking-stats {
    display: flex;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.ranking-stat {
    display: flex;
    flex-direction: column;
    align-items: center;
    flex: 1;
}

.ranking-stat .stat-number {
    font-size: 1.25rem;
    font-weight: 700;
}

.ranking-stat .stat-text {
    font-size: 0.75rem;
    opacity: 0.8;
}

.efficiency-bar {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.efficiency-label {
    font-size: 0.875rem;
    font-weight: 500;
    min-width: 80px;
}

.efficiency-progress {
    flex: 1;
    height: 8px;
    background: rgba(255, 255, 255, 0.3);
    border-radius: 4px;
    overflow: hidden;
}

.efficiency-fill {
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    border-radius: 4px;
    transition: width 0.3s ease;
}

.ranking-card:not(.rank-1):not(.rank-2):not(.rank-3) .efficiency-fill {
    background: #3B82F6;
}

.efficiency-value {
    font-size: 0.875rem;
    font-weight: 600;
    min-width: 50px;
    text-align: right;
}

/* Chart Section */
.chart-section {
    margin-bottom: 2rem;
}

.chart-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
}

.chart-header {
    margin-bottom: 1.5rem;
}

.chart-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1f2937;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0;
}

.chart-container {
    height: 400px;
    position: relative;
}

/* Warehouse Details */
.warehouse-details-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 2rem;
}

.warehouse-detail-card {
    background: #f8f9fa;
    border-radius: 16px;
    padding: 2rem;
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.warehouse-detail-card:hover {
    background: white;
    border-color: #3B82F6;
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.warehouse-detail-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.warehouse-badge {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    color: white;
    padding: 0.75rem 1rem;
    border-radius: 12px;
    font-weight: 700;
    font-size: 1.1rem;
}

.warehouse-detail-name {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
}

.warehouse-location {
    font-size: 0.875rem;
    color: #6b7280;
    margin: 0.25rem 0 0 0;
}

.warehouse-metrics {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.metric-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.metric-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: white;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
}

.metric-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.metric-icon.users {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
}

.metric-icon.active {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
}

.metric-icon.vehicle-2 {
    background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
}

.metric-icon.vehicle-4 {
    background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);
}

.metric-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

.metric-label {
    font-size: 0.875rem;
    color: #6b7280;
}

.performance-metrics {
    background: white;
    border-radius: 12px;
    padding: 1.5rem;
    border: 1px solid #e5e7eb;
}

.performance-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f3f4f6;
}

.performance-item:last-child {
    border-bottom: none;
}

.performance-label {
    font-size: 0.875rem;
    color: #6b7280;
}

.performance-value {
    font-weight: 600;
    color: #1f2937;
}

/* Responsive */
@media (max-width: 768px) {
    .warehouse-reports-container {
        padding: 1rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .header-actions {
        width: 100%;
        justify-content: stretch;
    }
    
    .btn {
        flex: 1;
        justify-content: center;
    }
    
    .filters-grid {
        grid-template-columns: 1fr;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .ranking-grid {
        grid-template-columns: 1fr;
    }
    
    .warehouse-details-grid {
        grid-template-columns: 1fr;
    }
    
    .metric-row {
        grid-template-columns: 1fr;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Trend Chart
const trendCtx = document.getElementById('trendChart').getContext('2d');
const trendChart = new Chart(trendCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($trendLabels); ?>,
        datasets: [
            <?php $__currentLoopData = $trendData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouseName => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            {
                label: '<?php echo e($warehouseName); ?>',
                data: <?php echo json_encode($data); ?>,
                borderColor: getRandomColor(),
                backgroundColor: 'transparent',
                tension: 0.4,
                borderWidth: 3
            },
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'top',
            }
        },
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

function getRandomColor() {
    const colors = [
        '#3B82F6', '#10B981', '#F59E0B', '#EF4444', 
        '#8B5CF6', '#06B6D4', '#84CC16', '#F97316'
    ];
    return colors[Math.floor(Math.random() * colors.length)];
}

function exportReport() {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?php echo e(route("admin.reports.warehouse.export")); ?>';
    
    // Add CSRF token
    const csrfToken = document.createElement('input');
    csrfToken.type = 'hidden';
    csrfToken.name = '_token';
    csrfToken.value = '<?php echo e(csrf_token()); ?>';
    form.appendChild(csrfToken);
    
    // Add current filters
    const params = new URLSearchParams(window.location.search);
    params.forEach((value, key) => {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = key;
        input.value = value;
        form.appendChild(input);
    });
    
    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
}

function resetFilters() {
    window.location.href = '<?php echo e(route("admin.reports.warehouse")); ?>';
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/admin/reports/warehouse.blade.php ENDPATH**/ ?>