<?php $__env->startSection('page-title', 'รายละเอียดการจัดส่ง'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 py-8">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Modern Header -->
        <div class="relative bg-gradient-to-r from-blue-600 via-purple-600 to-indigo-600 rounded-3xl p-8 mb-8 overflow-hidden shadow-2xl">
            <div class="absolute inset-0 bg-black/10"></div>
            <div class="absolute top-0 right-0 w-96 h-96 bg-white/10 rounded-full -translate-y-1/2 translate-x-1/2"></div>
            <div class="absolute bottom-0 left-0 w-64 h-64 bg-white/5 rounded-full translate-y-1/2 -translate-x-1/2"></div>
            
            <div class="relative z-10 flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
                <div class="text-white">
                    <div class="flex items-center gap-3 mb-2">
                        <div class="w-12 h-12 bg-white/20 rounded-2xl flex items-center justify-center backdrop-blur-sm">
                            <i class="fas fa-eye text-xl"></i>
                        </div>
                        <h1 class="text-3xl font-bold">รายละเอียดการจัดส่ง</h1>
                    </div>
                    <p class="text-white/90 text-lg">ข้อมูลการจัดส่งพัสดุวันที่ <?php echo e(\Carbon\Carbon::parse($delivery->delivery_date)->format('d/m/Y')); ?></p>
                </div>
                
                <div class="flex flex-wrap gap-3">
                    <a href="<?php echo e(route('vehicle.deliveries.edit', $delivery)); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-white/20 hover:bg-white/30 text-white rounded-2xl font-medium transition-all duration-300 backdrop-blur-sm border border-white/30 hover:border-white/50">
                        <i class="fas fa-edit"></i>
                        <span>แก้ไข</span>
                    </a>
                    <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-white/10 hover:bg-white/20 text-white rounded-2xl font-medium transition-all duration-300 backdrop-blur-sm border border-white/20 hover:border-white/40">
                        <i class="fas fa-arrow-left"></i>
                        <span>กลับ</span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Status Card -->
        <div class="bg-white rounded-3xl shadow-xl p-8 mb-8 border border-gray-100">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-4">
                    <div class="w-16 h-16 bg-gradient-to-r from-emerald-500 to-green-500 rounded-2xl flex items-center justify-center">
                        <i class="fas fa-info-circle text-white text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">ข้อมูลการจัดส่ง</h2>
                        <p class="text-gray-600">รายละเอียดการจัดส่งพัสดุ</p>
                    </div>
                </div>
                <div class="flex items-center gap-2 px-4 py-2 bg-gradient-to-r from-emerald-500 to-green-500 text-white rounded-full font-medium">
                    <i class="fas fa-check-circle"></i>
                    <span>สำเร็จ</span>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <!-- วันที่จัดส่ง -->
                <div class="group bg-gradient-to-br from-blue-50 to-indigo-50 rounded-2xl p-6 border border-blue-100 hover:shadow-lg transition-all duration-300">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-indigo-500 rounded-xl flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-calendar-alt text-white"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-600 mb-1">วันที่จัดส่ง</p>
                            <p class="text-xl font-bold text-gray-900 mb-1"><?php echo e(\Carbon\Carbon::parse($delivery->delivery_date)->format('d/m/Y')); ?></p>
                            <p class="text-sm text-gray-500"><?php echo e(\Carbon\Carbon::parse($delivery->delivery_date)->locale('th')->translatedFormat('l')); ?></p>
                        </div>
                    </div>
                </div>

                <!-- จำนวนพัสดุ -->
                <div class="group bg-gradient-to-br from-purple-50 to-pink-50 rounded-2xl p-6 border border-purple-100 hover:shadow-lg transition-all duration-300">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-purple-500 to-pink-500 rounded-xl flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-box text-white"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-600 mb-1">จำนวนพัสดุ</p>
                            <p class="text-xl font-bold text-gray-900 mb-1"><?php echo e(number_format($delivery->parcel_count)); ?> ชิ้น</p>
                            <p class="text-sm text-gray-500">พัสดุที่จัดส่งสำเร็จ</p>
                        </div>
                    </div>
                </div>

                <!-- ค่าคอมมิชชั่น -->
                <div class="group bg-gradient-to-br from-emerald-50 to-green-50 rounded-2xl p-6 border border-emerald-100 hover:shadow-lg transition-all duration-300">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-emerald-500 to-green-500 rounded-xl flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-coins text-white"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-600 mb-1">ค่าคอมมิชชั่น</p>
                            <p class="text-xl font-bold text-gray-900 mb-1"><?php echo e(number_format($delivery->commission_amount, 2)); ?> บาท</p>
                            <p class="text-sm text-gray-500"><?php echo e(number_format($delivery->commission_amount / $delivery->parcel_count, 2)); ?> บาท/ชิ้น</p>
                        </div>
                    </div>
                </div>

                <!-- ผู้จัดส่ง -->
                <div class="group bg-gradient-to-br from-orange-50 to-red-50 rounded-2xl p-6 border border-orange-100 hover:shadow-lg transition-all duration-300">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-orange-500 to-red-500 rounded-xl flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-user text-white"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-600 mb-1">ผู้จัดส่ง</p>
                            <p class="text-xl font-bold text-gray-900 mb-1"><?php echo e($delivery->user->name ?? 'ไม่ระบุ'); ?></p>
                            <p class="text-sm text-gray-500"><?php echo e($delivery->user->role ?? 'ไม่ระบุ'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- คลังสินค้า -->
                <div class="group bg-gradient-to-br from-cyan-50 to-blue-50 rounded-2xl p-6 border border-cyan-100 hover:shadow-lg transition-all duration-300">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-cyan-500 to-blue-500 rounded-xl flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-warehouse text-white"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-600 mb-1">คลังสินค้า</p>
                            <p class="text-xl font-bold text-gray-900 mb-1"><?php echo e($delivery->user->warehouse->warehouse_name ?? $delivery->user->warehouse_code ?? 'ไม่ระบุ'); ?></p>
                            <p class="text-sm text-gray-500">รหัส: <?php echo e($delivery->user->warehouse_code ?? 'ไม่ระบุ'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- บันทึกเมื่อ -->
                <div class="group bg-gradient-to-br from-gray-50 to-slate-50 rounded-2xl p-6 border border-gray-100 hover:shadow-lg transition-all duration-300">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-gray-500 to-slate-500 rounded-xl flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-clock text-white"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-600 mb-1">บันทึกเมื่อ</p>
                            <p class="text-xl font-bold text-gray-900 mb-1"><?php echo e(\Carbon\Carbon::parse($delivery->created_at)->format('d/m/Y H:i')); ?></p>
                            <p class="text-sm text-gray-500"><?php echo e(\Carbon\Carbon::parse($delivery->created_at)->diffForHumans()); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="bg-white rounded-3xl shadow-xl p-8 border border-gray-100">
            <div class="text-center mb-6">
                <h3 class="text-xl font-bold text-gray-900 mb-2">การจัดการ</h3>
                <p class="text-gray-600">เลือกการดำเนินการที่ต้องการ</p>
            </div>
            
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <a href="<?php echo e(route('vehicle.deliveries.edit', $delivery)); ?>" class="group flex items-center justify-center gap-3 px-6 py-4 bg-gradient-to-r from-amber-500 to-orange-500 hover:from-amber-600 hover:to-orange-600 text-white rounded-2xl font-medium transition-all duration-300 transform hover:scale-105 hover:shadow-lg">
                    <i class="fas fa-edit text-lg"></i>
                    <span>แก้ไขข้อมูล</span>
                </a>
                
                <button type="button" onclick="deleteRecord(<?php echo e($delivery->id); ?>)" class="group flex items-center justify-center gap-3 px-6 py-4 bg-gradient-to-r from-red-500 to-pink-500 hover:from-red-600 hover:to-pink-600 text-white rounded-2xl font-medium transition-all duration-300 transform hover:scale-105 hover:shadow-lg">
                    <i class="fas fa-trash text-lg"></i>
                    <span>ลบบันทึก</span>
                </button>
                
                <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="group flex items-center justify-center gap-3 px-6 py-4 bg-gradient-to-r from-blue-500 to-indigo-500 hover:from-blue-600 hover:to-indigo-600 text-white rounded-2xl font-medium transition-all duration-300 transform hover:scale-105 hover:shadow-lg">
                    <i class="fas fa-plus text-lg"></i>
                    <span>บันทึกใหม่</span>
                </a>
                
                <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="group flex items-center justify-center gap-3 px-6 py-4 bg-white hover:bg-gray-50 text-gray-700 hover:text-gray-900 border-2 border-gray-200 hover:border-gray-300 rounded-2xl font-medium transition-all duration-300 transform hover:scale-105 hover:shadow-lg">
                    <i class="fas fa-list text-lg"></i>
                    <span>ดูทั้งหมด</span>
                </a>
            </div>
        </div>
    </div>
</div>



<?php $__env->startPush('styles'); ?>
<script>
  const originalWarn = console.warn;
  console.warn = function(...args) {
    if (args[0] && args[0].includes('cdn.tailwindcss.com should not be used in production')) {
      return;
    }
    originalWarn.apply(console, args);
  };
</script>
<script src="https://cdn.tailwindcss.com"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Delete record function
function deleteRecord(id) {
    Swal.fire({
        title: 'ยืนยันการลบ',
        text: 'คุณต้องการลบบันทึกการจัดส่งนี้หรือไม่? การลบจะไม่สามารถกู้คืนได้',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก',
        confirmButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/vehicle/deliveries/${id}`;
            
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'DELETE';
            
            form.appendChild(csrfToken);
            form.appendChild(methodField);
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Show success message if redirected after action
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ',
        text: '<?php echo e(session('success')); ?>',
        timer: 2000,
        showConfirmButton: false
    });
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/vehicle/deliveries/show.blade.php ENDPATH**/ ?>