<?php $__env->startSection('title', 'จัดการผู้ใช้งาน - EazyCom Plus'); ?>
<?php $__env->startSection('page-title', 'จัดการผู้ใช้งาน'); ?>
<?php $__env->startSection('mobile-title', 'ผู้ใช้งาน'); ?>

<?php $__env->startPush('styles'); ?>
<style>
:root {
    --primary: #FF6B35;
    --primary-dark: #E85D2F;
    --primary-light: #FF8C61;
    --gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    --gradient-soft: linear-gradient(135deg, #FFE5DB 0%, #FFD4C4 100%);
    --success: #22C55E;
    --warning: #F59E0B;
    --danger: #EF4444;
    --info: #3B82F6;
    --purple: #8B5CF6;
    --white: #FFFFFF;
    --gray-50: #F8FAFC;
    --gray-100: #F1F5F9;
    --gray-200: #E2E8F0;
    --gray-400: #94A3B8;
    --gray-500: #64748B;
    --gray-600: #475569;
    --gray-700: #334155;
    --gray-900: #0F172A;
    --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    --shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
    --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    --radius-md: 12px;
    --radius-lg: 16px;
    --radius-xl: 20px;
    --transition: all 0.2s ease;
}

.users-page {
    padding: clamp(1rem, 4vw, 2rem);
    padding-bottom: clamp(2rem, 6vw, 4rem);
    background: var(--gray-50);
    min-height: 100vh;
}

.page-header {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: clamp(1.5rem, 4vw, 2rem);
    margin-bottom: clamp(1.5rem, 4vw, 2rem);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 1.5rem;
    flex-wrap: wrap;
}

.header-info {
    flex: 1;
    min-width: 280px;
}

.header-title {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 0.75rem;
}

.title-icon {
    width: clamp(40px, 8vw, 48px);
    height: clamp(40px, 8vw, 48px);
    background: var(--gradient);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--white);
    font-size: clamp(1rem, 3vw, 1.25rem);
    box-shadow: var(--shadow-md);
}

.title-text h1 {
    font-size: clamp(1.5rem, 4vw, 1.875rem);
    font-weight: 700;
    color: var(--gray-900);
    margin: 0;
    line-height: 1.2;
}

.title-text p {
    font-size: clamp(0.875rem, 2.5vw, 1rem);
    color: var(--gray-600);
    margin: 0;
}

.header-actions {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: clamp(0.625rem, 2vw, 0.75rem) clamp(1rem, 3vw, 1.25rem);
    border-radius: var(--radius-md);
    font-weight: 600;
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: var(--transition);
    white-space: nowrap;
}

.primary-btn {
    background: var(--gradient);
    color: var(--white);
    box-shadow: var(--shadow-md);
}

.primary-btn:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: var(--white);
}

.export-btn {
    background: var(--white);
    color: var(--info);
    border: 2px solid var(--info);
}

.export-btn:hover {
    background: var(--info);
    color: var(--white);
    transform: translateY(-2px);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: clamp(1rem, 3vw, 1.5rem);
    margin-bottom: clamp(1.5rem, 4vw, 2rem);
}

.stat-card {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: clamp(1.25rem, 3vw, 1.5rem);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    transition: var(--transition);
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: var(--gradient);
}

.stat-card.active::before { background: linear-gradient(135deg, var(--success) 0%, #16a34a 100%); }
.stat-card.vehicle-2w::before { background: linear-gradient(135deg, var(--info) 0%, #1d4ed8 100%); }
.stat-card.vehicle-4w::before { background: linear-gradient(135deg, var(--purple) 0%, #7c3aed 100%); }

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: var(--shadow-lg);
}

.stat-content {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: clamp(48px, 8vw, 56px);
    height: clamp(48px, 8vw, 56px);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: clamp(1.25rem, 3vw, 1.5rem);
    color: var(--white);
    background: var(--gradient);
    flex-shrink: 0;
}

.stat-card.active .stat-icon { background: linear-gradient(135deg, var(--success) 0%, #16a34a 100%); }
.stat-card.vehicle-2w .stat-icon { background: linear-gradient(135deg, var(--info) 0%, #1d4ed8 100%); }
.stat-card.vehicle-4w .stat-icon { background: linear-gradient(135deg, var(--purple) 0%, #7c3aed 100%); }

.stat-info {
    flex: 1;
}

.stat-number {
    font-size: clamp(1.75rem, 4vw, 2.25rem);
    font-weight: 800;
    color: var(--gray-900);
    line-height: 1;
    margin-bottom: 0.25rem;
}

.stat-label {
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    font-weight: 600;
    color: var(--gray-600);
    margin-bottom: 0.5rem;
}

.stat-trend {
    display: flex;
    align-items: center;
    gap: 0.375rem;
    font-size: clamp(0.7rem, 1.8vw, 0.75rem);
    color: var(--gray-500);
}

.filter-section {
    background: var(--white);
    border-radius: var(--radius-lg);
    margin-bottom: clamp(1.5rem, 4vw, 2rem);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    overflow: hidden;
}

.filter-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: clamp(1rem, 3vw, 1.25rem) clamp(1.25rem, 3vw, 1.5rem);
    background: var(--gradient-soft);
    border-bottom: 1px solid var(--gray-200);
}

.filter-title {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: var(--gray-900);
    font-size: clamp(0.875rem, 2.5vw, 1rem);
}

.filter-toggle {
    background: none;
    border: none;
    color: var(--primary);
    font-size: 1rem;
    cursor: pointer;
    padding: 0.5rem;
    border-radius: var(--radius-md);
    transition: var(--transition);
}

.filter-toggle:hover {
    background: rgba(255, 107, 53, 0.1);
}

.filter-content {
    padding: clamp(1rem, 3vw, 1.5rem);
    display: none;
}

.filter-content.show {
    display: block;
    animation: slideDown 0.3s ease;
}

@keyframes slideDown {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.filter-form {
    display: grid;
    gap: clamp(1rem, 3vw, 1.5rem);
}

.filter-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: clamp(0.75rem, 2vw, 1rem);
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.filter-label {
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    font-weight: 600;
    color: var(--gray-700);
}

.input-group {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray-400);
    font-size: 0.875rem;
    z-index: 1;
}

.filter-input, .filter-select {
    width: 100%;
    padding: clamp(0.625rem, 2vw, 0.75rem) clamp(2.5rem, 5vw, 2.75rem) clamp(0.625rem, 2vw, 0.75rem) clamp(0.75rem, 2vw, 1rem);
    border: 2px solid var(--gray-200);
    border-radius: var(--radius-md);
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    transition: var(--transition);
    background: var(--white);
}

.filter-input:focus, .filter-select:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.filter-actions {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.filter-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: clamp(0.625rem, 2vw, 0.75rem) clamp(1rem, 3vw, 1.25rem);
    border-radius: var(--radius-md);
    font-weight: 600;
    font-size: clamp(0.8rem, 2vw, 0.875rem);
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: var(--transition);
}

.search-btn {
    background: var(--gradient);
    color: var(--white);
}

.search-btn:hover {
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.clear-btn {
    background: var(--white);
    color: var(--gray-600);
    border: 2px solid var(--gray-300);
}

.clear-btn:hover {
    background: var(--gray-100);
    color: var(--gray-700);
}

.users-container {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    overflow: hidden;
}

.container-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: clamp(1rem, 3vw, 1.25rem) clamp(1.25rem, 3vw, 1.5rem);
    background: var(--gradient-soft);
    border-bottom: 1px solid var(--gray-200);
}

.container-title {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: var(--gray-900);
    font-size: clamp(0.875rem, 2.5vw, 1rem);
}

.container-count {
    font-size: clamp(0.75rem, 2vw, 0.875rem);
    color: var(--gray-600);
    background: var(--white);
    padding: 0.375rem 0.75rem;
    border-radius: var(--radius-md);
    border: 1px solid var(--gray-200);
}

.desktop-table {
    display: block;
    overflow-x: auto;
}

@media (max-width: 768px) {
    .desktop-table {
        display: none;
    }
}

.users-table {
    width: 100%;
    border-collapse: collapse;
}

.users-table th {
    background: var(--gray-50);
    padding: 1rem;
    text-align: left;
    font-weight: 600;
    color: var(--gray-700);
    font-size: 0.875rem;
    border-bottom: 2px solid var(--gray-200);
    white-space: nowrap;
}

.users-table td {
    padding: 1rem;
    border-bottom: 1px solid var(--gray-200);
    vertical-align: middle;
}

.user-row {
    transition: var(--transition);
    cursor: pointer;
}

.user-row:hover {
    background: rgba(255, 107, 53, 0.02);
}

.user-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: var(--radius-md);
    background: var(--gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--white);
    font-weight: 600;
    font-size: 0.875rem;
    flex-shrink: 0;
}

.user-details {
    min-width: 0;
}

.user-name {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
    margin-bottom: 0.125rem;
}

.user-email {
    font-size: 0.75rem;
    color: var(--gray-500);
}

.role-badge, .status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.375rem 0.75rem;
    border-radius: var(--radius-md);
    font-size: 0.75rem;
    font-weight: 600;
    white-space: nowrap;
}

.role-badge.role-admin {
    background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);
    color: var(--white);
}

.role-badge.role-2wheel {
    background: linear-gradient(135deg, var(--info) 0%, #1d4ed8 100%);
    color: var(--white);
}

.role-badge.role-4wheel {
    background: linear-gradient(135deg, var(--purple) 0%, #7c3aed 100%);
    color: var(--white);
}

.status-badge.status-active {
    background: rgba(34, 197, 94, 0.1);
    color: var(--success);
    border: 1px solid rgba(34, 197, 94, 0.2);
}

.status-badge.status-inactive {
    background: rgba(239, 68, 68, 0.1);
    color: var(--danger);
    border: 1px solid rgba(239, 68, 68, 0.2);
}

.warehouse-info {
    display: flex;
    flex-direction: column;
    gap: 0.125rem;
}

.warehouse-code {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
}

.warehouse-name {
    font-size: 0.75rem;
    color: var(--gray-500);
}

.date-info {
    display: flex;
    flex-direction: column;
    gap: 0.125rem;
}

.date-main {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
}

.date-time {
    font-size: 0.75rem;
    color: var(--gray-500);
}

.action-buttons {
    display: flex;
    gap: 0.375rem;
    align-items: center;
}

.action-buttons .action-btn {
    width: 32px;
    height: 32px;
    padding: 0;
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.875rem;
    border: none;
    cursor: pointer;
    transition: var(--transition);
}

.edit-btn {
    background: rgba(59, 130, 246, 0.1);
    color: var(--info);
}

.edit-btn:hover {
    background: var(--info);
    color: var(--white);
    transform: translateY(-1px);
}

.toggle-btn {
    background: rgba(245, 158, 11, 0.1);
    color: var(--warning);
}

.toggle-btn:hover {
    background: var(--warning);
    color: var(--white);
    transform: translateY(-1px);
}

.reset-btn {
    background: rgba(139, 92, 246, 0.1);
    color: var(--purple);
}

.reset-btn:hover {
    background: var(--purple);
    color: var(--white);
    transform: translateY(-1px);
}

.delete-btn {
    background: rgba(239, 68, 68, 0.1);
    color: var(--danger);
}

.delete-btn:hover {
    background: var(--danger);
    color: var(--white);
    transform: translateY(-1px);
}

.mobile-cards {
    display: none;
    padding: 1rem;
    gap: 1rem;
    flex-direction: column;
}

@media (max-width: 768px) {
    .mobile-cards {
        display: flex;
    }
}

.user-card {
    background: var(--white);
    border: 1px solid var(--gray-200);
    border-radius: var(--radius-lg);
    padding: 1rem;
    transition: var(--transition);
}

.user-card:hover {
    box-shadow: var(--shadow-md);
    border-color: var(--primary);
}

.card-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1rem;
}

.card-header .user-info {
    flex: 1;
}

.card-menu-btn {
    width: 32px;
    height: 32px;
    border: none;
    background: var(--gray-100);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--gray-600);
    cursor: pointer;
    transition: var(--transition);
}

.card-menu-btn:hover {
    background: var(--primary);
    color: var(--white);
}

.card-body {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.card-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 0.5rem;
}

.row-label {
    font-size: 0.875rem;
    color: var(--gray-600);
    font-weight: 500;
    flex-shrink: 0;
}

.row-value {
    font-size: 0.875rem;
    color: var(--gray-900);
    font-weight: 600;
    text-align: right;
}

.card-actions {
    display: none;
    flex-direction: column;
    gap: 0.5rem;
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid var(--gray-200);
    animation: slideDown 0.3s ease;
}

.card-action-btn {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem;
    border: none;
    background: var(--gray-50);
    border-radius: var(--radius-md);
    font-size: 0.875rem;
    font-weight: 500;
    color: var(--gray-700);
    cursor: pointer;
    transition: var(--transition);
    text-decoration: none;
}

.card-action-btn.edit:hover {
    background: rgba(59, 130, 246, 0.1);
    color: var(--info);
}

.card-action-btn.toggle:hover {
    background: rgba(245, 158, 11, 0.1);
    color: var(--warning);
}

.card-action-btn.reset:hover {
    background: rgba(139, 92, 246, 0.1);
    color: var(--purple);
}

.card-action-btn.delete:hover {
    background: rgba(239, 68, 68, 0.1);
    color: var(--danger);
}

.empty-state, .empty-state-mobile {
    text-align: center;
    padding: clamp(2rem, 6vw, 4rem);
}

.empty-icon {
    width: clamp(64px, 12vw, 80px);
    height: clamp(64px, 12vw, 80px);
    margin: 0 auto 1.5rem;
    background: var(--gradient-soft);
    border-radius: var(--radius-xl);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: clamp(1.5rem, 4vw, 2rem);
    color: var(--primary);
}

.empty-text h3 {
    font-size: clamp(1.125rem, 3vw, 1.25rem);
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 0.5rem;
}

.empty-text p {
    font-size: clamp(0.875rem, 2.5vw, 1rem);
    color: var(--gray-600);
    margin-bottom: 1.5rem;
}

.empty-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: var(--gradient);
    color: var(--white);
    border-radius: var(--radius-md);
    text-decoration: none;
    font-weight: 600;
    transition: var(--transition);
}

.empty-btn:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: var(--white);
}

.bulk-actions {
    display: none;
    align-items: center;
    justify-content: space-between;
    background: var(--gradient);
    color: var(--white);
    padding: 1rem 1.5rem;
    border-radius: var(--radius-lg);
    margin-bottom: 1rem;
    box-shadow: var(--shadow-md);
}

.bulk-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.bulk-icon {
    width: 32px;
    height: 32px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
}

.bulk-text {
    font-weight: 600;
}

.bulk-buttons {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.bulk-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.5rem 1rem;
    border: none;
    border-radius: var(--radius-md);
    font-size: 0.875rem;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition);
    background: rgba(255, 255, 255, 0.2);
    color: var(--white);
}

.bulk-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-1px);
}

.pagination-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem 1.5rem;
    background: var(--gray-50);
    border-top: 1px solid var(--gray-200);
    flex-wrap: wrap;
    gap: 1rem;
}

.pagination-info {
    font-size: 0.875rem;
    color: var(--gray-600);
}

@media (max-width: 640px) {
    .header-content {
        flex-direction: column;
        align-items: stretch;
    }
    
    .header-actions {
        justify-content: stretch;
    }
    
    .action-btn {
        flex: 1;
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .filter-row {
        grid-template-columns: 1fr;
    }
    
    .filter-actions {
        justify-content: stretch;
    }
    
    .filter-btn {
        flex: 1;
        justify-content: center;
    }
}

@media (max-width: 480px) {
    .users-page {
        padding: 1rem;
        padding-bottom: 3rem;
    }
    
    .stat-content {
        flex-direction: column;
        text-align: center;
        gap: 0.75rem;
    }
    
    .container-header {
        flex-direction: column;
        gap: 0.75rem;
        align-items: stretch;
    }
}

.table-checkbox, .card-checkbox {
    width: 18px;
    height: 18px;
    accent-color: var(--primary);
    cursor: pointer;
}

.loading {
    opacity: 0.6;
    pointer-events: none;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.fade-in {
    animation: fadeIn 0.3s ease;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="users-page">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-info">
                <div class="header-title">
                    <div class="title-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="title-text">
                        <h1>จัดการผู้ใช้งาน</h1>
                        <p>จัดการข้อมูลผู้ใช้งานทั้งหมดในระบบ</p>
                    </div>
                </div>
            </div>
            <div class="header-actions">
                <button onclick="exportUsers()" class="action-btn export-btn">
                    <i class="fas fa-download"></i>
                    <span>Export</span>
                </button>
                <a href="<?php echo e(route('admin.users.create')); ?>" class="action-btn primary-btn">
                    <i class="fas fa-plus"></i>
                    <span>เพิ่มผู้ใช้</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="stats-grid">
        <div class="stat-card total">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-number"><?php echo e(number_format($stats['total'] ?? 0)); ?></div>
                    <div class="stat-label">ผู้ใช้ทั้งหมด</div>
                    <div class="stat-trend">
                        <i class="fas fa-chart-line"></i>
                        <span>ทั้งระบบ</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card active">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fas fa-user-check"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-number"><?php echo e(number_format($stats['active'] ?? 0)); ?></div>
                    <div class="stat-label">ใช้งานอยู่</div>
                    <div class="stat-trend">
                        <i class="fas fa-check-circle"></i>
                        <span>Active</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card vehicle-2w">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fas fa-motorcycle"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-number"><?php echo e(number_format($stats['2wheel'] ?? 0)); ?></div>
                    <div class="stat-label">รถ 2 ล้อ</div>
                    <div class="stat-trend">
                        <i class="fas fa-motorcycle"></i>
                        <span>2-Wheeler</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card vehicle-4w">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-number"><?php echo e(number_format($stats['4wheel'] ?? 0)); ?></div>
                    <div class="stat-label">รถ 4 ล้อ</div>
                    <div class="stat-trend">
                        <i class="fas fa-truck"></i>
                        <span>4-Wheeler</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Search & Filter Section -->
    <div class="filter-section">
        <div class="filter-header">
            <div class="filter-title">
                <i class="fas fa-filter"></i>
                <span>ค้นหาและกรอง</span>
            </div>
            <button class="filter-toggle" onclick="toggleFilters()">
                <i class="fas fa-chevron-down"></i>
            </button>
        </div>
        <div class="filter-content" id="filterContent">
            <form method="GET" action="<?php echo e(route('admin.users.index')); ?>" class="filter-form">
                <div class="filter-row">
                    <div class="filter-group">
                        <label class="filter-label">ค้นหา</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-search"></i>
                            </div>
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                                   class="filter-input" placeholder="ชื่อ, อีเมล หรือรหัสคลัง">
                        </div>
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">บทบาท</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-user-tag"></i>
                            </div>
                            <select name="role" class="filter-select">
                                <option value="">ทั้งหมด</option>
                                <option value="admin" <?php echo e(request('role') === 'admin' ? 'selected' : ''); ?>>👑 ผู้ดูแลระบบ</option>
                                <option value="2wheel" <?php echo e(request('role') === '2wheel' ? 'selected' : ''); ?>>🏍️ รถ 2 ล้อ</option>
                                <option value="4wheel" <?php echo e(request('role') === '4wheel' ? 'selected' : ''); ?>>🚚 รถ 4 ล้อ</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">สถานะ</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-toggle-on"></i>
                            </div>
                            <select name="status" class="filter-select">
                                <option value="">ทั้งหมด</option>
                                <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>✅ ใช้งานอยู่</option>
                                <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>❌ ปิดใช้งาน</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="filter-actions">
                        <button type="submit" class="filter-btn search-btn">
                            <i class="fas fa-search"></i>
                            <span>ค้นหา</span>
                        </button>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="filter-btn clear-btn">
                            <i class="fas fa-times"></i>
                            <span>ล้าง</span>
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Bulk Actions Bar -->
    <div class="bulk-actions" id="bulkActions" style="display: none;">
        <div class="bulk-info">
            <div class="bulk-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="bulk-text">
                เลือกแล้ว <span id="selectedCount">0</span> รายการ
            </div>
        </div>
        <div class="bulk-buttons">
            <button onclick="bulkAction('activate')" class="bulk-btn activate-btn">
                <i class="fas fa-user-check"></i>
                <span>เปิดใช้งาน</span>
            </button>
            <button onclick="bulkAction('deactivate')" class="bulk-btn deactivate-btn">
                <i class="fas fa-user-slash"></i>
                <span>ปิดใช้งาน</span>
            </button>
            <button onclick="clearSelection()" class="bulk-btn cancel-btn">
                <i class="fas fa-times"></i>
                <span>ยกเลิก</span>
            </button>
        </div>
    </div>

    <!-- Users List -->
    <div class="users-container">
        <div class="container-header">
            <div class="container-title">
                <i class="fas fa-list"></i>
                <span>รายชื่อผู้ใช้งาน</span>
            </div>
            <div class="container-count">
                ทั้งหมด <?php echo e(($users ?? collect())->total() ?? 0); ?> รายการ
            </div>
        </div>
        
        <div class="users-content">
            <!-- Desktop Table -->
            <div class="desktop-table">
                <table class="users-table">
                    <thead>
                        <tr>
                            <th class="checkbox-col">
                                <input type="checkbox" id="selectAll" class="table-checkbox">
                            </th>
                            <th class="user-col">ผู้ใช้</th>
                            <th class="role-col">บทบาท</th>
                            <th class="warehouse-col">คลังสินค้า</th>
                            <th class="status-col">สถานะ</th>
                            <th class="date-col">สร้างเมื่อ</th>
                            <th class="actions-col">การดำเนินการ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $users ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="user-row" data-user-id="<?php echo e($user->id); ?>">
                            <td class="checkbox-cell">
                                <input type="checkbox" class="user-checkbox table-checkbox" value="<?php echo e($user->id); ?>">
                            </td>
                            <td class="user-cell">
                                <div class="user-info">
                                    <div class="user-avatar">
                                        <?php echo e(strtoupper(substr($user->name ?? 'U', 0, 2))); ?>

                                    </div>
                                    <div class="user-details">
                                        <div class="user-name"><?php echo e($user->name ?? 'ไม่ระบุชื่อ'); ?></div>
                                        <div class="user-email"><?php echo e($user->email ?? 'ไม่ระบุอีเมล'); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td class="role-cell">
                                <div class="role-badge role-<?php echo e($user->role ?? 'unknown'); ?>">
                                    <?php if(($user->role ?? '') === 'admin'): ?>
                                        <i class="fas fa-crown"></i>
                                        <span>ผู้ดูแลระบบ</span>
                                    <?php elseif(($user->role ?? '') === '2wheel'): ?>
                                        <i class="fas fa-motorcycle"></i>
                                        <span>รถ 2 ล้อ</span>
                                    <?php elseif(($user->role ?? '') === '4wheel'): ?>
                                        <i class="fas fa-truck"></i>
                                        <span>รถ 4 ล้อ</span>
                                    <?php else: ?>
                                        <i class="fas fa-question"></i>
                                        <span><?php echo e($user->role ?? 'ไม่ระบุ'); ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="warehouse-cell">
                                <?php if($user->warehouse_code): ?>
                                    <div class="warehouse-info">
                                        <div class="warehouse-code"><?php echo e($user->warehouse_code); ?></div>
                                        <div class="warehouse-name"><?php echo e($user->warehouse->name ?? 'ไม่พบชื่อคลัง'); ?></div>
                                    </div>
                                <?php else: ?>
                                    <span class="no-data">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="status-cell">
                                <div class="status-badge status-<?php echo e(($user->is_active ?? false) ? 'active' : 'inactive'); ?>">
                                    <?php if($user->is_active ?? false): ?>
                                        <i class="fas fa-check-circle"></i>
                                        <span>ใช้งานอยู่</span>
                                    <?php else: ?>
                                        <i class="fas fa-times-circle"></i>
                                        <span>ปิดใช้งาน</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="date-cell">
                                <?php if($user->created_at): ?>
                                    <div class="date-info">
                                        <div class="date-main"><?php echo e($user->created_at->format('d/m/Y')); ?></div>
                                        <div class="date-time"><?php echo e($user->created_at->format('H:i')); ?></div>
                                    </div>
                                <?php else: ?>
                                    <span class="no-data">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="actions-cell">
                                <div class="action-buttons">
                                    <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="action-btn edit-btn" title="แก้ไข">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php if($user->id !== auth()->id()): ?>
                                        <button onclick="toggleUserStatus(<?php echo e($user->id); ?>)" 
                                                class="action-btn toggle-btn" 
                                                title="<?php echo e(($user->is_active ?? false) ? 'ปิดใช้งาน' : 'เปิดใช้งาน'); ?>">
                                            <i class="fas fa-<?php echo e(($user->is_active ?? false) ? 'user-slash' : 'user-check'); ?>"></i>
                                        </button>
                                        <button onclick="resetPassword(<?php echo e($user->id); ?>)" 
                                                class="action-btn reset-btn" title="รีเซ็ตรหัสผ่าน">
                                            <i class="fas fa-key"></i>
                                        </button>
                                        <button onclick="deleteUser(<?php echo e($user->id); ?>)" 
                                                class="action-btn delete-btn" title="ลบผู้ใช้">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    <?php else: ?>
                                        <span class="self-indicator">ตัวคุณเอง</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="empty-state">
                                <div class="empty-content">
                                    <div class="empty-icon">
                                        <i class="fas fa-users"></i>
                                    </div>
                                    <div class="empty-text">
                                        <h3>ไม่มีผู้ใช้งาน</h3>
                                        <p>ยังไม่มีผู้ใช้งานในระบบ หรือไม่พบผลการค้นหา</p>
                                    </div>
                                    <div class="empty-action">
                                        <a href="<?php echo e(route('admin.users.create')); ?>" class="empty-btn">
                                            <i class="fas fa-plus"></i>
                                            <span>เพิ่มผู้ใช้แรก</span>
                                        </a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Mobile Cards -->
            <div class="mobile-cards">
                <?php $__empty_1 = true; $__currentLoopData = $users ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="user-card" data-user-id="<?php echo e($user->id); ?>">
                    <div class="card-header">
                        <input type="checkbox" class="user-checkbox card-checkbox" value="<?php echo e($user->id); ?>">
                        <div class="user-info">
                            <div class="user-avatar">
                                <?php echo e(strtoupper(substr($user->name ?? 'U', 0, 2))); ?>

                            </div>
                            <div class="user-details">
                                <div class="user-name"><?php echo e($user->name ?? 'ไม่ระบุชื่อ'); ?></div>
                                <div class="user-email"><?php echo e($user->email ?? 'ไม่ระบุอีเมล'); ?></div>
                            </div>
                        </div>
                        <?php if($user->id !== auth()->id()): ?>
                        <button class="card-menu-btn" onclick="toggleCardMenu(<?php echo e($user->id); ?>)">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                        <?php endif; ?>
                    </div>
                    
                    <div class="card-body">
                        <div class="card-row">
                            <span class="row-label">บทบาท:</span>
                            <div class="role-badge role-<?php echo e($user->role ?? 'unknown'); ?>">
                                <?php if(($user->role ?? '') === 'admin'): ?>
                                    <i class="fas fa-crown"></i> Admin
                                <?php elseif(($user->role ?? '') === '2wheel'): ?>
                                    <i class="fas fa-motorcycle"></i> 2 ล้อ
                                <?php elseif(($user->role ?? '') === '4wheel'): ?>
                                    <i class="fas fa-truck"></i> 4 ล้อ
                                <?php else: ?>
                                    <?php echo e($user->role ?? 'ไม่ระบุ'); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">คลัง:</span>
                            <span class="row-value">
                                <?php echo e($user->warehouse_code ?? '-'); ?>

                            </span>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">สถานะ:</span>
                            <div class="status-badge status-<?php echo e(($user->is_active ?? false) ? 'active' : 'inactive'); ?>">
                                <?php if($user->is_active ?? false): ?>
                                    <i class="fas fa-check-circle"></i> ใช้งาน
                                <?php else: ?>
                                    <i class="fas fa-times-circle"></i> ปิดใช้งาน
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">สร้างเมื่อ:</span>
                            <span class="row-value">
                                <?php echo e($user->created_at ? $user->created_at->format('d/m/Y H:i') : '-'); ?>

                            </span>
                        </div>
                    </div>
                    
                    <?php if($user->id !== auth()->id()): ?>
                    <div class="card-actions" id="card-actions-<?php echo e($user->id); ?>" style="display: none;">
                        <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="card-action-btn edit">
                            <i class="fas fa-edit"></i> แก้ไข
                        </a>
                        <button onclick="toggleUserStatus(<?php echo e($user->id); ?>)" class="card-action-btn toggle">
                            <i class="fas fa-<?php echo e(($user->is_active ?? false) ? 'user-slash' : 'user-check'); ?>"></i>
                            <?php echo e(($user->is_active ?? false) ? 'ปิดใช้งาน' : 'เปิดใช้งาน'); ?>

                        </button>
                        <button onclick="resetPassword(<?php echo e($user->id); ?>)" class="card-action-btn reset">
                            <i class="fas fa-key"></i> รีเซ็ตรหัสผ่าน
                        </button>
                        <button onclick="deleteUser(<?php echo e($user->id); ?>)" class="card-action-btn delete">
                            <i class="fas fa-trash"></i> ลบ
                        </button>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="empty-state-mobile">
                    <div class="empty-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="empty-text">
                        <h3>ไม่มีผู้ใช้งาน</h3>
                        <p>ยังไม่มีผู้ใช้งานในระบบ</p>
                    </div>
                    <div class="empty-action">
                        <a href="<?php echo e(route('admin.users.create')); ?>" class="empty-btn">
                            <i class="fas fa-plus"></i>
                            <span>เพิ่มผู้ใช้แรก</span>
                        </a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Pagination -->
        <?php if(isset($users) && $users->hasPages()): ?>
        <div class="pagination-section">
            <div class="pagination-info">
                แสดง <?php echo e($users->firstItem() ?? 0); ?> ถึง <?php echo e($users->lastItem() ?? 0); ?> 
                จาก <?php echo e($users->total() ?? 0); ?> รายการ
            </div>
            <div class="pagination-links">
                <?php echo e($users->links()); ?>

            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.users.index-scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/admin/users/index.blade.php ENDPATH**/ ?>