<?php $__env->startSection('title', __('Profile') . ' - ' . config('app.name')); ?>

<?php $__env->startSection('content'); ?>
<!-- Welcome Card (Mobile Only) -->
<div class="welcome-card">
    <div class="welcome-content">
        <div class="welcome-text">
            <div class="welcome-greeting">โปรไฟล์</div>
            <div class="welcome-name"><?php echo e($user->name); ?></div>
            <div class="welcome-subtitle">จัดการข้อมูลส่วนตัวของคุณ</div>
        </div>
        <div class="welcome-icon">
            <div class="profile-avatar-mobile">
                <?php echo e(strtoupper(substr($user->first_name, 0, 1) . substr($user->last_name, 0, 1))); ?>

            </div>
        </div>
    </div>
</div>

<div class="profile-container">

    <!-- User Info -->
    <div class="user-info-card">
        <div class="info-header">
            <div class="info-avatar">
                <?php echo e(strtoupper(substr($user->first_name, 0, 1) . substr($user->last_name, 0, 1))); ?>

            </div>
            <div class="info-details">
                <h2 class="info-name"><?php echo e($user->name); ?></h2>
                <div class="info-meta">
                    <div class="meta-item">
                        <i class="fas fa-<?php echo e($user->role == '2wheel' ? 'motorcycle' : ($user->role == '4wheel' ? 'truck' : 'user-shield')); ?>"></i>
                        <span><?php echo e($user->role_display_name); ?></span>
                    </div>
                    <div class="meta-item">
                        <i class="fas fa-warehouse"></i>
                        <span><?php echo e($user->warehouse->name ?? $user->warehouse_code); ?></span>
                    </div>
                </div>
            </div>
            <div class="info-status">
                <div class="status-badge <?php echo e($user->is_active ? 'active' : 'inactive'); ?>">
                    <i class="fas fa-circle"></i>
                    <span><?php echo e($user->is_active ? 'ใช้งานได้' : 'ปิดใช้งาน'); ?></span>
                </div>
            </div>
        </div>
    </div>

    <div class="content-grid">
        <div class="form-card">
            <div class="card-header">
                <div class="card-title">
                    <i class="fas fa-user"></i>
                    ข้อมูลส่วนตัว
                </div>
            </div>
            <div class="card-content">
                <form id="profileForm" method="post" action="<?php echo e(route('profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('patch'); ?>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="profile_first_name" class="form-label">ชื่อ <span class="required">*</span></label>
                            <input type="text" id="profile_first_name" name="first_name" 
                                   value="<?php echo e(old('first_name', $user->first_name)); ?>" 
                                   class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <label for="profile_last_name" class="form-label">นามสกุล <span class="required">*</span></label>
                            <input type="text" id="profile_last_name" name="last_name" 
                                   value="<?php echo e(old('last_name', $user->last_name)); ?>" 
                                   class="form-control <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="profile_email" class="form-label">อีเมล <span class="required">*</span></label>
                        <input type="email" id="profile_email" name="email" 
                               value="<?php echo e(old('email', $user->email)); ?>" 
                               class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php if($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail()): ?>
                            <div class="verification-notice">
                                <i class="fas fa-exclamation-triangle"></i>
                                <span>อีเมลยังไม่ได้รับการยืนยัน</span>
                                <button type="button" class="verify-btn" onclick="sendVerification()">
                                    ส่งอีเมลยืนยันใหม่
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i>
                            <span>บันทึกการเปลี่ยนแปลง</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="form-card">
            <div class="card-header">
                <div class="card-title">
                    <i class="fas fa-key"></i>
                    เปลี่ยนรหัสผ่าน
                </div>
            </div>
            <div class="card-content">
                <form id="passwordForm" method="post" action="<?php echo e(route('password.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('put'); ?>

                    <div class="form-group">
                        <label for="pwd_current_password" class="form-label">รหัสผ่านปัจจุบัน <span class="required">*</span></label>
                        <div class="password-wrapper">
                            <input type="password" id="pwd_current_password" name="current_password" 
                                   class="form-control <?php $__errorArgs = ['current_password', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   autocomplete="current-password" required>
                            <button type="button" class="password-toggle" onclick="togglePassword(this)">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <?php $__errorArgs = ['current_password', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="pwd_new_password" class="form-label">รหัสผ่านใหม่ <span class="required">*</span></label>
                        <div class="password-wrapper">
                            <input type="password" id="pwd_new_password" name="password" 
                                   class="form-control <?php $__errorArgs = ['password', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   autocomplete="new-password" required>
                            <button type="button" class="password-toggle" onclick="togglePassword(this)">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <?php $__errorArgs = ['password', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="pwd_password_confirmation" class="form-label">ยืนยันรหัสผ่านใหม่ <span class="required">*</span></label>
                        <div class="password-wrapper">
                            <input type="password" id="pwd_password_confirmation" name="password_confirmation" 
                                   class="form-control <?php $__errorArgs = ['password_confirmation', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   autocomplete="new-password" required>
                            <button type="button" class="password-toggle" onclick="togglePassword(this)">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <?php $__errorArgs = ['password_confirmation', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn btn-secondary">
                            <i class="fas fa-key"></i>
                            <span>อัปเดตรหัสผ่าน</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="form-card">
            <div class="card-header">
                <div class="card-title">
                    <i class="fas fa-info-circle"></i>
                    ข้อมูลบัญชี
                </div>
            </div>
            <div class="card-content">
                <div class="info-grid">
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-id-card"></i>
                        </div>
                        <div class="info-content">
                            <div class="info-label">รหัสพนักงาน</div>
                            <div class="info-value">#<?php echo e(str_pad($user->id, 4, '0', STR_PAD_LEFT)); ?></div>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-calendar-plus"></i>
                        </div>
                        <div class="info-content">
                            <div class="info-label">วันที่สมัคร</div>
                            <div class="info-value"><?php echo e($user->created_at->format('d/m/Y')); ?></div>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="info-content">
                            <div class="info-label">อัปเดตล่าสุด</div>
                            <div class="info-value"><?php echo e($user->updated_at->diffForHumans()); ?></div>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="info-content">
                            <div class="info-label">สถานะอีเมล</div>
                            <div class="info-value">
                                <?php if($user->hasVerifiedEmail()): ?>
                                    <span class="status-verified">
                                        <i class="fas fa-check-circle"></i>
                                        ยืนยันแล้ว
                                    </span>
                                <?php else: ?>
                                    <span class="status-unverified">
                                        <i class="fas fa-exclamation-circle"></i>
                                        ยังไม่ยืนยัน
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-card danger-card">
            <div class="card-header">
                <div class="card-title danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    โซนอันตราย
                </div>
            </div>
            <div class="card-content">
                <div class="danger-warning">
                    <h4 class="danger-title">ลบบัญชี</h4>
                    <p class="danger-text">
                        การลบบัญชีจะไม่สามารถกู้คืนได้ ข้อมูลทั้งหมดรวมถึงประวัติการจัดส่งจะถูกลบอย่างถาวร
                    </p>
                    <ul class="danger-list">
                        <li>ข้อมูลส่วนตัวทั้งหมดจะถูกลบ</li>
                        <li>ประวัติการจัดส่งจะหายไป</li>
                        <li>ไม่สามารถเข้าสู่ระบบได้อีก</li>
                    </ul>
                </div>
                <div class="form-actions">
                    <button type="button" class="btn btn-danger" onclick="confirmDeleteAccount()">
                        <i class="fas fa-trash"></i>
                        <span>ลบบัญชี</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<form id="deleteAccountForm" method="post" action="<?php echo e(route('profile.destroy')); ?>" style="display: none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('delete'); ?>
    <input type="password" name="password" id="deletePassword">
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Welcome Card */
.welcome-card {
    background: var(--gradient);
    border-radius: 20px;
    padding: 20px;
    margin-bottom: 20px;
    color: white;
}

.welcome-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.welcome-greeting {
    font-size: 14px;
    opacity: 0.9;
    margin-bottom: 4px;
}

.welcome-name {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 4px;
}

.welcome-subtitle {
    font-size: 14px;
    opacity: 0.9;
}

.profile-avatar-mobile {
    width: 50px;
    height: 50px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 18px;
    font-weight: 700;
    color: white;
}

.welcome-icon {
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Container */
.profile-container {
    padding: 0;
}

/* User Info Card */
.user-info-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.info-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 16px;
}

.info-avatar {
    width: 60px;
    height: 60px;
    background: var(--gradient-soft);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    font-weight: 700;
    color: var(--primary);
}

.info-details {
    flex: 1;
    margin-left: 16px;
}

.info-name {
    font-size: 18px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 8px;
}

.info-meta {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    color: var(--gray-600);
    font-weight: 500;
}

.meta-item i {
    color: var(--primary);
    width: 16px;
}

.info-status {
    display: flex;
    align-items: center;
}

.status-badge {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 8px 12px;
    border-radius: 20px;
    font-weight: 600;
    font-size: 12px;
}

.status-badge.active {
    background: #D1FAE5;
    color: #065F46;
}

.status-badge.inactive {
    background: #FEE2E2;
    color: #991B1B;
}

.content-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 20px;
}

.form-card {
    background: white;
    border-radius: 16px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
    overflow: hidden;
}

.danger-card {
    border: 2px solid rgba(239, 68, 68, 0.2);
}

.card-header {
    background: var(--gradient-soft);
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,107,53,0.1);
}

.card-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--primary);
    display: flex;
    align-items: center;
    gap: 8px;
}

.card-title.danger {
    color: #EF4444;
}

.card-content {
    padding: 20px;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 16px;
    margin-bottom: 16px;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
    margin-bottom: 16px;
}

.form-label {
    font-weight: 500;
    color: var(--gray-700);
    font-size: 14px;
}

.required {
    color: #EF4444;
}

.form-control {
    padding: 12px;
    border: 2px solid var(--gray-200);
    border-radius: 8px;
    font-size: 14px;
    transition: all 0.3s ease;
    background: white;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.form-control.error {
    border-color: #EF4444;
}

.error-message {
    color: #EF4444;
    font-size: 12px;
    margin-top: 4px;
}

.password-wrapper {
    position: relative;
}

.password-toggle {
    position: absolute;
    right: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: #9CA3AF;
    cursor: pointer;
    padding: 0.5rem;
    border-radius: 6px;
    transition: all 0.3s ease;
}

.password-toggle:hover {
    color: #6B7280;
    background: #F3F4F6;
}

.verification-notice {
    background: #FEF3C7;
    border: 1px solid #F59E0B;
    border-radius: 8px;
    padding: 0.75rem;
    margin-top: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.85rem;
    color: #92400E;
}

.verify-btn {
    background: none;
    border: none;
    color: #D97706;
    text-decoration: underline;
    cursor: pointer;
    font-weight: 600;
    margin-left: auto;
}

.btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border-radius: 8px;
    font-weight: 600;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    font-size: 14px;
}

.btn-primary {
    background: var(--gradient);
    color: white;
}

.btn-primary:active {
    transform: scale(0.98);
}

.btn-secondary {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    color: white;
}

.btn-secondary:active {
    transform: scale(0.98);
}

.btn-danger {
    background: linear-gradient(135deg, #EF4444 0%, #DC2626 100%);
    color: white;
}

.btn-danger:active {
    transform: scale(0.98);
}

.form-actions {
    margin-top: 20px;
    padding-top: 16px;
    border-top: 1px solid var(--gray-200);
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
}

.info-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 16px;
    background: var(--gray-50);
    border-radius: 12px;
    border: 1px solid var(--gray-200);
}

.info-icon {
    width: 40px;
    height: 40px;
    background: var(--gradient-soft);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--primary);
    font-size: 16px;
}

.info-content {
    flex: 1;
}

.info-label {
    display: block;
    font-size: 12px;
    color: var(--gray-500);
    font-weight: 500;
    margin-bottom: 4px;
}

.info-value {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 14px;
}

.status-verified {
    color: #059669;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.status-unverified {
    color: #DC2626;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.danger-warning {
    margin-bottom: 2rem;
}

.danger-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: #DC2626;
    margin: 0 0 1rem 0;
}

.danger-text {
    color: #7F1D1D;
    font-size: 0.9rem;
    margin-bottom: 1rem;
    line-height: 1.5;
}

.danger-list {
    color: #7F1D1D;
    font-size: 0.85rem;
    margin: 0;
    padding-left: 1.5rem;
}

.danger-list li {
    margin-bottom: 0.25rem;
}

/* Desktop Styles */
@media (min-width: 769px) {
    .welcome-card {
        display: none;
    }
    
    .user-info-card {
        display: block;
    }
}

@media (max-width: 768px) {
    .user-info-card {
        display: none;
    }
    
    .content-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .card-content {
        padding: 16px;
    }
    
    .card-header {
        padding: 12px 16px;
    }
    
    .info-header {
        flex-direction: column;
        text-align: center;
        gap: 12px;
    }
    
    .info-details {
        margin-left: 0;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function togglePassword(button) {
    const input = button.parentElement.querySelector('input');
    const icon = button.querySelector('i');
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

document.getElementById('profileForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    Swal.fire({
        title: 'ยืนยันการบันทึก',
        text: 'คุณต้องการบันทึกการเปลี่ยนแปลงหรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'บันทึก',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            this.submit();
        }
    });
});

document.getElementById('passwordForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    Swal.fire({
        title: 'ยืนยันการเปลี่ยนรหัสผ่าน',
        text: 'คุณจะต้องเข้าสู่ระบบใหม่หลังจากเปลี่ยนรหัสผ่าน',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'เปลี่ยนรหัสผ่าน',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            this.submit();
        }
    });
});

function confirmDeleteAccount() {
    Swal.fire({
        title: 'คุณแน่ใจหรือไม่?',
        html: `
            <div style="text-align: left;">
                <p style="color: #dc2626; font-weight: 600;">⚠️ การดำเนินการนี้ไม่สามารถยกเลิกได้</p>
                <ul style="text-align: left; color: #666; margin: 1rem 0;">
                    <li>ข้อมูลทั้งหมดจะถูกลบ</li>
                    <li>ประวัติการจัดส่งจะหายไป</li>
                    <li>ไม่สามารถเข้าสู่ระบบได้อีก</li>
                </ul>
                <p style="margin-top: 1rem;">กรุณาใส่รหัสผ่านเพื่อยืนยัน:</p>
            </div>
        `,
        input: 'password',
        inputPlaceholder: 'ใส่รหัสผ่านของคุณ',
        inputAttributes: {
            autocapitalize: 'off',
            autocorrect: 'off'
        },
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#DC2626',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ลบบัญชี',
        cancelButtonText: 'ยกเลิก',
        preConfirm: (password) => {
            if (!password) {
                Swal.showValidationMessage('กรุณาใส่รหัสผ่าน');
                return false;
            }
            return password;
        }
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'ยืนยันอีกครั้ง',
                text: 'นี่คือการยืนยันครั้งสุดท้าย คุณแน่ใจหรือไม่?',
                icon: 'error',
                showCancelButton: true,
                confirmButtonColor: '#DC2626',
                cancelButtonColor: '#6B7280',
                confirmButtonText: 'ใช่ ลบเลย',
                cancelButtonText: 'ไม่ เก็บไว้'
            }).then((finalResult) => {
                if (finalResult.isConfirmed) {
                    document.getElementById('deletePassword').value = result.value;
                    document.getElementById('deleteAccountForm').submit();
                }
            });
        }
    });
}

function sendVerification() {
    Swal.fire({
        title: 'ส่งอีเมลยืนยัน',
        text: 'ส่งลิงก์ยืนยันใหม่ไปยังอีเมลของคุณ?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ส่งอีเมล',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '<?php echo e(route("verification.send")); ?>';
            
            const token = document.createElement('input');
            token.type = 'hidden';
            token.name = '_token';
            token.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(token);
            
            document.body.appendChild(form);
            form.submit();
        }
    });
}

<?php if(session('status') === 'profile-updated'): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: 'อัปเดตโปรไฟล์เรียบร้อยแล้ว',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

<?php if(session('status') === 'password-updated'): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: 'เปลี่ยนรหัสผ่านเรียบร้อยแล้ว',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

<?php if(session('status') === 'verification-link-sent'): ?>
    Swal.fire({
        icon: 'success',
        title: 'ส่งอีเมลแล้ว!',
        text: 'ลิงก์ยืนยันถูกส่งไปยังอีเมลของคุณแล้ว',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\crs\resources\views/profile/edit.blade.php ENDPATH**/ ?>