

<?php $__env->startSection('title', 'แก้ไขคลังสินค้า'); ?>
<?php $__env->startSection('page-title', 'แก้ไขคลังสินค้า'); ?>
<?php $__env->startSection('mobile-title', 'แก้ไขคลัง'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Modern Page Header -->
    <div class="mb-8">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div class="flex-1">
                <div class="flex items-center gap-3 mb-2">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-edit text-white text-xl"></i>
                    </div>
                    <div>
                        <h1 class="text-2xl lg:text-3xl font-bold text-gray-900">แก้ไขคลังสินค้า</h1>
                        <p class="text-gray-600 mt-1">
                            รหัส: <span class="font-semibold text-orange-600"><?php echo e($warehouse->code); ?></span> - <?php echo e($warehouse->name); ?>

                        </p>
                    </div>
                </div>
            </div>
            <div class="flex flex-col sm:flex-row gap-3">
                <a href="<?php echo e(route('admin.commission-rates.index', ['warehouse' => $warehouse->code])); ?>" 
                   class="inline-flex items-center justify-center px-4 py-2.5 bg-gradient-to-r from-blue-500 to-blue-600 text-white font-medium rounded-xl hover:from-blue-600 hover:to-blue-700 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                    <i class="fas fa-percentage mr-2"></i>จัดการอัตราค่าคอมมิชชั่น
                </a>
                <a href="<?php echo e(route('admin.warehouses.index')); ?>" 
                   class="inline-flex items-center justify-center px-4 py-2.5 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-all duration-200">
                    <i class="fas fa-arrow-left mr-2"></i>กลับไปรายการ
                </a>
            </div>
        </div>
    </div>

    <!-- Modern Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-200">
            <div class="flex items-center gap-4">
                <div class="w-14 h-14 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-users text-white text-xl"></i>
                </div>
                <div class="flex-1">
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($warehouse->users->count()); ?></div>
                    <div class="text-sm font-medium text-gray-600 mb-1">ผู้ใช้ทั้งหมด</div>
                    <div class="text-xs text-gray-500"><?php echo e($warehouse->users->where('is_active', true)->count()); ?> ใช้งานอยู่</div>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-200">
            <div class="flex items-center gap-4">
                <div class="w-14 h-14 bg-gradient-to-br from-orange-500 to-orange-600 rounded-xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-percentage text-white text-xl"></i>
                </div>
                <div class="flex-1">
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($warehouse->commissionRates->count()); ?></div>
                    <div class="text-sm font-medium text-gray-600 mb-1">อัตราค่าคอมมิชชั่น</div>
                    <div class="text-xs text-gray-500"><?php echo e($warehouse->commissionRates->where('is_active', true)->count()); ?> ใช้งานอยู่</div>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-200">
            <div class="flex items-center gap-4">
                <div class="w-14 h-14 bg-gradient-to-br from-<?php echo e($warehouse->is_active ? 'green' : 'red'); ?>-500 to-<?php echo e($warehouse->is_active ? 'green' : 'red'); ?>-600 rounded-xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-<?php echo e($warehouse->is_active ? 'check-circle' : 'times-circle'); ?> text-white text-xl"></i>
                </div>
                <div class="flex-1">
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($warehouse->is_active ? 'เปิด' : 'ปิด'); ?></div>
                    <div class="text-sm font-medium text-gray-600 mb-1">สถานะ</div>
                    <div class="text-xs text-gray-500"><?php echo e($warehouse->is_active ? 'ใช้งานอยู่' : 'ปิดใช้งาน'); ?></div>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-200">
            <div class="flex items-center gap-4">
                <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-calendar-alt text-white text-xl"></i>
                </div>
                <div class="flex-1">
                    <div class="text-lg font-bold text-gray-900"><?php echo e($warehouse->created_at ? $warehouse->created_at->diffForHumans() : '-'); ?></div>
                    <div class="text-sm font-medium text-gray-600 mb-1">สร้างเมื่อ</div>
                    <div class="text-xs text-gray-500"><?php echo e($warehouse->created_at ? $warehouse->created_at->format('d/m/Y H:i') : '-'); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modern Form Container -->
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-6 py-4 border-b border-gray-200">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center">
                    <i class="fas fa-warehouse text-white"></i>
                </div>
                <h3 class="text-lg font-semibold text-gray-900">ข้อมูลคลังสินค้า</h3>
            </div>
        </div>
        
        <div class="p-6">
            <form method="POST" action="<?php echo e(route('admin.warehouses.update', $warehouse)); ?>" id="warehouseForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- รหัสคลัง -->
                    <div class="space-y-2">
                        <label for="code" class="block text-sm font-semibold text-gray-700">
                            รหัสคลัง <span class="text-red-500">*</span>
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-barcode text-gray-400"></i>
                            </div>
                            <input type="text" id="code" name="code" 
                                   value="<?php echo e(old('code', $warehouse->code)); ?>" 
                                   class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition-all duration-200 <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 ring-2 ring-red-200 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   placeholder="เช่น WH001, BKK01" required maxlength="10">
                        </div>
                        <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm flex items-center gap-1">
                                <i class="fas fa-exclamation-circle"></i><?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <p class="text-gray-500 text-sm flex items-center gap-1">
                            <i class="fas fa-info-circle text-blue-500"></i>รหัสคลังต้องไม่ซ้ำกัน และมีได้สูงสุด 10 ตัวอักษร
                        </p>
                    </div>

                    <!-- ชื่อคลัง -->
                    <div class="space-y-2">
                        <label for="name" class="block text-sm font-semibold text-gray-700">
                            ชื่อคลัง <span class="text-red-500">*</span>
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-warehouse text-gray-400"></i>
                            </div>
                            <input type="text" id="name" name="name" 
                                   value="<?php echo e(old('name', $warehouse->name)); ?>" 
                                   class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition-all duration-200 <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 ring-2 ring-red-200 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   placeholder="เช่น คลังสินค้ากรุงเทพ" required>
                        </div>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm flex items-center gap-1">
                                <i class="fas fa-exclamation-circle"></i><?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- ที่อยู่ -->
                    <div class="lg:col-span-2 space-y-2">
                        <label for="location" class="block text-sm font-semibold text-gray-700">ที่อยู่</label>
                        <div class="relative">
                            <div class="absolute top-3 left-3 pointer-events-none">
                                <i class="fas fa-map-marker-alt text-gray-400"></i>
                            </div>
                            <textarea id="location" name="location" rows="3" 
                                      class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition-all duration-200 resize-none <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 ring-2 ring-red-200 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      placeholder="ระบุที่อยู่ของคลังสินค้า"><?php echo e(old('location', $warehouse->location)); ?></textarea>
                        </div>
                        <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm flex items-center gap-1">
                                <i class="fas fa-exclamation-circle"></i><?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- สถานะ -->
                    <div class="space-y-3">
                        <label class="block text-sm font-semibold text-gray-700">สถานะ</label>
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                            <label class="relative flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all duration-200 <?php echo e(old('is_active', $warehouse->is_active) ? 'border-green-500 bg-green-50' : 'border-gray-200 hover:border-green-300'); ?>">
                                <input type="radio" name="is_active" value="1" 
                                       <?php echo e(old('is_active', $warehouse->is_active) ? 'checked' : ''); ?>

                                       class="sr-only">
                                <div class="flex items-center gap-3">
                                    <div class="w-5 h-5 border-2 rounded-full flex items-center justify-center <?php echo e(old('is_active', $warehouse->is_active) ? 'border-green-500 bg-green-500' : 'border-gray-300'); ?>">
                                        <?php if(old('is_active', $warehouse->is_active)): ?>
                                            <div class="w-2 h-2 bg-white rounded-full"></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-check-circle text-green-500"></i>
                                        <span class="font-medium text-gray-900">ใช้งานอยู่</span>
                                    </div>
                                </div>
                            </label>
                            <label class="relative flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all duration-200 <?php echo e(!old('is_active', $warehouse->is_active) ? 'border-red-500 bg-red-50' : 'border-gray-200 hover:border-red-300'); ?>">
                                <input type="radio" name="is_active" value="0" 
                                       <?php echo e(!old('is_active', $warehouse->is_active) ? 'checked' : ''); ?>

                                       class="sr-only">
                                <div class="flex items-center gap-3">
                                    <div class="w-5 h-5 border-2 rounded-full flex items-center justify-center <?php echo e(!old('is_active', $warehouse->is_active) ? 'border-red-500 bg-red-500' : 'border-gray-300'); ?>">
                                        <?php if(!old('is_active', $warehouse->is_active)): ?>
                                            <div class="w-2 h-2 bg-white rounded-full"></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-times-circle text-red-500"></i>
                                        <span class="font-medium text-gray-900">ปิดใช้งาน</span>
                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>

                    <!-- ข้อมูลระบบ -->
                    <div class="lg:col-span-2 space-y-3">
                        <label class="block text-sm font-semibold text-gray-700">ข้อมูลระบบ</label>
                        <div class="bg-gradient-to-r from-gray-50 to-gray-100 rounded-xl p-4 border border-gray-200">
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                <div class="space-y-1">
                                    <div class="text-sm font-medium text-gray-600">สร้างเมื่อ</div>
                                    <div class="text-sm font-semibold text-gray-900">
                                        <?php echo e($warehouse->created_at ? $warehouse->created_at->format('d/m/Y H:i:s') : '-'); ?>

                                    </div>
                                </div>
                                <div class="space-y-1">
                                    <div class="text-sm font-medium text-gray-600">อัปเดตล่าสุด</div>
                                    <div class="text-sm font-semibold text-gray-900">
                                        <?php echo e($warehouse->updated_at ? $warehouse->updated_at->format('d/m/Y H:i:s') : '-'); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Modern Submit Section -->
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4 pt-6 mt-6 border-t border-gray-200">
                    <div class="flex-1">
                        <?php if($warehouse->users->count() === 0): ?>
                        <button type="button" onclick="deleteWarehouse()" 
                                class="inline-flex items-center px-4 py-2.5 bg-gradient-to-r from-red-500 to-red-600 text-white font-medium rounded-xl hover:from-red-600 hover:to-red-700 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                            <i class="fas fa-trash mr-2"></i>ลบคลัง
                        </button>
                        <?php else: ?>
                        <div class="flex items-center gap-2 text-amber-600 bg-amber-50 px-4 py-2.5 rounded-xl border border-amber-200">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span class="text-sm font-medium">ไม่สามารถลบคลังที่มีผู้ใช้งานได้</span>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="flex flex-col sm:flex-row gap-3">
                        <a href="<?php echo e(route('admin.warehouses.index')); ?>" 
                           class="inline-flex items-center justify-center px-6 py-2.5 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-all duration-200">
                            <i class="fas fa-times mr-2"></i>ยกเลิก
                        </a>

                        <button type="submit" id="submitBtn" 
                                class="inline-flex items-center justify-center px-6 py-2.5 bg-gradient-to-r from-orange-500 to-orange-600 text-white font-medium rounded-xl hover:from-orange-600 hover:to-orange-700 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 relative overflow-hidden">
                            <span class="flex items-center">
                                <i class="fas fa-save mr-2"></i>บันทึกการเปลี่ยนแปลง
                            </span>
                            <span class="absolute inset-0 flex items-center justify-center opacity-0 transition-opacity duration-200" id="loadingSpinner">
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Users & Rates Overview -->
    <?php if($warehouse->users->count() > 0 || $warehouse->commissionRates->count() > 0): ?>
    <div class="mt-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Users Overview -->
            <?php if($warehouse->users->count() > 0): ?>
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-users text-white"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900">ผู้ใช้งานในคลัง (<?php echo e($warehouse->users->count()); ?> คน)</h3>
                    </div>
                </div>
                <div class="p-6">
                    <div class="space-y-4">
                        <?php $__currentLoopData = $warehouse->users->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center gap-4 p-4 border border-gray-200 rounded-xl hover:border-orange-300 hover:bg-orange-50 transition-all duration-200">
                            <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center text-white font-semibold">
                                <?php echo e(strtoupper(substr($user->name, 0, 2))); ?>

                            </div>
                            <div class="flex-1">
                                <div class="font-semibold text-gray-900"><?php echo e($user->name); ?></div>
                                <div class="text-sm text-gray-600"><?php echo e($user->role); ?></div>
                            </div>
                            <div>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium <?php echo e($user->is_active ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                                    <?php echo e($user->is_active ? 'ใช้งานอยู่' : 'ปิดใช้งาน'); ?>

                                </span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($warehouse->users->count() > 5): ?>
                        <div class="pt-4 border-t border-gray-200 text-center">
                            <a href="<?php echo e(route('admin.users.index', ['warehouse' => $warehouse->code])); ?>" 
                               class="inline-flex items-center px-4 py-2 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-all duration-200">
                                ดูทั้งหมด <?php echo e($warehouse->users->count()); ?> คน
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Commission Rates Overview -->
            <?php if($warehouse->commissionRates->count() > 0): ?>
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-orange-500 to-orange-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-percentage text-white"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900">อัตราค่าคอมมิชชั่น (<?php echo e($warehouse->commissionRates->count()); ?> อัตรา)</h3>
                    </div>
                </div>
                <div class="p-6">
                    <div class="space-y-4">
                        <?php $__currentLoopData = $warehouse->commissionRates->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center gap-4 p-4 border border-gray-200 rounded-xl hover:border-orange-300 hover:bg-orange-50 transition-all duration-200">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 font-semibold text-gray-900 mb-1">
                                    <i class="fas fa-<?php echo e($rate->vehicle_type === '2wheel' ? 'motorcycle' : 'truck'); ?>"></i>
                                    <?php echo e($rate->vehicle_type === '2wheel' ? 'รถ 2 ล้อ' : 'รถ 4 ล้อ'); ?>

                                </div>
                                <div class="text-sm text-gray-600"><?php echo e($rate->min_amount); ?>-<?php echo e($rate->max_amount); ?> บาท</div>
                            </div>
                            <div class="text-2xl font-bold text-orange-600 mr-4">
                                <?php echo e($rate->commission_rate); ?>%
                            </div>
                            <div>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium <?php echo e($rate->is_active ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                                    <?php echo e($rate->is_active ? 'ใช้งานอยู่' : 'ปิดใช้งาน'); ?>

                                </span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($warehouse->commissionRates->count() > 5): ?>
                        <div class="pt-4 border-t border-gray-200 text-center">
                            <a href="<?php echo e(route('admin.commission-rates.index', ['warehouse' => $warehouse->code])); ?>" 
                               class="inline-flex items-center px-4 py-2 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-all duration-200">
                                ดูทั้งหมด <?php echo e($warehouse->commissionRates->count()); ?> อัตรา
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
</div>

<style>
/* Modern Warehouse Edit Styles */
.max-w-7xl {
    max-width: 80rem;
}

.mx-auto {
    margin-left: auto;
    margin-right: auto;
}

.px-4 {
    padding-left: 1rem;
    padding-right: 1rem;
}

.py-8 {
    padding-top: 2rem;
    padding-bottom: 2rem;
}

.mb-8 {
    margin-bottom: 2rem;
}

.flex {
    display: flex;
}

.flex-col {
    flex-direction: column;
}

.lg\:flex-row {
    flex-direction: row;
}

@media (min-width: 1024px) {
    .lg\:flex-row {
        flex-direction: row;
    }
    .lg\:items-center {
        align-items: center;
    }
    .lg\:justify-between {
        justify-content: space-between;
    }
    .lg\:col-span-2 {
        grid-column: span 2 / span 2;
    }
}

.items-center {
    align-items: center;
}

.justify-center {
    justify-content: center;
}

.gap-3 {
    gap: 0.75rem;
}

.gap-4 {
    gap: 1rem;
}

.gap-6 {
    gap: 1.5rem;
}

.w-12 {
    width: 3rem;
}

.h-12 {
    height: 3rem;
}

.w-14 {
    width: 3.5rem;
}

.h-14 {
    height: 3.5rem;
}

.bg-gradient-to-br {
    background-image: linear-gradient(to bottom right, var(--tw-gradient-stops));
}

.from-blue-500 {
    --tw-gradient-from: #3b82f6;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(59, 130, 246, 0));
}

.to-blue-600 {
    --tw-gradient-to: #2563eb;
}

.from-purple-500 {
    --tw-gradient-from: #8b5cf6;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(139, 92, 246, 0));
}

.to-purple-600 {
    --tw-gradient-to: #7c3aed;
}

.from-orange-500 {
    --tw-gradient-from: #f97316;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(249, 115, 22, 0));
}

.to-orange-600 {
    --tw-gradient-to: #ea580c;
}

.from-green-500 {
    --tw-gradient-from: #22c55e;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(34, 197, 94, 0));
}

.to-green-600 {
    --tw-gradient-to: #16a34a;
}

.from-red-500 {
    --tw-gradient-from: #ef4444;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(239, 68, 68, 0));
}

.to-red-600 {
    --tw-gradient-to: #dc2626;
}

.rounded-xl {
    border-radius: 0.75rem;
}

.rounded-2xl {
    border-radius: 1rem;
}

.shadow-lg {
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
}

.shadow-sm {
    box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
}

.text-white {
    color: #ffffff;
}

.text-xl {
    font-size: 1.25rem;
}

.text-2xl {
    font-size: 1.5rem;
}

.text-3xl {
    font-size: 1.875rem;
}

.font-bold {
    font-weight: 700;
}

.font-medium {
    font-weight: 500;
}

.font-semibold {
    font-weight: 600;
}

.text-gray-900 {
    color: #111827;
}

.text-gray-600 {
    color: #4b5563;
}

.text-gray-700 {
    color: #374151;
}

.text-orange-600 {
    color: #ea580c;
}

.grid {
    display: grid;
}

.grid-cols-1 {
    grid-template-columns: repeat(1, minmax(0, 1fr));
}

.grid-cols-2 {
    grid-template-columns: repeat(2, minmax(0, 1fr));
}

@media (min-width: 768px) {
    .md\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
}

@media (min-width: 1024px) {
    .lg\:grid-cols-4 {
        grid-template-columns: repeat(4, minmax(0, 1fr));
    }
    .lg\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
}

.bg-white {
    background-color: #ffffff;
}

.p-6 {
    padding: 1.5rem;
}

.border {
    border-width: 1px;
}

.border-gray-100 {
    border-color: #f3f4f6;
}

.border-gray-200 {
    border-color: #e5e7eb;
}

.border-gray-300 {
    border-color: #d1d5db;
}

.hover\:shadow-lg:hover {
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
}

.transition-all {
    transition-property: all;
    transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
    transition-duration: 150ms;
}

.duration-200 {
    transition-duration: 200ms;
}

.flex-1 {
    flex: 1 1 0%;
}

.text-sm {
    font-size: 0.875rem;
}

.text-xs {
    font-size: 0.75rem;
}

.text-lg {
    font-size: 1.125rem;
}

.mb-1 {
    margin-bottom: 0.25rem;
}

.mb-2 {
    margin-bottom: 0.5rem;
}

.mt-1 {
    margin-top: 0.25rem;
}

.mr-2 {
    margin-right: 0.5rem;
}

.overflow-hidden {
    overflow: hidden;
}

.bg-gradient-to-r {
    background-image: linear-gradient(to right, var(--tw-gradient-stops));
}

.from-gray-50 {
    --tw-gradient-from: #f9fafb;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(249, 250, 251, 0));
}

.to-gray-100 {
    --tw-gradient-to: #f3f4f6;
}

.px-6 {
    padding-left: 1.5rem;
    padding-right: 1.5rem;
}

.py-4 {
    padding-top: 1rem;
    padding-bottom: 1rem;
}

.border-b {
    border-bottom-width: 1px;
}

.w-10 {
    width: 2.5rem;
}

.h-10 {
    height: 2.5rem;
}

.rounded-lg {
    border-radius: 0.5rem;
}

.space-y-2 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 0.5rem;
}

.space-y-3 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 0.75rem;
}

.space-y-4 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 1rem;
}

.mt-8 {
    margin-top: 2rem;
}

.pt-4 {
    padding-top: 1rem;
}

.text-center {
    text-align: center;
}

.bg-green-100 {
    background-color: #dcfce7;
}

.text-green-700 {
    color: #15803d;
}

.bg-red-100 {
    background-color: #fee2e2;
}

.text-red-700 {
    color: #b91c1c;
}

.hover\:border-orange-300:hover {
    border-color: #fdba74;
}

.hover\:bg-orange-50:hover {
    background-color: #fff7ed;
}

.block {
    display: block;
}

.text-red-500 {
    color: #ef4444;
}

.relative {
    position: relative;
}

.absolute {
    position: absolute;
}

.inset-y-0 {
    top: 0;
    bottom: 0;
}

.left-0 {
    left: 0;
}

.pl-3 {
    padding-left: 0.75rem;
}

.pl-10 {
    padding-left: 2.5rem;
}

.pr-3 {
    padding-right: 0.75rem;
}

.py-3 {
    padding-top: 0.75rem;
    padding-bottom: 0.75rem;
}

.pointer-events-none {
    pointer-events: none;
}

.text-gray-400 {
    color: #9ca3af;
}

.w-full {
    width: 100%;
}

.focus\:ring-2:focus {
    box-shadow: 0 0 0 2px rgba(249, 115, 22, 0.5);
}

.focus\:ring-orange-500:focus {
    --tw-ring-color: #f97316;
}

.focus\:border-orange-500:focus {
    border-color: #f97316;
}

.border-red-500 {
    border-color: #ef4444;
}

.ring-2 {
    box-shadow: 0 0 0 2px rgba(239, 68, 68, 0.2);
}

.ring-red-200 {
    --tw-ring-color: #fecaca;
}

.text-red-500 {
    color: #ef4444;
}

.gap-1 {
    gap: 0.25rem;
}

.text-blue-500 {
    color: #3b82f6;
}

.text-gray-500 {
    color: #6b7280;
}

.top-3 {
    top: 0.75rem;
}

.resize-none {
    resize: none;
}

.cursor-pointer {
    cursor: pointer;
}

.border-2 {
    border-width: 2px;
}

.border-green-500 {
    border-color: #22c55e;
}

.bg-green-50 {
    background-color: #f0fdf4;
}

.hover\:border-green-300:hover {
    border-color: #86efac;
}

.sr-only {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border-width: 0;
}

.w-5 {
    width: 1.25rem;
}

.h-5 {
    height: 1.25rem;
}

.rounded-full {
    border-radius: 9999px;
}

.w-2 {
    width: 0.5rem;
}

.h-2 {
    height: 0.5rem;
}

.bg-red-50 {
    background-color: #fef2f2;
}

.hover\:border-red-300:hover {
    border-color: #fca5a5;
}

.pt-6 {
    padding-top: 1.5rem;
}

.mt-6 {
    margin-top: 1.5rem;
}

.border-t {
    border-top-width: 1px;
}

.inline-flex {
    display: inline-flex;
}

.justify-center {
    justify-content: center;
}

.px-4 {
    padding-left: 1rem;
    padding-right: 1rem;
}

.py-2\.5 {
    padding-top: 0.625rem;
    padding-bottom: 0.625rem;
}

.from-red-500 {
    --tw-gradient-from: #ef4444;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(239, 68, 68, 0));
}

.hover\:from-red-600:hover {
    --tw-gradient-from: #dc2626;
}

.hover\:to-red-700:hover {
    --tw-gradient-to: #b91c1c;
}

.hover\:shadow-xl:hover {
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
}

.transform {
    transform: var(--tw-transform);
}

.hover\:-translate-y-0\.5:hover {
    --tw-translate-y: -0.125rem;
    transform: translateY(var(--tw-translate-y));
}

.bg-amber-50 {
    background-color: #fffbeb;
}

.text-amber-600 {
    color: #d97706;
}

.border-amber-200 {
    border-color: #fde68a;
}

.bg-gray-100 {
    background-color: #f3f4f6;
}

.hover\:bg-gray-200:hover {
    background-color: #e5e7eb;
}

.from-orange-500 {
    --tw-gradient-from: #f97316;
    --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(249, 115, 22, 0));
}

.hover\:from-orange-600:hover {
    --tw-gradient-from: #ea580c;
}

.hover\:to-orange-700:hover {
    --tw-gradient-to: #c2410c;
}

@media (min-width: 640px) {
    .sm\:px-6 {
        padding-left: 1.5rem;
        padding-right: 1.5rem;
    }
    .sm\:flex-row {
        flex-direction: row;
    }
    .sm\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
}

@media (min-width: 1024px) {
    .lg\:px-8 {
        padding-left: 2rem;
        padding-right: 2rem;
    }
}
</style>

<!-- Modern JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Modern functionality
document.addEventListener('DOMContentLoaded', function() {
    initializeForm();
    setupValidation();
    setupInteractions();
});

// Initialize form
function initializeForm() {
    // Auto format warehouse code to uppercase
    const codeInput = document.getElementById('code');
    if (codeInput) {
        codeInput.addEventListener('input', function() {
            this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
            validateField(this);
        });
    }
    
    // Radio button interactions
    const radioLabels = document.querySelectorAll('input[type="radio"][name="is_active"]');
    radioLabels.forEach(radio => {
        radio.addEventListener('change', function() {
            updateRadioStates();
        });
    });
    
    // Initial radio state
    updateRadioStates();
}

// Setup form validation
function setupValidation() {
    const form = document.getElementById('warehouseForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (validateForm()) {
            submitForm();
        }
    });
    
    // Real-time validation
    const inputs = form.querySelectorAll('input[required], textarea[required]');
    inputs.forEach(input => {
        input.addEventListener('blur', () => validateField(input));
        input.addEventListener('input', () => clearFieldError(input));
    });
}

// Setup interactions
function setupInteractions() {
    // Form field focus effects
    const formControls = document.querySelectorAll('.form-control');
    formControls.forEach(control => {
        control.addEventListener('focus', function() {
            this.parentElement.classList.add('focused');
        });
        
        control.addEventListener('blur', function() {
            this.parentElement.classList.remove('focused');
        });
    });
}

// Validate individual field
function validateField(field) {
    const value = field.value.trim();
    let isValid = true;
    let message = '';
    
    // Required field validation
    if (field.hasAttribute('required') && !value) {
        isValid = false;
        message = 'กรุณากรอกข้อมูลในช่องนี้';
    }
    
    // Specific validations
    if (field.id === 'code' && value) {
        if (value.length < 2) {
            isValid = false;
            message = 'รหัสคลังต้องมีอย่างน้อย 2 ตัวอักษร';
        } else if (value.length > 10) {
            isValid = false;
            message = 'รหัสคลังต้องมีไม่เกิน 10 ตัวอักษร';
        }
    }
    
    if (field.id === 'name' && value && value.length < 3) {
        isValid = false;
        message = 'ชื่อคลังต้องมีอย่างน้อย 3 ตัวอักษร';
    }
    
    // Update field appearance
    if (isValid) {
        field.classList.remove('border-red-500');
        field.classList.add('border-green-500');
        removeFieldError(field);
    } else {
        field.classList.remove('border-green-500');
        field.classList.add('border-red-500');
        showFieldError(field, message);
    }
    
    return isValid;
}

// Clear field error styling
function clearFieldError(field) {
    field.classList.remove('border-red-500', 'border-green-500');
    removeFieldError(field);
}

// Show field error
function showFieldError(field, message) {
    removeFieldError(field);
    
    const errorElement = document.createElement('p');
    errorElement.className = 'error-message';
    errorElement.textContent = message;
    
    field.parentElement.parentElement.appendChild(errorElement);
}

// Remove field error
function removeFieldError(field) {
    const errorElement = field.parentElement.parentElement.querySelector('.error-message');
    if (errorElement) {
        errorElement.remove();
    }
}

// Validate entire form
function validateForm() {
    const code = document.getElementById('code').value.trim();
    const name = document.getElementById('name').value.trim();
    
    if (!code) {
        Swal.fire({
            icon: 'error',
            title: 'ข้อมูลไม่ครบถ้วน',
            text: 'กรุณาระบุรหัสคลัง',
            confirmButtonColor: '#FF6B35'
        });
        document.getElementById('code').focus();
        return false;
    }
    
    if (code.length < 2) {
        Swal.fire({
            icon: 'error',
            title: 'รหัสคลังไม่ถูกต้อง',
            text: 'รหัสคลังต้องมีอย่างน้อย 2 ตัวอักษร',
            confirmButtonColor: '#FF6B35'
        });
        document.getElementById('code').focus();
        return false;
    }
    
    if (!name) {
        Swal.fire({
            icon: 'error',
            title: 'ข้อมูลไม่ครบถ้วน',
            text: 'กรุณาระบุชื่อคลัง',
            confirmButtonColor: '#FF6B35'
        });
        document.getElementById('name').focus();
        return false;
    }
    
    if (name.length < 3) {
        Swal.fire({
            icon: 'error',
            title: 'ชื่อคลังไม่ถูกต้อง',
            text: 'ชื่อคลังต้องมีอย่างน้อย 3 ตัวอักษร',
            confirmButtonColor: '#FF6B35'
        });
        document.getElementById('name').focus();
        return false;
    }
    
    return true;
}

// Submit form with loading state
function submitForm() {
    const submitBtn = document.getElementById('submitBtn');
    const form = document.getElementById('warehouseForm');
    const loadingSpinner = document.getElementById('loadingSpinner');
    const buttonText = submitBtn.querySelector('span:first-child');
    
    // Show loading state
    submitBtn.disabled = true;
    buttonText.style.opacity = '0';
    loadingSpinner.style.opacity = '1';
    
    // Show confirmation
    Swal.fire({
        title: 'ยืนยันการบันทึก',
        text: 'คุณต้องการบันทึกการเปลี่ยนแปลงหรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'บันทึก',
        cancelButtonText: 'ยกเลิก',
        showLoaderOnConfirm: true,
        preConfirm: () => {
            return new Promise((resolve) => {
                setTimeout(() => {
                    form.submit();
                    resolve();
                }, 1000);
            });
        }
    }).then((result) => {
        if (!result.isConfirmed) {
            // Reset button state if cancelled
            submitBtn.disabled = false;
            buttonText.style.opacity = '1';
            loadingSpinner.style.opacity = '0';
        }
    });
}

// Update radio button states
function updateRadioStates() {
    const radioInputs = document.querySelectorAll('input[type="radio"][name="is_active"]');
    radioInputs.forEach(radio => {
        const label = radio.closest('label');
        const dot = label.querySelector('div:nth-child(2)');
        
        if (radio.checked) {
            if (radio.value === '1') {
                label.className = 'relative flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all duration-200 border-green-500 bg-green-50';
                dot.className = 'w-5 h-5 border-2 rounded-full flex items-center justify-center border-green-500 bg-green-500';
                dot.innerHTML = '<div class="w-2 h-2 bg-white rounded-full"></div>';
            } else {
                label.className = 'relative flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all duration-200 border-red-500 bg-red-50';
                dot.className = 'w-5 h-5 border-2 rounded-full flex items-center justify-center border-red-500 bg-red-500';
                dot.innerHTML = '<div class="w-2 h-2 bg-white rounded-full"></div>';
            }
        } else {
            if (radio.value === '1') {
                label.className = 'relative flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all duration-200 border-gray-200 hover:border-green-300';
                dot.className = 'w-5 h-5 border-2 rounded-full flex items-center justify-center border-gray-300';
                dot.innerHTML = '';
            } else {
                label.className = 'relative flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all duration-200 border-gray-200 hover:border-red-300';
                dot.className = 'w-5 h-5 border-2 rounded-full flex items-center justify-center border-gray-300';
                dot.innerHTML = '';
            }
        }
    });
}

// Delete warehouse function
function deleteWarehouse() {
    Swal.fire({
        title: 'ยืนยันการลบคลัง',
        text: 'คุณต้องการลบคลังนี้หรือไม่? การดำเนินการนี้ไม่สามารถยกเลิกได้',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#EF4444',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ลบคลัง',
        cancelButtonText: 'ยกเลิก',
        showLoaderOnConfirm: true,
        preConfirm: () => {
            return fetch(`<?php echo e(route('admin.warehouses.destroy', $warehouse)); ?>`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    throw new Error(data.message || 'เกิดข้อผิดพลาด');
                }
                return data;
            })
            .catch(error => {
                Swal.showValidationMessage(`เกิดข้อผิดพลาด: ${error.message}`);
            });
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {
        if (result.isConfirmed && result.value) {
            Swal.fire({
                icon: 'success',
                title: 'ลบคลังสำเร็จ!',
                text: result.value.message,
                confirmButtonColor: '#FF6B35'
            }).then(() => {
                window.location.href = '<?php echo e(route('admin.warehouses.index')); ?>';
            });
        }
    });
}

// Show success/error messages from session
<?php if(session('success')): ?>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: 'success',
            title: 'สำเร็จ!',
            text: '<?php echo e(session('success')); ?>',
            confirmButtonColor: '#FF6B35'
        });
    });
<?php endif; ?>

<?php if(session('error')): ?>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: 'error',
            title: 'เกิดข้อผิดพลาด!',
            text: '<?php echo e(session('error')); ?>',
            confirmButtonColor: '#FF6B35'
        });
    });
<?php endif; ?>

// Enhanced search functionality for users and rates
document.addEventListener('DOMContentLoaded', function() {
    // Add search functionality to user/rate lists if needed
    const userItems = document.querySelectorAll('.user-item');
    const rateItems = document.querySelectorAll('.rate-item');
    
    // Add hover effects and click interactions
    userItems.forEach(item => {
        item.addEventListener('click', function() {
            const userId = this.dataset.userId;
            if (userId) {
                window.open(`/admin/users/${userId}/edit`, '_blank');
            }
        });
    });
    
    rateItems.forEach(item => {
        item.addEventListener('click', function() {
            const rateId = this.dataset.rateId;
            if (rateId) {
                window.open(`/admin/commission-rates/${rateId}/edit`, '_blank');
            }
        });
    });
});

// Keyboard shortcuts
document.addEventListener('keydown', function(e) {
    // Ctrl/Cmd + S to save
    if ((e.ctrlKey || e.metaKey) && e.key === 's') {
        e.preventDefault();
        if (validateForm()) {
            submitForm();
        }
    }
    
    // Escape to cancel
    if (e.key === 'Escape') {
        window.location.href = '<?php echo e(route('admin.warehouses.index')); ?>';
    }
    
    // Ctrl/Cmd + D to delete (if allowed)
    if ((e.ctrlKey || e.metaKey) && e.key === 'd' && <?php echo e($warehouse->users->count() === 0 ? 'true' : 'false'); ?>) {
        e.preventDefault();
        deleteWarehouse();
    }
});

// Auto-save draft functionality
let autoSaveTimer;
let hasChanges = false;

// Track form changes
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('warehouseForm');
    const originalData = new FormData(form);
    
    // Store original values
    const originalValues = {};
    for (let [key, value] of originalData.entries()) {
        originalValues[key] = value;
    }
    
    // Track changes
    form.addEventListener('input', function() {
        checkForChanges(originalValues);
    });
    
    form.addEventListener('change', function() {
        checkForChanges(originalValues);
    });
});

function checkForChanges(originalValues) {
    const form = document.getElementById('warehouseForm');
    const currentData = new FormData(form);
    let hasChanges = false;
    
    for (let [key, value] of currentData.entries()) {
        if (originalValues[key] !== value) {
            hasChanges = true;
            break;
        }
    }
    
    // Update UI to show unsaved changes
    if (hasChanges) {
        document.title = '* แก้ไขคลังสินค้า - ระบบจัดการค่าคอมมิชชั่น';
        showUnsavedChangesIndicator();
    } else {
        document.title = 'แก้ไขคลังสินค้า - ระบบจัดการค่าคอมมิชชั่น';
        hideUnsavedChangesIndicator();
    }
}

function showUnsavedChangesIndicator() {
    let indicator = document.querySelector('.unsaved-indicator');
    if (!indicator) {
        indicator = document.createElement('div');
        indicator.className = 'unsaved-indicator';
        indicator.innerHTML = '<i class="fas fa-circle text-orange-500"></i> มีการเปลี่ยนแปลงที่ยังไม่ได้บันทึก';
        indicator.style.cssText = `
            position: fixed;
            top: 20px;
            right: 20px;
            background: white;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            font-size: 0.875rem;
            z-index: 9999;
            border-left: 4px solid #FF6B35;
        `;
        document.body.appendChild(indicator);
    }
}

function hideUnsavedChangesIndicator() {
    const indicator = document.querySelector('.unsaved-indicator');
    if (indicator) {
        indicator.remove();
    }
}

// Warn before leaving if there are unsaved changes
window.addEventListener('beforeunload', function(e) {
    if (hasChanges) {
        e.preventDefault();
        e.returnValue = 'คุณมีการเปลี่ยนแปลงที่ยังไม่ได้บันทึก คุณต้องการออกจากหน้านี้หรือไม่?';
        return e.returnValue;
    }
});

// Remove warning when form is submitted
document.getElementById('warehouseForm').addEventListener('submit', function() {
    hasChanges = false;
});

// Add smooth scrolling to validation errors
function scrollToError(element) {
    element.scrollIntoView({
        behavior: 'smooth',
        block: 'center'
    });
    
    // Add pulse animation to highlight the error
    element.style.animation = 'pulse 2s ease-in-out';
    setTimeout(() => {
        element.style.animation = '';
    }, 2000);
}

// Add CSS for pulse animation
const style = document.createElement('style');
style.textContent = `
    @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.02); }
    }
`;
document.head.appendChild(style);
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/admin/warehouses/edit.blade.php ENDPATH**/ ?>