@extends('layouts.app')

@section('title', 'รายงาน - ระบบจัดการค่าคอมมิชชั่น')

@section('content')
<div class="content-container">
    <!-- Page Header -->
    <div class="page-header">
        <div class="page-header-content">
            <div class="page-header-text">
                <h1 class="page-title">
                    <i class="fas fa-chart-bar text-purple-500"></i>
                    <span>ศูนย์รายงาน</span>
                </h1>
                <p class="page-subtitle">ภาพรวมและการวิเคราะห์ข้อมูลทั้งหมดในระบบ</p>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="stats-grid">
        <div class="stat-card gradient-orange">
            <div class="stat-card-content">
                <div class="stat-icon">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-value">{{ number_format($stats['total_deliveries']) }}</div>
                    <div class="stat-label">การจัดส่งทั้งหมด</div>
                </div>
            </div>
        </div>

        <div class="stat-card gradient-green">
            <div class="stat-card-content">
                <div class="stat-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-value">฿{{ number_format($stats['total_commission'], 2) }}</div>
                    <div class="stat-label">ค่าคอมมิชชั่นรวม</div>
                </div>
            </div>
        </div>

        <div class="stat-card gradient-blue">
            <div class="stat-card-content">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-value">{{ number_format($stats['active_users']) }}</div>
                    <div class="stat-label">พนักงานที่ใช้งาน</div>
                </div>
            </div>
        </div>

        <div class="stat-card gradient-purple">
            <div class="stat-card-content">
                <div class="stat-icon">
                    <i class="fas fa-warehouse"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-value">{{ number_format($stats['active_warehouses']) }}</div>
                    <div class="stat-label">คลังที่ใช้งาน</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Performance Comparison -->
    <div class="report-section">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-chart-line text-blue-500"></i>
                เปรียบเทียบประสิทธิภาพ
            </h2>
            <span class="section-subtitle">เดือนนี้ vs เดือนที่แล้ว</span>
        </div>

        <div class="comparison-grid">
            <div class="comparison-card">
                <div class="comparison-header">
                    <h3>การจัดส่ง</h3>
                    @php
                        $deliveryChange = 0;
                        if ($lastMonthStats->total_deliveries > 0) {
                            $deliveryChange = (($thisMonthStats->total_deliveries - $lastMonthStats->total_deliveries) / $lastMonthStats->total_deliveries) * 100;
                        }
                    @endphp
                    <span class="change-badge {{ $deliveryChange >= 0 ? 'positive' : 'negative' }}">
                        <i class="fas fa-{{ $deliveryChange >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                        {{ abs(round($deliveryChange, 1)) }}%
                    </span>
                </div>
                <div class="comparison-content">
                    <div class="comparison-item">
                        <span class="label">เดือนนี้</span>
                        <span class="value">{{ number_format($thisMonthStats->total_deliveries) }}</span>
                    </div>
                    <div class="comparison-item">
                        <span class="label">เดือนที่แล้ว</span>
                        <span class="value">{{ number_format($lastMonthStats->total_deliveries) }}</span>
                    </div>
                </div>
            </div>

            <div class="comparison-card">
                <div class="comparison-header">
                    <h3>จำนวนพัสดุ</h3>
                    @php
                        $parcelChange = 0;
                        if ($lastMonthStats->total_parcels > 0) {
                            $parcelChange = (($thisMonthStats->total_parcels - $lastMonthStats->total_parcels) / $lastMonthStats->total_parcels) * 100;
                        }
                    @endphp
                    <span class="change-badge {{ $parcelChange >= 0 ? 'positive' : 'negative' }}">
                        <i class="fas fa-{{ $parcelChange >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                        {{ abs(round($parcelChange, 1)) }}%
                    </span>
                </div>
                <div class="comparison-content">
                    <div class="comparison-item">
                        <span class="label">เดือนนี้</span>
                        <span class="value">{{ number_format($thisMonthStats->total_parcels) }}</span>
                    </div>
                    <div class="comparison-item">
                        <span class="label">เดือนที่แล้ว</span>
                        <span class="value">{{ number_format($lastMonthStats->total_parcels) }}</span>
                    </div>
                </div>
            </div>

            <div class="comparison-card">
                <div class="comparison-header">
                    <h3>ค่าคอมมิชชั่น</h3>
                    @php
                        $commissionChange = 0;
                        if ($lastMonthStats->total_commission > 0) {
                            $commissionChange = (($thisMonthStats->total_commission - $lastMonthStats->total_commission) / $lastMonthStats->total_commission) * 100;
                        }
                    @endphp
                    <span class="change-badge {{ $commissionChange >= 0 ? 'positive' : 'negative' }}">
                        <i class="fas fa-{{ $commissionChange >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                        {{ abs(round($commissionChange, 1)) }}%
                    </span>
                </div>
                <div class="comparison-content">
                    <div class="comparison-item">
                        <span class="label">เดือนนี้</span>
                        <span class="value">฿{{ number_format($thisMonthStats->total_commission, 2) }}</span>
                    </div>
                    <div class="comparison-item">
                        <span class="label">เดือนที่แล้ว</span>
                        <span class="value">฿{{ number_format($lastMonthStats->total_commission, 2) }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Report Types -->
    <div class="report-section">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-file-chart-line text-orange-500"></i>
                ประเภทรายงาน
            </h2>
            <span class="section-subtitle">เลือกรายงานที่ต้องการดู</span>
        </div>

        <div class="report-types-grid">
            <a href="{{ route('admin.reports.delivery') }}" class="report-type-card">
                <div class="report-type-icon delivery">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="report-type-content">
                    <h3>รายงานการจัดส่ง</h3>
                    <p>ข้อมูลการจัดส่งพัสดุ แนวโน้ม และประสิทธิภาพการทำงาน</p>
                    <span class="report-type-link">
                        ดูรายงาน <i class="fas fa-arrow-right"></i>
                    </span>
                </div>
            </a>

            <a href="{{ route('admin.reports.commission') }}" class="report-type-card">
                <div class="report-type-icon commission">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="report-type-content">
                    <h3>รายงานค่าคอมมิชชั่น</h3>
                    <p>การวิเคราะห์ค่าคอมมิชชั่น รายได้ และการกระจายตามระดับ</p>
                    <span class="report-type-link">
                        ดูรายงาน <i class="fas fa-arrow-right"></i>
                    </span>
                </div>
            </a>

            <a href="{{ route('admin.reports.warehouse') }}" class="report-type-card">
                <div class="report-type-icon warehouse">
                    <i class="fas fa-warehouse"></i>
                </div>
                <div class="report-type-content">
                    <h3>รายงานคลังสินค้า</h3>
                    <p>ประสิทธิภาพคลังสินค้า การเปรียบเทียบ และการจัดอันดับ</p>
                    <span class="report-type-link">
                        ดูรายงาน <i class="fas fa-arrow-right"></i>
                    </span>
                </div>
            </a>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="report-section">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-bolt text-yellow-500"></i>
                การดำเนินการด่วน
            </h2>
        </div>

        <div class="quick-actions">
            <button onclick="generateMonthlyReport()" class="action-button primary">
                <i class="fas fa-file-pdf"></i>
                สร้างรายงานประจำเดือน
            </button>
            <button onclick="scheduleReport()" class="action-button secondary">
                <i class="fas fa-clock"></i>
                ตั้งเวลาส่งรายงาน
            </button>
            <button onclick="customReport()" class="action-button tertiary">
                <i class="fas fa-cog"></i>
                รายงานแบบกำหนดเอง
            </button>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
/* Page Header */
.page-header {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--medium-gray);
}

.page-header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.page-title {
    font-size: 1.75rem;
    font-weight: 600;
    color: var(--dark-gray);
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin: 0 0 0.5rem 0;
}

.page-subtitle {
    color: var(--gray);
    font-size: 1rem;
    margin: 0;
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    border-radius: var(--radius-lg);
    padding: 1.5rem;
    color: white;
    position: relative;
    overflow: hidden;
    transition: var(--transition-fast);
}

.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
}

.gradient-orange {
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
}

.gradient-green {
    background: linear-gradient(135deg, #22C55E 0%, #16A34A 100%);
}

.gradient-blue {
    background: linear-gradient(135deg, #3B82F6 0%, #2563EB 100%);
}

.gradient-purple {
    background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
}

.stat-card-content {
    display: flex;
    align-items: center;
    gap: 1.5rem;
}

.stat-icon {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.75rem;
}

.stat-info {
    flex: 1;
}

.stat-value {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
}

.stat-label {
    font-size: 0.9rem;
    opacity: 0.9;
}

/* Report Section */
.report-section {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--medium-gray);
}

.section-header {
    display: flex;
    align-items: baseline;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.section-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--dark-gray);
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0;
}

.section-subtitle {
    color: var(--gray);
    font-size: 0.9rem;
}

/* Comparison Grid */
.comparison-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
}

.comparison-card {
    background: #f8f9fa;
    border-radius: var(--radius-md);
    padding: 1.5rem;
    border: 1px solid #e9ecef;
}

.comparison-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.comparison-header h3 {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0;
}

.change-badge {
    display: flex;
    align-items: center;
    gap: 0.25rem;
    padding: 0.25rem 0.75rem;
    border-radius: var(--radius-full);
    font-size: 0.875rem;
    font-weight: 600;
}

.change-badge.positive {
    background: #d1fae5;
    color: #059669;
}

.change-badge.negative {
    background: #fee2e2;
    color: #dc2626;
}

.comparison-content {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.comparison-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.comparison-item .label {
    color: var(--gray);
    font-size: 0.9rem;
}

.comparison-item .value {
    font-weight: 600;
    font-size: 1.1rem;
    color: var(--dark-gray);
}

/* Report Types Grid */
.report-types-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
}

.report-type-card {
    display: block;
    background: #f8f9fa;
    border-radius: var(--radius-lg);
    padding: 2rem;
    text-decoration: none;
    transition: var(--transition-fast);
    border: 2px solid transparent;
}

.report-type-card:hover {
    background: white;
    border-color: var(--primary-orange);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.report-type-icon {
    width: 80px;
    height: 80px;
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2.5rem;
    margin-bottom: 1.5rem;
}

.report-type-icon.delivery {
    background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    color: #d97706;
}

.report-type-icon.commission {
    background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
    color: #059669;
}

.report-type-icon.warehouse {
    background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
    color: #2563eb;
}

.report-type-content h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0 0 0.5rem 0;
}

.report-type-content p {
    color: var(--gray);
    font-size: 0.95rem;
    margin: 0 0 1rem 0;
}

.report-type-link {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    color: var(--primary-orange);
    font-weight: 500;
    font-size: 0.95rem;
}

/* Quick Actions */
.quick-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.action-button {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border-radius: var(--radius-md);
    border: none;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-fast);
    font-size: 0.95rem;
}

.action-button.primary {
    background: var(--primary-gradient);
    color: white;
}

.action-button.primary:hover {
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.action-button.secondary {
    background: #e5e7eb;
    color: #374151;
}

.action-button.secondary:hover {
    background: #d1d5db;
}

.action-button.tertiary {
    background: transparent;
    color: var(--primary-orange);
    border: 2px solid var(--primary-orange);
}

.action-button.tertiary:hover {
    background: var(--primary-orange);
    color: white;
}

/* Responsive */
@media (max-width: 768px) {
    .stats-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .comparison-grid {
        grid-template-columns: 1fr;
    }
    
    .report-types-grid {
        grid-template-columns: 1fr;
    }
    
    .quick-actions {
        flex-direction: column;
    }
    
    .action-button {
        width: 100%;
        justify-content: center;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function generateMonthlyReport() {
    Swal.fire({
        title: 'สร้างรายงานประจำเดือน',
        text: 'คุณต้องการสร้างรายงานประจำเดือนนี้หรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'สร้างรายงาน',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'กำลังสร้างรายงาน...',
                text: 'กรุณารอสักครู่',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // Simulate report generation
            setTimeout(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'สร้างรายงานสำเร็จ!',
                    text: 'รายงานประจำเดือนถูกสร้างเรียบร้อยแล้ว',
                    confirmButtonColor: '#FF6B35'
                });
            }, 2000);
        }
    });
}

function scheduleReport() {
    Swal.fire({
        title: 'ตั้งเวลาส่งรายงาน',
        html: `
            <div class="schedule-form">
                <div class="form-group">
                    <label>ประเภทรายงาน</label>
                    <select class="swal2-input">
                        <option>รายงานประจำวัน</option>
                        <option>รายงานประจำสัปดาห์</option>
                        <option>รายงานประจำเดือน</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>เวลาส่ง</label>
                    <input type="time" class="swal2-input" value="08:00">
                </div>
                <div class="form-group">
                    <label>อีเมลผู้รับ</label>
                    <input type="email" class="swal2-input" placeholder="email@example.com">
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'บันทึก',
        cancelButtonText: 'ยกเลิก',
        customClass: {
            container: 'schedule-modal'
        }
    });
}

function customReport() {
    window.location.href = '#'; // Redirect to custom report builder
}
</script>
@endpush